// Borland C++ Builder
// Copyright (c) 1995, 1999 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'mySQLAccess.pas' rev: 5.00

#ifndef mySQLAccessHPP
#define mySQLAccessHPP

#pragma delphiheader begin
#pragma option push -w-
#pragma option push -Vx
#include <mySQLCP.hpp>	// Pascal unit
#include <DBCommon.hpp>	// Pascal unit
#include <Math.hpp>	// Pascal unit
#include <mySQLTypes.hpp>	// Pascal unit
#include <DBTables.hpp>	// Pascal unit
#include <Db.hpp>	// Pascal unit
#include <Bde.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <SysUtils.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Mysqlaccess
{
//-- type declarations -------------------------------------------------------
class DELPHICLASS EmySQLException;
class DELPHICLASS TNativeConnect;
class PASCALIMPLEMENTATION TNativeConnect : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	Mysqltypes::TMYSQL FHandle;
	Mysqltypes::TConnectOptions FOptions;
	bool FSystem;
	
protected:
	Bde::eXState FTransState;
	Bde::eXILType FTransLevel;
	int FStrtStmt;
	
public:
	Mysqltypes::TContainer* Tables;
	bool FLoggin;
	bool FInTrans;
	Mysqltypes::TDBOptions DBOptions;
	__fastcall TNativeConnect(Mysqltypes::TConnectOptions ConnOptions);
	__fastcall virtual ~TNativeConnect(void);
	void __fastcall ProcessDBParams(Classes::TStrings* Params);
	void __fastcall InternalConnect(void);
	void __fastcall InternalDisconnect(void);
	void __fastcall CheckResult(void);
	Word __fastcall GetErrorCode(void);
	AnsiString __fastcall GetErrorText(void);
	bool __fastcall Success(void);
	AnsiString __fastcall GetClientInfo(void);
	AnsiString __fastcall GetServerStat(void);
	AnsiString __fastcall GetHostInfo(void);
	unsigned __fastcall GetProtoInfo(void);
	AnsiString __fastcall GetServerInfo(void);
	void __fastcall Kill(int PID);
	void __fastcall SelectDB(char * DBName);
	int __fastcall Ping(void);
	void __fastcall TableList(char * pszWild, Classes::TStrings* List);
	void __fastcall DatabaseList(char * pszWild, Classes::TStrings* List);
	void __fastcall OpenTable(char * pszTableName, char * pszIndexName, Word iIndexId, Bde::DBIOpenMode 
		eOpenMode, Bde::DBIShareMode eShareMode, Bde::hDBICur &hCursor, int Offset, int Limit);
	void __fastcall QueryAlloc(Bde::hDBIStmt &hStmt);
	void __fastcall QueryPrepare(Bde::hDBIStmt &hStmt, AnsiString Query);
	void __fastcall BeginTran(Bde::eXILType eXIL, Bde::hDBIXact &hXact);
	void __fastcall EndTran(Bde::hDBIXact hXact, Bde::eXEnd eEnd);
	void __fastcall GetTranInfo(Bde::hDBIXact hXact, Bde::pXInfo pxInfo);
	void __fastcall QExecDirect(Bde::DBIQryLang eQryLang, AnsiString pszQuery, Bde::phDBICur phCur);
	void __fastcall OpenFieldList(char * pszTableName, char * pszDriverType, BOOL bPhyTypes, Bde::hDBICur 
		&hCur);
	void __fastcall OpenIndexList(char * pszTableName, char * pszDriverType, Bde::hDBICur &hCur);
	Mysqlcp::TConvertChar __fastcall GetCharSet(void);
	void __fastcall EmptyTable(Bde::hDBICur hCursor, char * pszTableName);
	void __fastcall TableExists(char * pszTableName);
	void __fastcall AddIndex(Bde::hDBICur hCursor, char * pszTableName, char * pszDriverType, Bde::IDXDesc 
		&IdxDesc, char * pszKeyviolName);
	void __fastcall DeleteIndex(Bde::hDBICur hCursor, char * pszTableName, char * pszDriverType, char * 
		pszIndexName, char * pszIndexTagName, Word iIndexId);
	void __fastcall CreateTable(BOOL bOverWrite, Bde::CRTblDesc &crTblDsc);
	__property Mysqltypes::TMYSQL Handle = {read=FHandle, write=FHandle};
};


class PASCALIMPLEMENTATION EmySQLException : public Sysutils::EAbort 
{
	typedef Sysutils::EAbort inherited;
	
private:
	TNativeConnect* FmySQL;
	Word FmySQLErrorCode;
	Word FBDEErrorCode;
	bool FBDE;
	AnsiString FmySQLErrorMsg;
	AnsiString __fastcall GetNativeErrorMsg(void);
	
public:
	__fastcall EmySQLException(Word ECode);
	__fastcall EmySQLException(Word ECode, const System::ShortString &EMessage);
	__fastcall EmySQLException(TNativeConnect* mySQL);
	__fastcall EmySQLException(TNativeConnect* mySQL, const AnsiString ErrorMsg);
	__property Word mySQLErrorCode = {read=FmySQLErrorCode, nodefault};
	__property AnsiString mySQLErrorMsg = {read=GetNativeErrorMsg};
	__property Word BDEErrorCode = {read=FBDEErrorCode, nodefault};
	__property bool BDEErrors = {read=FBDE, nodefault};
public:
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall EmySQLException(const AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size) : Sysutils::EAbort(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall EmySQLException(int Ident)/* overload */ : Sysutils::EAbort(
		Ident) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall EmySQLException(int Ident, const System::TVarRec * Args
		, const int Args_Size)/* overload */ : Sysutils::EAbort(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall EmySQLException(const AnsiString Msg, int AHelpContext
		) : Sysutils::EAbort(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall EmySQLException(const AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size, int AHelpContext) : Sysutils::EAbort(Msg, Args, Args_Size, AHelpContext
		) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall EmySQLException(int Ident, int AHelpContext)/* overload */
		 : Sysutils::EAbort(Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall EmySQLException(System::PResStringRec ResStringRec
		, const System::TVarRec * Args, const int Args_Size, int AHelpContext)/* overload */ : Sysutils::EAbort(
		ResStringRec, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~EmySQLException(void) { }
	#pragma option pop
	
};


class DELPHICLASS TmySQLEngine;
class PASCALIMPLEMENTATION TmySQLEngine : public Mysqltypes::TBaseObject 
{
	typedef Mysqltypes::TBaseObject inherited;
	
private:
	Bde::_hDBIObj *FCursor;
	Bde::_hDBIObj *FDatabase;
	int FNativeStatus;
	AnsiString FNativeMsg;
	Bde::_hDBIObj *FStatement;
	Bde::hDBICur __fastcall GetCursor(void);
	void __fastcall SetCursor(Bde::hDBICur H);
	Bde::hDBIDb __fastcall GetDatabase(void);
	void __fastcall SetDatabase(Bde::hDBIDb H);
	Bde::hDBIStmt __fastcall GetStatement(void);
	void __fastcall SetStatement(Bde::hDBIStmt H);
	
public:
	__fastcall TmySQLEngine(System::TObject* P, Mysqltypes::TContainer* Container);
	__fastcall virtual ~TmySQLEngine(void);
	__property int Status = {read=FNativeStatus, nodefault};
	__property AnsiString MessageStatus = {read=FNativeMsg};
	__property Bde::hDBIDb Database = {read=GetDatabase, write=SetDatabase};
	__property Bde::hDBICur Cursor = {read=GetCursor, write=SetCursor};
	__property Bde::hDBIStmt Statement = {read=GetStatement, write=SetStatement};
	bool __fastcall IsSqlBased(Bde::hDBIDb hDb);
	Word __fastcall OpenDatabase(Mysqltypes::TConnectOptions ConnOptions, Classes::TStrings* Params, Bde::hDBIDb 
		&hDb);
	Word __fastcall CloseDatabase(Bde::hDBIDb &hDb);
	Word __fastcall OpenTable(Bde::hDBIDb hDb, char * pszTableName, char * pszDriverType, char * pszIndexName
		, char * pszIndexTagName, Word iIndexId, Bde::DBIOpenMode eOpenMode, Bde::DBIShareMode eShareMode, 
		Bde::XLTMode exltMode, BOOL bUniDirectional, void * pOptParams, Bde::hDBICur &hCursor, int offset, 
		int Limit);
	Word __fastcall OpenTableList(Bde::hDBIDb hDb, char * pszWild, Classes::TStrings* List);
	Word __fastcall SetToBookMark(Bde::hDBICur hCur, void * pBookMark);
	Word __fastcall CompareBookMarks(Bde::hDBICur hCur, void * pBookMark1, void * pBookMark2, int &CmpBkmkResult
		);
	Word __fastcall GetNextRecord(Bde::hDBICur hCursor, Bde::DBILockType eLock, void * pRecBuff, Bde::pRECProps 
		pRecProps);
	Word __fastcall CloseCursor(Bde::hDBICur hCursor);
	Word __fastcall PutField(Bde::hDBICur hCursor, Word FieldNo, void * PRecord, void * pSrc);
	Word __fastcall OpenBlob(Bde::hDBICur hCursor, void * PRecord, Word FieldNo, Bde::DBIOpenMode eOpenMode
		);
	Word __fastcall GetBlobSize(Bde::hDBICur hCursor, void * PRecord, Word FieldNo, int &iSize);
	Word __fastcall GetBlob(Bde::hDBICur hCursor, void * PRecord, Word FieldNo, int iOffSet, int iLen, 
		void * pDest, int &iRead);
	Word __fastcall PutBlob(Bde::hDBICur hCursor, void * PRecord, Word FieldNo, int iOffSet, int iLen, 
		void * pSrc);
	Word __fastcall TruncateBlob(Bde::hDBICur hCursor, void * PRecord, Word FieldNo, int iLen);
	Word __fastcall FreeBlob(Bde::hDBICur hCursor, void * PRecord, Word FieldNo);
	Word __fastcall BeginTran(Bde::hDBIDb hDb, Bde::eXILType eXIL, Bde::hDBIXact &hXact);
	Word __fastcall EndTran(Bde::hDBIDb hDb, Bde::hDBIXact hXact, Bde::eXEnd eEnd);
	Word __fastcall GetTranInfo(Bde::hDBIDb hDb, Bde::hDBIXact hXact, Bde::pXInfo pxInfo);
	Word __fastcall GetEngProp(Bde::hDBIObj hObj, int iProp, void * PropValue, Word iMaxLen, Word &iLen
		);
	Word __fastcall SetEngProp(Bde::hDBIObj hObj, int iProp, int PropValue);
	Word __fastcall GetVchkDesc(Bde::hDBICur hCursor, Word iValSeqNo, Bde::pVCHKDesc pvalDesc);
	Word __fastcall GetCursorProps(Bde::hDBICur hCursor, Bde::CURProps &curProps);
	Word __fastcall GetObjFromObj(Bde::hDBIObj Source, Bde::DBIOBJType eObjType, Bde::hDBIObj &hObj);
	Word __fastcall GetFieldDescs(Bde::hDBICur hCursor, Bde::pFLDDesc pfldDesc);
	Word __fastcall SetToBegin(Bde::hDBICur hCursor);
	Word __fastcall SetToEnd(Bde::hDBICur hCursor);
	Word __fastcall RelRecordLock(Bde::hDBICur hCursor, BOOL bAll);
	Word __fastcall InitRecord(Bde::hDBICur hCursor, void * PRecord);
	Word __fastcall InsertRecord(Bde::hDBICur hCursor, Bde::DBILockType eLock, void * PRecord);
	Word __fastcall AppendRecord(Bde::hDBICur hCursor, void * PRecord);
	Word __fastcall ModifyRecord(Bde::hDBICur hCursor, void * OldRecord, void * PRecord, BOOL bFreeLock
		);
	Word __fastcall DeleteRecord(Bde::hDBICur hCursor, void * PRecord);
	Word __fastcall SettoSeqNo(Bde::hDBICur hCursor, int iSeqNo);
	Word __fastcall GetPriorRecord(Bde::hDBICur hCursor, Bde::DBILockType eLock, void * PRecord, Bde::pRECProps 
		pRecProps);
	Word __fastcall GetRecord(Bde::hDBICur hCursor, Bde::DBILockType eLock, void * PRecord, Bde::pRECProps 
		pRecProps);
	Word __fastcall GetBookMark(Bde::hDBICur hCur, void * pBookMark);
	Word __fastcall GetRecordCount(Bde::hDBICur hCursor, int &iRecCount);
	Word __fastcall ForceReread(Bde::hDBICur hCursor);
	Word __fastcall GetField(Bde::hDBICur hCursor, Word FieldNo, void * PRecord, void * pDest, BOOL &bBlank
		);
	Word __fastcall AnsiToNative(char * pNativeStr, char * pAnsiStr, int iLen, BOOL &bDataLoss);
	Word __fastcall NativeToAnsi(char * pAnsiStr, char * pNativeStr, int iLen, BOOL &bDataLoss);
	Word __fastcall AddFilter(Bde::hDBICur hCursor, int iClientData, Word iPriority, BOOL bCanAbort, Bde::pCANExpr 
		pcanExpr, Bde::pfGENFilter pfFilter, Bde::hDBIFilter &hFilter);
	Word __fastcall DropFilter(Bde::hDBICur hCursor, Bde::hDBIFilter hFilter);
	Word __fastcall ActivateFilter(Bde::hDBICur hCursor, Bde::hDBIFilter hFilter);
	Word __fastcall DeactivateFilter(Bde::hDBICur hCursor, Bde::hDBIFilter hFilter);
	Word __fastcall GetErrorEntry(Word uEntry, int &ulNativeError, char * pszError);
	Word __fastcall GetErrorString(Word rslt, AnsiString ErrorMsg);
	Word __fastcall QExecDirect(Bde::hDBIDb hDb, Bde::DBIQryLang eQryLang, AnsiString pszQuery, Bde::phDBICur 
		phCur);
	Word __fastcall QAlloc(Bde::hDBIDb hDb, Bde::DBIQryLang eQryLang, Bde::hDBIStmt &hStmt);
	Word __fastcall QPrepare(Bde::hDBIStmt hStmt, AnsiString pszQuery);
	Word __fastcall QExec(Bde::hDBIStmt hStmt, Bde::phDBICur phCur);
	Word __fastcall QPrepareExt(Bde::hDBIDb hDb, Bde::DBIQryLang eQryLang, char * pszQuery, Word propBits
		, Bde::hDBIStmt &hStmt);
	Word __fastcall QFree(Bde::hDBIStmt &hStmt);
	Word __fastcall QuerySetParams(Bde::hDBIStmt hStmt, Db::TParams* Params, AnsiString SQLText);
	Word __fastcall CheckError(void);
	Word __fastcall GetClientInfo(AnsiString &ClientInfo);
	Word __fastcall GetServerStat(Bde::hDBIDb hDb, AnsiString &ServerStat);
	Word __fastcall GetHostInfo(Bde::hDBIDb hDb, AnsiString &HostInfo);
	Word __fastcall GetProtoInfo(Bde::hDBIDb hDb, unsigned &ProtoInfo);
	Word __fastcall GetServerInfo(Bde::hDBIDb hDb, AnsiString &ServerInfo);
	Word __fastcall GetDatabases(Bde::hDBIDb hDb, char * pszWild, Classes::TStrings* List);
	Word __fastcall SelectDb(Bde::hDBIDb hDb, char * pszDbName);
	Word __fastcall GetCharacterSet(Bde::hDBIDb hDb, Mysqlcp::TConvertChar &CharSet);
	Word __fastcall Ping(Bde::hDBIDb hDb, int &Status);
	Word __fastcall Kill(Bde::hDBIDb hDb, int PID);
	Word __fastcall OpenFieldList(Bde::hDBIDb hDb, char * pszTableName, char * pszDriverType, BOOL bPhyTypes
		, Bde::hDBICur &hCur);
	Word __fastcall OpenIndexList(Bde::hDBIDb hDb, char * pszTableName, char * pszDriverType, Bde::hDBICur 
		&hCur);
	Word __fastcall EmptyTable(Bde::hDBIDb hDb, Bde::hDBICur hCursor, char * pszTableName, char * pszDriverType
		);
	Word __fastcall SetRange(Bde::hDBICur hCursor, BOOL bKeyItself, Word iFields1, Word iLen1, void * pKey1
		, BOOL bKey1Incl, Word iFields2, Word iLen2, void * pKey2, BOOL bKey2Incl);
	Word __fastcall ResetRange(Bde::hDBICur hCursor);
	Word __fastcall SwitchToIndex(Bde::hDBICur hCursor, char * pszIndexName, char * pszTagName, Word iIndexId
		, BOOL bCurrRec);
	Word __fastcall ExtractKey(Bde::hDBICur hCursor, void * PRecord, void * pKeyBuf);
	Word __fastcall GetRecordForKey(Bde::hDBICur hCursor, BOOL bDirectKey, Word iFields, Word iLen, void * 
		pKey, void * pRecBuff);
	Word __fastcall AddIndex(Bde::hDBIDb hDb, Bde::hDBICur hCursor, char * pszTableName, char * pszDriverType
		, Bde::IDXDesc &IdxDesc, char * pszKeyviolName);
	Word __fastcall DeleteIndex(Bde::hDBIDb hDb, Bde::hDBICur hCursor, char * pszTableName, char * pszDriverType
		, char * pszIndexName, char * pszIndexTagName, Word iIndexId);
	Word __fastcall GetIndexDesc(Bde::hDBICur hCursor, Word iIndexSeqNo, Bde::IDXDesc &idxDesc);
	Word __fastcall GetIndexDescs(Bde::hDBICur hCursor, Bde::pIDXDesc idxDesc);
	Word __fastcall TranslateRecordStructure(char * pszSrcDriverType, Word iFlds, Bde::pFLDDesc pfldsSrc
		, char * pszDstDriverType, char * pszLangDriver, Bde::pFLDDesc pfldsDst, BOOL bCreatable);
	Word __fastcall TableExists(Bde::hDBIDb hDb, char * pszTableName);
	Word __fastcall CreateTable(Bde::hDBIDb hDb, BOOL bOverWrite, Bde::CRTblDesc &crTblDsc);
	Word __fastcall AcqTableLock(Bde::hDBICur hCursor, Bde::DBILockType eLockType);
	Word __fastcall RelTableLock(Bde::hDBICur hCursor, BOOL bAll, Bde::DBILockType eLockType);
	Word __fastcall SetToKey(Bde::hDBICur hCursor, Bde::DBISearchCond eSearchCond, BOOL bDirectKey, Word 
		iFields, Word iLen, void * pBuff);
	Word __fastcall CloneCursor(Bde::hDBICur hCurSrc, BOOL bReadOnly, BOOL bUniDirectional, Bde::hDBICur 
		&hCurNew);
	Word __fastcall SetToCursor(Bde::hDBICur hDest, Bde::hDBICur hSrc);
};


#pragma option push -b-
enum TMySqlOpenMode { omUse, omStore };
#pragma option pop

class DELPHICLASS TmySQLField;
class PASCALIMPLEMENTATION TmySQLField : public Classes::TCollectionItem 
{
	typedef Classes::TCollectionItem inherited;
	
private:
	#pragma pack(push, 1)
	Bde::FLDDesc FDesc;
	#pragma pack(pop)
	
	#pragma pack(push, 1)
	Bde::VCHKDesc FValCheck;
	#pragma pack(pop)
	
	void *FBuffer;
	void *FData;
	Mysqltypes::TFieldStatus *FStatus;
	AnsiString FEnum_Val;
	Word __fastcall GetLocalSize(void);
	void __fastcall SetLocalSize(Word S);
	Word __fastcall GetLocalType(void);
	void __fastcall SetLocalType(Word S);
	AnsiString __fastcall GetFieldName(void);
	void __fastcall SetFieldName(const AnsiString Value);
	void __fastcall SetBuffer(void * PRecord);
	bool __fastcall GetChanged(void);
	void __fastcall SetChanged(bool Flag);
	bool __fastcall GetNull(void);
	void __fastcall SetNull(bool Flag);
	
public:
	__fastcall TmySQLField(Classes::TCollection* Owner, Bde::pFLDDesc P, Bde::pVCHKDesc P1, Word FNum, 
		Word LType, Word LSize, AnsiString enum_val);
	char * __fastcall FieldValue(void);
	__property void * Buffer = {read=FBuffer, write=SetBuffer};
	__property void * Data = {read=FData};
	__property Word DataOffset = {read=FDesc.iOffset, write=FDesc.iOffset, nodefault};
	__property Bde::FLDDesc Description = {read=FDesc, write=FDesc};
	__property Bde::VCHKDesc ValCheck = {read=FValCheck, write=FValCheck};
	__property bool FieldChanged = {read=GetChanged, write=SetChanged, nodefault};
	__property bool FieldNull = {read=GetNull, write=SetNull, nodefault};
	__property Mysqltypes::PFieldStatus FieldStatus = {read=FStatus};
	__property Word NullOffset = {read=FDesc.iNullOffset, write=FDesc.iNullOffset, nodefault};
	
__published:
	__property Word FieldNumber = {read=FDesc.iFldNum, write=FDesc.iFldNum, nodefault};
	__property AnsiString FieldName = {read=GetFieldName, write=SetFieldName};
	__property Word FieldType = {read=FDesc.iFldType, write=FDesc.iFldType, nodefault};
	__property Word FieldSubType = {read=FDesc.iSubType, write=FDesc.iSubType, nodefault};
	__property short FieldUnits1 = {read=FDesc.iUnits1, write=FDesc.iUnits1, nodefault};
	__property short FieldUnits2 = {read=FDesc.iUnits2, write=FDesc.iUnits2, nodefault};
	__property Word FieldLength = {read=FDesc.iLen, write=FDesc.iLen, nodefault};
	__property Word NativeType = {read=GetLocalType, write=SetLocalType, nodefault};
	__property Word NativeSize = {read=GetLocalSize, write=SetLocalSize, nodefault};
	__property AnsiString ENUN_VALUE = {read=FEnum_Val, write=FEnum_Val};
public:
	#pragma option push -w-inl
	/* TCollectionItem.Create */ inline __fastcall virtual TmySQLField(Classes::TCollection* Collection
		) : Classes::TCollectionItem(Collection) { }
	#pragma option pop
	#pragma option push -w-inl
	/* TCollectionItem.Destroy */ inline __fastcall virtual ~TmySQLField(void) { }
	#pragma option pop
	
};


class DELPHICLASS TmySQLFields;
class DELPHICLASS TNativeDataSet;
class DELPHICLASS TmySQLIndexes;
class DELPHICLASS TmySQLIndex;
class PASCALIMPLEMENTATION TmySQLIndexes : public Classes::TCollection 
{
	typedef Classes::TCollection inherited;
	
private:
	TNativeDataSet* FTable;
	TmySQLIndex* __fastcall GetIndex(int Index);
	TmySQLIndex* __fastcall FindByName(AnsiString Name);
	
public:
	__fastcall TmySQLIndexes(TNativeDataSet* Table);
	__property TmySQLIndex* mIndex[int Index] = {read=GetIndex/*, default*/};
	void __fastcall SetIndex(AnsiString Name, AnsiString Fields, bool aPrimary, bool aUnique, bool aDesc
		);
	int __fastcall FieldNumberFromName(char * SearchName);
public:
	#pragma option push -w-inl
	/* TCollection.Destroy */ inline __fastcall virtual ~TmySQLIndexes(void) { }
	#pragma option pop
	
};


class PASCALIMPLEMENTATION TNativeDataSet : public System::TObject 
{
	typedef System::TObject inherited;
	
protected:
	int FRecNo;
	TMySqlOpenMode FOpenMode;
	Bde::DBIOpenMode FOMode;
	char * *FRow;
	int FRecordCount;
	Mysqltypes::TMYSQL_RES *FStatement;
	Mysqltypes::TContainer* FFilters;
	bool FFilterActive;
	bool FReFetch;
	TmySQLFields* FFieldDescs;
	TmySQLIndexes* FIndexDescs;
	short FKeyNumber;
	char FIndexName[261];
	short FPrimaryKeyNumber;
	bool FGetKeyDesc;
	#pragma pack(push, 1)
	Bde::IDXDesc FKeyDesc;
	#pragma pack(pop)
	
	bool Ranges;
	int FRecSize;
	TNativeConnect* FConnect;
	bool FOpen;
	int FAffectedRows;
	int FBookOfs;
	Mysqltypes::TRecordState FRecordState;
	Mysqltypes::TDir FLastDir;
	void *FCurrentBuffer;
	void *FInternalBuffer;
	bool FIsLocked;
	bool FReRead;
	Classes::TStrings* OrderClause;
	Classes::TStrings* RangeClause;
	Classes::TStrings* StandartClause;
	Classes::TStrings* LimitClause;
	bool AutoReExec;
	#pragma pack(push, 1)
	Bde::TBLBaseDesc FBaseDesc;
	#pragma pack(pop)
	
	int FLimit;
	int FOffset;
	void *MasterCursor;
	void __fastcall SetInternalBuffer(void * Buffer);
	void * __fastcall GetInternalBuffer(void);
	void * __fastcall GetCurrentBuffer(void);
	void __fastcall SetCurrentBuffer(void * PRecord);
	void __fastcall SetBufferAddress(void * P);
	void __fastcall SetKeyNumber(short newValue);
	Word __fastcall FieldOffset(int iField);
	int __fastcall GetBookMarkSize(void);
	int __fastcall GetIndexCount(void);
	void __fastcall SetBufBookmark(void);
	int __fastcall GetRecordNumber(void);
	int __fastcall GetRecCount(void);
	void __fastcall InitFieldDescs(void);
	void __fastcall CheckFilter(void * PRecord);
	virtual void __fastcall FirstRecord(void);
	void __fastcall LastRecord(void);
	void __fastcall NextRecord(void);
	void __fastcall PrevRecord(void);
	void __fastcall CurrentRecord(int RecNo);
	void __fastcall GetWorkRecord(Bde::DBILockType eLock, void * PRecord);
	void __fastcall GetRecordNo(int &iRecNo);
	void __fastcall LockRecord(Bde::DBILockType eLock);
	bool __fastcall FilteredRecord(void * PRecord);
	void __fastcall UpdateFilterStatus(void);
	int __fastcall FieldCount(void);
	void __fastcall InternalReadBuffer(void);
	char * __fastcall GetTableName(void);
	void __fastcall SetTableName(char * Name);
	void __fastcall GetKeys(bool Unique, int * FieldList, int &FieldCount);
	AnsiString __fastcall GetDeleteSQL(AnsiString Table, void * PRecord);
	AnsiString __fastcall GetInsertSQL(AnsiString Table, void * PRecord);
	AnsiString __fastcall GetUpdateSQL(AnsiString Table, void * OldRecord, void * PRecord);
	AnsiString __fastcall InternaENUM_SET_Value(AnsiString TableName, AnsiString FieldName);
	System::ShortString __fastcall FieldName(int FieldNum);
	int __fastcall FieldIndex( System::ShortString &FieldName);
	int __fastcall FieldSize(int FieldNum);
	int __fastcall FieldMaxSize(int FieldNum);
	int __fastcall FieldType(int FieldNum);
	bool __fastcall FieldIsNull(int FieldNum);
	AnsiString __fastcall Field(int FieldNum);
	char * __fastcall FieldBuffer(int FieldNum);
	AnsiString __fastcall FieldByName( System::ShortString &FieldName);
	int __fastcall FieldDecimals(int FieldNum);
	char * __fastcall GetSQLClause(void);
	virtual Word __fastcall GetBufferSize(void);
	virtual Word __fastcall GetWorkBufferSize(void);
	void __fastcall GetNativeDesc(int FieldNo, Bde::pFLDDesc P, Bde::pVCHKDesc P1, Word &LocType, Word 
		&LocSize, AnsiString &EnumValue);
	void __fastcall NativeToDelphi(TmySQLField* P, void * PRecord, void * pDest, BOOL &bBlank);
	void __fastcall DelphiToNative(TmySQLField* P, void * PRecord, void * pSrc);
	void __fastcall CheckParam(bool Exp, Word BDECODE);
	int __fastcall GetRecordSize(void);
	Mysqltypes::PMYSQL_FIELD __fastcall GetFieldInfo(int Index);
	void __fastcall ReOpenTable(void);
	void __fastcall ClearIndexInfo(void);
	
private:
	__property short KeyNumber = {read=FKeyNumber, write=SetKeyNumber, nodefault};
	__property int RecordNumber = {read=GetRecordNumber, nodefault};
	__property int RecordCount = {read=GetRecCount, nodefault};
	__property TmySQLFields* Fields = {read=FFieldDescs};
	__property int RecordSize = {read=GetRecordSize, nodefault};
	__property Mysqltypes::PMYSQL_FIELD FieldInfo[int Index] = {read=GetFieldInfo};
	__property int BookMarkSize = {read=GetBookMarkSize, nodefault};
	__property void * BufferAddress = {write=SetBufferAddress};
	__property void * CurrentBuffer = {read=GetCurrentBuffer, write=SetCurrentBuffer};
	__property void * InternalBuffer = {read=GetInternalBuffer, write=SetInternalBuffer};
	__property int IndexCount = {read=GetIndexCount, nodefault};
	
public:
	AnsiString SQLQuery;
	__fastcall TNativeDataSet(TNativeConnect* mySQL, Mysqltypes::TContainer* Container, char * Name, char * 
		IndexName, Word Index, int Offset, int Limit);
	__fastcall virtual ~TNativeDataSet(void);
	void __fastcall CompareBookMarks(void * pBookMark1, void * pBookMark2, int &CmpBkmkResult);
	void __fastcall GetBookMark(void * P);
	void __fastcall Execute(void);
	void __fastcall OpenTable(void);
	void __fastcall ShowIndexes( System::ShortString &TableName);
	void __fastcall GetField(Word FieldNo, void * PRecord, void * pDest, BOOL &bBlank);
	void __fastcall PutField(Word FieldNo, void * PRecord, void * PSrc);
	void __fastcall CloseTable(void);
	void __fastcall GetVchkDesc(Word iValSeqNo, Bde::pVCHKDesc pvalDesc);
	void __fastcall GetCursorProps(Bde::CURProps &curProps);
	void __fastcall GetFieldDescs(Bde::pFLDDesc pFDesc);
	virtual void __fastcall GetRecordCount(int &iRecCount);
	void __fastcall LoadProperties(Bde::pRECProps pRecProps);
	virtual void __fastcall GetNextRecord(Bde::DBILockType eLock, void * PRecord, Bde::pRECProps pRecProps
		);
	virtual void __fastcall SetToBookmark(void * P);
	void __fastcall GetRecord(Bde::DBILockType eLock, void * PRecord, Bde::pRECProps pRecProps);
	void __fastcall GetPriorRecord(Bde::DBILockType eLock, void * PRecord, Bde::pRECProps pRecProps);
	void __fastcall AddFilter(int iClientData, Word iPriority, BOOL bCanAbort, Bde::pCANExpr pcanExpr, 
		Bde::pfGENFilter pfFilter, Bde::hDBIFilter &hFilter);
	void __fastcall DropFilter(Bde::hDBIFilter hFilter);
	void __fastcall ActivateFilter(Bde::hDBIFilter hFilter);
	void __fastcall DeactivateFilter(Bde::hDBIFilter hFilter);
	void __fastcall GetProp(int iProp, void * PropValue, Word iMaxLen, Word &iLen);
	void __fastcall SetProp(int iProp, int PropValue);
	virtual void __fastcall SetToBegin(void);
	void __fastcall SetToEnd(void);
	void __fastcall ForceReread(void);
	void __fastcall InitRecord(void * PRecord);
	void __fastcall InsertRecord(Bde::DBILockType eLock, void * PRecord);
	void __fastcall AppendRecord(void * PRecord);
	void __fastcall ModifyRecord(void * OldRecord, void * PRecord, BOOL bFreeLock);
	void __fastcall DeleteRecord(void * PRecord);
	void __fastcall SetToRecord(int RecNo);
	void __fastcall OpenBlob(void * PRecord, Word FieldNo, Bde::DBIOpenMode eOpenMode);
	void __fastcall FreeBlob(void * PRecord, Word FieldNo);
	void __fastcall GetBlobSize(void * PRecord, Word FieldNo, int &iSize);
	void __fastcall GetBlob(void * PRecord, Word FieldNo, int iOffSet, int iLen, void * pDest, int &iRead
		);
	void __fastcall PutBlob(void * PRecord, Word FieldNo, int iOffSet, int iLen, void * pSrc);
	void __fastcall TruncateBlob(void * PRecord, Word FieldNo, int iLen);
	void __fastcall QuerySetParams(Db::TParams* Params, AnsiString SQLText);
	void __fastcall RelRecordLock(BOOL bAll);
	void __fastcall ExtractKey(void * PRecord, void * pKeyBuf);
	void __fastcall GetRecordForKey(BOOL bDirectKey, Word iFields, Word iLen, void * pKey, void * pRecBuff
		);
	void __fastcall GetIndexDesc(Word iIndexSeqNo, Bde::IDXDesc &idxDesc);
	void __fastcall GetIndexDescs(Bde::pIDXDesc Desc);
	void __fastcall SetRange(BOOL bKeyItself, Word iFields1, Word iLen1, void * pKey1, BOOL bKey1Incl, 
		Word iFields2, Word iLen2, void * pKey2, BOOL bKey2Incl);
	void __fastcall ResetRange(void);
	void __fastcall SwitchToIndex(char * pszIndexName, char * pszTagName, Word iIndexId, BOOL bCurrRec)
		;
	void __fastcall SettoSeqNo(int iSeqNo);
	void __fastcall EmptyTable(void);
	void __fastcall AddIndex(Bde::IDXDesc &IdxDesc, char * pszKeyviolName);
	void __fastcall DeleteIndex(char * pszIndexName, char * pszIndexTagName, Word iIndexId);
	void __fastcall AcqTableLock(Bde::DBILockType eLockType);
	void __fastcall RelTableLock(BOOL bAll, Bde::DBILockType eLockType);
	void __fastcall SetToKey(Bde::DBISearchCond eSearchCond, BOOL bDirectKey, Word iFields, Word iLen, 
		void * pBuff);
	void __fastcall Clone(BOOL bReadOnly, BOOL bUniDirectional, Bde::hDBICur &hCurNew);
	void __fastcall SetToCursor(Bde::hDBICur hDest);
	__property TMySqlOpenMode OpenMode = {read=FOpenMode, write=FOpenMode, nodefault};
	__property Mysqltypes::TRecordState RecordState = {read=FRecordState, write=FRecordState, nodefault
		};
	__property char * TableName = {read=GetTableName, write=SetTableName};
};


class PASCALIMPLEMENTATION TmySQLFields : public Classes::TCollection 
{
	typedef Classes::TCollection inherited;
	
private:
	TNativeDataSet* FTable;
	TmySQLField* __fastcall GetField(int Index);
	
public:
	__fastcall TmySQLFields(TNativeDataSet* Table);
	__property TmySQLField* Field[int Index] = {read=GetField/*, default*/};
	void __fastcall SetFields(void * PRecord);
	int __fastcall FieldNumberFromName(char * SearchName);
public:
	#pragma option push -w-inl
	/* TCollection.Destroy */ inline __fastcall virtual ~TmySQLFields(void) { }
	#pragma option pop
	
};


class PASCALIMPLEMENTATION TmySQLIndex : public Classes::TCollectionItem 
{
	typedef Classes::TCollectionItem inherited;
	
private:
	#pragma pack(push, 1)
	Bde::IDXDesc FDesc;
	#pragma pack(pop)
	
	AnsiString __fastcall GetIndexName(void);
	void __fastcall SetIndexName(const AnsiString Value);
	
public:
	__fastcall TmySQLIndex(Classes::TCollection* Owner, Bde::pIDXDesc P);
	__property Bde::IDXDesc Description = {read=FDesc, write=FDesc};
	
__published:
	__property Word IndexNumber = {read=FDesc.iIndexId, write=FDesc.iIndexId, nodefault};
	__property AnsiString IndexName = {read=GetIndexName, write=SetIndexName};
	__property Word Primary = {read=FDesc.bPrimary, write=FDesc.bPrimary, nodefault};
	__property Word Unique = {read=FDesc.bUnique, write=FDesc.bUnique, nodefault};
	__property Word Descending = {read=FDesc.bDescending, write=FDesc.bDescending, nodefault};
	__property Word FldsInKey = {read=FDesc.iFldsInKey, write=FDesc.iFldsInKey, nodefault};
	__property Word KeyLen = {read=FDesc.iKeyLen, write=FDesc.iKeyLen, nodefault};
	__property Word BlockSize = {read=FDesc.iBlockSize, write=FDesc.iBlockSize, nodefault};
public:
	#pragma option push -w-inl
	/* TCollectionItem.Create */ inline __fastcall virtual TmySQLIndex(Classes::TCollection* Collection
		) : Classes::TCollectionItem(Collection) { }
	#pragma option pop
	#pragma option push -w-inl
	/* TCollectionItem.Destroy */ inline __fastcall virtual ~TmySQLIndex(void) { }
	#pragma option pop
	
};


class DELPHICLASS TmySQLFilter;
class PASCALIMPLEMENTATION TmySQLFilter : public System::TObject 
{
	typedef System::TObject inherited;
	
protected:
	Variant __fastcall PerformCANOp(Bde::CANOp AOperator, const Variant &AOp1, const Variant &AOp2);
	Variant __fastcall PerformCanConst(Bde::pCANConst ANode, void * ValuesStart, Mysqltypes::TFldType &
		FldType);
	System::TDateTime __fastcall TimeOf(const System::TDateTime ADateTime);
	
private:
	TNativeDataSet* FDataSet;
	Bde::CANExpr *FExpression;
	BOOL FActive;
	Word FExprSize;
	void *FRecBuff;
	Bde::pfGENFilter FPfFilter;
	int FClientData;
	int __fastcall GetLiteralStart(void);
	int __fastcall GetNodeStart(void);
	Bde::pCANNode __fastcall GetNodeByOffset(int AOffSet);
	Variant __fastcall UnaryNode(Bde::pCANUnary ANode);
	Variant __fastcall BinaryNode(Bde::pCANBinary ANode);
	Variant __fastcall CompareNode(Bde::pCANCompare ANode);
	Variant __fastcall FieldNode(Bde::pCANField ANode);
	Variant __fastcall GetNodeValue(int AOffSet);
	Variant __fastcall CalcExpression(Bde::pCANNode ANode);
	__property int LiteralStart = {read=GetLiteralStart, nodefault};
	__property int NodeStart = {read=GetNodeStart, nodefault};
	
public:
	__fastcall TmySQLFilter(TNativeDataSet* Owner, int AClientData, Bde::pCANExpr Exp, Bde::pfGENFilter 
		pfFilt);
	__fastcall virtual ~TmySQLFilter(void);
	Variant __fastcall GetFilterResult(void * PRecord);
	__property BOOL Active = {read=FActive, write=FActive, nodefault};
};


class DELPHICLASS TIndexList;
class PASCALIMPLEMENTATION TIndexList : public TNativeDataSet 
{
	typedef TNativeDataSet inherited;
	
private:
	void *Descs;
	Word Items;
	Word Position;
	
public:
	__fastcall TIndexList(TNativeConnect* mySQL, void * D, Word TotalCount);
	__fastcall virtual ~TIndexList(void);
	virtual void __fastcall SetToBegin(void);
	virtual void __fastcall GetNextRecord(Bde::DBILockType eLock, void * PRecord, Bde::pRECProps pRecProps
		);
	virtual Word __fastcall GetBufferSize(void);
	virtual Word __fastcall GetworkBufferSize(void);
	virtual void __fastcall SetToBookmark(void * P);
	virtual void __fastcall GetRecordCount(int &iRecCount);
};


class DELPHICLASS TFieldList;
class PASCALIMPLEMENTATION TFieldList : public TIndexList 
{
	typedef TIndexList inherited;
	
public:
	virtual Word __fastcall GetBufferSize(void);
public:
	#pragma option push -w-inl
	/* TIndexList.Create */ inline __fastcall TFieldList(TNativeConnect* mySQL, void * D, Word TotalCount
		) : TIndexList(mySQL, D, TotalCount) { }
	#pragma option pop
	#pragma option push -w-inl
	/* TIndexList.Destroy */ inline __fastcall virtual ~TFieldList(void) { }
	#pragma option pop
	
};


//-- var, const, procedure ---------------------------------------------------
extern PACKAGE Word __fastcall AdjustNativeField(TmySQLField* iField, void * Src, void * Dest, BOOL 
	&Blank);
extern PACKAGE Word __fastcall AdjustDelphiField(TmySQLField* iField, void * Src, void * Dest);
extern PACKAGE void __fastcall mySQLException(TNativeConnect* mySQL);
extern PACKAGE void __fastcall mySQLExceptionMsg(TNativeConnect* mySQL, const AnsiString ErrorMsg);
extern PACKAGE AnsiString __fastcall BDETOMySQLStr(TmySQLField* Field);
extern PACKAGE AnsiString __fastcall BDETOMySQLIdxStr(TmySQLIndex* Index, TmySQLFields* Flds);
extern PACKAGE AnsiString __fastcall SQLCreateIdxStr(TmySQLIndex* Index, AnsiString TableName, TmySQLFields* 
	Flds);

}	/* namespace Mysqlaccess */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Mysqlaccess;
#endif
#pragma option pop	// -w-
#pragma option pop	// -Vx

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// mySQLAccess
