{*******************************************************}
{                                                       }
{  mySQLExplorer main unit                              }
{                                                       }
{  Copyright (c) 2001 Jos Len Serna                   }
{                                                       }
{*******************************************************}
unit uMainUnit;

interface

uses
    Windows, Messages, SysUtils,
    Classes, Graphics, Controls,
    Forms, Dialogs, Grids, 
    DBGrids, Db, mySQLDbTables,
    ComCtrls, ExtCtrls, ToolWin,
    Menus, ImgList, ActnList, registry,
    uRegisterDatabase, mySQLCp, DBCtrls;

type
    TmySQLForm = class(TForm)
        MainMenu: TMainMenu;
        Object1: TMenuItem;
        Panel1: TPanel;
        Panel2: TPanel;
        PageControl1: TPageControl;
        TabSheet1: TTabSheet;
        StatusBar1: TStatusBar;
        dbTreeView: TTreeView;
        Splitter1: TSplitter;
        Panel3: TPanel;
        pnText: TPanel;
        pcData: TPageControl;
        tsDefinition: TTabSheet;
        ImageList: TImageList;
        ActionList: TActionList;
        ObjectRegisterDatabaseCommand: TAction;
        ObjectRegisterDatabaseCommand1: TMenuItem;
        dsCommon: TDataSource;
        tsData: TTabSheet;
        DBGrid: TDBGrid;
        defGrid: TStringGrid;
        tsSummary: TTabSheet;
        lvSummary: TListView;
        ImageList2: TImageList;
        ViewLargeIconsCommand: TAction;
        ViewSmallIconsCommand: TAction;
        ViewListCommand: TAction;
        ViewDetailCommand: TAction;
        View1: TMenuItem;
        ViewLargeIconsCommand1: TMenuItem;
        ViewSmallIconsCommand1: TMenuItem;
        ViewListCommand1: TMenuItem;
        ViewDetailCommand1: TMenuItem;
        ObjectExitCommand: TAction;
        N1: TMenuItem;
        Exit1: TMenuItem;
        Panel4: TPanel;
        ToolBar1: TToolBar;
        navigator: TDBNavigator;
        Panel5: TPanel;
        Bevel1: TBevel;
        ObjectCloseCommand: TAction;
        Close1: TMenuItem;
        ObjectUnregisterDatabaseCommand: TAction;
        UnregisterDatabase1: TMenuItem;
        ImageList1: TImageList;
        ToolButton1: TToolButton;
        ToolButton2: TToolButton;
        ToolButton3: TToolButton;
        ToolButton4: TToolButton;
        ToolButton5: TToolButton;
        ToolButton6: TToolButton;
        ToolButton7: TToolButton;
        ToolButton8: TToolButton;
        ViewBlobExplorerCommand: TAction;
        ToolButton9: TToolButton;
        ToolButton10: TToolButton;
        N2: TMenuItem;
        BlobExplorer1: TMenuItem;
        Help1: TMenuItem;
        About1: TMenuItem;
        PopupMenu: TPopupMenu;
        CloseDatabase1: TMenuItem;
        UnregisterDatabase2: TMenuItem;
        ViewDragCreatesFormCommand: TAction;
        ToolButton11: TToolButton;
        N3: TMenuItem;
        DragCreatesForm1: TMenuItem;
        ToolButton12: TToolButton;
        ObjectModifyDatabaseCommand: TAction;
        ModifyDatabase1: TMenuItem;
        ModifyDatabase2: TMenuItem;
        procedure ObjectRegisterDatabaseCommandUpdate(Sender: TObject);
        procedure ObjectRegisterDatabaseCommandExecute(Sender: TObject);
        procedure FormCreate(Sender: TObject);
        procedure dbTreeViewChange(Sender: TObject; Node: TTreeNode);
        procedure FormResize(Sender: TObject);
        procedure defGridDrawCell(Sender: TObject; ACol, ARow: Integer;
            Rect: TRect; State: TGridDrawState);
        procedure ViewLargeIconsCommandUpdate(Sender: TObject);
        procedure ViewLargeIconsCommandExecute(Sender: TObject);
        procedure ViewSmallIconsCommandExecute(Sender: TObject);
        procedure ViewListCommandExecute(Sender: TObject);
        procedure ViewDetailCommandExecute(Sender: TObject);
        procedure ObjectExitCommandExecute(Sender: TObject);
        procedure pcDataChange(Sender: TObject);
        procedure ObjectCloseCommandUpdate(Sender: TObject);
        procedure ObjectCloseCommandExecute(Sender: TObject);
        procedure dbTreeViewEditing(Sender: TObject; Node: TTreeNode;
            var AllowEdit: Boolean);
        procedure ObjectUnregisterDatabaseCommandExecute(Sender: TObject);
        procedure ViewBlobExplorerCommandExecute(Sender: TObject);
        procedure DBGridColEnter(Sender: TObject);
        procedure DBGridColExit(Sender: TObject);
        procedure FormClose(Sender: TObject; var Action: TCloseAction);
        procedure FormShow(Sender: TObject);
        procedure About1Click(Sender: TObject);
        procedure ObjectUnregisterDatabaseCommandUpdate(Sender: TObject);
        procedure dbTreeViewExpanded(Sender: TObject; Node: TTreeNode);
        procedure dbTreeViewMouseMove(Sender: TObject; Shift: TShiftState; X,
            Y: Integer);
        procedure dbTreeViewMouseUp(Sender: TObject; Button: TMouseButton;
            Shift: TShiftState; X, Y: Integer);
        procedure dbTreeViewMouseDown(Sender: TObject; Button: TMouseButton;
            Shift: TShiftState; X, Y: Integer);
        procedure ViewDragCreatesFormCommandExecute(Sender: TObject);
        procedure ObjectModifyDatabaseCommandUpdate(Sender: TObject);
        procedure ObjectModifyDatabaseCommandExecute(Sender: TObject);
        procedure dbTreeViewStartDrag(Sender: TObject;
            var DragObject: TDragObject);
    private
    { Private declarations }
        FDragObject: TDragObject;
    public
    { Public declarations }
        click: boolean;
        ox, oy: longint;
        parentNode: TTreeNode;
        //Adds a new database to the system
        procedure addNewDatabase(ahost, aport, ausername, apassword, dbname: string);

        //Shows the database information
        procedure showDatabaseData(database: TMySQLDatabase);
        //Shows the table information
        procedure showTableData(table: TMySQLTable);
        //Shows the field information
        procedure showFieldData(field: TField);
        //Load databases from registry
        procedure loaddatabases;
        //Store the position of the windows
        procedure storepositions;
        //Loads the position of the windows
        procedure loadpositions;
    end;

var
    mySQLForm: TmySQLForm;

const
    //Registry key to store configuration options    
    key = '\Software\QaDRAM\mySQLExplorer';

implementation

uses uBlobExplorer, uAboutDlg,uIDEInterface;

{$R *.DFM}

procedure TmySQLForm.ObjectRegisterDatabaseCommandUpdate(Sender: TObject);
begin
    (sender as TAction).enabled := true;
end;

procedure TmySQLForm.ObjectRegisterDatabaseCommandExecute(Sender: TObject);
begin
    with TRegisterDatabaseDlg.create(application) do begin
        try
            if showmodal = mrOk then begin
                addNewDatabase(edHost.text, edPort.text, edUsername.text, edPassword.text, edDatabase.text);
            end;
        finally
            free;
        end;
    end;
end;

procedure TmySQLForm.addNewDatabase(ahost, aport, ausername, apassword, dbname: string);
var
    db: TMySQLDatabase;
    t: TTreeNode;
    s: TStringList;
    tables: TTreeNode;
begin
    db := TMySQLDatabase.create(self);
    with db do begin
        host := ahost;
        handleshared := true;
        port := strtoint(aport);
        username := ausername;
        userpassword := apassword;
        databasename := dbname;
        t := dbtreeview.Items.AddChildObject(parentNode, dbname, db);
        t.ImageIndex := 1;
        t.SelectedIndex := 1;
        s := TStringList.create; //This strings remain as the node.data of the Tables node
        tables := dbtreeview.Items.AddChildObject(t, 'Tables', s);
        tables.ImageIndex := 2;
        tables.SelectedIndex := 2;
    end;
    with TRegistry.create do begin
        try
            openkey(key + '\Databases\' + dbname, true);
            writestring('host', ahost);
            writestring('port', aport);
            writestring('username', ausername);
            //It would be a good idea to encrypt this
            writestring('password', apassword);
        finally
            free;
        end;
    end;
end;

procedure TmySQLForm.FormCreate(Sender: TObject);
begin
    parentNode := dbTreeview.Items[0];
    click := false;
    tsDefinition.tabVisible := false;
    tsData.tabVisible := false;
    tsSummary.tabVisible := false;
    loadDatabases;
end;

procedure TmySQLForm.dbTreeViewChange(Sender: TObject; Node: TTreeNode);
var
    c: TObject;
    s: TStringList;
    i: longint;
    tb: TMySQLTable;
    li: TListItem;
begin
    if (assigned(node)) and (assigned(node.data)) then begin
        c := TObject(node.data);
        if c is TMySQLDatabase then begin
            tsDefinition.tabVisible := true;
            tsData.tabVisible := false;
            tsSummary.tabVisible := false;
            showdatabaseData((c as TMySQLDatabase));
        end
        else begin
            if c is TMySQLTable then begin
                tsData.tabVisible := true;
                tsDefinition.tabVisible := true;
                tsSummary.tabVisible := false;
                tb := (c as TMySQLTable);
                tb.active := true;
                showtableData(tb);
                blobexplorer.setfield(nil);
                dsCommon.dataset := tb;
            end
            else begin
                if c is TStringList then begin
                    tsDefinition.tabVisible := false;
                    tsData.tabVisible := false;
                    tsSummary.tabVisible := true;
                    s := (c as TStringList);
                    lvSummary.items.beginupdate;
                    try
                        lvSummary.items.clear;
                        for i := 0 to s.count - 1 do begin
                            li := lvSummary.Items.Add;
                            li.Caption := s[i];
                            li.imageindex := 3;
                        end;
                    finally
                        lvSummary.items.endupdate;
                    end;
                end
                else if c is TField then begin
                    tsDefinition.tabVisible := true;
                    tsData.tabVisible := false;
                    tsSummary.tabVisible := false;
                    showFieldData((c as TField));
                end;
            end;
        end;
    end
    else begin
        tsDefinition.tabVisible := false;
        tsData.tabVisible := false;
        tsSummary.tabVisible := false;
    end;
    pcDataChange(pcData);
    FormResize(self);
end;

procedure TmySQLForm.FormResize(Sender: TObject);
begin
    with defGrid do begin
        colwidths[1] := clientwidth - colwidths[0];
    end;
end;

procedure TmySQLForm.defGridDrawCell(Sender: TObject; ACol, ARow: Integer;
    Rect: TRect; State: TGridDrawState);
begin
    with defGrid.canvas do begin
        fillrect(rect);
        if ACol = 0 then font.style := [fsBold]
        else font.style := [];
        textout(rect.left + 4, rect.top + 1, defGrid.cells[ACol, ARow]);
    end;
end;

procedure TmySQLForm.showDatabaseData(database: TMySQLDatabase);
    function TranslateConvertChar(cchar: TConvertChar): string;
    begin
        case cChar of
            ccUndefine: result := 'Undefine';
            cc8859_1: result := '8859_1';
            cc8859_10: result := '8859_10';
            cc8859_13: result := '8859_13';
            cc8859_14: result := '8859_14';
            cc8859_15: result := '8859_15';
            cc8859_2: result := '8859_2';
            cc8859_3: result := '8859_3';
            cc8859_4: result := '8859_4';
            cc8859_5: result := '8859_5';
            cc8859_6: result := '8859_6';
            cc8859_7: result := '8859_7';
            cc8859_8: result := '8859_8';
            cc8859_9: result := '8859_9';
            ccCp1250: result := 'Cp1250';
            ccCp1251: result := 'Cp1251';
            ccCp1252: result := 'Cp1252';
            ccCp1253: result := 'Cp1253';
            ccCp1254: result := 'Cp1254';
            ccCp1255: result := 'Cp1255';
            ccCp1256: result := 'Cp1256';
            ccCp1257: result := 'Cp1257';
            ccCp1258: result := 'Cp1258';
            ccCp424: result := 'Cp424';
            ccCp437: result := 'Cp437';
            ccCp500: result := 'Cp500';
            ccCp737: result := 'Cp737';
            ccCp775: result := 'Cp775';
            ccCp850: result := 'Cp850';
            ccCp852: result := 'Cp852';
            ccCp855: result := 'Cp855';
            ccCp856: result := 'Cp856';
            ccCp857: result := 'Cp857';
            ccCp860: result := 'Cp860';
            ccCp861: result := 'Cp861';
            ccCp862: result := 'Cp862';
            ccCp863: result := 'Cp863';
            ccCp864: result := 'Cp864';
            ccCp865: result := 'Cp865';
            ccCp866: result := 'Cp866';
            ccCp869: result := 'Cp869';
            ccCp874: result := 'Cp874';
            ccCp875: result := 'Cp875';
            ccKoi8_r: result := 'Koi8_';
        end;
    end;


begin
    with database do begin
        defgrid.rowcount := 12;
        defgrid.cells[0, 0] := 'HOST';
        defgrid.cells[0, 1] := 'PORT';
        defgrid.cells[0, 2] := 'USERNAME';
        defgrid.cells[0, 3] := 'PASSWORD';
        defgrid.cells[0, 4] := 'DATABASE';
        defgrid.cells[0, 5] := 'CLIENTINFO';
        defgrid.cells[0, 6] := 'SERVERSTAT';
        defgrid.cells[0, 7] := 'HOSTINFO';
        defgrid.cells[0, 8] := 'PROTOINFO';
        defgrid.cells[0, 9] := 'SERVERINFO';
        defgrid.cells[0, 10] := 'CHARSET';
        defgrid.cells[0, 11] := 'PING';

        defgrid.cells[1, 0] := HOST;
        defgrid.cells[1, 1] := inttostr(PORT);
        defgrid.cells[1, 2] := USERNAME;
        defgrid.cells[1, 3] := userPASSWORD;
        defgrid.cells[1, 4] := DATABASEname;
        if connected then defgrid.cells[1, 5] := GetCLIENTINFO
        else defgrid.cells[1, 5] := 'database not connected!';
        if connected then defgrid.cells[1, 6] := GETSERVERSTAT
        else defgrid.cells[1, 6] := 'database not connected!';
        if connected then defgrid.cells[1, 7] := GETHOSTINFO
        else defgrid.cells[1, 7] := 'database not connected!';
        if connected then defgrid.cells[1, 8] := INTTOSTR(GETPROTOINFO)
        else defgrid.cells[1, 8] := 'database not connected!';
        if connected then defgrid.cells[1, 9] := GETSERVERINFO
        else defgrid.cells[1, 9] := 'database not connected!';
        if connected then defgrid.cells[1, 10] := translateConvertChar(getCHARSET)
        else defgrid.cells[1, 10] := 'database not connected!';
        if connected then defgrid.cells[1, 11] := INTTOSTR(PING)
        else defgrid.cells[1, 11] := 'database not connected!';
    end;
end;

procedure TmySQLForm.ViewLargeIconsCommandUpdate(Sender: TObject);
begin
    (sender as TAction).enabled := true;
end;

procedure TmySQLForm.ViewLargeIconsCommandExecute(Sender: TObject);
begin
    lvSummary.ViewStyle := vsIcon;
    viewlargeiconscommand.checked := false;
    viewsmalliconscommand.checked := false;
    viewlistcommand.checked := false;
    viewdetailcommand.checked := false;

    (sender as TAction).checked := true;
end;

procedure TmySQLForm.ViewSmallIconsCommandExecute(Sender: TObject);
begin
    lvSummary.ViewStyle := vsSmallIcon;
    viewlargeiconscommand.checked := false;
    viewsmalliconscommand.checked := false;
    viewlistcommand.checked := false;
    viewdetailcommand.checked := false;
    (sender as TAction).checked := true;
end;

procedure TmySQLForm.ViewListCommandExecute(Sender: TObject);
begin
    lvSummary.ViewStyle := vsList;
    viewlargeiconscommand.checked := false;
    viewsmalliconscommand.checked := false;
    viewlistcommand.checked := false;
    viewdetailcommand.checked := false;
    (sender as TAction).checked := true;
end;

procedure TmySQLForm.ViewDetailCommandExecute(Sender: TObject);
begin
    lvSummary.ViewStyle := vsReport;
    viewlargeiconscommand.checked := false;
    viewsmalliconscommand.checked := false;
    viewlistcommand.checked := false;
    viewdetailcommand.checked := false;
    (sender as TAction).checked := true;
end;

procedure TmySQLForm.showFieldData(field: TField);
var
    i: longint;
    function getFieldType: string;
    begin
        case field.datatype of
            ftUnknown: result := 'Unknown';
            ftString: result := 'String';
            ftSmallint: result := 'Smallint';
            ftInteger: result := 'Integer';
            ftWord: result := 'Word';
            ftBoolean: result := 'Boolean';
            ftFloat: result := 'Float';
            ftCurrency: result := 'Currency';
            ftBCD: result := 'BCD';
            ftDate: result := 'Date';
            ftTime: result := 'Time';
            ftDateTime: result := 'DateTime';
            ftBytes: result := 'Bytes';
            ftVarBytes: result := 'VarBytes';
            ftAutoInc: result := 'AutoInc';
            ftBlob: result := 'Blob';
            ftMemo: result := 'Memo';
            ftGraphic: result := 'Graphic';
            ftFmtMemo: result := 'FmtMemo';
            ftParadoxOle: result := 'ParadoxOle';
            ftDBaseOle: result := 'DBaseOle';
            ftTypedBinary: result := 'TypedBinary';
            ftCursor: result := 'Cursor';
            ftFixedChar: result := 'FixedChar';
            ftWideString: result := 'WideString';
            ftLargeint: result := 'Largeint';
            ftADT: result := 'ADT';
            ftArray: result := 'Array';
            ftReference: result := 'Reference';
            ftDataSet: result := 'DataSet';
            {$ifdef VER130}
            ftOraBlob: result := 'OraBlob';
            ftOraClob: result := 'OraClob';
            ftVariant: result := 'Variant';
            ftInterface: result := 'Interface';
            ftIDispatch: result := 'IDispatch';
            ftGuid: result := 'Guid';
            {$endif}
        end;
    end;
begin
    with field do begin
        i := 0;
        defgrid.rowcount := i + 1;
        defgrid.cells[0, i] := 'Type';
        defgrid.cells[1, i] := getFieldType;

        if field.Size <> 0 then begin
            inc(i);
            defgrid.rowcount := i + 1;
            defgrid.cells[0, i] := 'Size';
            defgrid.cells[1, i] := inttostr(field.size);
        end;

        inc(i);
        defgrid.rowcount := i + 1;
        defgrid.cells[0, i] := 'Physical Length';
        defgrid.cells[1, i] := inttostr(field.datasize);
    end;
end;

procedure TmySQLForm.ObjectExitCommandExecute(Sender: TObject);
begin
    storePositions;
    close;
end;

procedure TmySQLForm.pcDataChange(Sender: TObject);
var
    s: string;
begin
    if pcData.activepage = tsDefinition then begin
        s := format(' Definition of %s', [dbTreeView.selected.text]);
        navigator.visible := false;
    end
    else if pcData.activepage = tsSummary then begin
        s := format(' Summary of %s', [dbTreeView.selected.text]);
        navigator.visible := false;
    end
    else if pcData.activepage = tsData then begin
        s := format(' Contents of %s', [dbTreeView.selected.text]);
        navigator.visible := true;
    end
    else begin
        s := '';
        navigator.visible := false;
    end;
    pnText.caption := s;
end;

procedure TmySQLForm.ObjectCloseCommandUpdate(Sender: TObject);
var
    node: TTreeNode;
    c: TObject;
    en: boolean;
begin
    en := false;
    node := dbTreeView.selected;
    if assigned(node) then begin
        if assigned(node.data) then begin
            c := TObject(node.data);
            if c is TMySQLDatabase then begin
                en := (c as TMySQLDatabase).connected;
            end;
        end;
    end;
    (sender as TAction).enabled := en;
end;

procedure TmySQLForm.ObjectCloseCommandExecute(Sender: TObject);
var
    node: TTreeNode;
    c: TObject;
    tables: TTreeNode;
    s: TStringList;
begin
    node := dbTreeView.selected;
    if (assigned(node)) and (assigned(node.data)) then begin
        c := TObject(node.data);
        if c is TMySQLDatabase then begin
            (c as TMySQLDatabase).connected := false;
            node.imageindex := 1;
            node.selectedindex := 1;
            node.Collapse(true);
            if node.Count >= 1 then node.Item[0].free;

            s := TStringList.create; //This strings remain as the node.data of the Tables node
            tables := dbtreeview.Items.AddChildObject(node, 'Tables', s);
            tables.ImageIndex := 2;
            tables.SelectedIndex := 2;
        end;
    end;
end;

procedure TmySQLForm.dbTreeViewEditing(Sender: TObject; Node: TTreeNode;
    var AllowEdit: Boolean);
begin
    allowedit := false;
end;

procedure TmySQLForm.loaddatabases;
var
    s: TStringList;
    i: longint;
    dbname, host, port, username, password: string;
begin
    with TRegistry.create do begin
        s := TStringList.create;
        try
            openkey(key + '\Databases', true);
            getkeynames(s);
            for i := 0 to s.count - 1 do begin
                dbname := s[i];
                openkey(key + '\Databases\' + dbname, false);
                host := readstring('host');
                port := readstring('port');
                username := readstring('username');
                password := readstring('password');
                addNewDatabase(host, port, username, password, dbname);
            end;
        finally
            s.free;
            free;
        end;
    end;
end;

procedure TmySQLForm.ObjectUnregisterDatabaseCommandExecute(
    Sender: TObject);
var
    node: TTreeNode;
    c: TObject;
    dbname: string;
begin
    if application.messagebox('Are you sure you want to unregister this database?', 'Warning', MB_YESNO) = idyes then begin
        node := dbTreeView.selected;
        if (assigned(node)) and (assigned(node.data)) then begin
            c := TObject(node.data);
            if c is TMySQLDatabase then begin
                dbname := node.text;
                (c as TMySQLDatabase).connected := false;
                node.Collapse(true);
                node.free;
                (c as TMySQLDatabase).free;
                with TRegistry.create do begin
                    try
                        deletekey(key + '\Databases\' + dbname);
                    finally
                        free;
                    end;
                end;
            end;
        end;
    end;
end;

procedure TmySQLForm.ViewBlobExplorerCommandExecute(Sender: TObject);
begin
    (sender as TAction).checked := not (sender as TAction).checked;
    if (sender as TAction).checked then
       blobExplorer.show else
       blobExplorer.hide;
end;

procedure TmySQLForm.DBGridColEnter(Sender: TObject);
begin
    blobexplorer.setfield(dbgrid.selectedfield);
end;

procedure TmySQLForm.DBGridColExit(Sender: TObject);
begin
    blobexplorer.setfield(dbgrid.selectedfield);
end;

procedure TmySQLForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
    storePositions;
end;

procedure TmySQLForm.storepositions;
begin
    with TRegistry.create do begin
        try
            openkey(key + '\Windows\MainWindow', true);
            writeinteger('Left', self.left);
            writeinteger('Top', self.top);
            writeinteger('Width', self.width);
            writeinteger('Height', self.height);

            openkey(key + '\Windows\BlobExplorer', true);
            writeinteger('Left', blobexplorer.left);
            writeinteger('Top', blobexplorer.top);
            writeinteger('Width', blobexplorer.width);
            writeinteger('Height', blobexplorer.height);
            writebool('OnTop', (blobexplorer.formstyle = fsStayOnTop));
        finally
            free;
        end;
    end;
end;

procedure TmySQLForm.loadpositions;
begin
    with TRegistry.create do begin
        try
            if openkey(key + '\Windows\MainWindow', false) then begin
                self.left := readinteger('Left');
                self.top := readinteger('Top');
                self.width := readinteger('Width');
                self.height := readinteger('Height');
            end;

            if openkey(key + '\Windows\BlobExplorer', false) then begin
                blobexplorer.left := readinteger('Left');
                blobexplorer.top := readinteger('Top');
                blobexplorer.width := readinteger('Width');
                blobexplorer.height := readinteger('Height');
                if readbool('OnTop') then begin
                    blobexplorer.formstyle := fsStayOnTop;
                    blobexplorer.Alwaysontop1.checked := true;
                end
                else begin
                    blobexplorer.formstyle := fsNormal;
                    blobexplorer.Alwaysontop1.checked := false;
                end;
            end;
        finally
            free;
        end;
    end;
end;

procedure TmySQLForm.FormShow(Sender: TObject);
begin
    tsDefinition.caption := 'Definition';
    parentNode := dbTreeview.Items[0];
    loadpositions;
end;

procedure TmySQLForm.About1Click(Sender: TObject);
begin
    if myaboutDlg = nil then
       myaboutDlg := TmyaboutDlg.Create(Application);
    myaboutDlg.showmodal;
end;

procedure TmySQLForm.showTableData(table: TMySQLTable);
begin
    with table do begin
        defgrid.rowcount := 2;
        defgrid.cells[0, 0] := 'Database';
        defgrid.cells[0, 1] := 'Table';

        defgrid.cells[1, 0] := database.databasename;
        defgrid.cells[1, 1] := tablename;
    end;
end;

procedure TmySQLForm.ObjectUnregisterDatabaseCommandUpdate(
    Sender: TObject);
var
    node: TTreeNode;
    c: TObject;
    en: boolean;
begin
    en := false;
    node := dbTreeView.selected;
    if (assigned(node)) and (assigned(node.data)) then begin
        c := TObject(node.data);
        if c is TMySQLDatabase then begin
            en := true;
        end;
    end;
    (sender as TAction).enabled := en;
end;

procedure TmySQLForm.dbTreeViewExpanded(Sender: TObject; Node: TTreeNode);
var
    c: TObject;
    s: TStringList;
    d: TStringList;
    i: longint;
    tb: TMySQLTable;
    t: TTreeNode;
    tables: TTreeNode;
    fields: TTreeNode;
begin
    if (assigned(node)) and (assigned(node.data)) then begin
        c := TObject(node.data);
        if c is TMySQLDatabase then begin
            if not (c as TMySQLDatabase).connected then begin
                (c as TMySQLDatabase).connected := true;
                node.ImageIndex := 4;
                node.SelectedIndex := 4;
                tables := node.item[0];
                s := tables.data;
                (c as TMySQLDatabase).gettablenames('', s);
                for i := 0 to s.count - 1 do begin
                    tb := TMySQLTable.create(self);
                    tb.Database := (c as TMySQLDatabase);
                    tb.TableName := s[i];
                    t := dbtreeview.Items.AddChildObject(tables, tb.tablename, tb);
                    t.ImageIndex := 3;
                    t.SelectedIndex := 3;

                    d := TStringList.create;
                    fields := dbtreeview.Items.AddChildObject(t, 'Fields', d);
                    fields.ImageIndex := 2;
                    fields.SelectedIndex := 2;
                end;
            end;
        end
        else
            if c is TMySQLTable then begin
                if (not (c as TMySQLTable).active) or (node.item[0].count = 0) then begin
                    tb := (c as TMySQLTable);
                    fields := node.item[0];
                    d := fields.data;
                    tb.active := true;

                    for i := 0 to tb.fieldcount - 1 do begin
                        d.add(tb.fields[i].fieldname);
                        t := dbtreeview.Items.AddChildObject(fields, tb.fields[i].fieldname, tb.fields[i]);
                        t.ImageIndex := 3;
                        t.SelectedIndex := 3;
                    end;
                end;
            end;
    end
end;

procedure TmySQLForm.dbTreeViewMouseMove(Sender: TObject;
    Shift: TShiftState; X, Y: Integer);
begin
    if click then begin
        if (abs(x - ox) >= 3) or (abs(y - oy) >= 3) then dbTreeView.begindrag(false);
    end;
end;

procedure TmySQLForm.dbTreeViewMouseUp(Sender: TObject;
    Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
    click := false;
end;

procedure TmySQLForm.dbTreeViewMouseDown(Sender: TObject;
    Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
    if button = mbLeft then begin
        click := true;
        ox := x;
        oy := y;
    end;
end;

procedure TmySQLForm.ViewDragCreatesFormCommandExecute(Sender: TObject);
begin
    (sender as TAction).checked := not (sender as TAction).checked;
    if (sender as TAction).checked then dbTreeView.tag := 1
    else dbTreeView.tag := 0;
end;

procedure TmySQLForm.ObjectModifyDatabaseCommandUpdate(Sender: TObject);
var
    node: TTreeNode;
    c: TObject;
    en: boolean;
begin
    en := false;
    node := dbTreeView.selected;
    if (assigned(node)) and (assigned(node.data)) then begin
        c := TObject(node.data);
        if c is TMySQLDatabase then begin
            if ((c as TMySQLDatabase).connected = false) then en := true;
        end;
    end;
    (sender as TAction).enabled := en;
end;

procedure TmySQLForm.ObjectModifyDatabaseCommandExecute(Sender: TObject);
var
    node: TTreeNode;
    c: TObject;
    db: TMySQLDatabase;
begin
    node := dbTreeView.selected;
    if (assigned(node)) and (assigned(node.data)) then begin
        c := TObject(node.data);
        if c is TMySQLDatabase then begin
            db := (c as TMySQLDatabase);
            with TRegisterDatabaseDlg.create(application) do begin
                try
                    edHost.text := db.Host;
                    edPort.text := inttostr(db.port);
                    edUsername.text := db.username;
                    edPassword.text := db.userpassword;
                    edDatabase.text := db.databasename;
                    if showmodal = mrOk then begin
                        db.host := edHost.text;
                        db.port := strtoint(edPort.text);
                        db.username := edUsername.text;
                        db.userpassword := edPassword.text;
                        db.databasename := edDatabase.text;
                        node.text := db.databasename;
                        dbTreeViewChange(dbTreeView, Node);
                        with TRegistry.create do begin
                            try
                                openkey(key + '\Databases\' + db.databasename, true);
                                writestring('host', db.host);
                                writestring('port', inttostr(db.port));
                                writestring('username', db.username);
                                //It would be a good idea to encrypt this
                                writestring('password', db.userpassword);
                            finally
                                free;
                            end;
                        end;
                    end;
                finally
                    free;
                end;
            end;
        end;
    end;
end;

procedure TmySQLForm.dbTreeViewStartDrag(Sender: TObject;
    var DragObject: TDragObject);
begin
    if FDragObject = nil then FDragObject := TDragFields.Create(dbTreeView);
    DragObject := FDragObject;
end;

end.

