{*******************************************************}
{                                                       }
{  mySQLExplorer IDE interface                          }
{                                                       }
{  Copyright (c) 2001 Jos Len Serna                   }
{                                                       }
{*******************************************************}
unit uIDEInterface;

interface

uses
    Windows, Messages, SysUtils,
    {$ifdef VER140}
    designintf,designeditors,
    {$else}
    dsgnintf,
    {$endif}
    Classes, Graphics, Controls, Db, mySQLDbTables,
    {$ifdef VER140}
//    designintf,designeditors,
    {$else}
    LibIntf,
    {$endif}
    Forms, Dialogs, ExtCtrls, uMainUnit, uAboutDlg, uBlobExplorer,
    ComCtrls, EditIntf, VirtIntf, dbgrids, dbctrls,
    StdCtrls, ExptIntf, ToolIntf, Menus, ToolsAPI;

type
    TmySQLExplorerExpert = class(TIExpert)
    private
        DatabaseItem: TMenuItem;
        FParentMenu : TMenuItem;
    protected
        function CreateMenu(ParentName,AParentCaption,AName,ACaption : String;AImage: TBitmap;AShortCut : TShortCut;var ParentMenu : TMenuItem): TMenuItem;
    public
        procedure mySQLExplorerClick(Sender: TObject);
        constructor Create;
        destructor Destroy; override;
        function GetName: string; override; stdcall;
        function GetAuthor: string; override; stdcall;
        function GetComment: string; override; stdcall;
        function GetPage: string; override; stdcall;
        function GetGlyph: HICON; override; stdcall;
        function GetStyle: TExpertStyle; override; stdcall;
        function GetState: TExpertState; override; stdcall;
        function GetIDString: string; override; stdcall;
        function GetMenuText: string; override; stdcall;
    end;

type
    TDragFields = class(TDragControlObject)
    public
        constructor Create(AControl: TControl); reintroduce;
    end;

procedure Register;

implementation

{$R image.res}

procedure Register;
begin
    RegisterLibraryExpert(TmySQLExplorerExpert.Create);
end;

{ TDragFields }

constructor TDragFields.Create(AControl: TControl);
begin
    inherited Create(AControl);
end;

{ TFieldsTarget }

type
    TFieldsTarget = class(TDragTarget)
    public
        function DragOver(Target, Source: TObject; X, Y: Integer; State: TDragState): Boolean; override;
        procedure DragDrop(Target, Source: TObject; X, Y: Integer); override;
    end;

function TFieldsTarget.DragOver(Target, Source: TObject; X, Y: Integer;
    State: TDragState): Boolean;
begin
    Result := True;
end;

procedure TFieldsTarget.DragDrop(Target, Source: TObject; X, Y: Integer);
var
    AOwner: TComponent;
    cTarget: TComponent;
    cTreeView: TTreeView;
    node: TTreeNode;
    data: TObject;
    db: TMySQLDatabase;
    ds: TDatasource;
    gr: TDBGrid;
    tb: TMySQLTable;
    i: longint;
    c: TComponent;
    fw:longint;
    f: TField;
    lb: TLabel;
    ed: TDBEdit;
    me: TDBMemo;
    im: TDBImage;
    ch: TDBCheckBox;
begin
    cTarget := (Target as TComponent);
    cTreeView := (source as TDragFields).control as TTreeView;
    if assigned(cTarget.owner) then AOwner := cTarget.owner
    else AOwner := cTarget;

    node := cTreeView.selected;
    if assigned(node.data) then begin
        data := node.data;
        //*****************************************************
        if data is TMySQLDatabase then begin
            {$ifdef VER140}
            db := ((AOwner as TCustomForm).designer as IDesigner).CreateComponent(TMySQLDatabase, Target as TComponent, x, y, 34, 34) as TmySQLDatabase;
            {$else}
            db := ((AOwner as TCustomForm).designer as IFormDesigner).CreateComponent(TMySQLDatabase, Target as TComponent, x, y, 34, 34) as TmySQLDatabase;
            {$endif}
            with data as TMySQLDatabase do begin
                db.UserName := UserName;
                db.UserPassword := UserPassword;
                db.Port := Port;
                db.Host := Host;
                db.handleshared := true;
                db.Databasename := Databasename;
            end;
        end;
        //*****************************************************
        if data is TMySQLTable then begin
            {$ifdef VER140}
            tb := ((AOwner as TCustomForm).designer as IDesigner).CreateComponent(TMySQLTable, nil, 0, 0, 0, 0) as TmySQLTable;
            {$else}
            tb := ((AOwner as TCustomForm).designer as IFormDesigner).CreateComponent(TMySQLTable, nil, x, y, 0, 0) as TmySQLTable;
            {$endif}
            db := nil;
            for i := 0 to AOwner.componentcount - 1 do begin
                c := AOwner.components[i];
                if c is TMySQLDatabase then begin
                    with c as TMySQLDatabase do begin
                        if comparetext(databasename, (data as TMySQLTable).database.databasename) = 0 then begin
                            db := (c as TMySQLDatabase);
                            break;
                        end;
                    end;
                end;
            end;
            if not assigned(db) then begin
                {$ifdef VER140}
                db := ((AOwner as TCustomForm).designer as IDesigner).CreateComponent(TMySQLDatabase, nil, 0, 0, 0, 0) as TmySQLDatabase;
                {$else}
                db := ((AOwner as TCustomForm).designer as IFormDesigner).CreateComponent(TMySQLDatabase, nil, x, y, 0, 0) as TmySQLDatabase;
                {$endif}
                with data as TMySQLTable do begin
                    db.UserName := database.UserName;
                    db.UserPassword := database.UserPassword;
                    db.Port := database.Port;
                    db.Host := database.Host;
                    db.handleshared := true;
                    db.Databasename := database.Databasename;
                end;
            end;
            with data as TMySQLTable do begin
                tb.database := db;
                tb.tablename := tablename;
            end;
            {$ifdef VER140}
            ds := ((AOwner as TCustomForm).designer as IDesigner).CreateComponent(TDatasource, nil, 0, 0, 0, 0) as TDatasource;
            {$else}
            ds := ((AOwner as TCustomForm).designer as IFormDesigner).CreateComponent(TDatasource, nil, x, y, 0, 0) as TDatasource;
            {$endif}
            ds.dataset := tb;

            {$ifdef VER140}
            gr := ((AOwner as TCustomForm).designer as IDesigner).CreateComponent(TDBGrid, Target as TComponent, x, y, 320, 120) as TDBGrid;
            {$else}
            gr := ((AOwner as TCustomForm).designer as IFormDesigner).CreateComponent(TDBGrid, Target as TComponent, x, y, 320, 120) as TDBGrid;
            {$endif}
            gr.datasource := ds;
        end;
        //*****************************************************
        if data is TField then begin
            tb:=nil;
            f := (data as TField);
            for i := 0 to AOwner.componentcount - 1 do begin
                c := AOwner.components[i];
                if c is TMySQLTable then begin
                    tb := (c as TMySQLTable);
                    if comparetext((f.dataset as TMySQLTable).tablename, tb.tablename) = 0 then begin
                        if assigned(tb.database) then begin
                            if comparetext((f.dataset as TMySQLTable).database.databasename, tb.database.databasename) = 0 then begin
                                tb := (c as TMySQLTable);
                                break;
                            end
                            else tb := nil;
                        end
                        else tb := nil;
                    end
                    else tb := nil;
                end;
            end;

            if assigned(tb) then begin
                ds := nil;
                for i := 0 to AOwner.componentcount - 1 do begin
                    c := AOwner.components[i];
                    if c is TDatasource then begin
                        if (c as TDatasource).dataset = tb then begin
                            ds := (c as TDatasource);
                            break;
                        end;
                    end;
                end;
                if not assigned(ds) then begin
                    {$ifdef VER140}
                    ds := ((AOwner as TCustomForm).designer as IDesigner).CreateComponent(TDatasource, nil, x, y, 0, 0) as TDatasource;
                    {$else}
                    ds := ((AOwner as TCustomForm).designer as IFormDesigner).CreateComponent(TDatasource, nil, x, y, 0, 0) as TDatasource;
                    {$endif}
                    ds.dataset := tb;
                end;
            end
            else begin
                {$ifdef VER140}
                tb := ((AOwner as TCustomForm).designer as IDesigner).CreateComponent(TMySQLTable, nil, x, y, 0, 0) as TmySQLTable;
                {$else}
                tb := ((AOwner as TCustomForm).designer as IFormDesigner).CreateComponent(TMySQLTable, nil, x, y, 0, 0) as TmySQLTable;
                {$endif}
                db := nil;
                for i := 0 to AOwner.componentcount - 1 do begin
                    c := AOwner.components[i];
                    if c is TMySQLDatabase then begin
                        with c as TMySQLDatabase do begin
                            if comparetext(databasename, (f.dataset as TMySQLTable).database.databasename) = 0 then begin
                                db := (c as TMySQLDatabase);
                                break;
                            end;
                        end;
                    end;
                end;
                if not assigned(db) then begin
                    {$ifdef VER140}
                    db := ((AOwner as TCustomForm).designer as IDesigner).CreateComponent(TMySQLDatabase, nil, x, y, 0, 0) as TmySQLDatabase;
                    {$else}
                    db := ((AOwner as TCustomForm).designer as IFormDesigner).CreateComponent(TMySQLDatabase, nil, x, y, 0, 0) as TmySQLDatabase;
                    {$endif}
                    with f.dataset as TMySQLTable do begin
                        db.UserName := database.UserName;
                        db.UserPassword := database.UserPassword;
                        db.Port := database.Port;
                        db.Host := database.Host;
                        db.handleshared := true;
                        db.Databasename := database.Databasename;
                    end;
                end;
                with f.dataset as TMySQLTable do begin
                    tb.database := db;
                    tb.tablename := tablename;
                end;
                {$ifdef VER140}
                ds := ((AOwner as TCustomForm).designer as IDesigner).CreateComponent(TDatasource, nil, x, y, 0, 0) as TDatasource;
                {$else}
                ds := ((AOwner as TCustomForm).designer as IFormDesigner).CreateComponent(TDatasource, nil, x, y, 0, 0) as TDatasource;
                {$endif}
                ds.dataset := tb;
            end;

            with data as TField do begin
                case datatype of
                    ftBoolean: begin
                            {$ifdef VER140}
                            ch := ((AOwner as TCustomForm).designer as IDesigner).CreateComponent(TDBCheckbox, Target as TComponent, x, y, 97, 17) as TDBCheckbox;
                            {$else}
                            ch := ((AOwner as TCustomForm).designer as IFormDesigner).CreateComponent(TDBCheckbox, Target as TComponent, x, y, 97, 17) as TDBCheckbox;
                            {$endif}
                            ch.datasource := ds;
                            ch.datafield := f.fieldname;
                            ch.caption := f.fieldname;
                        end;
                    ftMemo, ftBlob: begin
                            {$ifdef VER140}
                            lb := ((AOwner as TCustomForm).designer as IDesigner).CreateComponent(TLabel, Target as TComponent, x, y, 200, 17) as TLabel;
                            me := ((AOwner as TCustomForm).designer as IDesigner).CreateComponent(TDBMemo, Target as TComponent, x, y + lb.height, 185, 89) as TDBMemo;
                            {$else}
                            lb := ((AOwner as TCustomForm).designer as IFormDesigner).CreateComponent(TLabel, Target as TComponent, x, y, 200, 17) as TLabel;
                            me := ((AOwner as TCustomForm).designer as IFormDesigner).CreateComponent(TDBMemo, Target as TComponent, x, y + lb.height, 185, 89) as TDBMemo;
                            {$endif}
                            me.datasource := ds;
                            me.datafield := f.fieldname;
                            lb.caption := f.fieldname;
                        end;
                    ftGraphic: begin
                            {$ifdef VER140}
                            lb := ((AOwner as TCustomForm).designer as IDesigner).CreateComponent(TLabel, Target as TComponent, x, y, 200, 17) as TLabel;
                            im := ((AOwner as TCustomForm).designer as IDesigner).CreateComponent(TDBImage, Target as TComponent, x, y + lb.height, 185, 89) as TDBImage;
                            {$else}
                            lb := ((AOwner as TCustomForm).designer as IFormDesigner).CreateComponent(TLabel, Target as TComponent, x, y, 200, 17) as TLabel;
                            im := ((AOwner as TCustomForm).designer as IFormDesigner).CreateComponent(TDBImage, Target as TComponent, x, y + lb.height, 185, 89) as TDBImage;
                            {$endif}
                            im.datasource := ds;
                            im.datafield := f.fieldname;
                            lb.caption := f.fieldname;
                        end
                else begin
                        {$ifdef VER140}
                        lb := ((AOwner as TCustomForm).designer as IDesigner).CreateComponent(TLabel, Target as TComponent, x, y, 200, 17) as TLabel;
                        {$else}
                        lb := ((AOwner as TCustomForm).designer as IFormDesigner).CreateComponent(TLabel, Target as TComponent, x, y, 200, 17) as TLabel;
                        {$endif}
                        fw := f.displaywidth * 10;
                        if fw > 100 then fw := 100;
                        {$ifdef VER140}
                        ed := ((AOwner as TCustomForm).designer as IDesigner).CreateComponent(TDBEdit, Target as TComponent, x, y + lb.height, fw, 21) as TDBEdit;
                        {$else}
                        ed := ((AOwner as TCustomForm).designer as IFormDesigner).CreateComponent(TDBEdit, Target as TComponent, x, y + lb.height, fw, 21) as TDBEdit;
                        {$endif}
                        ed.datasource := ds;
                        ed.datafield := f.fieldname;
                        lb.caption := f.fieldname;
                    end;
                end;
            end;
        end;
    end;
end;


{ TmySQLExplorerExpert }

constructor TmySQLExplorerExpert.Create;
var
  Main      : TMainMenu;
  Image     : TBitMap;
begin
    inherited Create;
    Image := TBitmap.Create;
    Image.LoadFromResourceName(HInstance,'IMAGE1');
    DatabaseItem := CreateMenu('DatabaseMenu','Database','MySQLExplorer','MySQL Explorer',Image,0,FParentMenu);
    DatabaseItem.OnClick := mySQLExplorerClick;
    Main := (BorlandIDEServices as INTAServices).GetMainMenu;
    Main.Items[Main.Items.IndexOf(FParentMenu)].Add(DatabaseItem);
    mySQLForm := TmySQLForm.create(nil);
    BlobExplorer := TBlobExplorer.create(nil);
end;

destructor TmySQLExplorerExpert.Destroy;
var
  Main      : TMainMenu;
begin
  if not Application.Terminated then
  begin
    if DatabaseItem <> nil then  DatabaseItem.Free;
    if FParentMenu <> nil then
    begin
       if FParentMenu.Count = 0 then
       begin
          Main := (BorlandIDEServices as INTAServices).GetMainMenu;
          if Main <> nil then
          begin
             Main.Items.Delete(Main.Items.IndexOf(FParentMenu));
             FParentMenu.Free;
          end;
       end;
    end;
  end;
  BlobExplorer.free;
  mySQLForm.free;
  inherited Destroy;
end;

function TmySQLExplorerExpert.CreateMenu(ParentName,AParentCaption,AName,ACaption : String;AImage: TBitmap;AShortCut : TShortCut;var ParentMenu : TMenuItem): TMenuItem;
var
   Main      : TMainMenu;
   I         : Integer;
begin
   Result := TMenuItem.Create(Application);
   Result.Caption := ACaption;
   Result.Name := AName;
   Result.ShortCut := AShortCut;
   if AImage <> nil then
      Result.ImageIndex := (BorlandIDEServices as INTAServices).AddMasked(AImage,AImage.Canvas.Pixels[0,0]);
   Main := (BorlandIDEServices as INTAServices).GetMainMenu;
   ParentMenu := nil;
   for I :=0 to Main.Items.Count-1 do
       if CompareText(Main.Items[I].Name,ParentName)=0 then
       begin
          ParentMenu := Main.Items[I];
          Break;
       end;
   if ParentMenu = nil then
   begin
      ParentMenu := TMenuItem.Create(Application);
      ParentMenu.Caption := AParentCaption;
      ParentMenu.Name := ParentName;
      Main.Items.Add(ParentMenu);
   end;
end;


function TmySQLExplorerExpert.GetAuthor: string;
begin
    result := 'Meridian Informatica';
end;

function TmySQLExplorerExpert.GetComment: string;
begin
    result := '';
end;

function TmySQLExplorerExpert.GetGlyph: HICON;
begin
    result := 0;
end;

function TmySQLExplorerExpert.GetIDString: string;
begin
    Result := 'Meridian.mySQLExplorer';
end;

function TmySQLExplorerExpert.GetMenuText: string;
begin
    result := '';
end;

function TmySQLExplorerExpert.GetName: string;
begin
    result := 'mySQL Explorer Expert';
end;

function TmySQLExplorerExpert.GetPage: string;
begin
    result := '';
end;

function TmySQLExplorerExpert.GetState: TExpertState;
begin
    result := [];
end;

function TmySQLExplorerExpert.GetStyle: TExpertStyle;
begin
    Result := esAddIn;
end;

procedure TmySQLExplorerExpert.mySQLExplorerClick(Sender: TObject);
begin
  mySQLForm.Show;
end;

initialization
    {$ifdef VER140}
    RegisterDragTarget(TDragFields.ClassName, TFieldsTarget);
    {$else}
    if Assigned(CompLib) then CompLib.RegisterDragTarget(TDragFields.ClassName, TFieldsTarget);    
    {$endif}

end.



