{*******************************************************}
{                                                       }
{  mySQLExplorer BLOB explorer                          }
{                                                       }
{  Copyright (c) 2001 Jos Len Serna                   }
{                                                       }
{*******************************************************}
unit uBlobExplorer;

interface

uses
    Windows, Messages, SysUtils,
    Classes, Graphics, Controls,
    Forms, Dialogs, DBCtrls,
    StdCtrls, db, Menus, uMainUnit;

type
    TBlobExplorer = class(TForm)
        DBMemo: TDBMemo;
        DBImage: TDBImage;
        PopupMenu: TPopupMenu;
        Alwaysontop1: TMenuItem;
        procedure Alwaysontop1Click(Sender: TObject);
    procedure FormHide(Sender: TObject);
    private
    { Private declarations }
    public
    { Public declarations }
        procedure setfield(field: TField);
    end;

var
    BlobExplorer: TBlobExplorer;

implementation

{$R *.DFM}

{ TBlobExplorer }

procedure TBlobExplorer.setfield(field: TField);
begin
    if assigned(field) then
    begin
//        if (field.DataType = ftMemo) or (field.DataType = ftBlob) then
//        begin
//            DBMemo.DataField := field.fieldname;
//            DBImage.DataField := '';
//            dbmemo.bringtofront;
//        end else
//        if field.DataType = ftGraphic then
//        begin
//            DBMemo.DataField := '';
//            DBImage.DataField := field.fieldname;
//            dbimage.bringtofront;
//        end else
        if field.DataType = ftMemo then
        begin
            DBMemo.DataField := field.fieldname;
            if DBMemo.DataSource = nil then
               ShowMessage('Datasource is NULL');
            DBImage.DataField := '';
            dbmemo.bringtofront;
        end else
        if field.DataType = ftBlob then
        begin
            DBMemo.DataField := '';
            DBImage.DataField := field.fieldname;
            dbimage.bringtofront;
        end else
        begin
            DBMemo.DataField := '';
            DBImage.DataField := '';
            dbmemo.bringtofront;
        end;
        caption := 'Column: ' + field.fieldname;
    end else
    begin
        DBMemo.DataField := '';
        DBImage.DataField := '';
        caption := 'Column: <none>';
    end;
end;

procedure TBlobExplorer.Alwaysontop1Click(Sender: TObject);
begin
    alwaysontop1.checked := not alwaysontop1.checked;
    if alwaysontop1.checked then formstyle := fsStayOnTop
    else formstyle := fsNormal;
end;

procedure TBlobExplorer.FormHide(Sender: TObject);
begin
   mySQLForm.ViewBlobExplorerCommand.Checked := False;
end;

end.


