/**
 **	File ......... dchat.cpp
 **	Published ....  2004-04-19
 **	Author ....... grymse@alhem.net
**/
/*
Copyright (C) 2004  Anders Hedstrom

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
#include <ListenSocket.h>
#include <signal.h>
#include "DChatHandler.h"
#include "DChatMinderSocket.h"
#include "DChatMinionSocket.h"
#include "ChatSocket.h"

#define DEB(x)

#define MINDER_HOST "minder.alhem.net"
#define MINDER_PORT 9696
#define LISTEN_PORT 20020

	bool quit = false;


void sigint(int s) /* save+quit */
{
	fprintf(stderr,"received sigint: shutting down\n");
	quit = true;
}


void sighup(int s) /* quit */
{
	fprintf(stderr,"received sighup: shutting down\n");
	quit = true;
}


void sigpipe(int s)
{
}


void reg_minder(DChatHandler& h,const std::string& cmd)
{
	DChatMinderSocket *m = new DChatMinderSocket(h);
	m -> Init();

	m -> Function(cmd); // Hello / Goodbye
	m -> SetDeleteByHandler(true);
	m -> Open(MINDER_HOST,MINDER_PORT);
	h.Add(m);
	m -> SetLocalIpPort(h.GetLocalAddress(),h.GetLocalPort());
	if (!m -> Connecting()) // connected
	{
		m -> SendHello();
	}

}


void connect(DChatHandler& h)
{
	if (h.Count() < 3)
	{
		ipaddr_t a;
		port_t p;
		std::string key;
		long host_id;
		if (h.GetHost(a,p,key,host_id))
		{
			MinionSocket *tmp = new DChatMinionSocket(h,key,a,p);
			tmp -> Init();
			ipaddr_t my_ip;
			port_t my_port;
			h.GetMyIpPort(my_ip, my_port);
			tmp -> SetMyIpPort(my_ip,my_port);
			tmp -> SetRemoteHostId(host_id);
			{
				std::string t;
				tmp -> l2ip(a,t);
DEB(				printf("Connect to:  %s:%d\n",t.c_str(),p);)
			}
			if (tmp -> Open(a,p))
			{
				tmp -> SetDeleteByHandler(true);
				h.Add(tmp);
				//
				tmp -> SendHello("Hello");
			}
			else
			if (tmp -> Connecting())
			{
				tmp -> SetDeleteByHandler(true);
				// check OnConnect
				h.Add(tmp);
			}
			else
			{
				delete tmp;
			}
		}
		else
		{
DEB(			printf("h.GetHost() failed?\n");)
		}
	}
}


int main(int argc,char *argv[])
{
	DChatHandler h( "config.xml" );
	ListenSocket<DChatMinionSocket> l3(h);
	ListenSocket<ChatSocket> l(h);

	signal(SIGINT, (__sighandler_t)sigint);
	signal(SIGHUP, (__sighandler_t)sighup);
	signal(SIGPIPE, (__sighandler_t)sigpipe);

	// telnet
	{
		port_t p = 4404;
		while (l.Bind(p) && p < 4410)
		{
			p++;
		}
		printf("Telnet port: %d\n",p);
	}
	h.Add(&l);
	// minion
	{
		port_t port = LISTEN_PORT;
		while (l3.Bind(port))
		{
			port++;
		}
		h.Add(&l3);
		h.SetLocalPort(port);
		printf("Minion port: %d\n",port);
	}
	// main loop
	{
		time_t tc = time(NULL);
		reg_minder(h,"Hello");
		h.Select(1,0);
		while (h.GetCount() && !quit)
		{
			h.Select(1,0);
			time_t t2 = time(NULL);
			if (t2 - tc > 60)
			{
				tc = t2;
				connect(h);
			}
		}
	}
	// shutdown
	{
		reg_minder(h,"Goodbye");
		h.Select(1,0);
		while (h.MinderSockets())
		{
			h.Select(1,0);
		}
	}
}


