#!/usr/bin/env python
"""
/***************************************************************************

	Author 			:Charles B. Cosse 
	
	Email			:ccosse@asymptopia.org
					
	Copyright		:(C) 2002,2004 Asymptopia Software.
	
 ***************************************************************************/
/***************************************************************************
                          tuxmathscrabble.py

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version. (Please note that if you use this *
 *   code you must give credit by including the Author and Copyright       *
 *   info at the top of this file).                                        *
 ***************************************************************************/
"""

DEBUG=0

import os, pygame,sys
from pygame.locals import *
from random import random
from asymptopia.myutil import load_image
		
from asymptopia.Board import *
from asymptopia.Spot import *
from asymptopia.myutil import *
from asymptopia.Tile import *
from asymptopia.Button import *
from asymptopia.Validator import *
from asymptopia.Localizer import *
from asymptopia.Tux import *
from asymptopia.Animator import *
from asymptopia.AnimatedChar import *
from asymptopia import themes
import pickle
#get path to site-packages:
try:
	for sitepkgdir in sys.path:
		if sitepkgdir[-13:]=='site-packages':break
except:pass


	
if not pygame.font: print 'Warning, fonts disabled'
if not pygame.mixer: print 'Warning, sound disabled'
M=13
N=17

W=750
H=550
DEFAULT_LEVEL=5



pygame.init()

class HSMGR:
	def __init__(self):
		self.HS=None
		try:
			f=open(os.path.join(os.environ['HOME'],'.tuxmathscrabble'),'r')
			self.HS=pickle.load(f)
			f.close()
		except:
			if sys.platform != 'win32':
				f=open(os.path.join(os.environ['HOME'],'.tuxmathscrabble'),'w')
				self.HS={
					'theme':'default',
					'hs':[('AAA',0),('AAA',0),('AAA',0),('AAA',0),('AAA',0),('AAA',0),('AAA',0),('AAA',0)],#top 10
				}
				pickle.dump(self.HS,f)
				f.close()
			
		
class TuxMathScrabble:
	def __init__(self,themes,theme_name,level):
		self.themes=themes
		self.theme_name=theme_name
		self.LEVEL=level
		self.theme_dir=os.path.join(sitepkgdir,'asymptopia')
		self.tuxtray=None
		self.tuxturn=0
		
		cmd='from asymptopia.themes.'+theme_name+'.'+theme_name+' import *'
		exec cmd
		self.theme=None
		cmd='self.theme='+theme_name+'()'
		exec cmd
		
		self.localizer=None
		self.validator=None
		self.animator=None
		self.screen=None
		self.board=None
		self.background=None
		self.buttons=None
		self.boardspots=None
		self.trayspots=None
		self.submissionspots=None
		self.target=None
		self.animatedChar=None
		self.animation_in_progress=None
		self.AnimatedTiles=None
		self.tuxtrayspots=None
		self.l1_button=None
		self.l2_button=None
		self.l3_button=None
		self.l4_button=None
		self.level_indicator=None
		self.tuxscore=None
		self.pyfont=None
		self.playerscore=None
		self.num_animated_tiles=None
		self.NTRAYSPOTS=None
		self.NNUMBERS=None
		self.HSMGR=HSMGR()
	
	def go_standby(self):
		HS=self.HSMGR.HS
		
		
			
		
	def draw_tiles(self,spots,who):
		theme=self.theme.theme
		imgnames=[
			'zero','one','two','three','four','five','six','seven','eight','nine','ten',
			'eleven','twelve','thirteen','fourteen','fifteen',
			#'sixteen','seventeen','eighteen','nineteen',
			'twenty'
		]
		for spot in spots:
			if spot.occupied():continue
			if (spot.getMN()[1]<self.NNUMBERS):
				if self.LEVEL==4:int_val=int(16*random())+1#1-20, no zero
				elif self.LEVEL==3:int_val=int(10*random())+1#1-20, no zero
				elif self.LEVEL==2:int_val=int(15*random())#1-15
				else:int_val=int(10*random())#1-10
				str_val=`int_val`+'.0'
				
				#special case for "20":(since skipping 16,17,18,19)
				if int_val==16:
					str_val='20.0'
				
				#print str_val,int_val
				if who=='tux':fname=os.path.join(theme['tux_tile_prefix']+imgnames[int_val]+'.gif')
				else:fname=os.path.join(theme['imgdir'],imgnames[int_val]+'.gif')
			elif spot.getMN()[1]<self.NTRAYSPOTS-1:
				opnames=['new_plus','new_minus','new_mult','new_divide']
				if self.LEVEL==4:idx=int(4*random())#add,subtract,mult,divide
				elif self.LEVEL==3:idx=int(3*random())#add,subtract,mult,divide
				else:idx=int(2*random())#add,subtract only
				int_val=None
				if   opnames[idx]=='new_plus':str_val='+'
				elif opnames[idx]=='new_minus':str_val='-'
				elif opnames[idx]=='new_mult':str_val='*'
				elif opnames[idx]=='new_divide':str_val='/'
				else:pass
				if who=='tux':opnames[idx]='tux_'+opnames[idx]
				fname=os.path.join(theme['imgdir'],opnames[idx]+'.gif')
			else:
				if who=='tux':fname=theme['tux_equal_imgpath']
				else:fname=theme['equal_imgpath']
				int_val=None
				str_val='='
			
			ptval=theme['str2pt'][str_val]	
				
			tile=Tile(fname,int_val,str_val,ptval)
			spot.take_guest(tile,1)
			tile.saved_center=spot.rect.center

	def pick_random(self,choices):
		idx=int(random()*(len(choices)+1))
		return(choices[idx])
		
	def play(self):
		theme=self.theme.theme
		pyfont=theme['font']
		pickup_sounds=theme['pickup_sounds']
		release_sounds=theme['release_sounds']
		lockin_sounds=theme['lockin_sounds']
		bounce_sounds=theme['bounce_sounds']
		win_sounds=theme['win_sounds']
		lose_sounds=theme['lose_sounds']
		
		
		####AnimationStuff
		animator=Animator()
		charManeuvers=theme['char_maneuvers']
		animatedChar=AnimatedChar(charManeuvers.getSequencesPyld(),W/2,100)
		animator.add_char(theme['char_name'],animatedChar)
		charManeuversPyld=charManeuvers.getManeuversPyld()
		for key in charManeuversPyld:
			animator.define_maneuver(key,charManeuversPyld[key])
		
		cuckooManeuvers=theme['cuckoo_maneuvers']
		AnimatedTiles=[]
		AnimatedTileNames=[]
		for idx in range(N):
			AnimatedTiles.append(AnimatedChar(cuckooManeuvers.getSequencesPyld(),-25,-25))#offscreen
			new_name="Tile_%02d"%(idx)
			AnimatedTileNames.append(new_name)
			animator.add_char(AnimatedTileNames[idx],AnimatedTiles[idx])
		cuckooManeuversPyld=cuckooManeuvers.getManeuversPyld()
		for key in cuckooManeuversPyld:
			animator.define_maneuver(key,cuckooManeuversPyld[key])
		####END:AnimationStuff
		
		####Setup screen...
		screen = pygame.display.set_mode((W,H))
		pygame.display.set_caption('www.asymptopia.org')
		pygame.mouse.set_visible(1)
		board=Board(M,N,W/2+10,H/2,None,theme['spot_imgpath'])
		boardspots=pygame.sprite.RenderPlain(board.get_spots())
		
		if self.LEVEL==3 or self.LEVEL==4:
			NTRAYSPOTS=12
			NNUMBERS=7
		else:
			NTRAYSPOTS=10
			NNUMBERS=6

		self.NTRAYSPOTS=NTRAYSPOTS
		self.NNUMBERS=NNUMBERS
		
		####Buttons
		button_imgpaths=theme['button_imgpaths']
		help_button=Button(os.path.join(sitepkgdir,button_imgpaths['help_button']))
		help_button.rect.center=(W-70,H-285)
		credit_button=Button(os.path.join(sitepkgdir,button_imgpaths['credit_button']))
		credit_button.rect.center=(W-70,H-235)
		skip_button=Button(os.path.join(sitepkgdir,button_imgpaths['skip_button']))
		skip_button.rect.center=(W-70,H-135)
		ready_button=Button(os.path.join(sitepkgdir,button_imgpaths['ready_button']))
		ready_button.rect.center=(W-70,H-185)
		
		l1_button=Button(os.path.join(sitepkgdir,button_imgpaths['l1_button']))
		l1_button.rect.center=(65,H-135)
		l2_button=Button(os.path.join(sitepkgdir,button_imgpaths['l2_button']))
		l2_button.rect.center=(65,H-185)
		l3_button=Button(os.path.join(sitepkgdir,button_imgpaths['l3_button']))
		l3_button.rect.center=(65,H-235)
		l4_button=Button(os.path.join(sitepkgdir,button_imgpaths['l4_button']))
		l4_button.rect.center=(65,H-285)
			
		buttongroup=pygame.sprite.Group([help_button,ready_button,skip_button,credit_button,l1_button,l2_button,l3_button,l4_button])
		buttons=pygame.sprite.RenderPlain(buttongroup)

		background = pygame.Surface(screen.get_size())
		background = background.convert()
		background.fill(theme['bgcolor'])#green

		level_indicator = pygame.Surface((10,10))
		level_indicator = level_indicator.convert()
		level_indicator.fill(theme['indicator_fill'])

		tray=Board(1,NTRAYSPOTS,W/2,H-40,None,theme['spot_imgpath'])
		trayspots=pygame.sprite.RenderPlain(tray.get_spots())
		submission=Board(M,N,W/2+10,H/2,None,theme['spot_imgpath'])
		submissionspots=pygame.sprite.RenderPlain()

		#drag-n-drop object	
		target=pygame.sprite.RenderClear()

		validator=Validator(board,self)#self passed for score update
		localizer=Localizer(board,self)#self passed for score update

		tuxtray=Board(1,NTRAYSPOTS,W/2,45,None,theme['spot_imgpath'])
		self.tuxtray=tuxtray
		tuxtrayspots=pygame.sprite.RenderPlain(tuxtray.get_spots())
		tux=Tux(self)
		tux.str2pt=theme['str2pt']
		
		tuxturn=0
		tuxscore=0
		playerscore=0
		self.tux_wait_counter=0
		
		#
		coin=int(random()*len(theme['welcome_maneuvers']))
		animator.start_maneuver('Tux',theme['welcome_maneuvers'][coin])
		
		self.animation_in_progress=0
		self.tux_move_progress=0
		self.tile_animation_in_progress=0
		self.num_animated_tiles=0
		
		self.animator=animator
		self.localizer=localizer
		self.validator=validator
		self.screen=screen
		self.board=board
		self.background=background
		self.buttons=buttons
		self.boardspots=boardspots
		self.trayspots=trayspots
		self.submissionspots=submissionspots
		self.target=target
		self.animatedChar=animatedChar
		self.AnimatedTiles=AnimatedTiles
		self.tuxtrayspots=tuxtrayspots
		
		self.l1_button=l1_button
		self.l2_button=l2_button
		self.l3_button=l3_button
		self.l4_button=l4_button
		self.level_indicator=level_indicator
		self.tuxscore=tuxscore
		self.playerscore=playerscore
		self.pyfont=pyfont
		
		self.draw_tiles(tray.get_spots(),'player')
		self.draw_tiles(tuxtray.get_spots(),'tux')
		while(1):
			if DEBUG:
				print 'tuxturn=',tuxturn
				print 'tux_move_progress=',self.tux_move_progress
				print 'animation_in_progress=',self.animation_in_progress
				print 'self.animation_in_progress=',self.animation_in_progress
				print 'num_animated_tiles=',self.num_animated_tiles
				print 'self.num_animated_tiles=',self.num_animated_tiles
			if (self.tuxturn==1) and (self.tux_move_progress==0) and (self.animation_in_progress==0) and (self.num_animated_tiles==0):#only @beginning of Tux's turn
				#_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/
				if DEBUG:print 'starting tux_get_up_maneuver'
				coin=int(random()*len(theme['get_up_maneuvers']))
				animator.start_maneuver('Tux',theme['get_up_maneuvers'][coin])
				
				
				self.tux_move_progress=1
				self.animation_in_progress=1
				#_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/
				
			if ((self.num_animated_tiles==0) and (self.animation_in_progress==0) and (self.tuxturn==1)):
				
				tux.generate_expressions()
				tux_finished=0
				
				while tux_finished!=1:
					tux_submission=tux.generate_options()
					rlist=tux_submission
					#print 'tux_submission=',tux_submission
					
					#_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/
					if tux_submission==None:
						tux_finished=1
						tuxturn=0
						#print 'Tux ran out of options!'
						coin=int(random()*len(theme['return_stumped_maneuvers']))
						animator.start_maneuver('Tux',theme['return_stumped_maneuvers'][coin])
						
						#GAME OVER HERE!
						break
					
					#_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/
					
					if rlist==None:
						#tux_finished=1
						#tuxturn=0
						#print 'Tux returned \'None\'...only handling first submission!'
						#break
						#print 'Tux returned \'None\'...trying another submission'
						pass
					
					else:
						#print rlist
						if rlist[0][0]==rlist[1][0]:exprtype='row'
						else:exprtype='col'
						try:
							for idx in range(len(rlist)):
								tile=tuxtray.get_guest_by_str(rlist[idx][0])
								spot=submission.take_guestMN(tile,rlist[idx][1],rlist[idx][2])
								submissionspots.add(spot)	
						except:
							print 'error line 332'
							
						#commit submission
						board.increment_num_commited()
						for spot in submissionspots.sprites():
							for board_spot in board.get_spots():
								if board_spot.rect.center==spot.rect.center:# M,N-Matching
									#print spot.guest.str_val,'len=',len(board.get_spots()),len(submissionspots.sprites())
									tile=spot.pop_guest()
									board_spot.take_guest(tile,1)
									board_spot.lock()
									submission.remove(spot)
									
									
						#del submissionspots			
						submissionspots.empty()
						self.draw_tiles(tuxtray.get_spots(),'tux')
						tux_finished=1
						self.tuxturn=0
						
						#_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/
						#return to corner: 
						coin=int(random()*len(theme['return_maneuvers']))
						animator.start_maneuver('Tux',theme['return_maneuvers'][coin])
						
						#_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/
						
			for event in pygame.event.get():
				if event.type == QUIT:return(0)
				elif event.type == KEYDOWN and event.key == K_ESCAPE:return(0)
				elif event.type == KEYDOWN and event.key == K_F1:
						display_surface=pygame.display.get_surface()
						pygame.image.save(display_surface,os.path.join(os.environ['HOME'],'tuxmathscrabble.bmp'))
				
				elif event.type == MOUSEBUTTONDOWN:
					#we have action! reset wait_counter:
					self.tux_wait_counter=0
					
					#HELP BUTTON:
					if help_button.rect.collidepoint(pygame.mouse.get_pos()):
						#help_image,rect=load_image(os.path.join('asymptopia','themes','default','images','help_splash.gif'))
						#screen.blit(help_image,(0,0))
						
						pygame.display.flip()
						while 1:
							breakout=0
							for event in pygame.event.get():
								if event.type == KEYDOWN:breakout=1
								elif event.type == MOUSEBUTTONDOWN:breakout=1
							if breakout:break	
					
					
					#CREDIT BUTTON:
					if credit_button.rect.collidepoint(pygame.mouse.get_pos()):
						credit_image,rect=load_image(os.path.join('asymptopia','themes','default','images','credit_splash.gif'))
						screen.blit(credit_image,(0,0))
						pygame.display.flip()
						while 1:
							breakout=0
							for event in pygame.event.get():
								if event.type == KEYDOWN:breakout=1
								elif event.type == MOUSEBUTTONDOWN:breakout=1
							if breakout:break	
					
					#LEVEL BUTTONS:
					if l1_button.rect.collidepoint(pygame.mouse.get_pos()):
						self.LEVEL=1
						return('default',1)
					if l2_button.rect.collidepoint(pygame.mouse.get_pos()):
						self.LEVEL=2
						return('default',2)
					if l3_button.rect.collidepoint(pygame.mouse.get_pos()):
						self.LEVEL=3
						return('default',3)
					if l4_button.rect.collidepoint(pygame.mouse.get_pos()):
						self.LEVEL=4
						return('default',4)
					
					
					#SKIP BUTTON:
					elif skip_button.rect.collidepoint(pygame.mouse.get_pos()):
						if self.tuxturn==1 or animatedChar.rect[0]<400:continue
						else:
							for spot in submissionspots.sprites():#reset
								tile=spot.pop_guest()
								if tile:
									for spot in tray.get_spots():	
										if	tile.saved_center==spot.rect.center:
											spot.take_guest(tile,1)
							
							#_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/
							if len(board.get_listofheads())==0:
								if not self.animation_in_progress:
									coin=int(random()*len(theme['insist_yougofirst_maneuvers']))
									animator.start_maneuver('Tux',theme['insist_yougofirst_maneuvers'][coin])
							else:
								coin=int(random()*len(theme['response_to_skip_maneuvers']))
								animator.start_maneuver('Tux',theme['response_to_skip_maneuvers'][coin])
								coin=int(random()*len(lose_sounds))
								lose_sounds[coin].play()
								self.animation_in_progress=1
								self.tux_move_progress=0
								submissionspots.empty()
								self.tuxturn=1
								continue
							#_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/
					
					#READY BUTTON:
					elif ready_button.rect.collidepoint(pygame.mouse.get_pos()):
						if(validator.validate(submissionspots.sprites())):#ready for this now!(first player turn)
							board.increment_num_commited()
							for spot in submissionspots.sprites():
								for board_spot in board.get_spots():
									if board_spot.rect.center==spot.rect.center and spot.guest:
										#validator is gonna have to fill-in AMHEAD fields, then add->board.list_of_heads.add(spot)
										#print spot.guest.str_val,'len=',len(board.get_spots()),len(submissionspots.sprites())
										tile=spot.pop_guest()
										
										#while we've got spot center info set_center of cuckoo_tile:
										rect=board_spot.rect
										xc=rect[0]+rect[2]/2
										yc=rect[1]+rect[3]/2
										cuckoo_tile_center=(xc,yc)
										AnimatedTiles[self.num_animated_tiles].set_center(cuckoo_tile_center)
										
										#Validator sets submission_spot and game(this) xfers->board_spot; (i.e. they work together)
										if spot.AMHEAD==1:
											board_spot.AMHEAD=1
											if spot.AMROWEXPR==1:
												board_spot.AMROWEXPR=1
												board_spot.ROWEXPRLENGTH=spot.ROWEXPRLENGTH
												
											if spot.AMCOLEXPR==1:
												board_spot.AMCOLEXPR=1
												board_spot.COLEXPRLENGTH=spot.COLEXPRLENGTH
												
											#board.list_of_heads.add(board_spot)#sprites know not to add selves twice; relying on that here.
										
										board_spot.take_guest(tile,1)
										board_spot.lock()
										submission.remove(spot)
										
								
								self.num_animated_tiles=self.num_animated_tiles+1#HACKHACKHACK!
								
							
							#_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/
							coin=int(random()*len(win_sounds))
							win_sounds[coin].play()
							
							#_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/
							#TRIGGER ANIMATION:
							#
							coin=int(random()*len(theme['response_to_win_maneuvers']))
							animator.start_maneuver('Tux',theme['response_to_win_maneuvers'][coin])
							
							self.tux_move_progress=0
							self.animation_in_progress=1
							
							cuckoo_maneuver_names=cuckooManeuvers.getManeuverNames()
							for idx in range(self.num_animated_tiles):
								maneuver_idx=int(random()*(len(cuckoo_maneuver_names)))
								animator.start_maneuver(AnimatedTileNames[idx],cuckoo_maneuver_names[maneuver_idx])
							if DEBUG:print 'self.num_animated_tiles=',self.num_animated_tiles#=self.num_animated_tiles
							
							#_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/
							
							self.draw_tiles(tray.get_spots(),'player')
							if DEBUG:print 'SCORE: Tux=',self.tuxscore,' PLAYER=',self.playerscore
							self.tuxturn=tuxturn=1
							
						else:#put back and play lose sound(not4tux)
							for spot in submissionspots.sprites():#reset
								tile=spot.pop_guest()
								if tile:
									for spot in tray.get_spots():	
										if	tile.saved_center==spot.rect.center:
											spot.take_guest(tile,1)
							
							if len(board.get_listofheads())>0:
								coin=int(random()*len(lose_sounds))
								lose_sounds[coin].play()
								coin=int(random()*len(theme['response_to_bad_submission_maneuver']))
								animator.start_maneuver('Tux',theme['response_to_bad_submission_maneuver'][coin])
								self.tux_move_progress=0
								self.animation_in_progress=1
							
						submissionspots.empty()
						continue
					
					#check tray for new target:
					for spot in tray.get_spots():
						if not spot.guest:continue
						if spot.rect.collidepoint(pygame.mouse.get_pos()):
							coin=int(random()*len(pickup_sounds))
							pickup_sounds[coin].play()
							target.add(spot.pop_guest())
					
					#check the board for new target:
					for spot in board.get_spots():
						if spot.rect.collidepoint(pygame.mouse.get_pos()) and spot.islocked():
							coin=int(random()*len(bounce_sounds))
							bounce_sounds[coin].play()
						
					#check the submission for new target:
					#print 'down1:len(submissionspots.sprites())=',len(submissionspots.sprites()),
					for spot in submission.get_spots():
						if not spot.occupied():continue
						if spot.rect.collidepoint(pygame.mouse.get_pos()):
							guest=spot.pop_guest()
							submissionspots.remove(spot)
							coin=int(random()*len(pickup_sounds))
							pickup_sounds[coin].play()
							target.add(guest)
					#print 'down2:len(submissionspots.sprites())=',len(submissionspots.sprites())
							
				elif event.type == MOUSEBUTTONUP:
					if len(target.sprites())>0:
						for spot in submission.get_spots():
							if spot.rect.collidepoint(target.sprites()[0].rect.center):#welcome to new home
								#print 'up1:len(submissionspots.sprites())=',len(submissionspots.sprites()),
								if spot.occupied():continue#part of submission
								#elif spot.islocked():continue#part of board
								spot.take_guest(target.sprites()[0],1)
								
								coin=int(random()*len(lockin_sounds))
								lockin_sounds[coin].play()
								submissionspots.add(spot)
								target.empty()
								#print 'up2:len=',len(board.get_spots()),len(submissionspots.sprites())
								break
						
						if len(target.sprites())==0:continue
						
						for spot in board.get_spots():
							if spot.rect.collidepoint(target.sprites()[0].rect.center):	
								coin=int(random()*len(bounce_sounds))
								bounce_sounds[coin].play()
								break
								
						if len(target.sprites())>0:#didn't drop? revert!
							#print 'cleanup'
							tile=target.sprites()[0]
							target.remove(tile)
							for spot in tray.get_spots():	
								if	tile.saved_center==spot.rect.center:
									spot.take_guest(tile,1)
									break
			
			if not self.tuxturn:
				self.tux_wait_counter=self.tux_wait_counter+1
				if self.tux_wait_counter>theme['WAIT_TIME'] and self.animation_in_progress==0:self.tux_wait_maneuver()
				#else:self.tux_wait_counter=0
			self.update()
			tuxturn=tuxturn
			
	
	def do_one_scratch(self):
			theme=self.theme.theme
			coin=int(random()*len(theme['thinking_maneuvers']))
			if coin==0:self.animator.start_maneuver('Tux',theme['thinking_maneuvers'][coin])
			self.tux_move_progress=0
			self.update()
			self.update()
			self.update()
			self.update()
			
	def tux_wait_maneuver(self):
			theme=self.theme.theme
			coin=int(random()*len(theme['wait_maneuvers']))
			self.animator.start_maneuver('Tux',theme['wait_maneuvers'][coin])
			
			self.tux_move_progress=0
			self.tux_wait_counter=0
			self.update()
			
	def update(self):
			screen=self.screen
			background=self.background
			buttons=self.buttons
			boardspots=self.boardspots
			trayspots=self.trayspots
			submissionspots=self.submissionspots
			target=self.target
			animatedChar=self.animatedChar
			animation_in_progress=self.animation_in_progress
			AnimatedTiles=self.AnimatedTiles
			tuxtrayspots=self.tuxtrayspots
			
			for event in pygame.event.get():
				if event.type == QUIT:return(0)
				elif event.type == KEYDOWN and event.key == K_ESCAPE:return(0)
							
			screen.blit(background,(0,0))
			#for button in buttons.sprites():
			#	
			if self.LEVEL==1:b=self.l1_button
			elif self.LEVEL==2:b=self.l2_button
			elif self.LEVEL==3:b=self.l3_button
			elif self.LEVEL==4:b=self.l4_button
			screen.blit(self.level_indicator,(10,b.rect[1]+b.rect[3]/3))
			
			#Scoreboard:
			tuxscorestring="Tux:%03d"%self.tuxscore
			screen.blit(self.pyfont.render(tuxscorestring,1,(255,255,0,0),(0, 150, 100)),(20,10))
			playerscorestring="You:%03d"%self.playerscore
			screen.blit(self.pyfont.render(playerscorestring,1,(255,255,0,0),(0, 150, 100)),(20,30))
			
			#Who's Turn-Indicator:
			if self.LEVEL>=3:
				if self.tuxturn==1:
					tuxturnstring= '<-Tux'
					screen.blit(self.pyfont.render(tuxturnstring,1,(255,255,0,0),(0, 150, 100)),(W-180,20))
				else:
					yourturnstring='<-You'
					screen.blit(self.pyfont.render(yourturnstring,1,(255,255,0,0),(0, 150, 100)),(W-180,485))
			else:
				if self.tuxturn==1:
					tuxturnstring= '<-Tux'
					screen.blit(self.pyfont.render(tuxturnstring,1,(255,255,0,0),(0, 150, 100)),(W-200,20))
				else:
					yourturnstring='<-You'
					screen.blit(self.pyfont.render(yourturnstring,1,(255,255,0,0),(0, 150, 100)),(W-200,485))
			
			#
			buttons.draw(screen)
			
			boardspots.draw(screen)
			submissionspots.draw(screen)
			#
			trayspots.draw(screen)
			tuxtrayspots.draw(screen)
			if len(target.sprites())>0:
				target.sprites()[0].update()
				target.draw(screen)
			
			#_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/
			#ANIMATED TUX UPDATE:
			#
			rval=animatedChar.update()
			screen.blit(animatedChar.image,(animatedChar.rect[0],animatedChar.rect[1]))
			
			sound=animatedChar.get_sound()
			if sound:sound.play()
			
			#okay, this is now official location of decision:
			if animatedChar.get_dest():
				self.animation_in_progress=1
			else:
				self.animation_in_progress=0
				
				
				
			#_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/
			#ANIMATED TILE UPDATE:
			#
			#sound=AnimatedTiles[0].get_sound()
			#if sound:sound.play()
			if self.num_animated_tiles>0:
				#time.sleep(.1)
				self.num_animated_tiles=0
				for tile in AnimatedTiles:
					if not tile.get_dest():
						tile.set_center((0,0))
					else:
						self.num_animated_tiles=self.num_animated_tiles+1
						rval=tile.update()
						screen.blit(tile.image,(tile.rect[0],tile.rect[1]))
				
			#_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/
			
			pygame.display.flip()
			
			if animatedChar.get_dest():
				if animatedChar.rect[0]<0:animatedChar.set_center((700,100))
				time.sleep(animatedChar.get_timeout())
			
