#!/usr/bin/env python
DEBUG=0
import pygame
from asymptopia.myutil import *
from asymptopia.themes.default.TuxManeuvers import *
from asymptopia.themes.default.CuckooManeuvers import *

class default:
	def __init__(self):
		if DEBUG:print 'default initialized'
		themedir=os.path.join('asymptopia','themes','default')
		
		self.theme={
			'font':pygame.font.Font(os.path.join(sitepkgdir,themedir,'font','freesansbold.ttf'),16),
			'pickup_sounds':[load_sound(os.path.join(sitepkgdir,themedir,'sounds','pickup01.wav')),],
			'release_sounds':[load_sound(os.path.join(sitepkgdir,themedir,'sounds','release01.wav')),],
			'bounce_sounds':[load_sound(os.path.join(sitepkgdir,themedir,'sounds','bounce01.wav')),],
			'lockin_sounds':[load_sound(os.path.join(sitepkgdir,themedir,'sounds','lockin01.wav')),],
			'win_sounds':[
						load_sound(os.path.join(sitepkgdir,themedir,'sounds','win01.wav')),
						load_sound(os.path.join(sitepkgdir,themedir,'sounds','win02.wav')),
						load_sound(os.path.join(sitepkgdir,themedir,'sounds','win03.wav')),
						],
			'lose_sounds':[load_sound(os.path.join(sitepkgdir,themedir,'sounds','lose01.wav')),],
			'char_maneuvers':TuxManeuvers(),
			'char_name':"Tux",
			'cuckoo_maneuvers':CuckooManeuvers(),
			'button_imgpaths':{
				'help_button':os.path.join(themedir,'button_images','help_button.gif'),
				'credit_button':os.path.join(themedir,'button_images','credits_button.gif'),
				'skip_button':os.path.join(themedir,'button_images','skip_button.gif'),
				'ready_button':os.path.join(themedir,'button_images','ready_button.gif'),
				'l1_button':os.path.join(themedir,'button_images','level_one.gif'),
				'l2_button':os.path.join(themedir,'button_images','level_two.gif'),
				'l3_button':os.path.join(themedir,'button_images','level_three.gif'),
				'l4_button':os.path.join(themedir,'button_images','level_four.gif'),
				},
			'bgcolor':(0, 150, 100),
			'indicator_fill':(255, 0, 0),
			'spot_imgpath':os.path.join(themedir,'images','new_spot.gif'),
			'tux_tile_prefix':os.path.join(themedir,'images','tux_'),
			'imgdir':os.path.join(themedir,'images'),
			'tux_equal_imgpath':os.path.join(themedir,'images','tux_new_equal.gif'),
			'equal_imgpath':os.path.join(themedir,'images','new_equal.gif'),
			'str2pt':self.get_str2pt(),
			'WAIT_TIME':50,
			
			#these are the maneuver lists that are expected to have at least one maneuver defined
			'welcome_maneuvers':['tux_welcome_maneuver_01',],
			'get_up_maneuvers':['tux_get_up_maneuver_01','tux_get_up_maneuver_02','tux_get_up_maneuver_03','tux_get_up_maneuver_04',],
			'return_stumped_maneuvers':['return_stumped_maneuver',],
			'return_maneuvers':['return_skating_maneuver','tux_go_back_from_tray_maneuver_01','tux_go_back_from_tray_maneuver_02',],
			'insist_yougofirst_maneuvers':['insist_yougofirst_maneuver',],
			'response_to_skip_maneuvers':['head_tilt_right_maneuver',],
			'response_to_win_maneuvers':['forehead_slap_maneuver','neck_stretch_maneuver',],
			'response_to_bad_submission_maneuver':['head_tilt_left_maneuver',],
			'thinking_maneuvers':['one_scratchr_maneuver','one_scratchl_maneuver',],
			'wait_maneuvers':['head_tilt_left_maneuver','head_tilt_right_maneuver','neck_stretch_maneuver','tux_flapper_maneuver',
				'hop_in_place_maneuver','walkoff_stage_right_maneuver','neck_squash_tiltleftright_maneuver','neck_squash_hop_in_place_maneuver',],
		
		}


	def get_str2pt(self):
		return({
			'0.0':1,
			'1.0':1,
			'2.0':1,
			'3.0':1,
			'4.0':1,
			'5.0':1,
			'6.0':1,
			'7.0':1,
			'8.0':1,
			'9.0':1,
			'10.0':2,
			'11.0':2,
			'12.0':2,
			'13.0':2,
			'14.0':2,
			'15.0':3,
			'16.0':3,
			'17.0':3,
			'18.0':3,
			'19.0':3,
			'20.0':3,
			'+':1,
			'-':2,
			'*':3,
			'/':5,
			'=':1,
		})
