"""
/***************************************************************************

	Author 			:Charles B. Cosse 
	
	Email			:ccosse@asymptopia.org
					
					
	Copyright		:(C) 2002-2004 Asymptopia Software.
	
 ***************************************************************************/
/***************************************************************************
                          TuxManeuvers.py
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version. (Please note that if you use this *
 *   code you must give credit by including the Author and Copyright       *
 *   info at the top of this file).                                        *
 ***************************************************************************/
"""
import os, pygame,sys
from pygame.locals import *
from random import random

from asymptopia.Maneuvers import Maneuvers
from asymptopia.myutil import *

#get path to site-packages:
try:
	for sitepkgdir in sys.path:
		if sitepkgdir[-13:]=='site-packages':break
except:pass

class TuxManeuvers(Maneuvers):
	def __init__(self):
		###Sequences are made of images; Maneuvers are made of sequences.
		
		self.maneuvers={}
		anim_imgdir=os.path.join('asymptopia','themes','default','anim_images')
		sound_dir=os.path.join('asymptopia','themes','default','sounds')
		
		pop01=load_sound(os.path.join(sitepkgdir,sound_dir,'pop01.wav'))
		pop02=load_sound(os.path.join(sitepkgdir,sound_dir,'pop01.wav'))
		boink=load_sound(os.path.join(sitepkgdir,sound_dir,'bong05.wav'))
		
		img_walkl_01=pygame.image.load(os.path.join(sitepkgdir,anim_imgdir,'walk_left_01_color.gif'))
		img_walkl_02=pygame.image.load(os.path.join(sitepkgdir,anim_imgdir,'walk_left_02_color.gif'))
		img_walkl_03=pygame.image.load(os.path.join(sitepkgdir,anim_imgdir,'walk_left_03_color.gif'))
		img_walkl_04=pygame.image.load(os.path.join(sitepkgdir,anim_imgdir,'walk_left_04_color.gif'))
		walkl=[
			{'img':img_walkl_02,'snd':None,'dx':-15,'dy':-8,'timeout':.1},
			{'img':img_walkl_03,'snd':None,'dx':-15,'dy':8,'timeout':.1},
			{'img':img_walkl_04,'snd':None,'dx':-15,'dy':-8,'timeout':.1},
			{'img':img_walkl_01,'snd':None,'dx':-15,'dy':8,'timeout':.1},
		]
		
		img_walkr_01=pygame.image.load(os.path.join(sitepkgdir,anim_imgdir,'walk_right_01_color.gif'))
		img_walkr_02=pygame.image.load(os.path.join(sitepkgdir,anim_imgdir,'walk_right_02_color.gif'))
		img_walkr_03=pygame.image.load(os.path.join(sitepkgdir,anim_imgdir,'walk_right_03_color.gif'))
		img_walkr_04=pygame.image.load(os.path.join(sitepkgdir,anim_imgdir,'walk_right_04_color.gif'))
		walkr=[
			{'img':img_walkr_02,'snd':None,'dx':+15,'dy':8,'timeout':.1},
			{'img':img_walkr_03,'snd':None,'dx':+15,'dy':-8,'timeout':.1},
			{'img':img_walkr_04,'snd':None,'dx':+15,'dy':8,'timeout':.1},
			{'img':img_walkr_01,'snd':None,'dx':+15,'dy':-8,'timeout':.1},
		]
		
		img_scratchl_01=pygame.image.load(os.path.join(sitepkgdir,anim_imgdir,'scratch_left_01.gif'))
		img_scratchl_02=pygame.image.load(os.path.join(sitepkgdir,anim_imgdir,'scratch_left_02.gif'))
		scratchl=[
			{'img':img_scratchl_01,'snd':None,'dx':0,'dy':0,'timeout':0},
			{'img':img_scratchl_02,'snd':None,'dx':0,'dy':0,'timeout':0},
		]
		
		img_scratchr_01=pygame.image.load(os.path.join(sitepkgdir,anim_imgdir,'scratch_right_01.gif'))
		img_scratchr_02=pygame.image.load(os.path.join(sitepkgdir,anim_imgdir,'scratch_right_02.gif'))
		scratchr=[
			{'img':img_scratchr_01,'snd':None,'dx':0,'dy':0,'timeout':0},
			{'img':img_scratchr_02,'snd':None,'dx':0,'dy':0,'timeout':0},
		]
		
		
		
		#i_am_stumped.gif
		#nice_move.gif
		#thinking.gif
		#your_move.gif
		#ok.gif
		#stand_front_look_left.gif
		#stand_front_look_right.gif
		#stand_left_look_front.gif
		#stand_left_look_front_neck_stretch.gif
		#stand_right_look_front.gif
		#stand_right_look_front_neck_stretch.gif
		
		img_forehead_slap_01=pygame.image.load(os.path.join(sitepkgdir,anim_imgdir,'forehead_slap_01_color.gif'))
		img_forehead_slap_02=pygame.image.load(os.path.join(sitepkgdir,anim_imgdir,'forehead_slap_02_color.gif'))
		img_forehead_slap_03=pygame.image.load(os.path.join(sitepkgdir,anim_imgdir,'forehead_slap_03_color.gif'))
		img_forehead_slap_04=pygame.image.load(os.path.join(sitepkgdir,anim_imgdir,'forehead_slap_04_color.gif'))
		img_forehead_slap_05=pygame.image.load(os.path.join(sitepkgdir,anim_imgdir,'forehead_slap_05_color.gif'))
		img_forehead_slap_06=pygame.image.load(os.path.join(sitepkgdir,anim_imgdir,'forehead_slap_06_color.gif'))
		img_forehead_slap_07=pygame.image.load(os.path.join(sitepkgdir,anim_imgdir,'forehead_slap_07_color.gif'))
		img_forehead_slap_08=pygame.image.load(os.path.join(sitepkgdir,anim_imgdir,'forehead_slap_08_color.gif'))
		img_forehead_slap_09=pygame.image.load(os.path.join(sitepkgdir,anim_imgdir,'forehead_slap_09_color.gif'))
		img_forehead_slap_10=pygame.image.load(os.path.join(sitepkgdir,anim_imgdir,'forehead_slap_10_color.gif'))
		forehead_slap=[
			{'img':img_forehead_slap_01,'snd':None,'dx':0,'dy':0,'timeout':.1},
			{'img':img_forehead_slap_02,'snd':None,'dx':0,'dy':0,'timeout':.1},
			{'img':img_forehead_slap_03,'snd':None,'dx':0,'dy':0,'timeout':.1},
			{'img':img_forehead_slap_04,'snd':None,'dx':0,'dy':0,'timeout':.1},
			{'img':img_forehead_slap_05,'snd':None,'dx':0,'dy':0,'timeout':.1},
			{'img':img_forehead_slap_05,'snd':None,'dx':0,'dy':0,'timeout':.1},
			{'img':img_forehead_slap_05,'snd':None,'dx':0,'dy':0,'timeout':.1},
			{'img':img_forehead_slap_05,'snd':None,'dx':0,'dy':0,'timeout':.1},
			{'img':img_forehead_slap_05,'snd':None,'dx':0,'dy':0,'timeout':.1},
			{'img':img_forehead_slap_06,'snd':None,'dx':0,'dy':0,'timeout':.1},
			{'img':img_forehead_slap_08,'snd':None,'dx':0,'dy':0,'timeout':.1},
			{'img':img_forehead_slap_09,'snd':None,'dx':0,'dy':0,'timeout':.1},
			{'img':img_forehead_slap_10,'snd':None,'dx':0,'dy':0,'timeout':.1},
		]
		
		img_big_flapper_00=pygame.image.load(os.path.join(sitepkgdir,anim_imgdir,'big_flapper_00.gif'))
		img_big_flapper_01=pygame.image.load(os.path.join(sitepkgdir,anim_imgdir,'big_flapper_01.gif'))
		big_flapper=[
			{'img':img_big_flapper_01,'snd':pop02,'dx':0,'dy':20,'timeout':.1},
			{'img':img_big_flapper_00,'snd':pop01,'dx':0,'dy':-20,'timeout':.1},
		]
		img_stand_left_01=img_walkl_01
		img_stand_right_01=img_walkr_01
		
		img_stand_front_01=pygame.image.load(os.path.join(sitepkgdir,anim_imgdir,'stand_front_01.gif'))
		stand_front=[
			{'img':img_stand_front_01,'snd':None,'dx':0,'dy':0,'timeout':0.},
		]
		img_stand_front_look_left=pygame.image.load(os.path.join(sitepkgdir,anim_imgdir,'stand_front_look_left.gif'))
		stand_front_look_left=[
			{'img':img_stand_front_01,'snd':None,'dx':0,'dy':0,'timeout':0.},
			{'img':img_stand_front_look_left,'snd':None,'dx':0,'dy':0,'timeout':0.5},
			{'img':img_stand_front_01,'snd':None,'dx':0,'dy':0,'timeout':0.},
		]
		img_stand_front_look_right=pygame.image.load(os.path.join(sitepkgdir,anim_imgdir,'stand_front_look_right.gif'))
		stand_front_look_right=[
			{'img':img_stand_front_01,'snd':None,'dx':0,'dy':0,'timeout':0.1},
			{'img':img_stand_front_look_right,'snd':None,'dx':0,'dy':0,'timeout':0.5},
			{'img':img_stand_front_01,'snd':None,'dx':0,'dy':0,'timeout':0.1},
		]
		img_stand_left_look_front=pygame.image.load(os.path.join(sitepkgdir,anim_imgdir,'stand_left_look_front.gif'))
		stand_left_look_front=[
			{'img':img_stand_left_01,'snd':None,'dx':0,'dy':0,'timeout':0.1},
			{'img':img_stand_left_look_front,'snd':None,'dx':0,'dy':0,'timeout':1.},
			{'img':img_stand_front_01,'snd':None,'dx':0,'dy':0,'timeout':0.1},
		]
		img_stand_right_look_front=pygame.image.load(os.path.join(sitepkgdir,anim_imgdir,'stand_right_look_front.gif'))
		stand_right_look_front=[
			{'img':img_stand_right_01,'snd':None,'dx':0,'dy':0,'timeout':0.1},
			{'img':img_stand_right_look_front,'snd':None,'dx':0,'dy':0,'timeout':1.},
			{'img':img_stand_right_01,'snd':None,'dx':0,'dy':0,'timeout':0.1},
		]
		img_stand_left_look_front_neck_stretch=pygame.image.load(os.path.join(sitepkgdir,anim_imgdir,'stand_left_look_front_neck_stretch.gif'))
		stand_left_look_front_neck_stretch=[
			{'img':img_stand_left_01,'snd':None,'dx':0,'dy':0,'timeout':0.1},
			{'img':img_stand_left_look_front_neck_stretch,'snd':None,'dx':0,'dy':0,'timeout':1.},
			{'img':img_stand_front_01,'snd':None,'dx':0,'dy':0,'timeout':0.1},
		]
		img_stand_right_look_front_neck_stretch=pygame.image.load(os.path.join(sitepkgdir,anim_imgdir,'stand_right_look_front_neck_stretch.gif'))
		stand_right_look_front_neck_stretch=[
			{'img':img_stand_right_01,'snd':None,'dx':0,'dy':0,'timeout':0.1},
			{'img':img_stand_right_look_front_neck_stretch,'snd':None,'dx':0,'dy':0,'timeout':1.},
			{'img':img_stand_right_01,'snd':None,'dx':0,'dy':0,'timeout':0.1},
		]
		hop_in_place=[
			{'img':img_stand_front_01,'snd':pop01,'dx':0,'dy':-10,'timeout':.1},
			{'img':img_stand_front_01,'snd':pop02,'dx':0,'dy':10,'timeout':.1},
		]
		img_lean_right_fwd=pygame.image.load(os.path.join(sitepkgdir,anim_imgdir,'lean_right_fwd.gif'))
		img_lean_right_bck=pygame.image.load(os.path.join(sitepkgdir,anim_imgdir,'lean_right_bck.gif'))
		img_lean_left_fwd=pygame.image.load(os.path.join(sitepkgdir,anim_imgdir,'lean_left_fwd.gif'))
		img_lean_left_bck=pygame.image.load(os.path.join(sitepkgdir,anim_imgdir,'lean_left_bck.gif'))
		hop_right=[
			{'img':img_lean_right_fwd,'snd':None,'dx':0,'dy':0,'timeout':.1},
			{'img':img_lean_right_fwd,'snd':None,'dx':5,'dy':-10,'timeout':.01},
			{'img':img_lean_right_fwd,'snd':None,'dx':5,'dy':-6,'timeout':.01},
			{'img':img_lean_right_fwd,'snd':None,'dx':5,'dy':-5,'timeout':.01},
			{'img':img_lean_right_fwd,'snd':None,'dx':5,'dy':-1,'timeout':.01},
			{'img':img_lean_right_fwd,'snd':None,'dx':5,'dy':0,'timeout':.01},
			{'img':img_lean_right_fwd,'snd':None,'dx':5,'dy':0,'timeout':.01},
			{'img':img_stand_right_01,'snd':None,'dx':15,'dy':1,'timeout':.01},
			{'img':img_stand_right_01,'snd':None,'dx':15,'dy':5,'timeout':.01},
			{'img':img_lean_right_bck,'snd':None,'dx':15,'dy':6,'timeout':.01},
			{'img':img_lean_right_bck,'snd':None,'dx':10,'dy':10,'timeout':.01},
			{'img':img_lean_right_bck,'snd':None,'dx':0,'dy':0,'timeout':.1},
			{'img':img_stand_right_01,'snd':boink,'dx':0,'dy':0,'timeout':.2},
		]
		hop_left=[
			{'img':img_lean_left_fwd,'snd':None,'dx':0,'dy':0,'timeout':.1},
			{'img':img_lean_left_fwd,'snd':None,'dx':-5,'dy':-10,'timeout':.01},
			{'img':img_lean_left_fwd,'snd':None,'dx':-5,'dy':-6,'timeout':.01},
			{'img':img_lean_left_fwd,'snd':None,'dx':-5,'dy':-5,'timeout':.01},
			{'img':img_lean_left_fwd,'snd':None,'dx':-5,'dy':-1,'timeout':.01},
			{'img':img_lean_left_fwd,'snd':None,'dx':-5,'dy':0,'timeout':.01},
			{'img':img_lean_left_fwd,'snd':None,'dx':-5,'dy':0,'timeout':.01},
			{'img':img_stand_left_01,'snd':None,'dx':-15,'dy':1,'timeout':.01},
			{'img':img_stand_left_01,'snd':None,'dx':-15,'dy':5,'timeout':.01},
			{'img':img_lean_left_bck,'snd':None,'dx':-15,'dy':6,'timeout':.01},
			{'img':img_lean_left_bck,'snd':None,'dx':-10,'dy':10,'timeout':.01},
			{'img':img_lean_left_bck,'snd':None,'dx':0,'dy':0,'timeout':.1},
			{'img':img_stand_left_01,'snd':boink,'dx':0,'dy':0,'timeout':.2},
		]
		
		hopflap_left=[
				{'img':img_big_flapper_00,'snd':None,'dx':-5,'dy':-10,'timeout':0.09},
				{'img':img_big_flapper_01,'snd':None,'dx':0,'dy':10,'timeout':0.09},
		]
		hopflap_right=[
				{'img':img_big_flapper_00,'snd':None,'dx':5,'dy':-10,'timeout':0.09},
				{'img':img_big_flapper_01,'snd':None,'dx':0,'dy':10,'timeout':0.09},
		]
		
		img_yougofirst_00=pygame.image.load(os.path.join(sitepkgdir,anim_imgdir,'yougofirst_00.gif'))
		you_go_first=[
			{'img':img_yougofirst_00,'snd':None,'dx':0,'dy':0,'timeout':0.},
		]
		
		img_himathlover_00=pygame.image.load(os.path.join(sitepkgdir,anim_imgdir,'himathlover_00.gif'))
		img_himathlover_01=pygame.image.load(os.path.join(sitepkgdir,anim_imgdir,'himathlover_01.gif'))
		hi_math_lover=[
			{'img':img_himathlover_00,'snd':None,'dx':0,'dy':0,'timeout':.1},
			{'img':img_himathlover_01,'snd':None,'dx':0,'dy':0,'timeout':.1},
		]
		
		img_head_tilt_left_00=pygame.image.load(os.path.join(sitepkgdir,anim_imgdir,'head_tilt_left_00.gif'))
		img_head_tilt_left_01=pygame.image.load(os.path.join(sitepkgdir,anim_imgdir,'head_tilt_left_01.gif'))
		head_tilt_left=[
			{'img':img_head_tilt_left_00,'snd':None,'dx':0,'dy':0,'timeout':.1},
			{'img':img_head_tilt_left_01,'snd':None,'dx':0,'dy':0,'timeout':.1},
			{'img':img_head_tilt_left_01,'snd':None,'dx':0,'dy':0,'timeout':.1},
			{'img':img_head_tilt_left_01,'snd':None,'dx':0,'dy':0,'timeout':.1},
			{'img':img_head_tilt_left_01,'snd':None,'dx':0,'dy':0,'timeout':.1},
			{'img':img_head_tilt_left_01,'snd':None,'dx':0,'dy':0,'timeout':.1},
			{'img':img_head_tilt_left_01,'snd':None,'dx':0,'dy':0,'timeout':.1},
			{'img':img_head_tilt_left_01,'snd':None,'dx':0,'dy':0,'timeout':.1},
			{'img':img_head_tilt_left_01,'snd':None,'dx':0,'dy':0,'timeout':.1},
			{'img':img_head_tilt_left_01,'snd':None,'dx':0,'dy':0,'timeout':.1},
			{'img':img_head_tilt_left_01,'snd':None,'dx':0,'dy':0,'timeout':.1},
			{'img':img_head_tilt_left_01,'snd':None,'dx':0,'dy':0,'timeout':.1},
			{'img':img_head_tilt_left_01,'snd':None,'dx':0,'dy':0,'timeout':.1},
			{'img':img_head_tilt_left_00,'snd':None,'dx':0,'dy':0,'timeout':.1},
		]
		
		img_head_tilt_right_00=pygame.image.load(os.path.join(sitepkgdir,anim_imgdir,'head_tilt_right_00.gif'))
		img_head_tilt_right_01=pygame.image.load(os.path.join(sitepkgdir,anim_imgdir,'head_tilt_right_01.gif'))
		head_tilt_right=[
			{'img':img_head_tilt_right_00,'snd':None,'dx':0,'dy':0,'timeout':.1},
			{'img':img_head_tilt_right_01,'snd':None,'dx':0,'dy':0,'timeout':.1},
			{'img':img_head_tilt_right_01,'snd':None,'dx':0,'dy':0,'timeout':.1},
			{'img':img_head_tilt_right_01,'snd':None,'dx':0,'dy':0,'timeout':.1},
			{'img':img_head_tilt_right_01,'snd':None,'dx':0,'dy':0,'timeout':.1},
			{'img':img_head_tilt_right_01,'snd':None,'dx':0,'dy':0,'timeout':.1},
			{'img':img_head_tilt_right_01,'snd':None,'dx':0,'dy':0,'timeout':.1},
			{'img':img_head_tilt_right_01,'snd':None,'dx':0,'dy':0,'timeout':.1},
			{'img':img_head_tilt_right_01,'snd':None,'dx':0,'dy':0,'timeout':.1},
			{'img':img_head_tilt_right_01,'snd':None,'dx':0,'dy':0,'timeout':.1},
			{'img':img_head_tilt_right_01,'snd':None,'dx':0,'dy':0,'timeout':.1},
			{'img':img_head_tilt_right_01,'snd':None,'dx':0,'dy':0,'timeout':.1},
			{'img':img_head_tilt_right_01,'snd':None,'dx':0,'dy':0,'timeout':.1},
			{'img':img_head_tilt_right_00,'snd':None,'dx':0,'dy':0,'timeout':.1},
		]
		
		img_neck_stretch_01=pygame.image.load(os.path.join(sitepkgdir,anim_imgdir,'neck_squash_01.gif'))
		img_neck_squash_01=pygame.image.load(os.path.join(sitepkgdir,anim_imgdir,'neck_squash_01.gif'))
		img_neck_squash_tilt_left=pygame.image.load(os.path.join(sitepkgdir,anim_imgdir,'neck_squash_tilt_left.gif'))
		img_neck_squash_tilt_right=pygame.image.load(os.path.join(sitepkgdir,anim_imgdir,'neck_squash_tilt_right.gif'))
		neck_stretch=[
			{'img':img_stand_front_01,'snd':None,'dx':0,'dy':0,'timeout':.1},
			{'img':img_neck_stretch_01,'snd':None,'dx':0,'dy':0,'timeout':.1},
		]
		neck_squash=[
			{'img':img_stand_front_01,'snd':None,'dx':0,'dy':0,'timeout':.1},
			{'img':img_neck_squash_01,'snd':None,'dx':0,'dy':0,'timeout':.1},
		]
		neck_squash_tilt_lr=[
			{'img':img_neck_squash_01,'snd':None,'dx':0,'dy':0,'timeout':.1},
			{'img':img_neck_squash_tilt_left,'snd':None,'dx':0,'dy':0,'timeout':.1},
			{'img':img_neck_squash_01,'snd':None,'dx':0,'dy':0,'timeout':.1},
			{'img':img_neck_squash_tilt_right,'snd':None,'dx':0,'dy':0,'timeout':.1},
			{'img':img_neck_squash_01,'snd':None,'dx':0,'dy':0,'timeout':.1},
		]
		
		neck_squash_tilt_l=[
			{'img':img_neck_squash_01,'snd':None,'dx':0,'dy':0,'timeout':.1},
			{'img':img_neck_squash_tilt_left,'snd':None,'dx':0,'dy':0,'timeout':.1},
			{'img':img_neck_squash_01,'snd':None,'dx':0,'dy':0,'timeout':.1},
		]
		neck_squash_tilt_r=[
			{'img':img_neck_squash_01,'snd':None,'dx':0,'dy':0,'timeout':.1},
			{'img':img_neck_squash_tilt_right,'snd':None,'dx':0,'dy':0,'timeout':.1},
			{'img':img_neck_squash_01,'snd':None,'dx':0,'dy':0,'timeout':.1},
		]
		
		neck_squash_hop_in_place=[
			{'img':img_neck_squash_01,'snd':None,'dx':0,'dy':0,'timeout':.1},
			{'img':img_neck_squash_01,'snd':None,'dx':0,'dy':-10,'timeout':.1},
			{'img':img_neck_squash_01,'snd':None,'dx':0,'dy':10,'timeout':.1},
			{'img':img_neck_squash_01,'snd':None,'dx':0,'dy':-10,'timeout':.1},
			{'img':img_neck_squash_01,'snd':None,'dx':0,'dy':10,'timeout':.1},
			{'img':img_neck_squash_01,'snd':None,'dx':0,'dy':-10,'timeout':.1},
			{'img':img_neck_squash_01,'snd':None,'dx':0,'dy':10,'timeout':.1},
			{'img':img_stand_front_01,'snd':None,'dx':0,'dy':00,'timeout':.1},
		]
		
		img_am_stumped=pygame.image.load(os.path.join(sitepkgdir,anim_imgdir,'i_am_stumped.gif'))
		i_am_stumped=[
			{'img':img_am_stumped,'snd':None,'dx':0,'dy':0,'timeout':.05},
		]
		img_skater=pygame.image.load(os.path.join(sitepkgdir,anim_imgdir,'skate_right.gif'))
		skate_right=[
			{'img':img_skater,'snd':None,'dx':15,'dy':0,'timeout':0},
		]
		skate_right_slower=[
			{'img':img_skater,'snd':None,'dx':9,'dy':0,'timeout':0},
		]
		
		img_skatel=pygame.image.load(os.path.join(sitepkgdir,anim_imgdir,'skate_left.gif'))
		skate_left=[
			{'img':img_skatel,'snd':None,'dx':-15,'dy':0,'timeout':0},
		]
		skate_left_slower=[
			{'img':img_skatel,'snd':None,'dx':-9,'dy':0,'timeout':0},
		]

		self.sequences={
			'walkl':walkl,'walkr':walkr,'scratchr':scratchr,'scratchl':scratchl,'forehead_slap':forehead_slap,
			'big_flapper':big_flapper,'stand_front':stand_front,'hop_in_place':hop_in_place,
			'hopflap_left':hopflap_left,'hopflap_right':hopflap_right,
			'you_go_first':you_go_first,'hi_math_lover':hi_math_lover,
			'head_tilt_left':head_tilt_left,'head_tilt_right':head_tilt_right,
			'neck_stretch':neck_stretch,
			'neck_squash':neck_squash,'neck_squash_tilt_lr':neck_squash_tilt_lr,
			'neck_squash_tilt_l':neck_squash_tilt_l,'neck_squash_tilt_r':neck_squash_tilt_r,
			
			'stand_front_look_left':stand_front_look_left,
			'stand_front_look_right':stand_front_look_right,
			'stand_left_look_front':stand_left_look_front,
			'stand_right_look_front':stand_right_look_front,
			'stand_left_look_front_neck_stretch':stand_left_look_front_neck_stretch,
			'stand_right_look_front_neck_stretch':stand_right_look_front_neck_stretch,
			'hop_right':hop_right,
			'hop_left':hop_left,
			'neck_squash_hop_in_place':neck_squash_hop_in_place,
			'i_am_stumped':i_am_stumped,
			'skate_right':skate_right,
			'skate_right_slower':skate_right_slower,
			'skate_left':skate_left,
			'skate_left_slower':skate_left_slower,
			
		}
		
		
		self.defineManeuver('look_left_maneuver',[{'stand_front_look_left':(-999,0)}])
		self.defineManeuver('look_right_maneuver',[{'stand_front_look_right':(-999,0)}])
		self.defineManeuver('insist_yougofirst_maneuver',[{'you_go_first':(-999,1)},])
		self.defineManeuver('return_stumped_maneuver',[{'i_am_stumped':(-999,10)},{'walkr':(680,100)},{'stand_front':(-999,0)},])
		
		
		self.defineManeuver('tux_welcome_maneuver_01',[{'stand_front':(-999,10)},{'hi_math_lover':(-999,10)},{'walkr':(680,100)},{'stand_front':(-999,1)},{'you_go_first':(-999,15)},{'stand_front':(-999,1)},])
		self.defineManeuver('tux_welcome_maneuver_02',[{'stand_front':(-999,10)},{'hi_math_lover':(-999,10)},{'hop_right':(680,100)},{'stand_front':(-999,1)},{'you_go_first':(-999,15)},{'stand_front':(-999,1)},])
		
		self.defineManeuver('forehead_slap_maneuver',[{'forehead_slap':(-999,0)},{'stand_front':(-999,0)}])
		self.defineManeuver('tux_get_up_maneuver_01',[{'walkl':(200,100)},{'scratchl':(-999,1)},])
		self.defineManeuver('tux_get_up_maneuver_02',[{'walkl':(400,100)},{'skate_left':(200,100)},{'scratchr':(-999,1)},])
		self.defineManeuver('tux_get_up_maneuver_03',[{'skate_left':(400,100)},{'walkl':(200,100)},{'scratchl':(-999,1)},])
		self.defineManeuver('tux_get_up_maneuver_04',[{'skate_left_slower':(400,100)},{'walkl':(200,100)},{'stand_front':(-999,0)},])
		self.defineManeuver('tux_get_up_maneuver_04',[{'walkl':(400,100)},{'skate_left':(200,100)},{'stand_front':(-999,0)},])

		self.defineManeuver('return_skating_maneuver',[{'stand_front':(-999,0)},{'skate_right':(680,100)},{'stand_front':(-999,0)}])
		self.defineManeuver('return_skating_slower_maneuver',[{'stand_front':(-999,0)},{'skate_right_slower':(680,100)},{'stand_front':(-999,0)}])
		self.defineManeuver('tux_go_back_from_tray_maneuver_01',[{'walkr':(680,100)},{'stand_front':(-999,0)},])
		self.defineManeuver('tux_go_back_from_tray_maneuver_02',[{'walkr':(330,100)},{'skate_right':(680,100)},{'stand_right_look_front':(-999,0)},{'stand_front':(-999,0)},])

		self.defineManeuver('tux_hop_back_from_tray_maneuver',[{'walkr':(680,100)},{'stand_front':(-999,0)},{'head_tilt_left':(-999,0)},{'stand_front':(-999,0)}])
		self.defineManeuver('one_scratchl_maneuver',[{'scratchl':(-999,1)},{'stand_front':(-999,0)}])
		self.defineManeuver('one_scratchr_maneuver',[{'scratchr':(-999,1)},{'stand_front':(-999,0)}])
		self.defineManeuver('tux_flapper_maneuver',[{'big_flapper':(-999,3)},{'stand_front':(-999,0)}])
		self.defineManeuver('hopflap_left_maneuver',[{'hopflap_left':(650,100)},{'stand_front':(-999,0)}])
		self.defineManeuver('hopflap_right_maneuver',[{'hopflap_right':(680,100)},{'stand_front':(-999,0)}])
		self.defineManeuver('hopflap_leftright_maneuver',[{'hopflap_left':(650,100)},{'hopflap_right':(680,100)},{'stand_front':(-999,1)}])
		self.defineManeuver('head_tilt_left_maneuver',[{'head_tilt_left':(-999,0)}])
		self.defineManeuver('head_tilt_right_maneuver',[{'head_tilt_right':(-999,0)}])
		self.defineManeuver('hop_in_place_maneuver',[{'hop_in_place':(-999,2)}])
		self.defineManeuver('neck_squash_hop_in_place_maneuver',[{'neck_squash_hop_in_place':(-999,0)}])
		
		self.defineManeuver('neck_stretch_maneuver',[{'neck_stretch':(-999,1)}])
		self.defineManeuver('neck_squash_maneuver',[{'neck_squash':(-999,1)}])
		self.defineManeuver('neck_squash_tiltleftright_maneuver',[{'neck_squash_tilt_lr':(-999,0)}])
		self.defineManeuver('neck_squash_tiltleft_maneuver',[{'neck_squash_tilt_l':(-999,0)}])
		self.defineManeuver('neck_squash_tiltright_maneuver',[{'neck_squash_tilt_r':(-999,0)}])
		self.defineManeuver('neck_stretch_hopinplace_maneuver',[{'neck_stretch':(-999,1)},{'hop_in_place':(-999,1)},{'neck_stretch':(-999,1)},])
		self.defineManeuver('walkoff_stage_right_maneuver',[{'walkr':(1100,100)},{'stand_front':(-999,10)},{'walkl':(680,100)},{'neck_stretch':(-999,1)},{'stand_front':(-999,0)}])
		
		
	def defineManeuver(self,maneuver_name,seqlist):
		self.maneuvers[maneuver_name]=seqlist
			
	def getSequencesPyld(self):
		return(self.sequences)
		
	def getManeuversPyld(self):
		return(self.maneuvers)
	
	def getManeuverNames(self):
		#not currently called for Tux -- his are hardcoded. this func for random tile anims.
		maneuver_names=[]
		for key in self.maneuvers.keys():
			maneuver_names.append(key)
		return(maneuver_names)
