#!/usr/bin/env python
"""
/***************************************************************************

	Author 			:Charles B. Cosse 
	
	Email			:ccosse@asymptopia.org
					
	Copyright		:(C) 2002,2004 Asymptopia Software.
	
 ***************************************************************************/
/***************************************************************************
                          Tux.py

	Description: The Tux object generates & submits Tux's options.

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version. (Please note that if you use this *
 *   code you must give credit by including the Author and Copyright       *
 *   info at the top of this file).                                        *
 ***************************************************************************/
"""

import os, pygame
from pygame.locals import *
from random import random

from Board import *
from Spot import *
from myutil import *
from Tile import *
from Button import *
from Validator import *

from Player import Player

class Tux(Player):
	"""Tux derives from asymptopia.Player
	We could have called it "penguin manager"
	or "Dealer", as in v.01.
	Tux just get instantiated with a ptr->TuxMathScrabble, itself.
	
	Need to add/take-off from submissionspots from here.
	Want to parallel same interface as player does, but can't use same
	actual lines of code, since Tux knows what he's doing and the board
	has yet to validate Tux's submission.
	
	Tux takes care of his own tray.
	He uses same "draw_tiles" func that gets called from play() after 
	win sound, upon successful validation and subsequent guest-exchange between
	layers (submission vs board).
	"""
	def __init__(self,game):
		Player.__init__(self)
		self.game=game
		self.tray=game.tuxtray
		self.LEVEL=game.LEVEL
		self.current_submission_idx=None
		
		self.triplets=None
		self.doublets=None
		self.singlets=None
		self.operator_doublets=None
		self.operator_singlets=None
		
		self.triplet_expressions=None
		self.doublet_expressions=None
		self.singlet_expressions=None
		self.wc_doublet_expressions=None
		self.wc_singlet_expressions=None
		
		self.str2pt=None
		#print 'Tux.LEVEL=',self.LEVEL
	
	def getStringValues(self):
		str_values=[]
		spots=self.tray.get_spots()#not sorted 1-10,so sort:
		nnumbers=self.game.NNUMBERS
		newspots=[]
		for spotidx in range(nnumbers):
			newspots.append(0)#=[0,0,0,0,0,0]
		
		ntrayspots=self.game.NTRAYSPOTS
		while len(spots)>ntrayspots-nnumbers:
			for spot in spots:
				if spot.getMN()[1]<nnumbers:
					newspots[spot.getMN()[1]]=spot
					spots.remove(spot)
				#else:print spot.getMN()
		
		for dummy in range(len(newspots)):
			str_values.append(newspots[dummy].guest.str_val)
		return(str_values)
	
	def getAllStringValues(self):
		str_values=[]
		spots=self.tray.get_spots()#not sorted 1-10,so sort:
		ntrayspots=self.game.NTRAYSPOTS
		newspots=[]
		for spotidx in range(ntrayspots):
			newspots.append(0)#=[0,0,0,0,0,0,0,0,0,0]
		while len(spots)>0:
			for spot in spots:
				newspots[spot.getMN()[1]]=spot
				spots.remove(spot)
		for dummy in range(len(newspots)):
			str_values.append(newspots[dummy].guest.str_val)
		return(str_values)

	def cycle_vals(self,vals):
		tmp=vals.pop()
		vals.insert(int(random()*len(vals)),tmp)
		return(vals)
	
	def get3x2x1x(self,N):
		#N=1,2,3 ~ singlets,doublets,tripplets
		#all unique index-triplets in set of 6 Tiles:
		#if 2 "5"'s in tiles, two "5"-singlets returned, etc..
		plets=[]
		num_times_cycled=0
		str_vals=self.getStringValues()
		#print str_vals
		NumNumbers=6
		while(num_times_cycled<1000):#print ratio when added vs idx on this before v2.0 release
			for idx in range(0,NumNumbers-N):
				i_plet=[]
				s_plet=[]
				for jdx in range(N):
					i_plet.append(float(str_vals[idx+jdx]))#changed to "float" v2.0
				i_plet.sort()
				for jdx in range(N):
					s_plet.append(`i_plet[jdx]`)
				
				if plets.count(s_plet)==0:plets.append(s_plet)
				elif(N==1 and plets.count(s_plet)<str_vals.count(s_plet[0])):
					plets.append(s_plet)
				
			str_vals=self.cycle_vals(str_vals)
			num_times_cycled=num_times_cycled+1
		return(plets)
	
	def evaluate(self,expr):	
		#print expr
		str=''
		for idx in range(len(expr)):
			str=str+expr[idx]
		
		try:
			val=eval(str)
			#print str,val
		except:return(0)
		return(val)

	def get3xPermutations(self,tripplet):#receives single triplet list of len=3
		#print 'tripplet:',tripplet
		p=[[1,2,3],[1,3,2],[2,1,3],[2,3,1],[3,1,2],[3,2,1]]
		px3=[]#list of permuted "t"riplets
		for pidx in range(len(p)):
			tx3=[]#a permuted "t"riplet
			for tidx in range(3):
				#print 'pidx:',pidx,'  tidx:',tidx,'  p[pidx][tidx]-1=',p[pidx][tidx]-1,'  tripplet[p[pidx][tidx]-1]=',tripplet[p[pidx][tidx]-1]
				tx3.append(tripplet[p[pidx][tidx]-1])
			if px3.count(tx3)==0:px3.append(tx3)
			#print 'px3:',px3
		return(px3)	
		
	def get2xPermutations(self,doublet):
		p=[[1,2],[2,1]]
		px2=[]#list of permuted doublets
		for pidx in range(len(p)):
			dx2=[]#permuted doublet
			for tidx in range(2):
				dx2.append(doublet[p[pidx][tidx]-1])
			if px2.count(dx2)==0:px2.append(dx2)
		return(px2)	
			
	#This needs modified to handle mult/div:
	def get_operator_plets(self,N):
		if(N==1):plets=[['+'],['-'],['*'],['/']]
		elif N==2 and self.LEVEL<=4:plets=[
			['+','+'],['+','-'],['-','+'],['-','-'],
			['*','*'],['*','/'],['/','*'],['/','/'],
			['*','-'],['-','*'],['*','+'],['+','*'],
			['/','-'],['-','/'],['/','+'],['+','/']
		]
		elif N==2 and self.LEVEL<3:plets=[
			['+','+'],['+','-'],['-','+'],['-','-'],]
		return(plets)
	
	def generate_expressions(self):
		triplets=self.get3x2x1x(3)#these currently rely on integer sort();could use sort.py on chars..?
		doublets=self.get3x2x1x(2)
		singlets=self.get3x2x1x(1)
		operator_doublets=self.get_operator_plets(2)#a "2" here corresponds to 2 operators between a ("3") tripplet of numbers
		operator_singlets=self.get_operator_plets(1)
		current_submission_idx=0

		triplet_expressions=[]
		for pdx in range(0,len(triplets)):
			permutations=self.get3xPermutations(triplets[pdx])#permutations of idx+1 (i.e. 1,2,3 rather than 0,1,2)
			for perm in permutations:
				for odx in range(len(operator_doublets)):
					expr=[perm[0],operator_doublets[odx][0],perm[1],operator_doublets[odx][1],perm[2]]#save these
					value=self.evaluate(expr)
					triplet_expressions.append([pdx,odx,expr,value])
		
		#+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
		"""deactivating: this works, but takes too long (testing, not generating (here)) by brute force.

		#v2.0
		wc_triplet_expressions=[]
		
		#wc_idx=0
		for pdx in range(0,len(triplets)):
			permutations=self.get3xPermutations(triplets[pdx])#permutations of idx+1 (i.e. 1,2,3 rather than 0,1,2)
			for perm in permutations:
				for odx in range(len(operator_doublets)):
					for val in range(16):
						expr=[`val`,operator_doublets[odx][0],perm[1],operator_doublets[odx][1],perm[2]]
						value=self.evaluate(expr)
						expr=['WC:'+`val`,operator_doublets[odx][0],perm[1],operator_doublets[odx][1],perm[2]]
						wc_triplet_expressions.append([pdx,odx,expr,value])
		#wc_idx=1
		for pdx in range(0,len(triplets)):
			permutations=self.get3xPermutations(triplets[pdx])#permutations of idx+1 (i.e. 1,2,3 rather than 0,1,2)
			for perm in permutations:
				for odx in range(len(operator_doublets)):
					for val in range(16):
						expr=[perm[0],operator_doublets[odx][0],`val`,operator_doublets[odx][1],perm[2]]
						value=self.evaluate(expr)
						expr=[perm[0],operator_doublets[odx][0],'WC:'+`val`,operator_doublets[odx][1],perm[2]]
						wc_triplet_expressions.append([pdx,odx,expr,value])
		#wc_idx=2
		for pdx in range(0,len(triplets)):
			permutations=self.get3xPermutations(triplets[pdx])#permutations of idx+1 (i.e. 1,2,3 rather than 0,1,2)
			for perm in permutations:
				for odx in range(len(operator_doublets)):
					for val in range(16):
						expr=[perm[0],operator_doublets[odx][0],perm[1],operator_doublets[odx][1],`val`]
						value=self.evaluate(expr)
						expr=[perm[0],operator_doublets[odx][0],perm[1],operator_doublets[odx][1],'WC:'+`val`]
						wc_triplet_expressions.append([pdx,odx,expr,value])
		#wc_idx~operator[0]
		for pdx in range(0,len(triplets)):
			permutations=self.get3xPermutations(triplets[pdx])#permutations of idx+1 (i.e. 1,2,3 rather than 0,1,2)
			for perm in permutations:
				for odx in range(len(operator_doublets)):
					expr=[perm[0],operator_doublets[odx][0],perm[1],operator_doublets[odx][1],perm[2]]
					value=self.evaluate(expr)
					expr=[perm[0],'WC:'+operator_doublets[odx][0],perm[1],operator_doublets[odx][1],perm[2]]
					wc_triplet_expressions.append([pdx,odx,expr,value])
		#wc_idx~operator[1]
		for pdx in range(0,len(triplets)):
			permutations=self.get3xPermutations(triplets[pdx])#permutations of idx+1 (i.e. 1,2,3 rather than 0,1,2)
			for perm in permutations:
				for odx in range(len(operator_doublets)):
					expr=[perm[0],operator_doublets[odx][0],perm[1],operator_doublets[odx][1],perm[2]]
					value=self.evaluate(expr)
					expr=[perm[0],operator_doublets[odx][0],perm[1],'WC:'+operator_doublets[odx][1],perm[2]]
					wc_triplet_expressions.append([pdx,odx,expr,value])
		
		print 'finished wc_triplet_expressions generation:',len(triplet_expressions),len(wc_triplet_expressions)
		"""
		#+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
		doublet_expressions=[]
		for pdx in range(0,len(doublets)):
			permutations=self.get2xPermutations(doublets[pdx])#permutations of idx+1 (i.e. 1,2,3 rather than 0,1,2)
			for perm in permutations:
				for odx in range(len(operator_singlets)):
					expr=[perm[0],operator_singlets[odx][0],perm[1]]
					value=self.evaluate(expr)
					doublet_expressions.append([pdx,odx,expr,value])
		
		#+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
		wc_doublet_expressions=[]
		#wc_idx=0
		for pdx in range(0,len(singlets)):
			for odx in range(len(operator_singlets)):
				for val in range(21):
					expr=[`val`+'.0',operator_singlets[odx][0],singlets[pdx][0]]
					value=self.evaluate(expr)
					expr=['WC:'+`val`+'.0',operator_singlets[odx][0],singlets[pdx][0]]
					wc_doublet_expressions.append([pdx,odx,expr,value])
		#wc_idx=1
		for pdx in range(0,len(singlets)):
			for odx in range(len(operator_singlets)):
				for val in range(21):
					expr=[singlets[pdx][0],operator_singlets[odx][0],`val`+'.0']
					value=self.evaluate(expr)
					expr=[singlets[pdx][0],operator_singlets[odx][0],'WC:'+`val`+'.0']
					wc_doublet_expressions.append([pdx,odx,expr,value])

		#wc~operator:
		for pdx in range(0,len(doublets)):
			permutations=self.get2xPermutations(doublets[pdx])#permutations of idx+1 (i.e. 1,2,3 rather than 0,1,2)
			for perm in permutations:
				for odx in range(len(operator_singlets)):
					expr=[perm[0],operator_singlets[odx][0],perm[1]]
					value=self.evaluate(expr)
					expr=[perm[0],'WC:'+operator_singlets[odx][0],perm[1]]
					wc_doublet_expressions.append([pdx,odx,expr,value])
		#print 'wc_doublet_expressions=',wc_doublet_expressions
		
		#+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
		#NEW: v2.0
		#wc_idx=1 AND wc_idx=2
		wc_wc_doublet_expressions=[]
		for v1 in range(21):
			for v2 in range(21):
				for odx in range(len(operator_singlets)):
					expr=[`v1`+'.0',operator_singlets[odx][0],`v2`+'.0']
					value=self.evaluate(expr)
					expr=['WC:'+`v1`+'.0',operator_singlets[odx][0],'WC:'+`v2`+'.0']
					wc_wc_doublet_expressions.append([0,odx,expr,value])#what did "pdx"(now "0") do?
		
		#+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
		singlet_expressions=[]
		for pdx in range(0,len(singlets)):
			expr=[singlets[pdx][0]]
			value=self.evaluate(expr[0])
			singlet_expressions.append([pdx,None,expr,value])
		#print 'singlet_expressions=',singlet_expressions
		
		#+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
		wc_singlet_expressions=[]
		#wc_idx=0
		for pdx in range(0,21):#depends on game.LEVEL
			expr=['WC:'+`pdx`+'.0']
			value=pdx
			wc_singlet_expressions.append([pdx,None,expr,value])
		#print 'wc_singlet_expressions=',wc_singlet_expressions
		#+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
		self.triplet_expressions=triplet_expressions
		self.doublet_expressions=doublet_expressions
		self.singlet_expressions=singlet_expressions
		#self.wc_triplet_expressions=wc_triplet_expressions
		self.wc_doublet_expressions=wc_doublet_expressions
		self.wc_wc_doublet_expressions=wc_wc_doublet_expressions
		self.wc_singlet_expressions=wc_singlet_expressions
		#+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
		self.game.do_one_scratch()
		

	def construct_submission(self,lhs_expressions,rhs_expressions):
		#$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$PERFECT
		#doublet=wc_wc_doublet
		#$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$PERFECT
		
		stringValues=self.getAllStringValues()
		str2pt=self.str2pt
		#print len(lhs_expressions)*len(rhs_expressions),' possible'
		self.game.do_one_scratch()
		for idx1 in range(len(lhs_expressions)):
			for idx2 in range(len(rhs_expressions)):
				if lhs_expressions[idx1][3]==rhs_expressions[idx2][3]:
					#print 'combining:',lhs_expressions[idx1],rhs_expressions[idx2]
					combinedList=[]
					for idx in range(len(lhs_expressions[idx1][2])):
						#print 'idx1=',idx1,' idx=',idx
						combinedList.append(lhs_expressions[idx1][2][idx])
					combinedList.append('=')
					for idx in range(len(rhs_expressions[idx2][2])):
						combinedList.append(rhs_expressions[idx2][2][idx])
					ok=1
					for elem in combinedList:
							count=combinedList.count(elem)
							if elem.count('WC:'):#Then we don't want to check for it in stringValues!!
								pass
							elif stringValues.count(elem)<count:
								#print combinedList,elem,count,stringValues.count(elem)
								ok=0
					if ok==1:
						#print combinedList
						rlist=self.game.localizer.localize(combinedList)
						if rlist:
							print combinedList,rlist
							score=0
							for cidx in range(len(combinedList)):
								if combinedList[cidx][:3]=='WC:':score=score+str2pt[combinedList[cidx][3:]]
								else:
									#print str2pt,combinedList[cidx]
									score=score+str2pt[combinedList[cidx]]
							#print 'score=',score
							self.game.tuxscore=self.game.tuxscore+score
							return(rlist)
		return(None)
							
	def generate_options(self):
		triplet_expressions=self.triplet_expressions
		doublet_expressions=self.doublet_expressions
		singlet_expressions=self.singlet_expressions
		#wc_triplet_expressions=self.wc_triplet_expressions
		wc_doublet_expressions=self.wc_doublet_expressions
		wc_wc_doublet_expressions=self.wc_wc_doublet_expressions
		wc_singlet_expressions=self.wc_singlet_expressions
		operator_doublets=self.operator_doublets
		operator_singlets=self.operator_singlets
		
		LEVEL=self.LEVEL
		#print 'tux generating options'	

		self.options=[]#the result of this function
		tray=self.tray
		spots=self.tray.get_spots()
		
		#board get 1 copy 1x str_val array in preparation of numerous brute-force localization attempts:
		self.game.localizer.update_board_map()
		
		
		num_commited=self.game.board.get_num_commited()
		
		if num_commited>3 and LEVEL>1:#SPARE LEVEL 1 BIG ENTRIES
			rlist=self.construct_submission(triplet_expressions,wc_doublet_expressions)
			if rlist:return(rlist)
			rlist=self.construct_submission(wc_doublet_expressions,triplet_expressions)
			if rlist:return(rlist)
			rlist=self.construct_submission(triplet_expressions,wc_singlet_expressions)
			if rlist:return(rlist)
			rlist=self.construct_submission(wc_singlet_expressions,triplet_expressions)
			if rlist:return(rlist)
		
		if num_commited>3:
			rlist=self.construct_submission(doublet_expressions,wc_wc_doublet_expressions)
			if rlist:return(rlist)
			rlist=self.construct_submission(wc_wc_doublet_expressions,doublet_expressions)
			if rlist:return(rlist)
			rlist=self.construct_submission(wc_wc_doublet_expressions,singlet_expressions)
			if rlist:return(rlist)
			rlist=self.construct_submission(singlet_expressions,wc_wc_doublet_expressions)
			if rlist:return(rlist)
			rlist=self.construct_submission(wc_doublet_expressions,wc_doublet_expressions)
			if rlist:return(rlist)
			rlist=self.construct_submission(doublet_expressions,wc_doublet_expressions)
			if rlist:return(rlist)
			rlist=self.construct_submission(wc_doublet_expressions,doublet_expressions)
			if rlist:return(rlist)
		
		rlist=self.construct_submission(wc_singlet_expressions,wc_doublet_expressions)
		if rlist:return(rlist)
		rlist=self.construct_submission(wc_doublet_expressions,wc_singlet_expressions)
		if rlist:return(rlist)
		rlist=self.construct_submission(doublet_expressions,wc_singlet_expressions)
		if rlist:return(rlist)
		rlist=self.construct_submission(wc_singlet_expressions,doublet_expressions)
		if rlist:return(rlist)
		rlist=self.construct_submission(singlet_expressions,wc_doublet_expressions)
		if rlist:return(rlist)
		rlist=self.construct_submission(wc_doublet_expressions,singlet_expressions)
		if rlist:return(rlist)
		rlist=self.construct_submission(wc_singlet_expressions,singlet_expressions)
		if rlist:return(rlist)
		rlist=self.construct_submission(singlet_expressions,wc_singlet_expressions)
		if rlist:return(rlist)
		else:return(None)


	
