"""
/***************************************************************************

	Author 			:Charles B. Cosse 
	
	Email			:ccosse@asymptopia.org
					
	Copyright		:(C) 2002,2004 Asymptopia Software.
	
 ***************************************************************************/
/***************************************************************************
                          Spot.py

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version. (Please note that if you use this *
 *   code you must give credit by including the Author and Copyright       *
 *   info at the top of this file).                                        *
 ***************************************************************************/
"""
import pygame
from pygame.locals import *
from myutil import *

class Spot(pygame.sprite.Sprite):
	def __init__(self,default_image,M,N,TYPE):
		pygame.sprite.Sprite.__init__(self)
		if default_image:
			self.default_image,self.rect=load_image(default_image,-1)
			self.image=self.default_image
		else:
			self.default_image=None
			self.rect=pygame.Rect(0,0,0,0)
			self.image=None
		self.guest=None
		self.locked=0
		self.M=M
		self.N=N
		self.TYPE=TYPE
		
		
		self.AMHEAD=0
		self.AMROWEXPR=0
		self.AMCOLEXPR=0
		self.ROWEXPRLENGTH=0
		self.COLEXPRLENGTH=0

	
	def setMN(self,M,N):
		self.M=M
		self.N=N
	
	def getMN(self):
		return((self.M,self.N))
		
	def take_guest(self,guest,use_guest_image):
		self.guest=guest
		#print 'guest=',guest
		self.guest.rect.center=self.rect.center
		if use_guest_image:self.image=guest.image

	def lock(self):
		self.locked=1
	
	def islocked(self):
		return(self.locked)

	def occupied(self):
		if self.guest==None:return(0)
		return(1)
		
	def pop_guest(self):
		self.image=self.default_image
		guest=self.guest
		self.guest=None
		return(guest)
		
	def update(self):
		pass
		
	
