"""
/***************************************************************************

	Author 			:Charles B. Cosse 
	
	Email			:ccosse@asymptopia.org
					
	Copyright		:(C) 2002,2004 Asymptopia Software.
	
 ***************************************************************************/
/***************************************************************************
                          Localizer.py
 ***************************************************************************/
 
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version. (Please note that if you use this *
 *   code you must give credit by including the Author and Copyright       *
 *   info at the top of this file).                                        *
 ***************************************************************************/

"""
import pygame,os
from pygame.locals import *
from random import random

class Localizer:
	"""Localizer has game model.
	"""
	def __init__(self,board,game):
		self.board=board
		self.game=game#only used to update score
		self.board_map=None
		self.M=self.board.M
		self.N=self.board.N

	#_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/
	#NEW FUNCTION V2.0
	#_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/
	def update_board_map(self):
		#returns a 2D array of str_vals
		self.board_map=self.board.get_map()
	
	#_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/
	#NEW LOCALIZER
	#_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/
	def localize(self,submission):
		
		#flip coin to decide whether to try row or col first:
		rand=int(random()*2)
		if rand==0:
			rlist=self.try_row(submission)
			if rlist:return(rlist)
			rlist=self.try_col(submission)
			if rlist:return(rlist)
		else:	
			rlist=self.try_col(submission)
			if rlist:return(rlist)
			rlist=self.try_row(submission)
			if rlist:return(rlist)
		return(None)
		
	def try_row(self,submission):	
		board_map=self.board_map
		M=self.M
		N=self.N
		if len(submission)==0:return(None)
		if len(self.board.get_listofheads())==0:return(None)
		slim=len(submission)
		nlim=N-len(submission)+1
		for m in range(M):
			for n in range(nlim):
				ok=1
				for sidx in range(slim):
					if submission[sidx][:3]=='WC:':
						if board_map[m][n+sidx]==submission[sidx][3:]:
							dummy=0
							#print submission,'we have match:',submission[sidx],' at m,n = ',m,n+sidx
						else:ok=0
					elif board_map[m][n+sidx]=='':dummy=0
					else:
						#print 'ROW: setting->0 b/c board ',m,n+sidx,' !=\'\' ',board_map[m][n+sidx],submission[sidx][:3]
						ok=0;
				if ok==1:#head @(m,n)
					rlist=[]
					for idx in range(slim):
						tripple=[submission[idx],m,n+idx]
						#if tripple[0][:3]=='WC:':dummy=0  <-remove these after check;keep "WC:" in the value
						#else:rlist.append(tripple)
						rlist.append(tripple)
					rval=self.check_neighborhood(rlist)
					#print 'check_neighborhood returned:',rval
					
					"""
					#####This section (v2.5-2.6a) handled various values of spots; instead (v2.7)
					#####now using various tile values (only).
					tuxscore=0
					multiplier=1
					for nn in range(n,n+len(rlist)):
						spot2check=self.board.get_spotMN(m,nn	)
						if spot2check.TYPE=='2XL':tuxscore=tuxscore+2
						elif spot2check.TYPE=='2XW':
							tuxscore=tuxscore+1
							multiplier=multiplier*2
						elif spot2check.TYPE=='3XL':tuxscore=tuxscore+3
						elif spot2check.TYPE=='3XW':
							tuxscore=tuxscore+1
							multiplier=multiplier*3
						else:tuxscore=tuxscore+1
					tuxscore=tuxscore*multiplier
					"""
					#### v2.7 tiles have associated values (not spots)
					#now remove "WC:"s
					for idx in range(slim-1,-1,-1):
						if rlist[idx][0][:3]=='WC:':rlist.pop(idx)
					if rval==1:
						return(rlist)
		return(None)
		
	def try_col(self,submission):	
		board_map=self.board_map
		M=self.M
		N=self.N
		if len(submission)==0:return(None)
		if len(self.board.get_listofheads())==0:return(None)
		slim=len(submission)
		mlim=M-len(submission)+1
		for n in range(N):
			for m in range(mlim):
				ok=1
				for sidx in range(slim):
					if submission[sidx][:3]=='WC:':
						if board_map[m+sidx][n]==submission[sidx][3:]:
							#print submission,'we have match:',submission[sidx],' at m,n = ',m+sidx,n
							dummy=0
						else:ok=0
					elif board_map[m+sidx][n]=='':dummy=0
					else:
						#print 'COL: setting->0 b/c board ',m+sidx,n,' !=\'\' ',board_map[m+sidx][n],submission[sidx][:3]
						ok=0;
				if ok==1:#head @(m,n)
					rlist=[]
					for idx in range(slim):
						tripple=[submission[idx],m+idx,n]
						#if tripple[0][:3]=='WC:':dummy=0
						#else:rlist.append(tripple)
						rlist.append(tripple)
					rval=self.check_neighborhood(rlist)
					#print 'check_neighborhood returned:',rval
					
					for mm in range(m,m+len(rlist)):
						"""
						if spot2check.TYPE=='2XL':tuxscore=tuxscore+2
						elif spot2check.TYPE=='2XW':
							tuxscore=tuxscore+1
							multiplier=multiplier*2
						elif spot2check.TYPE=='3XL':tuxscore=tuxscore+3
						elif spot2check.TYPE=='3XW':
							tuxscore=tuxscore+1
							multiplier=multiplier*3
						else:tuxscore=tuxscore+1
						"""
					#tuxscore=tuxscore*multiplier
					#now remove "WC:"s
					for idx in range(slim-1,-1,-1):
						if rlist[idx][0][:3]=='WC:':rlist.pop(idx)
					if rval==1:
						return(rlist)
		return(None)
	
	#_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/
	#CHECK NEIGHBORHOOD
	#NOTE: still not chaining adjacent eqns...might leave off for now.
	#_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/
	def check_neighborhood(self,rlist):
		board_map=self.board_map
		M=self.M
		N=self.N
		
		ok=1
		slen=len(rlist)
		head=(rlist[0][1],rlist[0][2])
		tail=(rlist[slen-1][1],rlist[slen-1][2])
		if rlist[0][2]==rlist[1][2]:
			iscol=1
			col=rlist[0][2]
		else:
			iscol=0
			row=rlist[0][1]
		
		if iscol:
			#check above:
			if head[0]==0:pass
			elif board_map[head[0]-1][col]!='':ok=-1;return(ok)
			else:pass
			#check below:
			if tail[0]==M-1:pass
			elif board_map[tail[0]+1][col]!='':ok=-2;return(ok)
			else:pass
			#check left:
			if col==0:pass
			else:
				#for ridx in range(head[0],tail[0]):
				for qty in rlist:
					if qty[0][:3]=='WC:':pass
					elif board_map[qty[1]][col-1]!='':ok=-3;return(ok)
			#check right:
			if col==N-1:pass
			else:
				#for ridx in range(head[0],tail[0]):
				for qty in rlist:
					if qty[0][:3]=='WC:':pass
					elif board_map[qty[1]][col+1]!='':ok=-4;return(ok)
			
		else:#submission is a row
			#check left:
			if head[1]==0:pass
			elif board_map[row][head[1]-1]!='':ok=-5;return(ok)
			else:pass
			#check right:
			if tail[1]==N-1:pass
			elif board_map[row][tail[1]+1]!='':ok=-6;return(ok)
			else:pass
			#check above:
			if row==0:pass
			else:
				#for cidx in range(head[1],tail[1]):
				for qty in rlist:
					if qty[0][:3]=='WC:':pass
					elif board_map[row-1][qty[2]]!='':ok=-7;return(ok)
			#check below:
			if head[0]==M-1:pass
			else:
				#for cidx in range(head[1],tail[1]):
				for qty in rlist:
					if qty[0][:3]=='WC:':pass
					elif board_map[row+1][qty[2]]!='':ok=-8;return(ok)
		return(ok)
