"""
/***************************************************************************

	Author 			:Charles B. Cosse 
	
	Email			:ccosse@asymptopia.org
					
	Copyright		:(C) 2002,2004 Asymptopia Software.
	
 ***************************************************************************/
/***************************************************************************
                          Board.py

	Description:

	A Board is a group of generalized spots.
	This class should be used as a base class for various types of
	boards -- blackjack tables,cw puzzles,checkers -- any thing with
	fixed spots. The game pieces are attirbutes of the board.
	If you want a background image, blit that as background from the
	outermost game class, not this class, as this is a Group.
	
	Group base class provides: Add,copy,empty,has,sprites,remove,update
	Should not give both empty_spot_image and background_image; either/or.

	If background image, then we break-up the background image into default 
	spot images. If neither, of course, then it's an *invisible* spot.
	*Derived* classes set the location of the self.spots.
	The way the images are passed to __init__, the look of the board(ie spot
	images) is still controlled from outside. No need to manaully
	do anything unless get the spots through the get_spots() method.
	XC,YC are center of board -- boards all assumed array like
	
	Latest: submission is M*N array of invisible spots; validate_submission(self.submission);

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version. (Please note that if you use this *
 *   code you must give credit by including the Author and Copyright       *
 *   info at the top of this file).                                        *
 ***************************************************************************/

"""

import pygame
from pygame.locals import *
from Spot import Spot


class Board(pygame.sprite.Group):
	
	def __init__(self,M,N,XC,YC,background_image,default_spot_image):
		pygame.sprite.Group.__init__(self)
		self.M=M
		self.N=N
		self.XC=XC#this is 974/2
		self.YC=YC
		self.default_spot_image=default_spot_image
		self.map=None
		self.num_commited=0
		
		if background_image and not default_spot_image:self.make_background_spots(background_image)
		elif default_spot_image and not background_image:self.make_default_spots(default_spot_image)
		else:self.make_invisible_spots(None)
	
	def get_map(self):
		m=[]
		for midx in range(self.M):
			m.append([])
			for nidx in range(self.N):
				for spot in self.sprites():
					if spot.getMN()[0]==midx and spot.getMN()[1]==nidx:
						if spot.guest:m[midx].append(spot.guest.str_val)
						else:m[midx].append('')
		return(m)
	
			
	def check4guest(self,m,n):
		#print 'check4guest:',m,n
		if m<0 or m>self.M-1 or n<0 or n>self.N-1:return(0)
		spot=self.get_spotMN(m,n)
		if spot.guest==None:return(0)
		else:return(1)
		
	def get_listofheads(self):
		heads=[]
		for spot in self.sprites():
			if spot.guest:
				if spot.AMHEAD:heads.append(spot)
		return(heads)			
	
	def clear_spots(self):
		for spot in self.sprites():
			spot.remove(self)
	
	def get_spotMN(self,m,n):
		for spot in self.sprites():
			MN=spot.getMN()
			if MN[0]==m and MN[1]==n:
				return(spot)
	
	def take_guestMN(self,tile,m,n):
		#print 'take_guestMN:',tile,m,n
		for spot in self.sprites():
			MN=spot.getMN()
			if MN[0]==m and MN[1]==n:
				spot.take_guest(tile,1)
				return(spot)
	
	def get_num_commited(self):
		return(self.num_commited)
	
	def increment_num_commited(self):
		self.num_commited=self.num_commited+1
	
	def get_guest_by_str(self,str_val):
		#this function TuxTray->Submission ('getting' from Tux Tray)
		for spot in self.sprites():
			if spot.guest and spot.guest.str_val==str_val:
				return spot.pop_guest()
		return(None)
			
	def get_spots(self):
		#this function is boardspots
		return(self.sprites())
	
	#SPOT MAKERS:
	def make_background_spots(self,background_image):
		#print 'make_background_spots'
		for midx in range(self.M):
			for nidx in range(self.N):
				#print 'need to break-up background image!'
				self.add(Spot(default_spot_image,midx,nidx))#change to background_tile
	
	def make_default_spots(self,default_spot_image):
		#print 'make_default_spots'
		XC=self.XC
		YC=self.YC
		M=self.M
		N=self.N
		
		for midx in range(0,M):
			for nidx in range(0,N):
				spot=Spot(default_spot_image,midx,nidx,'REG')
				"""
				if self.M==1:spot=Spot(default_spot_image,midx,nidx,'REG')
				####This section was v2.5-v2.6a colored/weighted spots; as of
				####v2.7 the tiles (only) have various values.
				elif abs(M/2-midx)==abs(N/2-nidx):
					img=default_spot_image[:-4]+'_2XL.gif'
					spot=Spot(img,midx,nidx,'2XL')
				####
				elif (midx)==(-nidx+(N/2-4)):#top left
					img=default_spot_image[:-4]+'_3XL.gif'
					spot=Spot(img,midx,nidx,'3XL')
				elif (midx)==(-nidx+(N/2+16)):#bot right
					img=default_spot_image[:-4]+'_3XL.gif'
					spot=Spot(img,midx,nidx,'3XL')
				elif (midx)==(+nidx-(N/2+4)):#top right
					img=default_spot_image[:-4]+'_3XL.gif'
					spot=Spot(img,midx,nidx,'3XL')
				elif (midx)==(+nidx+(8)):#bot left
					img=default_spot_image[:-4]+'_3XL.gif'
					spot=Spot(img,midx,nidx,'3XL')
				####
				elif (midx==0 and nidx==0) or (nidx==N-1 and midx==M-1) or (nidx==0 and midx==M-1) or (nidx==N-1 and midx==0):
					img=default_spot_image[:-4]+'_2XW.gif'
					spot=Spot(img,midx,nidx,'2XW')
				elif (midx==M/2 and nidx==N/4) or (nidx==N/2 and midx==M/4) or (nidx==N/2 and midx==3*M/4) or (nidx==3*N/4 and midx==M/2):
					img=default_spot_image[:-4]+'_2XW.gif'
					spot=Spot(img,midx,nidx,'2XW')
				####
				elif (nidx==N/2 and midx==0):
					img=default_spot_image[:-4]+'_3XW.gif'
					spot=Spot(img,midx,nidx,'3XW')
				elif (nidx==N/2 and midx==M-1):
					img=default_spot_image[:-4]+'_3XW.gif'
					spot=Spot(img,midx,nidx,'3XW')
				elif (nidx==0 and midx==M/2):
					img=default_spot_image[:-4]+'_3XW.gif'
					spot=Spot(img,midx,nidx,'3XW')
				elif (nidx==N-1 and midx==M/2):
					img=default_spot_image[:-4]+'_3XW.gif'
					spot=Spot(img,midx,nidx,'3XW')
				####
				else:
					spot=Spot(default_spot_image,midx,nidx,'REG')
				"""
				w=spot.image.get_width()
				h=spot.image.get_height()
				spot.rect.center=(	XC+((-N/2+nidx+.5)*w),YC+(	(-M/2+midx+.5)*h)	)
				self.add(spot)
							
	def make_invisible_spots(self,invisible):#instantiate with invisible="None"
		print 'make_invisible_spots'
		for midx in range(self.M):
			for nidx in range(self.N):
				self.add(Spot(invisible,midx,nidx))
	
	
	#def localize(self,submission):
	#	print 'board.localize:',submission
	#	return(1)
