#!/usr/bin/python
"""
/***************************************************************************

	Author 			:Charles B. Cosse 
	
	Email			:ccosse@asymptopia.org
					
	Copyright		:(C) 2002,2004 Asymptopia Software.
	
 ***************************************************************************/
/***************************************************************************
                          Animator.py


 ***************************************************************************/
 
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version. (Please note that if you use this *
 *   code you must give credit by including the Author and Copyright       *
 *   info at the top of this file).                                        *
 ***************************************************************************/

"""

import os, pygame,sys
from pygame.locals import *
from random import random

class Animator:
	def __init__(self):
		self.characters={}
		self.maneuvers={}#keep separate from chars?
		
	def add_char(self,name,char):
		self.characters[name]=char
	
	def start_maneuver(self,who,which):
		maneuvers=self.maneuvers
		#print 'Animator.maneuvers=',maneuvers
		#print ''
		#print 'Animator setting maneuver=',maneuvers[which]
		self.characters[who].begin_maneuver(maneuvers[which])
		
	
	def define_maneuver(self,name,maneuver):
		self.maneuvers[name]=maneuver
		
	
	

