#!/usr/bin/env python
#
# This is the distutils setup script for pygame.
# Full instructions are in "install.txt" or "install.html"
#
# To configure, compile, install, just run this script.

DESCRIPTION = """
TuxMathScrab*le is a math version of
the popular board game for kids age 4-10. It is a 
single player game where the player drags-n-drops 
tiles from a tray to the gameboard. If the submission 
is a valid equation (left side = right side) then the 
tiles come to life and little animated penguins perform 
various animations. Tux (the Linux mascott) then proceeds 
to move his tiles in an animated fashion.

TuxMathScrab*le is written in Python using PyGame for 
multimedia support. It is platform independent and 
development is ongoing. This is version 2.0 released
April 10, 2003. """



METADATA = {
    "name":             "TuxMathScrabble",
    "version":          "2.0",
    "license":          "LGPL",
    "url":              "http://www.asymptopia.com",
    "author":           "Charlie Cosse",
    "author_email":     "ccosse@asymptopia.com",
    "description":      "A Math Scrab*le Game For Kids 4-40",
    "long_description": DESCRIPTION,
}

try:
    import distutils
except ImportError:
    raise SystemExit, "TuxMathScrabble requires distutils to build and install."


#get us to the correct directory
import os, sys
path = os.path.split(os.path.abspath(sys.argv[0]))[0]
os.chdir(path)


import os.path, glob
import distutils.sysconfig 
from distutils.core import setup, Extension
from distutils.extension import read_setup_file
from distutils.ccompiler import new_compiler
from distutils.command.install_data import install_data


#sanity check for any arguments
#"""
if len(sys.argv) == 1:
    reply = raw_input('\nNo Arguments Given, Perform Default Install? [Y/n]')
    if not reply or reply[0].lower() != 'n':
        sys.argv.append('install')

if sys.platform != 'win32':
	try:os.system('rm -rf /usr/local/lib/python2.2/site-packages/asymptopia')
	except Exception,e:pass
	os.system('rm -rf build')
	os.system('rm -f asymptopia/*.pyc')


sys.argv.append('install')

#make sure there is a Setup file
if not os.path.isfile('Setup'):
    print '\n\nWARNING, No "Setup" File Exists, Running "config.py"'
    import config
    config.main()
    print '\nContinuing With "setup.py"'



#get compile info for all extensions
try: extensions = read_setup_file('Setup')
except: raise SystemExit, """Error with the "Setup" file,
perhaps make a clean copy from "Setup.in"."""


#extra files to install
data_path = os.path.join(distutils.sysconfig.get_python_lib(), 'asymptopia')
images_contents=[]
anim_images_contents=[]
font_files=[]
sound_files=[]
for f in glob.glob(os.path.join('asymptopia/images', '*')):
    images_contents.append(f)
for f in glob.glob(os.path.join('asymptopia/anim_images', '*')):
    anim_images_contents.append(f)
for f in glob.glob(os.path.join('asymptopia/font', '*')):
    font_files.append(f)
for f in glob.glob(os.path.join('asymptopia/sounds', '*')):
    sound_files.append(f)
	
	
		


#try to find DLLs and copy them too  (only on windows)
if sys.platform == 'win32':
    tempcompiler = new_compiler()
    ext = tempcompiler.shared_lib_extension
    for e in extensions:
        paths = []
        for d in e.library_dirs:
             for l in e.libraries:
                    name = tempcompiler.shared_lib_format%(l, ext)
                    paths.append(os.path.join(d, name))
        for p in paths:
            if os.path.isfile(p) and p not in data_files:
                data_files.append(p)


#clean up the list of extensions
for e in extensions[:]:
    if e.name[:8] == 'COPYLIB_':
        extensions.remove(e) #don't compile the COPYLIBs, just clean them
    else:
        e.name = 'tuxmathscrabble.' + e.name #prepend package name on modules
        

#data installer with improved intelligence over distutils
#data files are copied into the project directory instead
#of willy-nilly
class smart_install_data(install_data):   
    def run(self):
        #need to change self.install_dir to the actual library dir
        install_cmd = self.get_finalized_command('install')
        self.install_dir = getattr(install_cmd, 'install_lib')
        return install_data.run(self)






#finally, 
#call distutils with all needed info
PACKAGEDATA = {
       "cmdclass":    {'install_data': smart_install_data},
       "packages":    ['asymptopia'],
       "package_dir": {'asymptopia': 'asymptopia'},
       "ext_modules": extensions,
       "data_files":  [['asymptopia/images', images_contents],['asymptopia/anim_images',anim_images_contents],['asymptopia/sounds',sound_files],['asymptopia/font',font_files]],
		
}
PACKAGEDATA.update(METADATA)
apply(setup, [], PACKAGEDATA)

if sys.platform != 'win32':
	os.system('cp tuxmathscrabble.py /usr/local/bin/tuxmathscrabble')
	os.system('chmod +x /usr/local/bin/tuxmathscrabble')

	
