#!/usr/bin/env python
"""
/***************************************************************************

	Author 			:Charles B. Cosse 
	
	Email			:ccosse@asymptopia.com
					
					
	Copyright		:(C) 2002,2003 Asymptopia Software.
	
 ***************************************************************************/
/***************************************************************************
                          tuxmathscrabble.py

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version. (Please note that if you use this *
 *   code you must give credit by including the Author and Copyright       *
 *   info at the top of this file).                                        *
 ***************************************************************************/
"""



import os, pygame,sys
from pygame.locals import *
from random import random
from asymptopia.myutil import load_image
		
from asymptopia.Board import *
from asymptopia.Spot import *
from asymptopia.myutil import *
from asymptopia.Tile import *
from asymptopia.Button import *
from asymptopia.Validator import *
from asymptopia.Localizer import *
from asymptopia.Tux import *
from asymptopia.Animator import *
from asymptopia.AnimatedChar import *
from asymptopia.CuckooManeuvers import CuckooManeuvers
from asymptopia.TuxManeuvers import TuxManeuvers

#get path to site-packages:
try:
	for sitepkgdir in sys.path:
		if sitepkgdir[-13:]=='site-packages':break
except:pass
	

if not pygame.font: print 'Warning, fonts disabled'
if not pygame.mixer: print 'Warning, sound disabled'
M=14
N=18
W=800
H=600
DEFAULT_LEVEL=5
#WAIT_TIME=300
WAIT_TIME=100

class TuxMathScrabble:
	def __init__(self,level):
		pygame.init()
		screen = pygame.display.set_mode((W,H))
		pygame.display.set_caption('www.asymptopia.com')
		pygame.mouse.set_visible(1)
		
		self.pyfont=pygame.font.Font(os.path.join(sitepkgdir,'asymptopia/font/freesansbold.ttf'),16)
		
		self.LEVEL=level
		self.tux_wait_counter=0
		
		slide1=load_sound('asymptopia/sounds/slide01.wav')
		slide2=load_sound('asymptopia/sounds/slide02.wav')
		boink=load_sound('asymptopia/sounds/bong05.wav')
		kerplunk=load_sound('asymptopia/sounds/beep07.wav')
		win_sound_01=load_sound('asymptopia/sounds/sparcle.wav')
		win_sound_02=load_sound('asymptopia/sounds/bullcall.wav')
		win_sound_03=load_sound('asymptopia/sounds/aooga.wav')
		lose_sound=load_sound('asymptopia/sounds/foghorn2.wav')
		pop01=load_sound('asymptopia/sounds/pop01.wav')
		pop02=load_sound('asymptopia/sounds/pop01.wav')
		
		
		#_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/
		animator=Animator()
		
		self.tuxManeuvers=TuxManeuvers()
		AnimatedTux=AnimatedChar(self.tuxManeuvers.getSequencesPyld(),W/2,100)
		animator.add_char("Tux",AnimatedTux)
		
		tuxManeuversPyld=self.tuxManeuvers.getManeuversPyld()
		for key in tuxManeuversPyld:
			animator.define_maneuver(key,tuxManeuversPyld[key])
		
		self.cuckooManeuvers=CuckooManeuvers()
		AnimatedTiles=[]
		AnimatedTileNames=[]
		for idx in range(N):
			AnimatedTiles.append(AnimatedChar(self.cuckooManeuvers.getSequencesPyld(),-25,-25))#offscreen
			new_name="Tile_%02d"%(idx)
			AnimatedTileNames.append(new_name)
			animator.add_char(AnimatedTileNames[idx],AnimatedTiles[idx])
		
		cuckooManeuversPyld=self.cuckooManeuvers.getManeuversPyld()
		for key in cuckooManeuversPyld:
			animator.define_maneuver(key,cuckooManeuversPyld[key])

		#_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/
		
		
		#onward...
		credit_button=Button('asymptopia/images/credits.gif')
		credit_button.rect.center=(W-70,H-235)
		skip_button=Button('asymptopia/images/skip.gif')
		skip_button.rect.center=(W-70,H-135)
		ready_button=Button('asymptopia/images/ready.gif')
		ready_button.rect.center=(W-70,H-185)

		l1_button=Button('asymptopia/images/level_one.gif')
		l1_button.rect.center=(65,H-135)
		l2_button=Button('asymptopia/images/level_two.gif')
		l2_button.rect.center=(65,H-185)
		l3_button=Button('asymptopia/images/level_three.gif')
		l3_button.rect.center=(65,H-235)
		l4_button=Button('asymptopia/images/level_four.gif')
		l4_button.rect.center=(65,H-285)
			
		buttongroup=pygame.sprite.Group([ready_button,skip_button,credit_button,l1_button,l2_button,l3_button,l4_button])
		buttons=pygame.sprite.RenderPlain(buttongroup)

		background = pygame.Surface(screen.get_size())
		background = background.convert()
		background.fill((0, 150, 100))#green
		
		level_indicator = pygame.Surface((10,10))
		level_indicator = level_indicator.convert()
		level_indicator.fill((255, 0, 0))
		
		#Specific Test beyond this point:
		board=Board(M,N,W/2,H/2,None,'asymptopia/images/new_spot.gif')
		boardspots=pygame.sprite.RenderPlain(board.get_spots())
		
		if self.LEVEL==3 or self.LEVEL==4:
			NTRAYSPOTS=12
			NNUMBERS=7
		else:
			NTRAYSPOTS=10
			NNUMBERS=6
			
		tray=Board(1,NTRAYSPOTS,W/2,H-40,None,'asymptopia/images/new_spot.gif')
		trayspots=pygame.sprite.RenderPlain(tray.get_spots())
		
		submission=Board(M,N,W/2,H/2,None,'asymptopia/images/new_spot.gif')
		submissionspots=pygame.sprite.RenderPlain()
		
		#drag-n-drop object	
		target=pygame.sprite.RenderClear()
		
		validator=Validator(board,self)#self passed for score update
		localizer=Localizer(board,self)#self passed for score update

		self.NTRAYSPOTS=NTRAYSPOTS
		self.NNUMBERS=NNUMBERS
		self.localizer=localizer
		self.validator=validator
		self.screen=screen
		self.boink=boink
		self.kerplunk=kerplunk
		self.slide1=slide1
		self.slide2=slide2
		self.win_sound_01=win_sound_01
		self.win_sound_02=win_sound_02
		self.win_sound_03=win_sound_03
		self.lose_sound=lose_sound
		self.submissionspots=submissionspots
		self.submission=submission
		self.board=board
		self.boardspots=boardspots
		self.tray=tray
		self.trayspots=trayspots
		self.target=target
		self.background=background
		self.level_indicator=level_indicator
		self.buttons=buttons
		self.ready_button=ready_button
		self.skip_button=skip_button
		self.credit_button=credit_button
		self.l1_button=l1_button
		self.l2_button=l2_button
		self.l3_button=l3_button
		self.l4_button=l4_button
		self.animator=animator
		self.AnimatedTux=AnimatedTux
		self.AnimatedTiles=AnimatedTiles
		self.AnimatedTileNames=AnimatedTileNames
		self.num_animated_tiles=0
		self.animation_in_progress=0
		self.tuxturn=0
	
		tuxtray=Board(1,NTRAYSPOTS,W/2,70,None,'asymptopia/images/new_spot.gif')
		tuxtrayspots=pygame.sprite.RenderPlain(tuxtray.get_spots())
		self.tuxtrayspots=tuxtrayspots
		self.tuxtray=tuxtray
		tux=Tux(self)
		self.tux=tux
		
	def draw_tiles(self,spots,who):
		imgnames=[
			'zero','one','two','three','four','five','six','seven','eight','nine','ten',
			'eleven','twelve','thirteen','fourteen','fifteen',
			#'sixteen','seventeen','eighteen','nineteen',
			'twenty'
		]
		for spot in spots:
			if spot.occupied():continue
			if (spot.getMN()[1]<self.NNUMBERS):
				if self.LEVEL==4:int_val=int(16*random())+1#1-20, no zero
				elif self.LEVEL==3:int_val=int(10*random())+1#1-20, no zero
				elif self.LEVEL==2:int_val=int(15*random())#1-15
				else:int_val=int(10*random())#1-10
				str_val=`int_val`+'.0'
				
				#special case for "20":(since skipping 16,17,18,19)
				if int_val==16:
					str_val='20.0'
				
				#print str_val,int_val
				if who=='tux':fname='asymptopia/images/tux_'+imgnames[int_val]+'.gif'
				else:fname='asymptopia/images/'+imgnames[int_val]+'.gif'
			elif spot.getMN()[1]<self.NTRAYSPOTS-1:
				opnames=['new_plus','new_minus','new_mult','new_divide']
				if self.LEVEL==4:idx=int(4*random())#add,subtract,mult,divide
				elif self.LEVEL==3:idx=int(3*random())#add,subtract,mult,divide
				else:idx=int(2*random())#add,subtract only
				int_val=None
				if   opnames[idx]=='new_plus':str_val='+'
				elif opnames[idx]=='new_minus':str_val='-'
				elif opnames[idx]=='new_mult':str_val='*'
				elif opnames[idx]=='new_divide':str_val='/'
				else:pass
				if who=='tux':opnames[idx]='tux_'+opnames[idx]
				fname='asymptopia/images/'+opnames[idx]+'.gif'
			else:
				if who=='tux':fname='asymptopia/images/tux_new_equal.gif'
				else:fname='asymptopia/images/new_equal.gif'
				int_val=None
				str_val='='
			tile=Tile(fname,int_val,str_val)
			spot.take_guest(tile,1)
			tile.saved_center=spot.rect.center
			
		
	def play(self):
		
		AnimatedTiles=self.AnimatedTiles
		AnimatedTileNames=self.AnimatedTileNames
		
		
		AnimatedTux=self.AnimatedTux
		animator=self.animator
		tux=self.tux
		validator=self.validator
		localizer=self.localizer
		screen=self.screen
		boink=self.boink
		kerplunk=self.kerplunk
		slide1=self.slide1
		slide2=self.slide2
		win_sound_01=self.win_sound_01
		win_sound_02=self.win_sound_02
		win_sound_03=self.win_sound_03
		lose_sound=self.lose_sound
		submissionspots=self.submissionspots
		submission=self.submission
		board=self.board
		boardspots=self.boardspots
		tray=self.tray
		trayspots=self.trayspots
		target=self.target
		background=self.background
		level_indicator=self.level_indicator
		buttons=self.buttons
		ready_button=self.ready_button
		skip_button=self.skip_button
		credit_button=self.credit_button
		l1_button=self.l1_button
		l2_button=self.l2_button
		l3_button=self.l3_button
		l4_button=self.l4_button
		tuxtrayspots=self.tuxtrayspots	
		tuxtray=self.tuxtray
		self.draw_tiles(tray.get_spots(),'player')
		self.draw_tiles(tuxtray.get_spots(),'tux')
		tuxturn=self.tuxturn
		num_animated_tiles=self.num_animated_tiles
		animation_in_progress=self.animation_in_progress
		
		self.tuxscore=0
		self.playerscore=0
		
		#
		coin=0#int(random()*2)
		if coin==0:animator.start_maneuver('Tux','tux_welcome_maneuver_01')
		#else:animator.start_maneuver('Tux','tux_welcome_maneuver_02')
		
		animation_in_progress=1
		tux_move_progress=0
		tile_animation_in_progress=0
		num_animated_tiles=0
		
		while(1):
			num_animated_tiles=self.num_animated_tiles
			animation_in_progress=self.animation_in_progress
			if (tuxturn==1) and (tux_move_progress==0) and (animation_in_progress==0) and (num_animated_tiles==0):#only @beginning of Tux's turn
				#_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/
				#print 'starting tux_get_up_maneuver'
				coin=int(random()*4)
				if coin==0:animator.start_maneuver('Tux','tux_get_up_maneuver_01')
				elif coin==1:animator.start_maneuver('Tux','tux_get_up_maneuver_02')
				elif coin==2:animator.start_maneuver('Tux','tux_get_up_maneuver_03')
				else:animator.start_maneuver('Tux','tux_get_up_maneuver_04')
				
				tux_move_progress=1
				animation_in_progress=1
				#_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/
				
			if ((num_animated_tiles==0) and (animation_in_progress==0) and (tuxturn==1)):
				
				tux.generate_expressions()
				tux_finished=0
				
				while tux_finished!=1:
					tux_submission=tux.generate_options()
					rlist=tux_submission
					#print 'tux_submission=',tux_submission
					
					#_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/
					if tux_submission==None:
						tux_finished=1
						tuxturn=0
						self.tux_wait_counter=0
						#print 'Tux ran out of options!'
						animator.start_maneuver('Tux','return_stumped_maneuver')
						break
					
					#_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/
					
					if rlist==None:
						#tux_finished=1
						#tuxturn=0
						#print 'Tux returned \'None\'...only handling first submission!'
						#break
						#print 'Tux returned \'None\'...trying another submission'
						pass
					
					else:
						#print rlist
						if rlist[0][0]==rlist[1][0]:exprtype='row'
						else:exprtype='col'
						try:
							for idx in range(len(rlist)):
								tile=tuxtray.get_guest_by_str(rlist[idx][0])
								spot=submission.take_guestMN(tile,rlist[idx][1],rlist[idx][2])
								submissionspots.add(spot)	
						except:
							raw_input()
							
						#commit submission
						board.increment_num_commited()
						for spot in submissionspots.sprites():
							for board_spot in board.get_spots():
								if board_spot.rect.center==spot.rect.center:# M,N-Matching
									#print spot.guest.str_val,'len=',len(board.get_spots()),len(submissionspots.sprites())
									tile=spot.pop_guest()
									board_spot.take_guest(tile,1)
									board_spot.lock()
									submission.remove(spot)
									
									
						#del submissionspots			
						submissionspots.empty()
						self.draw_tiles(tuxtray.get_spots(),'tux')
						tux_finished=1
						tuxturn=0
						
						#_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/
						#return to corner: 
						coin=int(random()*3)
						if coin==0:animator.start_maneuver('Tux','return_skating_maneuver')
						elif coin==1:animator.start_maneuver('Tux','tux_go_back_from_tray_maneuver_01')
						else:animator.start_maneuver('Tux','tux_go_back_from_tray_maneuver_02')
						
						#_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/
						
			for event in pygame.event.get():
				if event.type == QUIT:return(0)
				elif event.type == KEYDOWN and event.key == K_ESCAPE:return(0)
				elif event.type == KEYDOWN and event.key == K_F1:
						display_surface=pygame.display.get_surface()
						pygame.image.save(display_surface,os.path.join(os.environ['HOME'],'tuxmathscrabble.bmp'))
				
				elif event.type == MOUSEBUTTONDOWN:
					#we have action! reset wait_counter:
					self.tux_wait_counter=0
					
					#CREDIT BUTTON:
					if credit_button.rect.collidepoint(pygame.mouse.get_pos()):
						credit_image,rect=load_image('asymptopia/images/credit_splash.gif')
						self.screen.blit(credit_image,(0,0))
						pygame.display.flip()
						while 1:
							breakout=0
							for event in pygame.event.get():
								if event.type == KEYDOWN:breakout=1
								elif event.type == MOUSEBUTTONDOWN:breakout=1
							if breakout:break	
						#return(self.LEVEL)
					
					#LEVEL BUTTONS:
					if l1_button.rect.collidepoint(pygame.mouse.get_pos()):
						self.LEVEL=1
						return(1)
					if l2_button.rect.collidepoint(pygame.mouse.get_pos()):
						self.LEVEL=2
						return(2)
					if l3_button.rect.collidepoint(pygame.mouse.get_pos()):
						self.LEVEL=3
						return(3)
					if l4_button.rect.collidepoint(pygame.mouse.get_pos()):
						self.LEVEL=4
						return(4)
					
					
					#SKIP BUTTON:
					elif skip_button.rect.collidepoint(pygame.mouse.get_pos()):
						if tuxturn==1 or AnimatedTux.rect[0]<400:continue
						else:
							for spot in submissionspots.sprites():#reset
								tile=spot.pop_guest()
								if tile:
									for spot in tray.get_spots():	
										if	tile.saved_center==spot.rect.center:
											spot.take_guest(tile,1)
							
							#_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/
							if len(board.get_listofheads())==0:
								if not animation_in_progress:
									animator.start_maneuver('Tux','insist_yougofirst_maneuver')
							else:
								animator.start_maneuver('Tux','head_tilt_right_maneuver')
								lose_sound.play()
								animation_in_progress=1
								tux_move_progress=0
								submissionspots.empty()
								tuxturn=1
								continue
							#_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/
					
					#READY BUTTON:
					elif ready_button.rect.collidepoint(pygame.mouse.get_pos()):
						if(validator.validate(submissionspots.sprites())):#ready for this now!(first player turn)
							board.increment_num_commited()
							for spot in submissionspots.sprites():
								for board_spot in board.get_spots():
									if board_spot.rect.center==spot.rect.center and spot.guest:
										#validator is gonna have to fill-in AMHEAD fields, then add->board.list_of_heads.add(spot)
										#print spot.guest.str_val,'len=',len(board.get_spots()),len(submissionspots.sprites())
										tile=spot.pop_guest()
										
										#while we've got spot center info set_center of cuckoo_tile:
										rect=board_spot.rect
										xc=rect[0]+rect[2]/2
										yc=rect[1]+rect[3]/2
										cuckoo_tile_center=(xc,yc)
										AnimatedTiles[num_animated_tiles].set_center(cuckoo_tile_center)
										
										#Validator sets submission_spot and game(this) xfers->board_spot; they work together!
										if spot.AMHEAD==1:
											board_spot.AMHEAD=1
											if spot.AMROWEXPR==1:
												board_spot.AMROWEXPR=1
												board_spot.ROWEXPRLENGTH=spot.ROWEXPRLENGTH
												
											if spot.AMCOLEXPR==1:
												board_spot.AMCOLEXPR=1
												board_spot.COLEXPRLENGTH=spot.COLEXPRLENGTH
												
											#board.list_of_heads.add(board_spot)#sprites know not to add selves twice; relying on that here.
										
										board_spot.take_guest(tile,1)
										board_spot.lock()
										submission.remove(spot)
										
								
								num_animated_tiles=num_animated_tiles+1#HACKHACKHACK!
								
							
							#_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/
							coin=int(random()*2)
							if coin==0:win_sound_01.play()
							else:win_sound_02.play()
							#else:win_sound_03.play()
							
							#_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/
							#TRIGGER ANIMATION:
							#
							coin=int(random()*2)
							if coin==0:animator.start_maneuver('Tux','forehead_slap_maneuver')
							else:animator.start_maneuver('Tux','neck_stretch_maneuver')
							tux_move_progress=0
							animation_in_progress=1
							
							cuckoo_maneuver_names=self.cuckooManeuvers.getManeuverNames()
							for idx in range(num_animated_tiles):
								maneuver_idx=int(random()*(len(cuckoo_maneuver_names)))
								animator.start_maneuver(AnimatedTileNames[idx],cuckoo_maneuver_names[maneuver_idx])
							self.num_animated_tiles=num_animated_tiles
							
							#_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/
							
							self.draw_tiles(tray.get_spots(),'player')
							#print 'SCORE: Tux=',self.tuxscore,' PLAYER=',self.playerscore
							tuxturn=1
						else:#put back and play lose sound(not4tux)
							for spot in submissionspots.sprites():#reset
								tile=spot.pop_guest()
								if tile:
									for spot in tray.get_spots():	
										if	tile.saved_center==spot.rect.center:
											spot.take_guest(tile,1)
							
							if len(self.board.get_listofheads())>0:
								lose_sound.play()
								animator.start_maneuver('Tux','head_tilt_left_maneuver')
								tux_move_progress=0
								animation_in_progress=1
							
						submissionspots.empty()
						continue
					
					#check tray for new target:
					for spot in tray.get_spots():
						if not spot.guest:continue
						if spot.rect.collidepoint(pygame.mouse.get_pos()):
							slide1.play()
							target.add(spot.pop_guest())
					
					#check the board for new target:
					for spot in board.get_spots():
						if spot.rect.collidepoint(pygame.mouse.get_pos()) and spot.islocked():
							boink.play()
						
					#check the submission for new target:
					#print 'down1:len(submissionspots.sprites())=',len(submissionspots.sprites()),
					for spot in submission.get_spots():
						if not spot.occupied():continue
						if spot.rect.collidepoint(pygame.mouse.get_pos()):
							guest=spot.pop_guest()
							submissionspots.remove(spot)
							slide1.play()
							target.add(guest)
					#print 'down2:len(submissionspots.sprites())=',len(submissionspots.sprites())
							
				elif event.type == MOUSEBUTTONUP:
					if len(target.sprites())>0:
						for spot in submission.get_spots():
							if spot.rect.collidepoint(target.sprites()[0].rect.center):#welcome to new home
								#print 'up1:len(submissionspots.sprites())=',len(submissionspots.sprites()),
								if spot.occupied():continue#part of submission
								#elif spot.islocked():continue#part of board
								spot.take_guest(target.sprites()[0],1)
								kerplunk.play()
								submissionspots.add(spot)
								target.empty()
								#print 'up2:len=',len(board.get_spots()),len(submissionspots.sprites())
								break
						
						if len(target.sprites())==0:continue
						
						for spot in board.get_spots():
							if spot.rect.collidepoint(target.sprites()[0].rect.center):	
								boink.play()
								break
								
						if len(target.sprites())>0:#didn't drop? revert!
							#print 'cleanup'
							tile=target.sprites()[0]
							target.remove(tile)
							for spot in tray.get_spots():	
								if	tile.saved_center==spot.rect.center:
									spot.take_guest(tile,1)
									break
			
			if not tuxturn:
				self.tux_wait_counter=self.tux_wait_counter+1
				if self.tux_wait_counter>WAIT_TIME and self.animation_in_progress==0:self.tux_wait_maneuver()
				else:tux_wait_counter=0
			self.update()
			self.tuxturn=tuxturn
	
	def do_one_scratch(self):
			coin=int(random()*2)
			if coin==0:self.animator.start_maneuver('Tux','one_scratchl_maneuver')
			else:self.animator.start_maneuver('Tux','one_scratchr_maneuver')
			self.tux_move_progress=0
			self.update()
			self.update()
			self.update()
			self.update()
			
	def tux_wait_maneuver(self):
			idx=int(random()*9)
			if idx==0:self.animator.start_maneuver('Tux','head_tilt_left_maneuver')
			if idx==1:self.animator.start_maneuver('Tux','head_tilt_right_maneuver')
			if idx==2:self.animator.start_maneuver('Tux','neck_stretch_maneuver')
			if idx==3:self.animator.start_maneuver('Tux','tux_flapper_maneuver')
			#if idx==4:self.animator.start_maneuver('Tux','hopflap_leftright_maneuver')#can get away if allowed to go left!
			if idx==5:self.animator.start_maneuver('Tux','hop_in_place_maneuver')
			if idx==6:self.animator.start_maneuver('Tux','walkoff_stage_right_maneuver')
			if idx==7:self.animator.start_maneuver('Tux','neck_squash_tiltleftright_maneuver')
			if idx==8:self.animator.start_maneuver('Tux','neck_squash_hop_in_place_maneuver')
			
			self.tux_move_progress=0
			self.tux_wait_counter=0
			self.update()
								
	
	def update(self):
			screen=self.screen
			background=self.background
			buttons=self.buttons
			boardspots=self.boardspots
			trayspots=self.trayspots
			submissionspots=self.submissionspots
			target=self.target
			AnimatedTux=self.AnimatedTux
			animation_in_progress=self.animation_in_progress
			AnimatedTiles=self.AnimatedTiles
			tuxtrayspots=self.tuxtrayspots
			
			for event in pygame.event.get():
				if event.type == QUIT:return(0)
				elif event.type == KEYDOWN and event.key == K_ESCAPE:return(0)
							
			screen.blit(background,(0,0))
			#for button in buttons.sprites():
			#	
			if self.LEVEL==1:b=self.l1_button
			elif self.LEVEL==2:b=self.l2_button
			elif self.LEVEL==3:b=self.l3_button
			elif self.LEVEL==4:b=self.l4_button
			screen.blit(self.level_indicator,(10,b.rect[1]+b.rect[3]/3))
			
			#Scoreboard:
			tuxscorestring=" Tux\'s Score: %03d"%self.tuxscore
			screen.blit(self.pyfont.render(tuxscorestring,1,(255,255,0,0),(0, 150, 100)),(20,30))
			playerscorestring=" Your Score : %03d"%self.playerscore
			screen.blit(self.pyfont.render(playerscorestring,1,(255,255,0,0),(0, 150, 100)),(20,60))
			
			#Who's Turn-Indicator:
			if self.LEVEL==3:
				if self.tuxturn==1:
					tuxturnstring= '<-- Tux\'s Turn'
					screen.blit(self.pyfont.render(tuxturnstring,1,(255,255,0,0),(0, 150, 100)),(W-210,45))
				else:
					yourturnstring='<-- Your Turn!'
					screen.blit(self.pyfont.render(yourturnstring,1,(255,255,0,0),(0, 150, 100)),(W-210,530))
			else:
				if self.tuxturn==1:
					tuxturnstring= '<-- Tux\'s Turn'
					screen.blit(self.pyfont.render(tuxturnstring,1,(255,255,0,0),(0, 150, 100)),(W-240,45))
				else:
					yourturnstring='<-- Your Turn!'
					screen.blit(self.pyfont.render(yourturnstring,1,(255,255,0,0),(0, 150, 100)),(W-240,530))
			
			#
			buttons.draw(screen)
			
			boardspots.draw(screen)
			submissionspots.draw(screen)
			#
			trayspots.draw(screen)
			tuxtrayspots.draw(screen)
			if len(target.sprites())>0:
				target.sprites()[0].update()
				target.draw(screen)
			
			#_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/
			#ANIMATED TUX UPDATE:
			#
			rval=AnimatedTux.update()
			screen.blit(AnimatedTux.image,(AnimatedTux.rect[0],AnimatedTux.rect[1]))
			
			sound=AnimatedTux.get_sound()
			if sound:sound.play()
			
			#okay, this is now official location of decision:
			if AnimatedTux.get_dest():
				self.animation_in_progress=1
			else:
				self.animation_in_progress=0
				
				
			#_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/
			#ANIMATED TILE UPDATE:
			#
			#sound=AnimatedTiles[0].get_sound()
			#if sound:sound.play()
			if self.num_animated_tiles>0:
				#time.sleep(.1)
				self.num_animated_tiles=0
				for tile in AnimatedTiles:
					if not tile.get_dest():
						tile.set_center((0,0))
					else:
						self.num_animated_tiles=self.num_animated_tiles+1
						rval=tile.update()
						screen.blit(tile.image,(tile.rect[0],tile.rect[1]))
				
			#_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/
			
			pygame.display.flip()
			
			
			if AnimatedTux.get_dest():
				if AnimatedTux.rect[0]<0:AnimatedTux.set_center((730,100))
				time.sleep(AnimatedTux.get_timeout())
			
