"""
/***************************************************************************

	Author 			:Charles B. Cosse 
	
	Email			:ccosse@asymptopia.com
					:ccosse@linux4schools.org
					
	Copyright		:(C) 2001,2002 Asymptopia Software.
	
 ***************************************************************************/
/***************************************************************************
                          Localizer.py

	Description:
	
	THESE AREN'T SPOTS -- should they be? currently we're handling just 
	localization before getting into the guest-exchange business; on the 
	other hand, we do need to know if it's an operator, etc, and if we want 
	to go with it, then if already a spot, then it's already there; BUT, since 
	we're trying firstly to *substitute*, then we'd be having to put something
	*back* as well as commit -- not a good way, hmmm. Best soln would be to 
	know all the various ways we might go about making the dealer move and 
	then make our requests to Tux accordingly, like 
	"get_submission(<existing_spot_to_use_as_substitute>) -- this *does* get 
	lengthly, so think we'll just go with the good-'ol 1-step-at-a-time and 
	worry about next detail separately.

 ***************************************************************************/
 
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version. (Please note that if you use this *
 *   code you must give credit by including the Author and Copyright       *
 *   info at the top of this file).                                        *
 ***************************************************************************/

"""
import pygame,os
from pygame.locals import *

class Localizer:
	"""Localizer has game model.
	"""
	def __init__(self,board,game):
		self.board=board
		self.game=game#only used to update score
		
	def localize(self,submission):
		#print 'Localizer.localize: submission=',submission
		if len(submission)==0:return(None)
		board=self.board
		#if self.board.num_submissions==0:
		if len(self.board.get_listofheads())==0:
			for elem in submission:
				if elem.count('WC'):return(None)
			#print 'zeroeth submission:',submission
			lhs=board.N/2-len(submission)/2	#this can't work with floats!
			row=board.M/2
			rlist=[]
			for col in range(len(submission)):
				rlist.append([submission[col],row,lhs+col])
			
			#+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-
			#head_spot stuff for zeroth submission (assuming only row here)
			head_spot=board.get_spotMN(row,lhs)
					
			head_spot.AMHEAD=1
			head_spot.AMROWEXPR=1
			head_spot.ROWEXPRLENGTH=len(submission)
			self.game.tuxscore=self.game.tuxscore+len(submission)
			return(rlist)	
				
		else:
			#+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-
			#print 'submission number:',board.num_submissions
			spots=board.get_spots()
			
			#+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-
			#just print text version of board to terminal w/*'s at HEADS
			for m in range(board.M):
				for n in range(board.N):
					for spot in spots:
						if spot.M==m and spot.N==n:
							if spot.guest and spot.AMHEAD:dummy=0#print '*%2s'%spot.guest.str_val,
							elif spot.guest:dummy=0#print '%3s'%spot.guest.str_val,
							else:dummy=0#print '%3s'%'x',
				#print ''
			
			#+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-
			#get the list_of_heads and print-out(list_of_heads==list of spots)
			list_of_heads=board.get_listofheads()
			for headspot in list_of_heads:
				#print headspot.guest.str_val
				pass
			
			#+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-
			#have to head-this-off if has wildcards: ("WC")
			#if submission has WC, then that's all we try to satisfy
			list_of_submission_indices=[]
			for idx in range(len(submission)):
				if submission[idx][0:3]=='WC:':
					submission[idx]=submission[idx][3:]
					list_of_submission_indices.append(idx)
					#print 'list_of_submission_indices=',list_of_submission_indices,' submission->',submission
			
			#+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-
			#submission lacked WC, so we try to replace one from submission.
			if len(list_of_submission_indices)==0:
				for idx in range(len(submission)):list_of_submission_indices.append(idx)
			
			#+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-
			
			#print 'localizer:',list_of_submission_indices
			
			#now it's satisfying both matches of wc=wc separately -- ok remains "1", but fix[0] lost for fix[1]
			for head_idx in range(len(list_of_heads)):
				#try column expression:
				row=list_of_heads[head_idx].M
				col=list_of_heads[head_idx].N
				
				ok=1
				for  dummy in range(len(list_of_submission_indices)):
					#"substitution_idx" is actually the idx of another list (i.e. the submission array)
					substitution_idx=list_of_submission_indices[dummy]
					#print 'substitution_idx=',substitution_idx
						
					#problem facing 2x substitution: 
				
					
					#print 'TRYING COL EXPR'
					
					#HERE! We are only searcing along 1 row. Should really just go by brute force w/however many WC's and
					#overlay; just only submit with WC's (that's Tux's unique, hardcoded restriction).
					
					head_spot=board.get_spotMN(row,col)
					if head_spot.AMROWEXPR==1:
						#print 'head_spot.ROWEXPRLENGTH:',head_spot.ROWEXPRLENGTH
						#print 'using HEAD at:',row,col
						self.current_submission_type='col'
						
						for col_idx in range(col,col+head_spot.ROWEXPRLENGTH):#property of head element only
							if col_idx>board.N-1:continue
							#print 'checking along row for substitution candidate: requesting spotMN(',row,',',col_idx,')'
							
							
							#HERE! Instead of checkinf for particular WC, check if _ANY_
							if board.get_spotMN(row,col_idx).guest.str_val==submission[substitution_idx]:#check-4-opportunity
							
								if board.get_spotMN(row,col_idx).AMHEAD and board.get_spotMN(row,col_idx).AMCOLEXPR:#bug fix: we're traversing a row and chose a COLHEAD
									#print 'bailing out -- too much effort required here!' 
									continue
								#how many empty above/below? vs. substitution_idx/len(submission)
								num_needed_above=substitution_idx
								num_needed_below=len(submission)-substitution_idx-1
								#print submission[substitution_idx],num_needed_above,num_needed_below
								
								if row-num_needed_above<0:
									ok=0
									continue
								if row+num_needed_below>board.M-1:
									ok=0
									continue
								
								#did not re-check logic latest use of this section
								#could have board.check_if_occupied(m,n) and avoid exceptions...
								for num_above in range(num_needed_above,0,-1):
									if board.check4guest(row-num_above-1,col_idx):ok=0#above
									if board.check4guest(row-num_above,col_idx-1):ok=0#lhs
									if board.check4guest(row-num_above,col_idx+1):ok=0#rhs
									if board.check4guest(row-num_above,col_idx):
										if num_needed_above-num_above==substitution_idx:pass
										else:ok=0#below
								#print 'okabove=',ok,' submission=',submission
								
								for num_below in range(1,num_needed_below+1):
									if board.check4guest(row+num_below+1,col_idx):ok=0#below
									if board.check4guest(row+num_below,col_idx-1):ok=0#rhs
									if board.check4guest(row+num_below,col_idx+1):ok=0#lhs
									if board.check4guest(row+num_below,col_idx):
										if num_needed_below-num_below == substitution_idx:pass#okay for substidx to be "fixed" (that's why we're using it!)
										else:ok=0#above
								#print 'okbelow=',ok,' submission=',submission
			
								#if subbing endpts, check either side of them:
								if substitution_idx==0:
									if row>0:
										if board.check4guest(row-1,col_idx):ok=0
								if substitution_idx==len(submission)-1:
									if row+substitution_idx<=board.M-1:
										if board.check4guest(row+substitution_idx,col_idx):ok=0
								
								if ok==1 and dummy==len(list_of_submission_indices)-1:
									rlist=[]
									for col in range(len(submission)):
										
										#+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-
										#only doing last substitution idx
										#instead of asking only "if current", need to see if it's _anywhere_ in list_of_substitution_indices
										#if col != substitution_idx:
										
										#then still need to maintain "ok" over whole range of len(list_of_sub_idxs)
										
										if not list_of_submission_indices.count(col):
											rlist.append([submission[col],row-num_needed_above+col,col_idx])
										#+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-	
									
									#board.num_submissions=board.num_submissions+1
									#print rlist
									
									#fill-in head-spot info:
									if substitution_idx==0:
										head_spot=board.get_spotMN(row,col_idx)
									else:
										head_spot=board.get_spotMN(row-num_needed_above,col_idx)
									head_spot.AMHEAD=1
									head_spot.AMCOLEXPR=1
									head_spot.COLEXPRLENGTH=len(submission)
									self.game.tuxscore=self.game.tuxscore+head_spot.COLEXPRLENGTH
									#print 'rlist=',rlist
									print 'returning from localizer:',rlist
									return(rlist)
			
					

			for head_idx in range(len(list_of_heads)):
				#try row expression:
				row=list_of_heads[head_idx].M
				col=list_of_heads[head_idx].N
				ok=1
				for dummy in range(len(list_of_submission_indices)):#see if board has this available to use/substitute<-should be "substitution_idx
					substitution_idx=list_of_submission_indices[dummy]
					#print 'substitution_idx=',substitution_idx
				
					#problem facing 2x substitution: 
				
					
					#print 'TRYING ROW EXPR'
					head_spot=board.get_spotMN(row,col)
					if head_spot.AMCOLEXPR==1:
						#print 'using HEAD at:',row,col
						#print 'AMCOLEXPR==1 for row,col=',row,col
						self.current_submission_type='row'
						for row_idx in range(row,row+head_spot.COLEXPRLENGTH):#property of head element only
							if row_idx>board.M-1:continue
							#print 'retrieving str_val at: ',row_idx,col,' to replace: ',submission[substitution_idx]
							if board.get_spotMN(row_idx,col).guest.str_val==submission[substitution_idx]:#check-4-opportunity
								if board.get_spotMN(row_idx,col).AMHEAD and board.get_spotMN(row_idx,col).AMROWEXPR:#bug fix: we're traversing a col and chose a ROWHEAD
									#print 'bailing out -- too much effort required here!' 
									continue
								#how many empty above/below? vs. substitution_idx/len(submission)
								num_needed_left=substitution_idx
								num_needed_right=len(submission)-substitution_idx-1
								#print submission[substitution_idx],num_needed_left,num_needed_right

								#ok=1
								if col-num_needed_left<0:
									ok=0
									continue
								if col+num_needed_right>board.N-1:
									ok=0
									continue
								
								#did not re-check logic latest use of this section
								#could have board.check_if_occupied(m,n) and avoid exceptions...
								for num_left in range(num_needed_left,0,-1):
									if board.check4guest(row_idx-1,col-num_left):ok=0#above
									if board.check4guest(row_idx+1,col-num_left):ok=0#lhs
									if board.check4guest(row_idx,col-num_left-1):ok=0#rhs
									if board.check4guest(row_idx,col-num_left):
										if num_needed_left-num_left==substitution_idx:pass
										else:ok=0#below
								#print 'okleft=',ok,' submission=',submission
								
								
								for num_right in range(1,num_needed_right+1):
									if board.check4guest(row_idx-1,col+num_right):ok=0#below
									if board.check4guest(row_idx+1,col+num_right):ok=0#rhs
									if board.check4guest(row_idx,col+num_right+1):ok=0#lhs
									if board.check4guest(row_idx,col+num_right):
										if num_needed_right-num_right == substitution_idx:pass#okay for substidx to be "fixed" (that's why we're using it!)
										else:ok=0#above
								#print 'okright=',ok,' submission=',submission
								
								#if subbing endpts, check either side of them:
								if substitution_idx==0:
									if col>0:
										if board.check4guest(row_idx,col-1):ok=0
								if substitution_idx==len(submission)-1:
									if col+substitution_idx<=board.N-1:
										if board.check4guest(row_idx,col+substitution_idx):ok=0
																
								if ok==1 and dummy==len(list_of_submission_indices)-1:
									rlist=[]
									for row in range(len(submission)):
										#if row != substitution_idx:
										if not list_of_submission_indices.count(row):
											rlist.append([submission[row],row_idx,col-num_needed_left+row])
									#board.num_submissions=board.num_submissions+1
									#print rlist
									
									#fill-in head-spot info:
									if substitution_idx==0:
										head_spot=board.get_spotMN(row_idx,col)
									else:
										head_spot=board.get_spotMN(row_idx,col-num_needed_left)
									head_spot.AMHEAD=1
									head_spot.AMROWEXPR=1
									head_spot.ROWEXPRLENGTH=len(submission)
									self.game.tuxscore=self.game.tuxscore+head_spot.ROWEXPRLENGTH
									#print 'rlist=',rlist
									return(rlist)
			return(None)						
