"""
/***************************************************************************

	Author 			:Charles B. Cosse 
	
	Email			:ccosse@asymptopia.com
					
	Copyright		:(C) 2002,2003 Asymptopia Software.
	
 ***************************************************************************/
/***************************************************************************
                          CuckooManeuvers.py

 ***************************************************************************/
 
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version. (Please note that if you use this *
 *   code you must give credit by including the Author and Copyright       *
 *   info at the top of this file).                                        *
 ***************************************************************************/

"""

import os, pygame,sys
from pygame.locals import *
from random import random

from Maneuvers import Maneuvers
from asymptopia.myutil import *

#get path to site-packages:
try:
	for sitepkgdir in sys.path:
		if sitepkgdir[-13:]=='site-packages':break
except:pass


class CuckooManeuvers(Maneuvers):
	def __init__(self):
		self.maneuvers={}
		
		img_cuckoo_flap_01=pygame.image.load(os.path.join(sitepkgdir,'./asymptopia/anim_images/cuckoo_flap_01.gif'))
		img_cuckoo_flap_02=pygame.image.load(os.path.join(sitepkgdir,'./asymptopia/anim_images/cuckoo_flap_02.gif'))
		cuckoo_flap=[
			{'img':img_cuckoo_flap_02,'snd':None,'dx':0,'dy': 0,'timeout':0},
			{'img':img_cuckoo_flap_01,'snd':None,'dx':0,'dy':-3,'timeout':0},
			{'img':img_cuckoo_flap_01,'snd':None,'dx':0,'dy': 0,'timeout':0},
			{'img':img_cuckoo_flap_01,'snd':None,'dx':0,'dy': 0,'timeout':0},
			{'img':img_cuckoo_flap_01,'snd':None,'dx':0,'dy': 0,'timeout':0},
			{'img':img_cuckoo_flap_02,'snd':None,'dx':0,'dy':+3,'timeout':0},
			{'img':img_cuckoo_flap_02,'snd':None,'dx':0,'dy': 0,'timeout':0},
			{'img':img_cuckoo_flap_02,'snd':None,'dx':0,'dy': 0,'timeout':0},
			{'img':img_cuckoo_flap_02,'snd':None,'dx':0,'dy': 0,'timeout':0},
			{'img':img_cuckoo_flap_01,'snd':None,'dx':0,'dy':-3,'timeout':0},
			{'img':img_cuckoo_flap_01,'snd':None,'dx':0,'dy': 0,'timeout':0},
			{'img':img_cuckoo_flap_01,'snd':None,'dx':0,'dy': 0,'timeout':0},
			{'img':img_cuckoo_flap_01,'snd':None,'dx':0,'dy': 0,'timeout':0},
			{'img':img_cuckoo_flap_02,'snd':None,'dx':0,'dy':+3,'timeout':0},
			{'img':img_cuckoo_flap_02,'snd':None,'dx':0,'dy': 0,'timeout':0},
			{'img':img_cuckoo_flap_02,'snd':None,'dx':0,'dy': 0,'timeout':0},
			{'img':img_cuckoo_flap_02,'snd':None,'dx':0,'dy': 0,'timeout':0},
		]
		
		img_cuckoo_skate_left=pygame.image.load(os.path.join(sitepkgdir,'./asymptopia/anim_images/cuckoo_skate_left.gif'))
		img_cuckoo_stand=pygame.image.load(os.path.join(sitepkgdir,'./asymptopia/anim_images/cuckoo_stand.gif'))
		img_cuckoo_skate_right=pygame.image.load(os.path.join(sitepkgdir,'./asymptopia/anim_images/cuckoo_skate_right.gif'))
		img_cuckoo_stand_back=pygame.image.load(os.path.join(sitepkgdir,'./asymptopia/anim_images/cuckoo_stand_back.gif'))
		cuckoo_spin_left=[
			{'img':img_cuckoo_skate_left,'snd':None,'dx':0,'dy':0,'timeout':0},
			{'img':img_cuckoo_stand,'snd':None,'dx':0,'dy':0,'timeout':0},
			{'img':img_cuckoo_stand,'snd':None,'dx':0,'dy':0,'timeout':0},
			{'img':img_cuckoo_skate_right,'snd':None,'dx':0,'dy':0,'timeout':0},
			{'img':img_cuckoo_skate_right,'snd':None,'dx':0,'dy':0,'timeout':0},
			{'img':img_cuckoo_stand_back,'snd':None,'dx':0,'dy':0,'timeout':0},
			{'img':img_cuckoo_stand_back,'snd':None,'dx':0,'dy':0,'timeout':0},
			{'img':img_cuckoo_skate_left,'snd':None,'dx':0,'dy':0,'timeout':0},
			
		]
		cuckoo_spin_right=[
			{'img':img_cuckoo_skate_left,'snd':None,'dx':0,'dy':0,'timeout':0},
			{'img':img_cuckoo_stand_back,'snd':None,'dx':0,'dy':0,'timeout':0},
			{'img':img_cuckoo_stand_back,'snd':None,'dx':0,'dy':0,'timeout':0},
			{'img':img_cuckoo_skate_right,'snd':None,'dx':0,'dy':0,'timeout':0},
			{'img':img_cuckoo_skate_right,'snd':None,'dx':0,'dy':0,'timeout':0},
			{'img':img_cuckoo_stand,'snd':None,'dx':0,'dy':0,'timeout':0},
			{'img':img_cuckoo_stand,'snd':None,'dx':0,'dy':0,'timeout':0},
			{'img':img_cuckoo_skate_left,'snd':None,'dx':0,'dy':0,'timeout':0},
			
		]
		
		img_cuckoo_bow=pygame.image.load(os.path.join(sitepkgdir,'./asymptopia/anim_images/cuckoo_bow_02.gif'))
		cuckoo_bow=[
			{'img':img_cuckoo_stand,'snd':None,'dx':0,'dy':0,'timeout':0},
			{'img':img_cuckoo_stand,'snd':None,'dx':0,'dy':0,'timeout':0},
			{'img':img_cuckoo_bow,'snd':None,'dx':0,'dy':0,'timeout':0},
			{'img':img_cuckoo_bow,'snd':None,'dx':0,'dy':0,'timeout':0},
			{'img':img_cuckoo_bow,'snd':None,'dx':0,'dy':0,'timeout':0},
			{'img':img_cuckoo_bow,'snd':None,'dx':0,'dy':0,'timeout':0},
			{'img':img_cuckoo_bow,'snd':None,'dx':0,'dy':0,'timeout':0},
			{'img':img_cuckoo_bow,'snd':None,'dx':0,'dy':0,'timeout':0},
			{'img':img_cuckoo_bow,'snd':None,'dx':0,'dy':0,'timeout':0},
			{'img':img_cuckoo_bow,'snd':None,'dx':0,'dy':0,'timeout':0},
			{'img':img_cuckoo_bow,'snd':None,'dx':0,'dy':0,'timeout':0},
			{'img':img_cuckoo_bow,'snd':None,'dx':0,'dy':0,'timeout':0},
			{'img':img_cuckoo_bow,'snd':None,'dx':0,'dy':0,'timeout':0},
			{'img':img_cuckoo_stand,'snd':None,'dx':0,'dy':0,'timeout':0},
			{'img':img_cuckoo_stand,'snd':None,'dx':0,'dy':0,'timeout':0},
		
		]
		
		img_cuckoo_hula_00=pygame.image.load(os.path.join(sitepkgdir,'./asymptopia/anim_images/cuckoo_hula_00.gif'))
		img_cuckoo_hula_01=pygame.image.load(os.path.join(sitepkgdir,'./asymptopia/anim_images/cuckoo_hula_01.gif'))
		img_cuckoo_hula_02=pygame.image.load(os.path.join(sitepkgdir,'./asymptopia/anim_images/cuckoo_hula_02.gif'))
		cuckoo_hula_01=[
			{'img':img_cuckoo_hula_00,'snd':None,'dx':0,'dy':0,'timeout':0},
			{'img':img_cuckoo_hula_00,'snd':None,'dx':0,'dy':0,'timeout':0},
			{'img':img_cuckoo_hula_00,'snd':None,'dx':0,'dy':0,'timeout':0},
			{'img':img_cuckoo_hula_01,'snd':None,'dx':0,'dy':0,'timeout':0},
			{'img':img_cuckoo_hula_01,'snd':None,'dx':0,'dy':0,'timeout':0},
			{'img':img_cuckoo_hula_01,'snd':None,'dx':0,'dy':0,'timeout':0},
			{'img':img_cuckoo_hula_00,'snd':None,'dx':0,'dy':0,'timeout':0},
			{'img':img_cuckoo_hula_00,'snd':None,'dx':0,'dy':0,'timeout':0},
			{'img':img_cuckoo_hula_00,'snd':None,'dx':0,'dy':0,'timeout':0},
			{'img':img_cuckoo_hula_02,'snd':None,'dx':0,'dy':0,'timeout':0},
			{'img':img_cuckoo_hula_02,'snd':None,'dx':0,'dy':0,'timeout':0},
			{'img':img_cuckoo_hula_02,'snd':None,'dx':0,'dy':0,'timeout':0},
		]	
		cuckoo_hula_02=[
			{'img':img_cuckoo_hula_00,'snd':None,'dx':0,'dy':0,'timeout':0},
			{'img':img_cuckoo_hula_00,'snd':None,'dx':0,'dy':0,'timeout':0},
			{'img':img_cuckoo_hula_02,'snd':None,'dx':0,'dy':0,'timeout':0},
			{'img':img_cuckoo_hula_02,'snd':None,'dx':0,'dy':0,'timeout':0},
			{'img':img_cuckoo_hula_00,'snd':None,'dx':0,'dy':0,'timeout':0},
			{'img':img_cuckoo_hula_00,'snd':None,'dx':0,'dy':0,'timeout':0},
			{'img':img_cuckoo_hula_00,'snd':None,'dx':0,'dy':0,'timeout':0},
			{'img':img_cuckoo_hula_01,'snd':None,'dx':0,'dy':0,'timeout':0},
			{'img':img_cuckoo_hula_01,'snd':None,'dx':0,'dy':0,'timeout':0},
			{'img':img_cuckoo_hula_01,'snd':None,'dx':0,'dy':0,'timeout':0},
			{'img':img_cuckoo_hula_01,'snd':None,'dx':0,'dy':0,'timeout':0},
		]	
		
		img_cuckoo_bend_00=pygame.image.load(os.path.join(sitepkgdir,'./asymptopia/anim_images/cuckoo_bend_00.gif'))
		img_cuckoo_bend_01=pygame.image.load(os.path.join(sitepkgdir,'./asymptopia/anim_images/cuckoo_bend_01.gif'))
		img_cuckoo_bend_02=pygame.image.load(os.path.join(sitepkgdir,'./asymptopia/anim_images/cuckoo_bend_02.gif'))
		cuckoo_bend_01=[
			{'img':img_cuckoo_bend_00,'snd':None,'dx':0,'dy':0,'timeout':0},
			{'img':img_cuckoo_bend_00,'snd':None,'dx':0,'dy':0,'timeout':0},
			{'img':img_cuckoo_bend_00,'snd':None,'dx':0,'dy':0,'timeout':0},
			{'img':img_cuckoo_bend_02,'snd':None,'dx':0,'dy':0,'timeout':0},
			{'img':img_cuckoo_bend_02,'snd':None,'dx':0,'dy':0,'timeout':0},
			{'img':img_cuckoo_bend_02,'snd':None,'dx':0,'dy':0,'timeout':0},
			{'img':img_cuckoo_bend_00,'snd':None,'dx':0,'dy':0,'timeout':0},
			{'img':img_cuckoo_bend_00,'snd':None,'dx':0,'dy':0,'timeout':0},
			{'img':img_cuckoo_bend_00,'snd':None,'dx':0,'dy':0,'timeout':0},
			{'img':img_cuckoo_bend_01,'snd':None,'dx':0,'dy':0,'timeout':0},
			{'img':img_cuckoo_bend_01,'snd':None,'dx':0,'dy':0,'timeout':0},
			{'img':img_cuckoo_bend_01,'snd':None,'dx':0,'dy':0,'timeout':0},
		]	
		cuckoo_bend_02=[
			{'img':img_cuckoo_bend_00,'snd':None,'dx':0,'dy':0,'timeout':0},
			{'img':img_cuckoo_bend_00,'snd':None,'dx':0,'dy':0,'timeout':0},
			{'img':img_cuckoo_bend_00,'snd':None,'dx':0,'dy':0,'timeout':0},
			{'img':img_cuckoo_bend_01,'snd':None,'dx':0,'dy':0,'timeout':0},
			{'img':img_cuckoo_bend_01,'snd':None,'dx':0,'dy':0,'timeout':0},
			{'img':img_cuckoo_bend_01,'snd':None,'dx':0,'dy':0,'timeout':0},
			{'img':img_cuckoo_bend_01,'snd':None,'dx':0,'dy':0,'timeout':0},
			{'img':img_cuckoo_bend_00,'snd':None,'dx':0,'dy':0,'timeout':0},
			{'img':img_cuckoo_bend_00,'snd':None,'dx':0,'dy':0,'timeout':0},
			{'img':img_cuckoo_bend_02,'snd':None,'dx':0,'dy':0,'timeout':0},
			{'img':img_cuckoo_bend_02,'snd':None,'dx':0,'dy':0,'timeout':0},
		]	
		
		self.sequences={
			'cuckoo_flap':cuckoo_flap,
			'cuckoo_spin_left':cuckoo_spin_left,
			'cuckoo_spin_right':cuckoo_spin_right,
			'cuckoo_bow':cuckoo_bow,
			'cuckoo_hula_01':cuckoo_hula_01,
			'cuckoo_hula_02':cuckoo_hula_02,
			'cuckoo_bend_01':cuckoo_bend_01,
			'cuckoo_bend_02':cuckoo_bend_02,
		}
		
		self.defineManeuver('cuckoo_maneuver_00',[{'cuckoo_flap':(-999,10)},])
		self.defineManeuver('cuckoo_maneuver_01',[{'cuckoo_spin_left':(-999,10)},])
		self.defineManeuver('cuckoo_maneuver_01',[{'cuckoo_spin_right':(-999,10)},])
		self.defineManeuver('cuckoo_maneuver_02',[{'cuckoo_bow':(-999,10)},])
		self.defineManeuver('cuckoo_maneuver_04',[{'cuckoo_hula_01':(-999,10)},])
		self.defineManeuver('cuckoo_maneuver_05',[{'cuckoo_hula_02':(-999,10)},])
		self.defineManeuver('cuckoo_maneuver_06',[{'cuckoo_bend_01':(-999,10)},])
		self.defineManeuver('cuckoo_maneuver_07',[{'cuckoo_bend_02':(-999,10)},])
		
		

	def defineManeuver(self,maneuver_name,seqlist):
		self.maneuvers[maneuver_name]=seqlist
			
	def getSequencesPyld(self):
		return(self.sequences)	

	def getManeuversPyld(self):
		return(self.maneuvers)
	
	def getManeuverNames(self):
		maneuver_names=[]
		for key in self.maneuvers.keys():
			maneuver_names.append(key)
		return(maneuver_names)
	
