#!/usr/bin/python
"""
/***************************************************************************

	Author 			:Charles B. Cosse 
	
	Email			:ccosse@asymptopia.com
					
	Copyright		:(C) 2002,2003 Asymptopia Software.
	
 ***************************************************************************/
/***************************************************************************
                         AnimatedChar.py

 ***************************************************************************/
 
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version. (Please note that if you use this *
 *   code you must give credit by including the Author and Copyright       *
 *   info at the top of this file).                                        *
 ***************************************************************************/

"""

import os, pygame,sys
from pygame.locals import *
from random import random
import time

class AnimatedChar(pygame.sprite.Sprite):
	def __init__(self,seqpyld,xc0,yc0):
		pygame.sprite.Sprite.__init__(self)

		self.seqpyld=seqpyld
		self.seqname=None
		self.frame=None
		self.image=seqpyld[seqpyld.keys()[0]][0]['img']
		self.rect=self.image.get_rect()
		self.rect.center=(xc0,yc0)
		self.dx=None
		self.dy=None
		self.timeout=None
		
		self.dest=None	
		self.xc=xc0
		self.yc=yc0
		
		self.idx=0
		self.stationary_idx=0
		
		self.maneuver_stack=[]
			
	def update(self):
	
		if not self.dest:return
		if not self.rect:return
		
		if self.dest[0]!=(-999 or None):
			if self.idx<len(self.seqpyld[self.seqname])-1:
				self.frame=self.seqpyld[self.seqname][self.idx]
				self.image=self.frame['img']
				self.idx=self.idx+1
			else:
				self.frame=self.seqpyld[self.seqname][self.idx]
				self.image=self.frame['img']
				self.idx=0
			
			self.xc=self.xc+self.frame['dx']
			self.yc=self.yc+self.frame['dy']
			self.rect=self.image.get_rect()	
			self.rect.center=(self.xc,self.yc)
			
			#get within some r_min, then sync centers:
			#if self.rect.collidepoint(self.dest):
			r2=2*pow(self.frame['dx'],2)+2*pow(self.frame['dy'],2)
			dist=pow((self.dest[0]-self.rect.center[0]),2)+pow((self.dest[1]-self.rect.center[1]),2)
			if dist<=r2:
				self.xc=self.dest[0]#xc,yc are what is persistent between sequences -- not "self.rect"!
				self.yc=self.dest[1]
				self.unset_dest()
				self.idx=0
				if len(self.maneuver_stack)>0:
					self.set_dest(self.maneuver_stack.pop())
					
			return(`self.rect.center`)
		
		elif self.dest[0]==-999:
			if self.stationary_idx<=self.dest[1]:
				try:
					self.frame=self.seqpyld[self.seqname][self.idx]
				except Exception,e:
					print `e`,self.seqname,self.idx,self.stationary_idx,self.dest
				self.image=self.frame['img']
				
				self.xc=self.xc+self.frame['dx']
				self.yc=self.yc+self.frame['dy']
				self.rect=self.image.get_rect()	
				self.rect.center=(self.xc,self.yc)
				
				self.idx=self.idx+1
				if self.idx>=len(self.seqpyld[self.seqname]):
					self.idx=0
					self.stationary_idx=self.stationary_idx+1
			else:
				self.unset_dest()
				self.idx=0
				self.stationary_idx=0
				if len(self.maneuver_stack)>0:
					self.set_dest(self.maneuver_stack.pop())
					self.stationary_idx=self.stationary_idx+1
			
			
			return(`self.rect.center`)


	def set_seqname(self,seqname):
		self.seqname=seqname
		self.frame=self.seqpyld[seqname][0]
		self.image=self.frame['img']
		self.rect=self.image.get_rect()
		self.rect.center=(self.xc,self.yc)
		self.dx=self.frame['dx']
		self.dy=self.frame['dy']
		self.timeout=self.frame['timeout']
		self.stationary_idx=0
		
	def unset_seqname(self):
		#print 'unset_seqname'
		self.seqname=None
		self.frame=None
		#self.image=None
		self.dx=None
		self.dy=None
		self.timeout=None
	
	def set_dest(self,dest):
		#print 'set_dest:',dest,self.maneuver_stack
		self.set_seqname(dest.keys()[0])
		self.dest=dest[self.seqname]
	
	def unset_dest(self):
		#print 'unset_dest w/stacklength=',len(self.maneuver_stack),self.maneuver_stack
		self.unset_seqname()
		self.dest=None
	
	def set_center(self,center):
		self.xc=center[0]
		self.yc=center[1]
	
	def get_seqname(self):
		return(self.seqname)
	
	def get_dest(self):
		return(self.dest)	
		
	def get_timeout(self):
		try:return(self.frame['timeout'])
		except:return(0)
	
	def get_sound(self):
		try:return(self.frame['snd'])
		except:return(None)
	
	def begin_maneuver(self,maneuver):
		#print ''
		#print 'AnimatedChar:',len(maneuver),maneuver
		if len(maneuver)>0:
			self.set_dest(maneuver[0])
		if len(maneuver)>1:
			#print 'to here...'
			for idx in range(len(maneuver)-1,0,-1):
				#print 'adding ',idx
				self.maneuver_stack.append(maneuver[idx])
			
