; Template file: LIST.APL
; Type         : AreaMgr
;
; This template generates one list of all the fileechos with the access
; code in the first collumn. Fileechos and conferences where the "Visible"
; option has been turned off (Default), will NOT be included in this list,
; unless the person is connected to them.
;
@assign(@count,0)
@assign(@doneheader,"No")
@areabegin
@test(@doneheader,=,"No")
  The following is a list of all the fileechos and your access level:

  Fileecho      Description                                Avg Kb   Avg Files
  ---------------------------------------------------------------------------
@assign(@doneheader,"Yes")
@end
@echostat @just(@fileecho,L,14)@just(@echodesc,L,39) @just(@avgkb,R,9)   @just(@avgfiles,R,9)
@add(@count,1)
@end
@test(@doneheader,=,"Yes")
  ---------------------------------------------------------------------------
  @count fileecho(s)
@end
@test(@count,=,0)
  You are currently not connected to any fileechos
@end
@assign(@count,0)
@assign(@doneheader,"No")
@confbegin
@test(@doneheader,=,"No")

  The following is a list of all the echomail conferences and your
  access level:

  Conference    Description
  ---------------------------------------------------------------------------
@assign(@doneheader,"Yes")
@end
@echostat @just(@conference,L,14)@just(@confdesc,L,39)
@add(@count,1)
@end
@test(@doneheader,=,"Yes")
  ---------------------------------------------------------------------------
  @count conference(s)
@end
@test(@count,=,0)
  You are currently not connected to any conferences
@end
@test(@pfileecho,<>,null)
@assign(@pendcnt,0)
@pendingbegin
@test(@pendcnt,=,0)

  The following fileechos have been requested by our uplink, for you:

  Fileecho      Description                                          Date
  ---------------------------------------------------------------------------
@end
  @just(@pfileecho,L,14)@just(@pdesc,L,53)@pdate
@add(@pendcnt,1)
@end
@test(@pendcnt,<>,0)
  ---------------------------------------------------------------------------
  @pendcnt echo(s)
@end
@end
@test(@count,<>,0)

"+"  You are connected to the fileecho and only receive files from our system.
"*"  You are connected to the fileecho and only send files to our system.
"&"  You are connected to the fileecho and both send and receive files.
"-"  You do not have access to the fileecho.
" "  You are not connected to the fileecho.
@end

---
 * Origin: use %HELP for help using the AreaMgr in ALLFIX (@akatouse)
