(******************************************************************************)
(*                          ALLFIX sample procedures                          *)
(*    Copyright (C) 1992,99 Harms Software Engineering, all rights reserved   *)
(*                                                                            *)
(*                 All information in this documentation is                   *)
(*                  subject to change without prior notice                    *)
(******************************************************************************)

Uses Types;

Procedure ReadStatFile;

  (* This procedure demonstrates how to read the STATFILE.FIX file *)

  Var Index, Data : file;
      Cnt         : word;
      {$IFDEF OS2}
      Nr          : longint;
      {$ELSE}
      Nr          : word;
      {$ENDIF}
      Rec         : StatisticRecord;
      Idx         : StatisticIndex;
      Node        : NetAddress;

  Begin
    WriteLn('Reading STATFILE.FIX');

    Assign(Index, 'STATFILE.IDX');
    Reset(Index, Sizeof(Idx));

    Assign(Data, 'STATFILE.FIX');
    Reset(Data, 1);

    Blockread(Index, Idx, 1, Nr);
    While Nr > 0 Do
    Begin
      Seek(Data, Idx.Offset);
      Blockread(Data, Rec, Sizeof(Rec), Nr);

      WriteLn('File echo : ', Rec.FileEcho);
      WriteLn('File name : ', Rec.FileName);
      WriteLn('Downlinks : ');

      For Cnt := 1 to Rec.NumDown Do
      Begin
        Blockread(Data, Node, Sizeof(Node), Nr);
        WriteLn('            ', Node.Zone,':', Node.Net, '\', Node.Node, '.', Node.Point);
      End;

      Blockread(Index, Idx, 1, Nr);
    End;

    Close(Index);
    Close(Data);
  End;

Begin
  ReadStatFile;
End.
