import java.awt.event.KeyEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyListener;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.net.URL;

import java.applet.Applet;

public class Tetris extends Applet { 

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
// CONSTANTS & VARIABLES                                                                    //
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//

    public static final String IMAGE_DIR = "images/";
    public static final String AUDIO_DIR = "audio/";

    public static final int GAME_INTRO = 0;
    public static final int GAME_PLAY  = 1;
    public static final int GAME_END   = 2;

    private int runMode;

	private Handler handler;
	private Screen screen;
    private Statistics stats;
    private Highscores highscores;
    private Sound sound;
    private Game game;

    private String uid;
    private String pwd;

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
// METHODES to ACCESS VARIABLES                                                             //
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//

    public Screen getScreen() {
        return screen;
    }
    public Sound getSound() {
        return sound;
    }
    public Game getGame() {
        return game;
    }
    public Statistics getStatistics() {
        return stats;
    }
    public Highscores getHighscores() {
        return highscores;
    }


//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
// RUN MODE METHODES                                                                        //
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//

    public void setRunMode(int mode) {
        runMode = mode;
    }
	public int getRunMode() {
		return runMode;
	}

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
// GAME MODE METHODES                                                                       //
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//

    public void backToIntroScreen() {

        setRunMode(GAME_INTRO);
        game.end();
        repaint();
    }

    public void startGame(int level) {

		setRunMode(GAME_PLAY);

        sound.playOnce(Sound.START_GAME);
		stats = new Statistics(level,this);
        game = new Game(this);
        game.start();

        repaint();
    }

	public void restartGame() {

        try {
            game.end();
            Thread.sleep(100);
            startGame(stats.getStartLevel());
        }
        catch (InterruptedException e) {
        }
    }

	public void endGame() {

		setRunMode(GAME_END);

        game.end();
        sound.playOnce(Sound.GAME_OVER);
        highscores.saveStatistics(stats);
		repaint();
    }

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
// SOUND MODE METHODES                                                                      //
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//

    public void toggleSoundFx() {
        sound.toggleSoundFx();
    }

    public void toggleMusic() {
        sound.toggleMusic();
        sound.startLoop(Sound.MUSIC);
    }

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
// MAIN PROGRAM                                                                             //
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
    
    public void init() {

        setBackground(Color.white);

        highscores = new Highscores(this);
        screen = new Screen(this);
        sound = new Sound(this);

		handler = new Handler(this);
		addKeyListener(handler);
        requestFocus();

        setRunMode(GAME_INTRO);
    }


    public void repaintEntireGameScreen() {

        screen.resetScreenBuffer();
        screen.drawGameInfoOnBuffer();
        screen.drawPlayfieldOnBuffer();

        paint(getGraphics());
    }

    public void repaintPlayfield() {

        screen.drawPlayfieldOnBuffer();

        paint(getGraphics());
    }

    public void paint(Graphics g) {
		switch (runMode) {
			
            case GAME_INTRO: 
                screen.resetScreenBuffer();
                screen.drawIntroScreenOnBuffer();
                screen.drawBufferOnAppletScreen();
                break;

            case GAME_PLAY:
                // see the two functions above:
                // repaintEntireGameScreen()
                // and repaintPlayfield();
                screen.drawBufferOnAppletScreen();
                break;

            case GAME_END:
                screen.resetScreenBuffer();
                screen.drawGameOverScreenOnBuffer();
                screen.drawBufferOnAppletScreen();
                break;

            default:
                break;
        }
    }
}
