import java.awt.Image;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Component;

class Tetramino {

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
// CONSTANTS & VARIABLES                                                                    //
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//

    public static final int NUMBER_OF_TETRAMINOS = 7;

    public static final int J_TETRAMINO = 0;
    public static final int L_TETRAMINO = 1;
    public static final int S_TETRAMINO = 2;
    public static final int O_TETRAMINO = 3;
    public static final int Z_TETRAMINO = 4;
    public static final int T_TETRAMINO = 5;
    public static final int I_TETRAMINO = 6;

    private Color COLOR_J = new Color(153,0,204);
    private Color COLOR_L = new Color(0,153,0);
    private Color COLOR_S = new Color(255,204,0);
    private Color COLOR_O = new Color(204,255,0);
    private Color COLOR_Z = new Color(204,0,153);
    private Color COLOR_T = new Color(0,51,204);
    private Color COLOR_I = new Color(204,0,0);

    private int shape;
    private int width;
    private int height;

    private int xPosition;
    private int yPosition;

    private Block[][] tetramino;
    private Tetris tetris;

    private Image tetraminoBuffer;
    private Graphics tetraminoGraphics;

    private int sleepTime;


//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~// 
// CONSTRUCTORS                                                                             // 
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~// 

    Tetramino() {
              
    }
    Tetramino(int tetraminoShape, Tetris tetrisApplet) {

        tetris = tetrisApplet;

        shape     = tetraminoShape;
        tetramino = constructTetramino();

        width  = tetramino.length;
        height = tetramino[0].length;
        
        xPosition = (int) (Playfield.WIDTH / 2 - width / 2);
        yPosition = -1; // start just above playfield;

        sleepTime = tetris.getStatistics().getSleepTime();

        updateTetraminoBuffer();
    }
 
  
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~// 
// PLAYFIELD BUFFER METHODES                                                                // 
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~// 

    public Image getBuffer() {
        return tetraminoBuffer;
    }

    public void updateTetraminoBuffer() {

        int bufferWidth  = width  * Block.WIDTH;
        int bufferHeight = height * Block.HEIGHT;

        tetraminoBuffer = tetris.createImage(bufferWidth,bufferHeight);
        tetraminoGraphics = tetraminoBuffer.getGraphics();
        tetraminoGraphics.setClip(null);

        int x,y;


        for (int i=0; i < width ; i++ ) {
            for (int j=0; j < height ; j++ ) {
                
                x = i * Block.WIDTH;
                y = j * Block.HEIGHT;

                if (tetramino[i][j] != null) {
                    tetraminoGraphics.drawImage(tetramino[i][j].getBuffer(),x,y,tetris);
//                    tetraminoGraphics.clipRect(x,y,Block.WIDTH,Block.HEIGHT);
                }
            }
        }
    }

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
// METHODES to ACCESS VARIABLES                                                             //
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//

    public int getSleepTime() {
        return sleepTime;
    }
    public void setSleepTime(int time) {
        sleepTime = time;
    }


    public int getWidth() {
        return width;
    }
    public int getHeight() {
        return height;
    }
    public Block[][] getBlockMatrix() {
        return tetramino;
    }
    public int getShape() {
        return shape;
    }

    public int getPositionWest() {
        return xPosition;
    }
    public int getPositionEast() {
        return xPosition + width - 1;
    }
    public int getPositionNorth() {
        return yPosition - height + 1;      
    }  
    public int getPositionSouth() {
        return yPosition;
    }

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~// 
// MOVEMENT METHODES                                                                        // 
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~// 

    public void rotateCW() {

        Block[][] rotatedTetramino = new Block[height][width];
        
        for (int i=0; i < width; i++) 
            for (int j=0; j < height; j++) 
                rotatedTetramino[height-1-j][i] = tetramino[i][j];

        tetramino = rotatedTetramino;
        width     = tetramino.length;
        height    = tetramino[0].length;
    }

    public void rotateCCW() {

        Block[][] rotatedTetramino = new Block[height][width];
        
        for (int i=0; i < width; i++) 
            for (int j=0; j < height; j++) 
                rotatedTetramino[j][width-1-i] = tetramino[i][j];

        tetramino = rotatedTetramino;
        width     = tetramino.length;
        height    = tetramino[0].length;
    }

    public void moveUp() {
        yPosition -= 1;
    }
    public void moveDown() {
        yPosition += 1;
    }
    public void moveLeft() {
        xPosition -= 1;
    }
    public void moveRight() {
        xPosition += 1;
    }


//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~// 
// PRIVATE METHODES                                                                         // 
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~// 

    private Block[][] constructTetramino() {

        Block b;
		Block[][] t;

        switch (shape) {

            case J_TETRAMINO:
                b = new Block(COLOR_J,tetris);
                t = new Block[3][3];
   
                             t[1][0] = b;
                             t[1][1] = b;
                t[0][2] = b; t[1][2] = b;

                break;

            case L_TETRAMINO:
                b = new Block(COLOR_L,tetris);
                t = new Block[3][3];

                             t[1][0] = b; 
                             t[1][1] = b; 
                             t[1][2] = b; t[2][2] = b;

                break;

            case S_TETRAMINO:
                b = new Block(COLOR_S,tetris);
                t = new Block[3][3];


                             t[1][1] = b; t[2][1] = b;
                t[0][2] = b; t[1][2] = b;

                break;

            case O_TETRAMINO:
                b = new Block(COLOR_O,tetris);
                t = new Block[2][2];

                t[0][0] = b; t[1][0] = b;
                t[0][1] = b; t[1][1] = b;

                break;

            case Z_TETRAMINO:
                b = new Block(COLOR_Z,tetris);
                t = new Block[3][3];


                t[0][1] = b; t[1][1] = b;
                             t[1][2] = b; t[2][2] = b;

                break;

            case T_TETRAMINO:
                b = new Block(COLOR_T,tetris);
                t = new Block[3][3];


                t[0][1] = b; t[1][1] = b; t[2][1] = b;
                             t[1][2] = b;

                break;

            default: // I_TETRAMINO:
                b = new Block(COLOR_I,tetris);
                t = new Block[3][4];

                         t[1][0] = b;
                         t[1][1] = b;
                         t[1][2] = b;
                         t[1][3] = b; 

                break;
        }

        return t;
    }


}
