class Statistics {

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
// CONSTANTS & VARIABLES                                                                    //
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
    
    private static final double SLEEP_FACTOR = 1.2;
    private static final int START_SLEEP = 1000;
    private static final int DROP_SLEEP_TIME = 30;

    private static final int LINES_PER_LEVEL = 15;

    private static final int SINGLE_SCORE  =  25;
    private static final int DOUBLE_SCORE  =  75;
    private static final int TRIPPLE_SCORE = 300;
    
    private Tetris tetris;
    private int score;
    private int level;
    private int blocks;
    private int lines;
    private int startLevel;

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~// 
// CONSTRUCTORS                                                                             // 
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~// 

    Statistics() {
    }

    Statistics(int start,Tetris tetrisApplet) {

        blocks = 0;
        lines  = 0;
        level  = start;
        tetris = tetrisApplet;
        score  = level * LINES_PER_LEVEL * SINGLE_SCORE;
        startLevel = start;
    }
 
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
// METHODES to ACCESS VARIABLES                                                             //
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//

    public int getLevel() {
        return level;
    }
    public int getScore() {
        return score;
    }
    public int getBlocks() {
        return blocks;
    }
    public int getLines() {
        return lines;
    }
    public int getStartLevel() {
        return startLevel;
    }

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~// 
// METHODES TO UPDATE STATISTICS                                                            // 
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~// 

    public void update(int linesRemoved) {
    
        blocks += 1;
        score  += 5;
        lines  += linesRemoved;
        
        if (lines >= (level - startLevel + 1) * LINES_PER_LEVEL) {
            level += 1;
            tetris.getSound().playOnce(Sound.NEXT_LEVEL);
        }
    
        switch (linesRemoved) {

            case 1:
                score += 4 * SINGLE_SCORE;
                break;

            case 2:
                score += 4 * DOUBLE_SCORE;
                break;

            case 3:
            case 4:
                score += 4 * TRIPPLE_SCORE;
                break;

            default:
                break;
        }
    }


    public int getSleepTime() {
        return (int) ( START_SLEEP / Math.pow(SLEEP_FACTOR,level+1) );
    }
    public int getDropSleepTime() {
        return DROP_SLEEP_TIME;
    }


    public void resetStatistics() {

        score  = 0;
        level  = startLevel;
        blocks = 0;
        lines  = 0;
    }
}
