import java.applet.AudioClip;
import java.net.URL;

class Sound {

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
// CONSTANTS & VARIABLES                                                                    //
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//

    private final int NUMBER_OF_FILES = 5;

    private final String AU_MUSIC          = "music.au";
    private final String AU_ROW_REMOVED    = "rowremoved.au";
    private final String AU_NEXT_LEVEL     = "nextlevel.au";
	private final String AU_START_GAME	   = "startgame.au";
	private final String AU_GAME_OVER      = "gameover.au";

    static final int MUSIC          = 0;
    static final int ROW_REMOVED    = 1;
    static final int NEXT_LEVEL     = 2;
	static final int START_GAME		= 3;
	static final int GAME_OVER      = 4;

    private boolean musicActive;
    private boolean soundFxActive;

    private AudioClip[] audio;
    private Tetris tetris;

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~// 
// CONSTRUCTORS                                                                             // 
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~// 

    Sound(Tetris tetrisApplet) {

        audio = new AudioClip[NUMBER_OF_FILES];
		tetris = tetrisApplet;
        
        musicActive = false;
        soundFxActive = true;

		loadAudioClips();
    }

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~// 
// METHODES                                                                                 // 
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~// 

	private void loadAudioClips() {

		URL base   = tetris.getCodeBase();
		String dir = tetris.AUDIO_DIR;

		audio[MUSIC]          = tetris.getAudioClip(base,dir + AU_MUSIC);
        audio[ROW_REMOVED]    = tetris.getAudioClip(base,dir + AU_ROW_REMOVED);
        audio[NEXT_LEVEL]     = tetris.getAudioClip(base,dir + AU_NEXT_LEVEL);
		audio[START_GAME]     = tetris.getAudioClip(base,dir + AU_START_GAME);
        audio[GAME_OVER]      = tetris.getAudioClip(base,dir + AU_GAME_OVER);
	}

    public void playOnce(int type) {

        if (type == MUSIC && musicActive) {
            audio[type].play();
        }
        else if (type != MUSIC && soundFxActive) {
            audio[type].play();
        }
    }

    public void startLoop(int type) {

        if (type == MUSIC && musicActive) {
            audio[type].loop();
        }
        else if (type != MUSIC && soundFxActive) {
            audio[type].loop();
        }
    }

    public void stopLoop(int type) {
        audio[type].stop();
    }

    public void toggleSoundFx() {
        soundFxActive = ! soundFxActive;
    }

    public void toggleMusic() {
        musicActive = ! musicActive;
        stopLoop(MUSIC);
    }
}
