import java.awt.Image;
import java.awt.Graphics;
import java.awt.MediaTracker;
import java.awt.Color;
import java.awt.Label;
import java.awt.Font;
import java.net.URL;



class Screen {
    
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
// CONSTANTS & VARIABLES                                                                    //
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//

    public static final int SCREEN_WEST = 25;
    
    public static final int BUFFER_WIDTH  = 375;
    public static final int BUFFER_HEIGHT = 450;

    public static final int PLAYFIELD_NORTH  = 25;
    public static final int PLAYFIELD_WEST   = 145;

    public static final int PLAYFIELD_WIDTH  = Block.WIDTH * Playfield.WIDTH;
    public static final int PLAYFIELD_HEIGHT = Block.HEIGHT * Playfield.HEIGHT;

    private static final String JAVA_LOGO = "java.gif";
    private static final String TETRIS_LOGO = "logo.jpg";

    private Tetris tetris;
    private Graphics graphics;
    private Font defaultFont;

    private Image javaLogo;
    private Image tetrisLogo;

    private Image screenBuffer;
    private Graphics screenGraphics;

    private boolean showNextTetramino;

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~// 
// CONSTRUCTORS                                                                             // 
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~// 

    Screen() {
    }

    Screen(Tetris tetrisApplet) {

        tetris   = tetrisApplet;
        graphics = tetris.getGraphics();
        
        screenBuffer = tetris.createImage(BUFFER_WIDTH,BUFFER_HEIGHT);
        screenGraphics = screenBuffer.getGraphics();
        defaultFont = screenGraphics.getFont();

        javaLogo = tetris.getImage(tetris.getCodeBase(),tetris.IMAGE_DIR + JAVA_LOGO);
        tetrisLogo = tetris.getImage(tetris.getCodeBase(),tetris.IMAGE_DIR + TETRIS_LOGO);

        resetScreenBuffer();

        showNextTetramino = true;
   }


//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~// 
// SHOW / HIDE NEXT TETRAMINO                                                               // 
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~// 

    public void toggleShowNext() {
        showNextTetramino = ! showNextTetramino;
        tetris.repaintEntireGameScreen();
    }

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~// 
// BUFFER METHODS                                                                           // 
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~// 

    public void resetScreenBuffer() {

        screenGraphics.clearRect(0,0,BUFFER_WIDTH,BUFFER_HEIGHT);
    }

    public void drawBufferOnAppletScreen() {

        graphics.drawImage(screenBuffer,0,0,tetris);
	}
    

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~// 
// PUBLIC METHODES TO UPDATE BUFFER                                                         // 
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~// 

    public void drawIntroScreenOnBuffer() {

        screenGraphics.drawImage(tetrisLogo,SCREEN_WEST-5,15,tetris);
        screenGraphics.drawImage(javaLogo,290,15,tetris);

        drawUsageText(screenGraphics,SCREEN_WEST+10,140);
        drawScoresToBeat(screenGraphics,210,125);
        drawGameControls(screenGraphics,SCREEN_WEST,255);
        drawCredits(screenGraphics,SCREEN_WEST,440);
    }


    public void drawGameInfoOnBuffer() {

        screenGraphics.drawImage(tetrisLogo,SCREEN_WEST-5,15,tetris);
        screenGraphics.drawImage(javaLogo,40,345,tetris);

        if (showNextTetramino)
        drawNextTextramino(screenGraphics,SCREEN_WEST,220);
        drawStatistics(screenGraphics,SCREEN_WEST,120);

        drawPlayfield(screenGraphics,PLAYFIELD_WEST,PLAYFIELD_NORTH);
        drawCurrentTetraminoOnBuffer();

    }
    public void drawPlayfieldOnBuffer() {

        drawPlayfield(screenGraphics,PLAYFIELD_WEST,PLAYFIELD_NORTH);
        drawCurrentTetraminoOnBuffer();
    }


    public void drawGameOverScreenOnBuffer() {

        screenGraphics.drawImage(tetrisLogo,SCREEN_WEST-5,15,tetris);
        screenGraphics.drawImage(javaLogo,290,15,tetris);

        drawGameOverText(screenGraphics,200,200);
        drawStatistics(screenGraphics,SCREEN_WEST,120);
        drawCredits(screenGraphics,SCREEN_WEST,440);
    }


//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~// 
// GAME INTRO METHODES                                                                      // 
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~// 


//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~// 
// GAME PLAY METHODES                                                                       // 
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~// 

    public void drawCurrentTetraminoOnBuffer() {

        int tX,tY;
        
        Tetramino t = tetris.getGame().getCurrentTetramino();
        Block[][] block = t.getBlockMatrix();

        for (int i=0; i < block.length ; i++ ) {
            for (int j=0; j < block[0].length ; j++ ) { 
        
                tX = PLAYFIELD_WEST  + ( i + t.getPositionWest()  ) * Block.WIDTH;
                tY = PLAYFIELD_NORTH + ( j + t.getPositionNorth() ) * Block.HEIGHT;

                if (tY < PLAYFIELD_NORTH)
                    continue;

                if (block[i][j] != null)
                    screenGraphics.drawImage(block[i][j].getBuffer(),tX,tY,tetris);
            }
        }
    }



//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~// 
// GAME INTRO METHODES                                                                      // 
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~// 

    private void drawUsageText(Graphics g,int x,int y) {

        g.drawString("Welcome to Startpage Tetris!",         x, y);
        g.drawString("Press 'space' or 'enter' to start",    x, y+20);
        g.drawString("or select a level with '1' to '9'. ",  x, y+40);  
        g.drawString("You can always return to this",        x, y+60);
        g.drawString("screen by pressing 'escape'.",         x, y+80);
    }

    private void drawScoresToBeat(Graphics g,int x,int y) {

		g.drawRect(x,y,140,20);
		g.drawString("Scores to Beat", x+10, y+15);

//        if (tetris.getHighscores().getMySQLConnection().isConnected()) {

//        }
//        else {
            g.drawString("The highscores database ",     x+10, y+55);  
            g.drawString("is not yet working. Just",   x+10, y+75);
            g.drawString("playing for fun now ...", x+10, y+95);
//        }
    }

    private void drawGameControls(Graphics g, int x, int y) {

        g.drawRect(x,y,BUFFER_WIDTH-50,20);
        g.drawString("Game Controls", x+10, y+15);
        g.drawString("Function Keys", 250,  y+15);

        g.drawString("[arrow up]",    x+10, y+40);
        g.drawString("[arrow down]",  x+10, y+60);
        g.drawString("[arrow left]",  x+10, y+80);
        g.drawString("[arrow right]", x+10, y+100);
        g.drawString("[enter]",       x+10, y+120);
        g.drawString("[space]",       x+10, y+140);

        g.drawString("-  rotate clockwise",         x+80,y+40);
        g.drawString("-  rotate counter clockwise", x+80,y+60);
        g.drawString("-  move tetramino left",      x+80,y+80);
        g.drawString("-  move tetramino right",     x+80,y+100);
        g.drawString("-  move tetramino down",      x+80,y+120);
        g.drawString("-  drop to bottom",           x+80,y+140);
 
        g.drawString("[q]", x+225, y+40);
        g.drawString("[r]", x+225, y+60);
        g.drawString("[p]", x+225, y+80);
        g.drawString("[m]", x+225, y+100);
        g.drawString("[s]", x+225, y+120);
        g.drawString("[n]", x+225, y+140);

        g.drawString("-  quit game",     x+245, y+40);
        g.drawString("-  restart game",  x+245, y+60);
        g.drawString("-  pause game",    x+245, y+80);
        g.drawString("-  game music",    x+245, y+100);
        g.drawString("-  sound effects", x+245, y+120);
        g.drawString("-  toggle next",   x+245, y+140);
    }

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~// 
// GAME PLAY METHODES                                                                       // 
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~// 

    private void drawStatistics(Graphics g, int x, int y) {
    
        Statistics stats = tetris.getStatistics();

		g.drawRect(x,y,90,20);
		g.drawString("Game Statistics", x+10, y+15);

		g.drawString(" Score: ",        x+10, y+35);
		g.drawString(" Level: ",        x+10, y+50);
		g.drawString(" Blocks: ",       x+10, y+65);
		g.drawString(" Lines: ",        x+10, y+80);

		g.drawString("" + stats.getScore(),  x+60, y+35);
		g.drawString("" + stats.getLevel(),  x+60, y+50);
		g.drawString("" + stats.getBlocks(), x+60, y+65);
		g.drawString("" + stats.getLines(),  x+60, y+80);
    }

    private void drawNextTextramino(Graphics g, int x, int y) {

        g.drawRect(x,y,90,20);
        g.drawString("Next Tetramino", x+10, y+15);
        g.drawImage(tetris.getGame().getNextTetramino().getBuffer(), x+15, y+35, tetris);
    }

    public void drawPlayfield(Graphics g, int x, int y) {

        g.drawRect(x-1, y-1, PLAYFIELD_WIDTH + 1, PLAYFIELD_HEIGHT + 1);
        g.drawImage(tetris.getGame().getPlayfield().getBuffer(),x,y,tetris);
    }

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~// 
// GAME OVER METHODES                                                                       // 
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~// 

    private void drawGameOverText(Graphics g, int x, int y) {

        g.drawString("Well done, you've lost!!!!!!!!!!!!", x,y);
        g.drawString("Press 'space' or 'enter' to restart",    x, y+20);
        g.drawString("or select a level with '1' to '9'. ",  x, y+40);  
        g.drawString("You can return to the start screen",        x, y+60);
        g.drawString("by pressing 'escape'.",         x, y+80);

    }


//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~// 
// SHARED METHODES                                                                          // 
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~// 


    private void drawCredits(Graphics g, int x, int y) {

        g.fillRect(0,y-20,BUFFER_WIDTH,BUFFER_HEIGHT);

        g.setFont(new Font("SansSerif",Font.PLAIN,12));
        g.setColor(Color.white);

        g.drawString("Copyright  2000 Startpage  - http://games.startpage.org/",x+10,y);

        g.setFont(defaultFont);
        g.setColor(Color.black);
    }

}

