import java.awt.Image;
import java.awt.Graphics;
import java.awt.Component;

class Playfield {

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
// CONSTANTS & VARIABLES                                                                    //
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//

    public static final int WIDTH  = 10;
    public static final int HEIGHT = 20;

    private Image screenBuffer;
    private Graphics screenGraphics;

    private Block[][] field;
    private Tetris tetris;

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~// 
// CONSTRUCTORS                                                                             // 
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~// 

    Playfield(Tetris tetrisApplet) {

        tetris = tetrisApplet;
        field  = new Block[HEIGHT][WIDTH];

        updatePlayfieldBuffer();
    }
 
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~// 
// PLAYFIELD BUFFER METHODES                                                                // 
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~// 

    public Image getBuffer() {
        return screenBuffer;
    }

    public void updatePlayfieldBuffer() {

        int bufferWidth  = WIDTH  * Block.WIDTH;
        int bufferHeight = HEIGHT * Block.HEIGHT;

        screenBuffer = tetris.createImage(bufferWidth,bufferHeight);
        screenGraphics = screenBuffer.getGraphics();

        int fX,fY;

        for (int y=0; y < HEIGHT ; y++ ) {
            for (int x=0; x < WIDTH ; x++ ) {
                
                fX = x * Block.WIDTH;
                fY = y * Block.HEIGHT;

                if (field[y][x] != null) {
                    screenGraphics.drawImage(field[y][x].getBuffer(),fX,fY,tetris);                }
            }
        }
    }

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~// 
// PUBLIC METHODES                                                                          // 
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~// 

    public boolean topRowReached() {
    
        for (int x=0; x < WIDTH ; x++ ) 
            if (field[0][x] != null) 
                return true;

        return false;
    }

    private boolean completeRowFilled(int row) {

        for (int x=0; x < WIDTH ; x++ ) 
            if (field[row][x] == null)
                return false;

        return true;
    }

    public int removeCompleteRows() {

        int rowsRemoved = 0;
        int newRowIndex = HEIGHT - 1;

        Block[][] newField = new Block[HEIGHT][WIDTH];

        for (int y=HEIGHT-1; y >= 0 ; y-- ) {
            if (completeRowFilled(y)) {
                rowsRemoved += 1;
            }
            else {
                newField[newRowIndex] = field[y];
                newRowIndex -= 1;
            }
        }
        field = newField;
        return rowsRemoved;
    }   

    public boolean tetraminoFits(Tetramino t) {

        int tX,tY;
        Block[][] block = t.getBlockMatrix();

        for (int y=0; y < t.getHeight() ; y++ ) { 
            for (int x=0; x < t.getWidth() ; x++ ) {

                tY = y + t.getPositionNorth();
                tX = x + t.getPositionWest();

                if (block[x][y] != null) {

                    if (tX < 0 || tX >= WIDTH)
                        return false;

                    else if (tY < 0) 
                        continue;

                    else if (tY >= HEIGHT)
                        return false;

                    else if (field[tY][tX] != null)
                       return false;
                }
            }
        }

        return true;
    }

    public void placeTetramino(Tetramino t) {

        int tX,tY;
        Block[][] block = t.getBlockMatrix();

        for (int y=0; y < block[0].length ; y++ ) { 
            // System.out.println("Playfield.placeTetramino() - OUTER loop -  y: " + y);
            // System.out.println();
            for (int x=0; x < block.length ; x++ ) {
                // System.out.println("Playfield.placeTetramino() - inner loop -  x: " + x);

                tY = y + t.getPositionNorth();
                tX = x + t.getPositionWest();

                // System.out.println("Playfield.placeTetramino() - before placing - tY: "+tY+", tX: "+tX);

                if (tY < 0 || tX < 0 || tX >= WIDTH) {
                    // System.out.println("Playfield.placeTetramino() - condition failed: continued");
                    // System.out.println();
                    continue;
                }

                if (block[x][y] != null) {
                    field[tY][tX] = block[x][y]; 
                    // System.out.println("Playfield.placeTetramino() - after placing - y: " + y + ", x: " + x + ", tY: "+tY+", tX: "+tX);
                    // System.out.println();
                }
            }
        }
    }

    public void resetPlayield() {

        for (int y=0; y < HEIGHT ; y++ )
            for (int x=0; x < WIDTH ; x++ )
                field[y][x] = null;
    }


}
