import java.awt.event.KeyEvent;
import java.awt.event.KeyAdapter;

class Handler extends KeyAdapter {

   private Tetris tetris;

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
// CONSTRUCTORS                                                                             //
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//

    Handler() {
    }

    Handler(Tetris tetris) {
        this.tetris = tetris;
    }

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
// METHODES                                                                                 //
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//

    public void keyPressed(KeyEvent e) {

        // use keyPressed(), so that users can hold keys;
        // and while ESC which only triggers keyPressed()
        // because there's no associated character;

        switch (tetris.getRunMode()) {
    
            case Tetris.GAME_INTRO :
                gameIntroHandler(e);
                break;
            
            case Tetris.GAME_PLAY :
                gamePlayHandler(e);
                break;

            case Tetris.GAME_END :
                gameEndHandler(e);
                break;

            default:
                break;
        }
    }
    
    /*
    // already defined in KeyAdapter;
    public void keyTyped(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }
    */

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
// KEY HANDLER FUNCTIONS                                                                    //
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//

    private void gameIntroHandler(KeyEvent e) {

        startPlayingTetris(e);
    }

    private void gamePlayHandler(KeyEvent e) {

        handleFunctionKeys(e.getKeyChar());

        if (e.getKeyCode() == KeyEvent.VK_ESCAPE)
            tetris.backToIntroScreen();

        if (! tetris.getGame().getThreadSuspended()) 
            handleGameControls(e.getKeyCode());
    }

    private void gameEndHandler(KeyEvent e) {

        if (e.getKeyCode() == KeyEvent.VK_ESCAPE) {
            tetris.backToIntroScreen();
        }
        else {
            startPlayingTetris(e);
        }
    }


//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
// HELPER FUNCTIONS                                                                         //
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//

    private void handleGameControls(int keyCode) {

        switch(keyCode) {

            case KeyEvent.VK_UP:
                tetris.getGame().tryRotateTetraminoCCW();
                // System.out.println("Handler.handleGameControls() - rotate CCW (up)");
                break;

            case KeyEvent.VK_DOWN:
                tetris.getGame().tryRotateTetraminoCW();
                // System.out.println("Handler.handleGameControls() - rotate CW (down)");
                break;

            case KeyEvent.VK_LEFT:
                tetris.getGame().tryMoveTetraminoLeft();
                // System.out.println("Handler.handleGameControls() - move left");
                break;

            case KeyEvent.VK_RIGHT:
                tetris.getGame().tryMoveTetraminoRight();
                // System.out.println("Handler.handleGameControls() - move right");
                break;

            case KeyEvent.VK_ENTER:
                tetris.getGame().tryMoveTetraminoDown();
                break;

            case KeyEvent.VK_SPACE:
                tetris.getGame().dropTetraminoToBottom();
                // System.out.println("Handler.handleGameControls() - drop tetramino");
                break;
        }
    }


    private void handleFunctionKeys(char keyChar) {

        switch (keyChar) {

            case 's':
                tetris.toggleSoundFx();
                break;

            case 'm':
                tetris.toggleMusic();
                break;

            case 'n':
                tetris.getScreen().toggleShowNext();
                break;

            case 'p':
                tetris.getGame().togglePause();
                break;
            
            case 'r':
                tetris.restartGame();
                break;
                
            case 'q':
                tetris.backToIntroScreen();
                break;
        }
    }

    private void startPlayingTetris(KeyEvent e) {

        if (e.getKeyCode() == KeyEvent.VK_SPACE)
            tetris.startGame(0);

        if (e.getKeyCode() == KeyEvent.VK_ENTER)
            tetris.startGame(0);

        int level = (int) (e.getKeyChar() - '0');
        if (0 <= level && level <= 9) 
            tetris.startGame(level);
    }
}
