import java.awt.Color;
import java.awt.Image;
import java.awt.Graphics;
import java.awt.Component;
import java.net.URL;

class Block {

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
// CONSTANTS & VARIABLES                                                                    //
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
    
    public static final int WIDTH  = 20;
    public static final int HEIGHT = 20;

    private Tetris tetris;
    private Image blockBuffer;
    private Graphics blockGraphics;


//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~// 
// CONSTRUCTORS                                                                             // 
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~// 

    Block() {

    }

    Block(Color color, Tetris tetrisApplet) {

        tetris = tetrisApplet;
        
        blockBuffer   = tetris.createImage(WIDTH,HEIGHT);
        blockGraphics = blockBuffer.getGraphics();

        blockGraphics.setColor(color);
        blockGraphics.draw3DRect(0,0,WIDTH,HEIGHT,false);
        blockGraphics.fill3DRect(0,0,WIDTH,HEIGHT,true);
        blockGraphics.draw3DRect(2,2,WIDTH-5,HEIGHT-5,true);
    }
 
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~// 
// METHODES                                                                                 // 
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~// 

    public Image getBuffer() {
        return blockBuffer;
    }
}
