/*
                     WAVTOSAM 1.0

 Convert a .WAV sound file in a .SAM sound file used by MAME

*/


#include <stdio.h>
#include <bios.h>
#include <conio.h>
#include <ctype.h>
#include <process.h>
#include <dos.h>
#include <string.h>


typedef unsigned char    BYTE;
typedef unsigned short   WORD;

FILE *FOut,*FIn;



void CloseAll(int no)
{
	switch(no){
  	case 1:
      printf("Not a WAV file?\n");
      fclose(FIn);
      exit(1);
    	break;
  }
}


void main(int argc,char *argv[])
{
char filename[100];
int i;
unsigned char ch;
long templong,freq,len,ll;

	printf("--------- WAV to SAM 1.0 --------\n");

	if( argc != 2 ) {
		printf("Convert a .WAV in a .SAM used by MAME.\n");
		printf("Usage: WAVTOSAM <InFile>\n");
		printf("EX: WAVTOSAM TEST.WAV\n");
		printf("    The result will be TEST.SAM\n");
		exit(0);
	}


	printf("Source: %s\n",argv[1]);

	if( (FIn=fopen(argv[1],"rb"))==NULL ) {
		printf("%s not found\n",argv[1]);
		exit(5);
	}


//Check if we recognize the header.
  ch = fgetc(FIn);
  if(ch != 'R')
  	CloseAll(1);
  ch = fgetc(FIn);
  if(ch != 'I')
  	CloseAll(1);
  ch = fgetc(FIn);
  if(ch != 'F')
  	CloseAll(1);
  ch = fgetc(FIn);
  if(ch != 'F')
  	CloseAll(1);

//Skip the next 4 bytes
  for(i=0;i<4;i++)
	  ch = fgetc(FIn);

  ch = fgetc(FIn);
  if(ch != 'W')
  	CloseAll(1);
  ch = fgetc(FIn);
  if(ch != 'A')
  	CloseAll(1);
  ch = fgetc(FIn);
  if(ch != 'V')
  	CloseAll(1);
  ch = fgetc(FIn);
  if(ch != 'E')
  	CloseAll(1);

  ch = fgetc(FIn);
  if(ch != 'f')
  	CloseAll(1);
  ch = fgetc(FIn);
  if(ch != 'm')
  	CloseAll(1);
  ch = fgetc(FIn);
  if(ch != 't')
  	CloseAll(1);
  ch = fgetc(FIn);
  if(ch != ' ')
  	CloseAll(1);

//Skip the next 12 bytes
  for(i=0;i<12;i++)
	  ch = fgetc(FIn);

  ll = fgetc(FIn);
  freq = ll;
  ll = fgetc(FIn);
  freq += ll<<8;
  ll = fgetc(FIn);
  freq += ll<<16;
  ll = fgetc(FIn);
  freq += ll<<24;

	printf("Wave frequency: %ld\n",freq);

//Skip the next 8 bytes
  for(i=0;i<8;i++)
	  ch = fgetc(FIn);

  ll = fgetc(FIn);
  len = ll;
  ll = fgetc(FIn);
  len += ll<<8;
  ll = fgetc(FIn);
  len += ll<<16;
  ll = fgetc(FIn);
  len += ll<<24;

	printf("Wave length: %ld\n",len);

//SAM name
  for(i=0;i<100;i++){
    if(argv[1][i] == '.')
    	break;
    if(argv[1][i] == 0)
    	break;
  	filename[i] = argv[1][i];
  }
  filename[i] = 0;
  strcat(filename,".SAM");

	printf("Destination: %s\n",filename);


	if ((FOut = fopen(filename, "wb"))	== NULL){
		printf("Cannot open %s\n",filename);
		fclose(FIn);
		exit(1);
	}

/*
        MAMEHeader = Record
          ID   : array[0..3] of char;
          len  : longint;
          freq : longint;
          res  : byte;
          vol  : byte;
          exp  : word;   (* expansion *)
        End;
*/

//Write MAME header
	fputc('M',FOut);
	fputc('A',FOut);
	fputc('M',FOut);
	fputc('E',FOut);

	fputc(len&0xFF,FOut);
	fputc(len>>8&0xFF,FOut);
	fputc(len>>16&0xFF,FOut);
	fputc(len>>24&0xFF,FOut);

	fputc(freq&0xFF,FOut);
	fputc(freq>>8&0xFF,FOut);
	fputc(freq>>16&0xFF,FOut);
	fputc(freq>>24&0xFF,FOut);

	fputc(8,FOut);
	fputc(255,FOut);

	fputc(0,FOut);
	fputc(0,FOut);

//Copy the data
  for(templong=0;templong<len;templong++){
    ch = fgetc(FIn);
    ch = ch-0x80;
		fputc(ch,FOut);
  }

	fclose(FOut);

	fclose(FIn);
}
