/***************************************************************************/
/* ASG 971011 -- moved this into a "core" function */
void drawgfx_core(struct osd_bitmap *dest,const struct GfxElement *gfx,
		unsigned int code,unsigned int color,int flipx,int flipy,int sx,int sy,
		const struct rectangle *clip,int transparency,int transparent_color,int dirty)
{
    int ox,oy,ex,ey,x,y,start,dy;
    const unsigned char *sd;
    unsigned char *bm;
    int col;
    int temp;
    struct rectangle myclip;

    if (!gfx) return;
    if (Machine->orientation & ORIENTATION_SWAP_XY) {
        temp = sx; sx = sy; sy = temp;
        temp = flipx; flipx = flipy; flipy = temp;
        if (clip) {
            myclip.min_x = clip->min_y;
            myclip.max_x = clip->max_y;
            myclip.min_y = clip->min_x;
            myclip.max_y = clip->max_x;
            clip = &myclip;
        }
    }
    if (Machine->orientation & ORIENTATION_FLIP_X) {
        sx = dest->width - gfx->width - sx;
        if (clip) {
            temp = clip->min_x;
            myclip.min_x = dest->width-1 - clip->max_x;
            myclip.max_x = dest->width-1 - temp;
            myclip.min_y = clip->min_y;
            myclip.max_y = clip->max_y;
            clip = &myclip;
        }
    }
    if (Machine->orientation & ORIENTATION_FLIP_Y) {
        sy = dest->height - gfx->height - sy;
        if (clip) {
            myclip.min_x = clip->min_x;
            myclip.max_x = clip->max_x;
            temp = clip->min_y;
            myclip.min_y = dest->height-1 - clip->max_y;
            myclip.max_y = dest->height-1 - temp;
            clip = &myclip;
        }
    }
    /* check bounds */
    ox = sx;
    oy = sy;
    ex = sx + gfx->width-1;
    if (sx < 0) sx = 0;
    if (clip && sx < clip->min_x) sx = clip->min_x;
    if (ex >= dest->width) ex = dest->width-1;
    if (clip && ex > clip->max_x) ex = clip->max_x;
    if (sx > ex) return;
    ey = sy + gfx->height-1;
    if (sy < 0) sy = 0;
    if (clip && sy < clip->min_y) sy = clip->min_y;
    if (ey >= dest->height) ey = dest->height-1;
    if (clip && ey > clip->max_y) ey = clip->max_y;
    if (sy > ey) return;

    if (dirty) osd_mark_dirty (sx,sy,ex,ey,0);	/* ASG 971011 */

    if (flipy)  /* Y flop */ {
       start = (code%gfx->total_elements) * gfx->height + gfx->height-1 - (sy-oy);
       dy = -1;
    } else      /* normal */ {
       start = (code % gfx->total_elements) * gfx->height + (sy-oy);
       dy = 1;
    }
    
    /* if necessary, remap the transparent color */
    if (transparency==TRANSPARENCY_COLOR || transparency==TRANSPARENCY_THROUGH)
		transparent_color = Machine->pens[transparent_color];
    if (gfx->colortable)    /* remap colors */ {
        const unsigned char *paldata;

        paldata = &gfx->colortable[gfx->color_granularity * (color % gfx->total_colors)];

        switch (transparency) {
            case TRANSPARENCY_NONE:
                if (flipx)    /* X flip */ {
                    for (y = sy;y <= ey;y++) {
                        bm = dest->line[y] + sx;
                        sd = gfx->gfxdata->line[start] + gfx->width-1 - (sx-ox);
                        for( x = sx; x <= ex ; x++) *(bm++) = paldata[*(sd--)];
                        start+=dy;
                    }
                } else        /* normal */ {
                    for (y = sy;y <= ey;y++) {
                        bm = dest->line[y] + sx;
                        sd = gfx->gfxdata->line[start] + (sx-ox);
                        for( x = sx ; x <= ex ; x++) *(bm++) = paldata[*(sd++)];
                        start+=dy;
                    }
                }
                break;

            case TRANSPARENCY_PEN:
                if (flipx)    /* X flip */ {
                    for (y = sy;y <= ey;y++) {
                        bm = dest->line[y] + sx;
                        sd = (const unsigned char *)(gfx->gfxdata->line[start] + gfx->width -1 - (sx-ox));
                        for (x = sx ;x <= ex;x++) {
                            col = *(sd--);
                            if (col != transparent_color) *bm = paldata[col];
                            bm++;
                        }
                        start+=dy;
                    }
                } else        /* normal */ {
                    for (y = sy;y <= ey;y++) {
                        bm = dest->line[y] + sx;
                        sd = (const unsigned char *)(gfx->gfxdata->line[start] + (sx-ox));
                        for (x = sx;x <= ex;x++) {
                            col = *(sd++);
                            if (col != transparent_color) *bm = paldata[col];
                            bm++;
                        }
                        start+=dy;
                    }
                }
                break;

            case TRANSPARENCY_COLOR:
                if (flipx)    /* X flip */ {
                    for (y = sy;y <= ey;y++) {
                        bm = dest->line[y] + sx;
                        sd = gfx->gfxdata->line[start] + gfx->width-1 - (sx-ox);
                        for (x = sx;x <= ex;x++) {
                            col = paldata[*(sd--)];
                            if (col != transparent_color) *bm = col;
                            bm++;
                        }
                        start+=dy;
                    }
                } else        /* normal */ {
                    for (y = sy;y <= ey;y++) {
                        bm = dest->line[y] + sx;
                        sd = gfx->gfxdata->line[start] + (sx-ox);
                        for (x = sx;x <= ex;x++) {
                            col = paldata[*(sd++)];
                            if (col != transparent_color) *bm = col;
                            bm++;
                        }
                        start+=dy;
                    }
                }
                break;

            case TRANSPARENCY_THROUGH:
                if (flipx)    /* X flip */ {
                    for (y = sy;y <= ey;y++) {
                        bm = dest->line[y] + sx;
                        sd = gfx->gfxdata->line[start] + gfx->width-1 - (sx-ox);
                        for (x = sx;x <= ex;x++) {
                            if (*bm == transparent_color)
                                *bm = paldata[*sd];
                            bm++;
                            sd--;
                        }
                        start+=dy;
                    }
                } else        /* normal */ {
                    for (y = sy;y <= ey;y++) {
                        bm = dest->line[y] + sx;
                        sd = gfx->gfxdata->line[start] + (sx-ox);
                        for (x = sx;x <= ex;x++) {
                            if (*bm == transparent_color)
                                *bm = paldata[*sd];
                            bm++;
                            sd++;
                        }
                        start+=dy;
                    }
                }
                break;
        }
    } else {
        switch (transparency) {
            case TRANSPARENCY_NONE:        /* do a verbatim copy (faster) */
                if (flipx)    /* X flip */ {
                    for (y = sy;y <= ey;y++) {
                        bm = dest->line[y] + sx;
                        sd = gfx->gfxdata->line[start] + gfx->width-1 - (sx-ox);
                        for( x = sx ; x <= ex ; x++) *(bm++) = *(sd--);
                        start+=dy;
                    }
                } else        /* normal */ {
                    for (y = sy;y <= ey;y++) {
                        bm = dest->line[y] + sx;
                        sd = gfx->gfxdata->line[start] + (sx-ox);
                        memcpy(bm,sd,ex-sx+1);
                        start+=dy;
                    }
                }
                break;

            case TRANSPARENCY_PEN:
            case TRANSPARENCY_COLOR:
                if (flipx)    /* X flip */ {
                    for (y = sy;y <= ey;y++) {
                        bm = dest->line[y] + sx;
                        sd = (const unsigned char *)(gfx->gfxdata->line[start] + gfx->width -1 
- (sx-ox));
                        for (x = sx ;x <= ex;x++) {
                            col = *(sd--);
                            if (col != transparent_color) *bm = col;
                            bm++;
                        }
                        start+=dy;
                    }
                } else    /* normal */ {
                    for (y = sy;y <= ey;y++) {
                        bm = dest->line[y] + sx;
                        sd = (const unsigned char *)(gfx->gfxdata->line[start] + (sx-ox));
                        for (x = sx ;x <= ex;x++) {
                            col = *(sd++);
                            if (col != transparent_color) *bm = col;
                            bm++;
                        }
                        start+=dy;
                    }
                }
                break;

            case TRANSPARENCY_THROUGH:
                if (flipx)    /* X flip */ {
                    for (y = sy;y <= ey;y++) {
                        bm = dest->line[y] + sx;
                        sd = gfx->gfxdata->line[start] + gfx->width-1 - (sx-ox);
                        for (x = sx;x <= ex;x++) {
                            if (*bm == transparent_color) *bm = *sd;
                            bm++;
                            sd--;
                        }
                        start+=dy;
                    }
                } else        /* normal */ {
                    for (y = sy;y <= ey;y++) {
                        bm = dest->line[y] + sx;
                        sd = gfx->gfxdata->line[start] + (sx-ox);
                        for (x = sx;x <= ex;x++) {
                            if (*bm == transparent_color) *bm = *sd;
                            bm++;
                            sd++;
                        }
                        start+=dy;
                    }
                }
                break;
        }
    }
}

