/***************************************************************************

 Linux libGGI driver by Gabriele Boccone - clayton@dist.unige.it

  Something is recycled (and/or tweaked) from svgalib.c. This is only
  a "Quick and Dirty Hack"(TM) to make things interesting.

  Please if you test GGI-mame send me a mail, saying: "It works on my system"
  or "It does not work on my system", and what kind of computer you tested
  GGI-mame on. If you also want to send me sugar, coffee, chocolate, etc,
  feel free to send it by e-mail.

***************************************************************************/
#ifdef ggi
#define __GGI_C

#include <ggi/libggi.h>

#include "xmame.h"
#include "osdepend.h"
#include "driver.h"
#include "linux.c"	/* Mostly for audio devices. Should be easy to
			   replace with other OSs */

static int visual_width;
static int visual_height;
static int video_width;
static int video_height;
static ggi_visual_t vis;

/* Possible states of keys */
#define	RELEASED	0
#define	PRESSED		1

static unsigned char kstate[128];

/* Table needed to translate keysyms to pseudo-scancodes */
/* Using scancodes directly does not seem to work :( */

#define NR_KEYSYMS	65536	/* keysyms are unicode = 16 bit each */

static unsigned char codetable[NR_KEYSYMS];

void set_video_mode(void)
{
    int err;
    ggi_mode gmode;
    int type = GT_8BIT; /* 8-bit visual is enough for all games. I say */
    vis = ggiOpen(NULL);
    
    err = ggiSetGraphMode(vis, visual_width, visual_height, visual_width,
			  visual_height, type);

    /* err will probably be 0 only if we are in an X-window, but we need
       to draw into something anyway. 320x200 is not much, but it works */

 
    if (err) err = ggiSetGraphMode(vis, 320, 200, 320, 200, type);

    if (err) {
	fprintf (stderr, "Cannot set graphics mode. Exiting\n");
	exit(1);
    }

    ggiGetMode(vis, &gmode); /* Maybe we did not get what we asked for */
    if ((gmode.visible.x != visual_width)||
	(gmode.visible.y != visual_height)) {
	fprintf(stderr,
		"Warning: cannot get mode %dx%d, setting to %dx%d\n",
		visual_width, visual_height, gmode.visible.x,
		gmode.visible.y);
    }
    video_width = gmode.visible.x;
    video_height = gmode.visible.y;
}

struct osd_bitmap *osd_create_display(int width,int height,int totalcolors,
				      const unsigned char *palette,
				      unsigned char *pens,int attributes)
{
   int a,b;
   ggi_color cmap[256];
   bitmap = osd_create_bitmap(width,height);
   if (bitmap==NULL) return NULL;
   
   if( Machine->orientation & ORIENTATION_SWAP_XY) {
	int temp=width;
	width=height;
	height=temp;
   } 
   
   visual_width=width;
   visual_height=height;

   set_video_mode();
        
   /* Set the palette */
   if (totalcolors>256)
   {
      fprintf(stderr, "Warning: More than 256 colors (%d) are needed for this emulation\n", totalcolors);
      /* fill the remainder of the pens array with 0's to make sure */
      /* nothing strange happens                                    */
      for (a=256;a<totalcolors;a++) pens[a]=0;
      totalcolors=256;
   }
   
   if (totalcolors==256) /* better leave color 0 alone, but we need it */
      b=0;               /* if the emulation wants all 256 colors.     */
    else
      {
         b=1;
         cmap[0].r = 0; /* In this case we need color 0 to be black */
         cmap[0].g = 0; /* and GGI does not set it */
         cmap[0].b = 0; /* We do it here because we are sure it */
         pens[0] = 0;   /* will never change during the game */
      }
   for (a=0; a < totalcolors; a++)
   {
      cmap[a+b].r = palette[3*a] << 8;
      cmap[a+b].g = palette[3*a+1] << 8;
      cmap[a+b].b = palette[3*a+2] << 8;
      pens[a] = a+b;
   }
   ggiSetPaletteVec(vis, 0, 256, cmap); /* Since we have 256 colors, let's
					   use them all. */
   return bitmap;
}


/* shut up the display */
void osd_close_display(void)
{
   free(bitmap);
   ggiExit();
}

/* This is horrible, but seems to be the only way */

void osd_modify_pen(int pen,unsigned char red, unsigned char green, unsigned char blue)
{
   ggi_color gpen;
   gpen.r = red << 8;
   gpen.g = green << 8;
   gpen.b = blue << 8;
   ggiSetPaletteVec(vis, pen, 1, &gpen);
}

/* Same as above */
void osd_get_pen(int pen,unsigned char *red, unsigned char *green, unsigned char *blue)
{
    ggi_color gpen;
    ggiGetPaletteVec(vis, pen, 1, &gpen); /* (2) */
    *red   =  gpen.r >> 8 ; 
    *green =  gpen.g >> 8 ; 
    *blue  =  gpen.b >> 8 ;
}

void osd_mark_dirty(int x1, int y1, int x2, int y2, int ui)
{
   /* Not needed. Dirty enough even without it */
}

/* Update the display. */
void osd_update_display(void)
{
   /* This is surprisingly fast */
   ggiPutBox(vis, (video_width - bitmap->width)/2,
	     (video_height - bitmap->height)/2, bitmap->width,
	     bitmap->height, bitmap->_private);
}

int sysdep_keyboard_init(void) {

   /* I know what you are thinking. I did not write all this. I wrote
      a program to print both keysyms and scancodes. Something is
      still broken :( */

   memset(codetable, 0, NR_KEYSYMS); /* Not necessary? who knows? */

   codetable[61448] =	14;
   codetable[61449] =	15;
   codetable[61467] =	1;
   codetable[61468] =	99;
   codetable[61472] =	57;
   codetable[61479] =	40;
   codetable[61483] =	27;
   codetable[61484] =	51;
   codetable[61485] =	12;
   codetable[61486] =	52;
   codetable[61487] =	14;
   codetable[61488] =	11;
   codetable[61489] =	2;
   codetable[61490] =	3;
   codetable[61491] =	4;
   codetable[61492] =	5;
   codetable[61493] =	6;
   codetable[61494] =	7;
   codetable[61495] =	8;
   codetable[61496] =	9;
   codetable[61497] =	10;
   codetable[61499] =	39;
   codetable[61500] =	86;
   codetable[61501] =	13;
   codetable[61531] =	26;
   codetable[61532] =	43;
   codetable[61533] =	27;
   codetable[61536] =	41;
   codetable[61537] =	30;
   codetable[61538] =	48;
   codetable[61539] =	46;
   codetable[61540] =	32;
   codetable[61541] =	18;
   codetable[61542] =	33;
   codetable[61543] =	34;
   codetable[61544] =	35;
   codetable[61545] =	23;
   codetable[61546] =	36;
   codetable[61547] =	37;
   codetable[61548] =	38;
   codetable[61549] =	50;
   codetable[61550] =	49;
   codetable[61551] =	24;
   codetable[61552] =	25;
   codetable[61553] =	16;
   codetable[61554] =	19;
   codetable[61555] =	31;
   codetable[61556] =	20;
   codetable[61557] =	22;
   codetable[61558] =	47;
   codetable[61559] =	17;
   codetable[61560] =	45;
   codetable[61561] =	21;
   codetable[61562] =	44;
   codetable[61567] =	14;
   codetable[61664] =	40;
   codetable[61672] =	26;
   codetable[61676] =	13;
   codetable[61682] =	39;
   codetable[61689] =	43;
   codetable[61696] =	59;
   codetable[61697] =	60;
   codetable[61698] =	61;
   codetable[61699] =	62;
   codetable[61700] =	63;
   codetable[61701] =	64;
   codetable[61702] =	65;
   codetable[61703] =	66;
   codetable[61704] =	67;
   codetable[61705] =	68;
   codetable[61706] =	87;
   codetable[61707] =	88;
   codetable[61716] =	102;
   codetable[61717] =	110;
   codetable[61718] =	111;
   codetable[61719] =	107;
   codetable[61720] =	104;
   codetable[61721] =	109;
   codetable[61725] =	119;
   codetable[61953] =	28;
   codetable[61959] =	58;
   codetable[61960] =	69;
   codetable[61961] =	70;
   codetable[62208] =	82;
   codetable[62209] =	79;
   codetable[62210] =	80;
   codetable[62211] =	81;
   codetable[62212] =	75;
   codetable[62213] =	76;
   codetable[62214] =	77;
   codetable[62215] =	71;
   codetable[62216] =	72;
   codetable[62217] =	73;
   codetable[62218] =	78;
   codetable[62219] =	74;
   codetable[62220] =	55;
   codetable[62221] =	98;
   codetable[62222] =	96;
   codetable[62224] =	83;
   codetable[62976] =	80;
   codetable[62977] =	75;
   codetable[62978] =	77;
   codetable[62979] =	72;
   codetable[63232] =	42;
   codetable[63233] =	100;
   codetable[63234] =	29;
   codetable[63235] =	56;
   codetable[63236] =	42;
   codetable[63237] =	54;
   codetable[63238] =	29;
   codetable[63239] =	97;
   codetable[63248] =	58;
   codetable[64353] =	30;
   codetable[64354] =	48;
   codetable[64355] =	46;
   codetable[64356] =	32;
   codetable[64357] =	18;
   codetable[64358] =	33;
   codetable[64359] =	34;
   codetable[64360] =	35;
   codetable[64361] =	23;
   codetable[64362] =	36;
   codetable[64363] =	37;
   codetable[64364] =	38;
   codetable[64365] =	50;
   codetable[64366] =	49;
   codetable[64367] =	24;
   codetable[64368] =	25;
   codetable[64369] =	16;
   codetable[64370] =	19;
   codetable[64371] =	31;
   codetable[64372] =	20;
   codetable[64373] =	22;
   codetable[64374] =	47;
   codetable[64375] =	17;
   codetable[64376] =	45;
   codetable[64377] =	21;
   codetable[64378] =	44;
   codetable[76] =	96;

   return OSD_OK;
}

void sysdep_keyboard_close(void) { }

/* check if a key is pressed. The keycode is the standard PC keyboard code, as */
/* defined in osdepend.h. Return 0 if the key is not pressed, nonzero otherwise. */
int osd_key_pressed(int keycode)
{
   /* This is from DUMB, thanks to Willie Daniel (I don't know if he is DUMB
      too, he only gave me the source) :). We need something much simpler
      than DUMB keyboard handling is, anyway */

   ggi_event_mask em = emKeyPress | emKeyRelease;
   ggi_event ev;
   struct timeval t = {0, 0};

   while (ggiEventPoll(vis, em, &t)) {
      ggiEventRead (vis, &ev, em);
      
      switch (ev.any.type) {
         case evKeyPress:
	    kstate[codetable[ev.key.sym]] = PRESSED;
	    break;

         case evKeyRelease:
	    kstate[codetable[ev.key.sym]] = RELEASED;
      }
   }
   return kstate[keycode];
}


/*Wait for a keypress and return the key code. */
int osd_read_key(void)
{
   ggi_event ev;
   struct timeval *t = NULL;

   while (1) {
      ggiEventPoll(vis, emKeyPress, t);
      ggiEventRead (vis, &ev, emKeyPress);
      if ((ev.any.type == evKeyPress))
	 return (codetable[ev.key.sym]);
   }
}


/* src/msdos/msdos.c added in mame 0.22.1 Not sure why, so.... */
int osd_read_keyrepeat() 
{
	return osd_read_key();
}


int sysdep_mapkey(int from, int to) 
{
	return OSD_OK;
}

#endif /* ifdef ggi */
