/***************************************************************************

  inptport.c

  Input ports handling

TODO: remove the 1 analog device per port limitation

***************************************************************************/

#include "driver.h"


/* header identifying the version of the game.cfg file */
#define MAMECFGSTRING "MAMECFG\2"

extern int nocheat;

static unsigned char input_port_value[MAX_INPUT_PORTS];
static unsigned char input_vblank[MAX_INPUT_PORTS];

/* Assuming a maxium of one analog input device per port BW 101297 */
static struct NewInputPort *input_analog[MAX_INPUT_PORTS];
static int input_analog_value[MAX_INPUT_PORTS];

static int newgame = 1;

/***************************************************************************

  Obsolete functions which will eventually be removed

***************************************************************************/
static void old_load_input_port_settings(void)
{
	void *f;
	char buf[100];
	unsigned int i,j;
	unsigned int len,incount,keycount;


	incount = 0;
	while (Machine->gamedrv->input_ports[incount].default_value != -1) incount++;

	keycount = 0;
	while (Machine->gamedrv->keysettings[keycount].num != -1) keycount++;


		/* find the configuration file */
		if ((f = osd_fopen(Machine->gamedrv->name,0,OSD_FILETYPE_CONFIG,0)) != 0)
		{
			for (j=0; j < 4; j++)
			{
				if ((len = osd_fread(f,buf,4)) == 4)
				{
					len = (unsigned char)buf[3];
					buf[3] = '\0';
					if (stricmp(buf,"dsw") == 0) {
						if ((len == incount) && (osd_fread(f,buf,incount) == incount))
		{
			for (i = 0;i < incount;i++)
				Machine->gamedrv->input_ports[i].default_value = ((unsigned char)buf[i]);
		}
					} else if (stricmp(buf,"key") == 0) {
						if ((len == keycount) && (osd_fread(f,buf,keycount) == keycount))
		{
			for (i = 0;i < keycount;i++)
				Machine->gamedrv->input_ports[ Machine->gamedrv->keysettings[i].num ].keyboard[ Machine->gamedrv->keysettings[i].mask ] = ((unsigned char)buf[i]);
		}
					} else if (stricmp(buf,"joy") == 0) {
						if ((len == keycount) && (osd_fread(f,buf,keycount) == keycount))
		{
			for (i = 0;i < keycount;i++)
				Machine->gamedrv->input_ports[ Machine->gamedrv->keysettings[i].num ].joystick[ Machine->gamedrv->keysettings[i].mask ] = ((unsigned char)buf[i]);
		}
					}
			}
		}
		osd_fclose(f);
	}
}



static void old_save_input_port_settings(void)
{
	void *f;
	char buf[100];
	unsigned int i;
	unsigned int incount,keycount;


incount = 0;
while (Machine->gamedrv->input_ports[incount].default_value != -1) incount++;

keycount = 0;
while (Machine->gamedrv->keysettings[keycount].num != -1) keycount++;


				/* write the configuration file */
				if ((f = osd_fopen(Machine->gamedrv->name,0,OSD_FILETYPE_CONFIG,1)) != 0)
				{
						sprintf(buf, "dsw ");
						buf[3] = incount;
						osd_fwrite(f,buf,4);
	/* use buf as temporary buffer */
	for (i = 0;i < incount;i++)
		buf[i] = Machine->gamedrv->input_ports[i].default_value;
	osd_fwrite(f,buf,incount);

						sprintf(buf, "key ");
						buf[3] = keycount;
						osd_fwrite(f,buf,4);
	/* use buf as temporary buffer */
	for (i = 0;i < keycount;i++)
		buf[i] = Machine->gamedrv->input_ports[ Machine->gamedrv->keysettings[i].num ].keyboard[ Machine->gamedrv->keysettings[i].mask ];
	osd_fwrite(f,buf,keycount);

						sprintf(buf, "joy ");
						buf[3] = keycount;
						osd_fwrite(f,buf,4);
	/* use buf as temporary buffer */
	for (i = 0;i < keycount;i++)
		buf[i] = Machine->gamedrv->input_ports[ Machine->gamedrv->keysettings[i].num ].joystick[ Machine->gamedrv->keysettings[i].mask ];
	osd_fwrite(f,buf,keycount);

						osd_fclose(f);
				}
}



static void old_update_input_ports(void)
{
	int port;


	/* scan all the input ports */
	port = 0;
	while (Machine->gamedrv->input_ports[port].default_value != -1)
	{
		int res, i;
		struct InputPort *in;


		in = &Machine->gamedrv->input_ports[port];

		res = in->default_value;
		input_vblank[port] = 0;

		for (i = 7;i >= 0;i--)
		{
			int c;


			c = in->keyboard[i];
			if (c == IPB_VBLANK)
			{
				res ^= (1 << i);
				input_vblank[port] ^= (1 << i);
			}
			else
			{
				if (c && osd_key_pressed(c))
					res ^= (1 << i);
				else
				{
					c = in->joystick[i];
					if (c && osd_joy_pressed(c))
						res ^= (1 << i);
				}
			}
		}

		input_port_value[port] = res;
		port++;
	}
}
/***************************************************************************

  End of obsolete functions

***************************************************************************/








/***************************************************************************

  Configuration load/save

***************************************************************************/

static int readint(void *f,int *num)
{
	int i;


	*num = 0;
	for (i = 0;i < sizeof(int);i++)
	{
		unsigned char c;


		*num <<= 8;
		if (osd_fread(f,&c,1) != 1)
			return -1;
		*num |= c;
	}

	return 0;
}

static void writeint(void *f,int num)
{
	int i;


	for (i = 0;i < sizeof(int);i++)
	{
		unsigned char c;


		c = (num >> 8 * (sizeof(int)-1)) & 0xff;
		osd_fwrite(f,&c,1);
		num <<= 8;
	}
}

static int readip(void *f,struct NewInputPort *in)
{
	if (readint(f,&in->type) != 0)
		return -1;
	if (osd_fread(f,&in->mask,1) != 1)
		return -1;
	if (osd_fread(f,&in->default_value,1) != 1)
		return -1;
	if (readint(f,&in->keyboard) != 0)
		return -1;
	if (readint(f,&in->joystick) != 0)
		return -1;
	if (readint(f,&in->arg) != 0)
		return -1;

	return 0;
}

static void writeip(void *f,struct NewInputPort *in)
{
	writeint(f,in->type);
	osd_fwrite(f,&in->mask,1);
	osd_fwrite(f,&in->default_value,1);
	writeint(f,in->keyboard);
	writeint(f,in->joystick);
	writeint(f,in->arg);
}



void load_input_port_settings(void)
{
	void *f;


if (Machine->input_ports == 0)
{
	old_load_input_port_settings();
	return;
}

	if ((f = osd_fopen(Machine->gamedrv->name,0,OSD_FILETYPE_CONFIG,0)) != 0)
	{
		struct NewInputPort *in;
		int total,savedtotal;
		char buf[8];


		in = Machine->gamedrv->new_input_ports;

		/* calculate the size of the array */
		total = 0;
		while (in->type != IPT_END)
		{
			total++;
			in++;
		}

		/* read header */
		if (osd_fread(f,buf,8) != 8)
			goto getout;
		if (memcmp(buf,MAMECFGSTRING,8) != 0)
			goto getout;	/* header invalid */

		/* read array size */
		if (readint(f,&savedtotal) != 0)
			goto getout;
		if (total != savedtotal)
			goto getout;	/* different size */

		/* read the original settings and compare them with the ones defined in the driver */
		in = Machine->gamedrv->new_input_ports;
		while (in->type != IPT_END)
		{
			struct NewInputPort saved;


			if (readip(f,&saved) != 0)
				goto getout;
			if (in->type != saved.type ||
					in->mask != saved.mask ||
					in->default_value != saved.default_value ||
					in->keyboard != saved.keyboard ||
					in->joystick != saved.joystick ||
					in->arg != saved.arg)
				goto getout;	/* the default values are different */

			in++;
		}

		/* read the current settings */
		in = Machine->input_ports;
		newgame = 1;
		while (in->type != IPT_END)
		{
			if (readip(f,in) != 0)
				goto getout;

			in++;
		}

getout:
		osd_fclose(f);
	}
}



void save_input_port_settings(void)
{
	void *f;


if (Machine->input_ports == 0)
{
	old_save_input_port_settings();
	return;
}


	if ((f = osd_fopen(Machine->gamedrv->name,0,OSD_FILETYPE_CONFIG,1)) != 0)
	{
		struct NewInputPort *in;
		int total;


		in = Machine->gamedrv->new_input_ports;

		/* calculate the size of the array */
		total = 0;
		while (in->type != IPT_END)
		{
			total++;
			in++;
		}

		/* write header */
		osd_fwrite(f,MAMECFGSTRING,8);
		/* write array size */
		writeint(f,total);
		/* write the original settings as defined in the driver */
		in = Machine->gamedrv->new_input_ports;
		while (in->type != IPT_END)
		{
			writeip(f,in);
			in++;
		}
		/* write the current settings */
		in = Machine->input_ports;
		while (in->type != IPT_END)
		{
			writeip(f,in);
			in++;
		}

		osd_fclose(f);
	}
}





struct ipd
{
	int type;
	const char *name;
	int keyboard;
	int joystick;
};
struct ipd inputport_defaults[] =
{
	{ IPT_JOYSTICK_UP,        "Up",              OSD_KEY_UP,      OSD_JOY_UP },
	{ IPT_JOYSTICK_DOWN,      "Down",            OSD_KEY_DOWN,    OSD_JOY_DOWN },
	{ IPT_JOYSTICK_LEFT,      "Left",            OSD_KEY_LEFT,    OSD_JOY_LEFT },
	{ IPT_JOYSTICK_RIGHT,     "Right",           OSD_KEY_RIGHT,   OSD_JOY_RIGHT },
	{ IPT_JOYSTICK_UP    | IPF_PLAYER2, "2 Up",            OSD_KEY_R,       0 },
	{ IPT_JOYSTICK_DOWN  | IPF_PLAYER2, "2 Down",          OSD_KEY_F,       0 },
	{ IPT_JOYSTICK_LEFT  | IPF_PLAYER2, "2 Left",          OSD_KEY_D,       0 },
	{ IPT_JOYSTICK_RIGHT | IPF_PLAYER2, "2 Right",         OSD_KEY_G,       0 },
	{ IPT_JOYSTICK_UP    | IPF_PLAYER3, "3 Up",            0,               0 },
	{ IPT_JOYSTICK_DOWN  | IPF_PLAYER3, "3 Down",          0,               0 },
	{ IPT_JOYSTICK_LEFT  | IPF_PLAYER3, "3 Left",          0,               0 },
	{ IPT_JOYSTICK_RIGHT | IPF_PLAYER3, "3 Right",         0,               0 },
	{ IPT_JOYSTICK_UP    | IPF_PLAYER4, "4 Up",            0,               0 },
	{ IPT_JOYSTICK_DOWN  | IPF_PLAYER4, "4 Down",          0,               0 },
	{ IPT_JOYSTICK_LEFT  | IPF_PLAYER4, "4 Left",          0,               0 },
	{ IPT_JOYSTICK_RIGHT | IPF_PLAYER4, "4 Right",         0,               0 },
	{ IPT_JOYSTICKRIGHT_UP,    "Right/Up",        OSD_KEY_I,       OSD_JOY_FIRE2 },
	{ IPT_JOYSTICKRIGHT_DOWN,  "Right/Down",      OSD_KEY_K,       OSD_JOY_FIRE3 },
	{ IPT_JOYSTICKRIGHT_LEFT,  "Right/Left",      OSD_KEY_J,       OSD_JOY_FIRE1 },
	{ IPT_JOYSTICKRIGHT_RIGHT, "Right/Right",     OSD_KEY_L,       OSD_JOY_FIRE4 },
	{ IPT_JOYSTICKLEFT_UP,     "Left/Up",         OSD_KEY_E,       OSD_JOY_UP },
	{ IPT_JOYSTICKLEFT_DOWN,   "Left/Down",       OSD_KEY_D,       OSD_JOY_DOWN },
	{ IPT_JOYSTICKLEFT_LEFT,   "Left/Left",       OSD_KEY_S,       OSD_JOY_LEFT },
	{ IPT_JOYSTICKLEFT_RIGHT,  "Left/Right",      OSD_KEY_F,       OSD_JOY_RIGHT },
	{ IPT_JOYSTICKRIGHT_UP    | IPF_PLAYER2, "2 Right/Up",        0,               0 },
	{ IPT_JOYSTICKRIGHT_DOWN  | IPF_PLAYER2, "2 Right/Down",      0,               0 },
	{ IPT_JOYSTICKRIGHT_LEFT  | IPF_PLAYER2, "2 Right/Left",      0,               0 },
	{ IPT_JOYSTICKRIGHT_RIGHT | IPF_PLAYER2, "2 Right/Right",     0,               0 },
	{ IPT_JOYSTICKLEFT_UP     | IPF_PLAYER2, "2 Left/Up",         0,               0 },
	{ IPT_JOYSTICKLEFT_DOWN   | IPF_PLAYER2, "2 Left/Down",       0,               0 },
	{ IPT_JOYSTICKLEFT_LEFT   | IPF_PLAYER2, "2 Left/Left",       0,               0 },
	{ IPT_JOYSTICKLEFT_RIGHT  | IPF_PLAYER2, "2 Left/Right",      0,               0 },
	{ IPT_BUTTON1,             "Button 1",        OSD_KEY_LCONTROL,OSD_JOY_FIRE1 },
	{ IPT_BUTTON2,             "Button 2",        OSD_KEY_ALT,     OSD_JOY_FIRE2 },
	{ IPT_BUTTON3,             "Button 3",        OSD_KEY_SPACE,   OSD_JOY_FIRE3 },
	{ IPT_BUTTON4,             "Button 4",        OSD_KEY_LSHIFT,  OSD_JOY_FIRE4 },
	{ IPT_BUTTON5,             "Button 5",        OSD_KEY_Z,       0 },
	{ IPT_BUTTON1 | IPF_PLAYER2, "2 Button 1",        OSD_KEY_A,       0 },
	{ IPT_BUTTON2 | IPF_PLAYER2, "2 Button 2",        OSD_KEY_S,       0 },
	{ IPT_BUTTON3 | IPF_PLAYER2, "2 Button 3",        OSD_KEY_Q,       0 },
	{ IPT_BUTTON4 | IPF_PLAYER2, "2 Button 4",        OSD_KEY_W,       0 },
	{ IPT_BUTTON1 | IPF_PLAYER3, "3 Button 1",        0,               0 },
	{ IPT_BUTTON2 | IPF_PLAYER3, "3 Button 2",        0,               0 },
	{ IPT_BUTTON3 | IPF_PLAYER3, "3 Button 3",        0,               0 },
	{ IPT_BUTTON4 | IPF_PLAYER3, "3 Button 4",        0,               0 },
	{ IPT_BUTTON1 | IPF_PLAYER4, "4 Button 1",        0,               0 },
	{ IPT_BUTTON2 | IPF_PLAYER4, "4 Button 2",        0,               0 },
	{ IPT_BUTTON3 | IPF_PLAYER4, "4 Button 3",        0,               0 },
	{ IPT_BUTTON4 | IPF_PLAYER4, "4 Button 4",        0,               0 },
	{ IPT_COIN1,               "Coin A",          OSD_KEY_3,       IP_JOY_NONE },
	{ IPT_COIN2,               "Coin B",          OSD_KEY_4,       IP_JOY_NONE },
	{ IPT_COIN3,               "Coin C",          OSD_KEY_5,       IP_JOY_NONE },
	{ IPT_COIN4,               "Coin D",          OSD_KEY_6,       IP_JOY_NONE },
	{ IPT_TILT,                "Tilt",            OSD_KEY_T,       IP_JOY_NONE },
	{ IPT_START1,              "1 Player Start",  OSD_KEY_1,       IP_JOY_NONE },
	{ IPT_START2,              "2 Players Start", OSD_KEY_2,       IP_JOY_NONE },
	{ IPT_START3,              "3 Players Start", OSD_KEY_7,       IP_JOY_NONE },
	{ IPT_START4,              "4 Players Start", OSD_KEY_8,       IP_JOY_NONE },
	{ IPT_PADDLE,                "Paddle",            IPF_DEC(OSD_KEY_LEFT)    | IPF_INC(OSD_KEY_RIGHT)     | IPF_DELTA(4), \
	                                              IPF_DEC(OSD_JOY_LEFT) | IPF_INC(OSD_JOY_RIGHT) | IPF_DELTA(4) },
	{ IPT_PADDLE | IPF_PLAYER2,  "Paddle 2",          IPF_DELTA(4), IPF_DELTA(4) },
	{ IPT_PADDLE | IPF_PLAYER3,  "Paddle 3",          IPF_DELTA(4), IPF_DELTA(4) },
	{ IPT_PADDLE | IPF_PLAYER4,  "Paddle 4",          IPF_DELTA(4), IPF_DELTA(4) },
	{ IPT_DIAL,                "Dial",            IPF_DEC(OSD_KEY_Z)    | IPF_INC(OSD_KEY_X)     | IPF_DELTA(4), \
	                                              IPF_DEC(OSD_JOY_LEFT) | IPF_INC(OSD_JOY_RIGHT) | IPF_DELTA(4) },
	{ IPT_DIAL | IPF_PLAYER2,  "Dial 2",          IPF_DELTA(4), IPF_DELTA(4) },
	{ IPT_DIAL | IPF_PLAYER3,  "Dial 3",          IPF_DELTA(4), IPF_DELTA(4) },
	{ IPT_DIAL | IPF_PLAYER4,  "Dial 4",          IPF_DELTA(4), IPF_DELTA(4) },
	{ IPT_TRACKBALL_X,         "Trak X",          IPF_DEC(OSD_KEY_LEFT) | IPF_INC(OSD_KEY_RIGHT) | IPF_DELTA(4), \
	                                              IPF_DEC(OSD_JOY_LEFT) | IPF_INC(OSD_JOY_RIGHT) | IPF_DELTA(4) },
	{ IPT_TRACKBALL_X | IPF_PLAYER2, "Track X 2", IPF_DELTA(4), IPF_DELTA(4) },
	{ IPT_TRACKBALL_X | IPF_PLAYER3, "Track X 3", IPF_DELTA(4), IPF_DELTA(4) },
	{ IPT_TRACKBALL_X | IPF_PLAYER4, "Track X 4", IPF_DELTA(4), IPF_DELTA(4) },
	{ IPT_TRACKBALL_Y,         "Trak Y",          IPF_DEC(OSD_KEY_UP)   | IPF_INC(OSD_KEY_DOWN)  | IPF_DELTA(4), \
	                                              IPF_DEC(OSD_JOY_UP)   | IPF_INC(OSD_JOY_DOWN)  | IPF_DELTA(4) },
	{ IPT_TRACKBALL_Y | IPF_PLAYER2, "Track Y 2", IPF_DELTA(4), IPF_DELTA(4) },
	{ IPT_TRACKBALL_Y | IPF_PLAYER3, "Track Y 3", IPF_DELTA(4), IPF_DELTA(4) },
	{ IPT_TRACKBALL_Y | IPF_PLAYER4, "Track Y 4", IPF_DELTA(4), IPF_DELTA(4) },
	{ IPT_AD_STICK_X,          "AD Stick X",      IPF_DEC(OSD_KEY_LEFT) | IPF_INC(OSD_KEY_RIGHT) | IPF_DELTA(4), \
	                                              IPF_DEC(OSD_JOY_LEFT) | IPF_INC(OSD_JOY_RIGHT) | IPF_DELTA(4) },
	{ IPT_AD_STICK_X | IPF_PLAYER2, "AD Stick X 2", IPF_DELTA(4), IPF_DELTA(4) },
	{ IPT_AD_STICK_X | IPF_PLAYER3, "AD Stick X 3", IPF_DELTA(4), IPF_DELTA(4) },
	{ IPT_AD_STICK_X | IPF_PLAYER4, "AD Stick X 4", IPF_DELTA(4), IPF_DELTA(4) },
	{ IPT_AD_STICK_Y,          "AD Stick Y",      IPF_DEC(OSD_KEY_UP)   | IPF_INC(OSD_KEY_DOWN)  | IPF_DELTA(4), \
	                                              IPF_DEC(OSD_JOY_UP)   | IPF_INC(OSD_JOY_DOWN)  | IPF_DELTA(4) },
	{ IPT_AD_STICK_Y | IPF_PLAYER2, "AD Stick X 2", IPF_DELTA(4), IPF_DELTA(4) },
	{ IPT_AD_STICK_Y | IPF_PLAYER3, "AD Stick X 3", IPF_DELTA(4), IPF_DELTA(4) },
	{ IPT_AD_STICK_Y | IPF_PLAYER4, "AD Stick X 4", IPF_DELTA(4), IPF_DELTA(4) },
	{ IPT_UNKNOWN,             "UNKNOWN",         IP_KEY_NONE,     IP_JOY_NONE },
	{ IPT_END,                 0,                 IP_KEY_NONE,     IP_JOY_NONE }
};

/* Note that the following 3 routines have slightly different meanings with analog ports */
const char *default_name(const struct NewInputPort *in)
{
	int i;


	if (in->name != IP_NAME_DEFAULT) return in->name;

	i = 0;
	while (inputport_defaults[i].type != IPT_END &&
			inputport_defaults[i].type != (in->type & (~IPF_MASK | IPF_PLAYERMASK)))
		i++;

	return inputport_defaults[i].name;
}

int default_key(const struct NewInputPort *in)
{
	int i;


	if (in->keyboard == IP_KEY_PREVIOUS) in--;

	if (in->keyboard != IP_KEY_DEFAULT) return in->keyboard;

	i = 0;
	while (inputport_defaults[i].type != IPT_END &&
			inputport_defaults[i].type != (in->type & (~IPF_MASK | IPF_PLAYERMASK)))
		i++;

	return inputport_defaults[i].keyboard;
}

int default_joy(const struct NewInputPort *in)
{
	int i;


	if (in->joystick == IP_JOY_PREVIOUS) in--;

	if (in->joystick != IP_JOY_DEFAULT) return in->joystick;

	i = 0;
	while (inputport_defaults[i].type != IPT_END &&
			inputport_defaults[i].type != (in->type & (~IPF_MASK | IPF_PLAYERMASK)))
		i++;

	return inputport_defaults[i].joystick;
}

void update_analog_port(int port)
{
	struct NewInputPort *in;
	int current, delta, scaled_delta, type, sensitivity, clip, min, max;
	int axis, is_stick, check_bounds, anajoy;
	int inckey, deckey, keydelta, incjoy, decjoy, joydelta;
	int key,joy;


	/* get input definition */
	in=input_analog[port];
	if (nocheat && (in->type & IPF_CHEAT)) return;
	type=(in->type & ~IPF_MASK);

	key = default_key(in);
	joy = default_joy(in);

	deckey =   key & 0x000000ff;
	inckey =   (key & 0x0000ff00) >> 8;
	keydelta = (key & 0x00ff0000) >> 16;
	decjoy =   joy & 0x000000ff;
	incjoy =   (joy & 0x0000ff00) >> 8;
	/* I am undecided if the joydelta is really needed. LBO 120897 */
	/* We probably don't, but this teases the compiler. BW 120997 */
	joydelta = (joy & 0x00ff0000) >> 16;

	switch (type)
	{
		case IPT_PADDLE:
			axis = X_AXIS;
			is_stick = 0;
			check_bounds = 1;
			break;
		case IPT_DIAL:
			axis = X_AXIS;
			is_stick = 0;
			check_bounds = 0;
			break;
		case IPT_TRACKBALL_X:
			axis = X_AXIS;
			is_stick = 0;
			check_bounds = 0;
			break;
		case IPT_TRACKBALL_Y:
			axis = Y_AXIS;
			is_stick = 0;
			check_bounds = 0;
			break;
		case IPT_AD_STICK_X:
			axis = X_AXIS;
			is_stick = 1;
			check_bounds = 1;
			break;
		case IPT_AD_STICK_Y:
			axis = Y_AXIS;
			is_stick = 1;
			check_bounds = 1;
			break;
		default:
			/* Use some defaults to prevent crash */
			axis = X_AXIS;
			is_stick = 0;
			check_bounds = 0;
			if (errorlog)
				fprintf (errorlog,"Oops, polling non analog device in update_analog_port()????\n");
	}


	sensitivity = in->arg & 0x000000ff;
	clip = (in->arg & 0x0000ff00) >> 8;
	min = (in->arg & 0x00ff0000) >> 16;
	max = (in->arg & 0xff000000) >> 24;

	if (newgame || ((in->type & IPF_CENTER) && (!is_stick)))
		input_analog_value[port] = in->default_value * 16 / sensitivity;

	current = input_analog_value[port];

	delta = osd_trak_read(axis);

	if (osd_key_pressed(deckey)) delta -= keydelta;
	if (osd_key_pressed(inckey)) delta += keydelta;
	if (osd_joy_pressed(decjoy)) delta -= keydelta; /* LBO 120897 */
	if (osd_joy_pressed(incjoy)) delta += keydelta;

	/* Internally, we use 16=2^4 as default sensivity. 32 is twice as */
	/* sensitive, 8 half, and so on. The macro in driver.h translates */
	/* this to the old "percent" semantics, so there's no need to     */
	/* change the drivers. 101297 BW */

	scaled_delta = delta;

	if (clip != 0)
	{
		if (scaled_delta*sensitivity/16 < -clip)
			scaled_delta = -clip*16/sensitivity;
		else if (scaled_delta*sensitivity/16 > clip)
			scaled_delta = clip*16/sensitivity;
	}

	if (in->type & IPF_REVERSE) scaled_delta = -scaled_delta;

	if (is_stick)
	{
		if (axis == Y_AXIS) scaled_delta = -scaled_delta;
		if ((delta == 0) && (in->type & IPF_CENTER))
		{
			if (current * sensitivity / 16 > in->default_value)
			scaled_delta = -1;
			if (current * sensitivity / 16 < in->default_value)
			scaled_delta = 1;
		}

		/* perhaps there's a real analog joystick present? */
		/* osd_analog_joyread() returns values from -128 to 127 */

		anajoy=osd_analogjoy_read(axis);
		if (anajoy != NO_ANALOGJOY)
		{
			if ((in->type & IPF_REVERSE) && (axis==X_AXIS)) anajoy=-anajoy;
			if (!(in->type & IPF_REVERSE) && (axis==Y_AXIS)) anajoy=-anajoy;
			scaled_delta=0;
			current = (anajoy * (max-min)) / 256 + in->default_value;
		}
	}

	current += scaled_delta;

	if (check_bounds)
	{
		if (current*sensitivity/16 <= min)
			current=min*16/sensitivity;
		if (current*sensitivity/16 >= max)
			current=max*16/sensitivity;
	}

	input_analog_value[port]=current;

	input_port_value[port] &= ~in->mask;
	input_port_value[port] |= (current * sensitivity / 16) & in->mask;
}

void update_analog_ports(void)
{
	int port;

	for (port = 0;port < MAX_INPUT_PORTS;port++)
	{
		if (input_analog[port])
			update_analog_port(port);
	}
}

void update_input_ports(void)
{
	int i,port,ib;
	struct NewInputPort *in;
#define MAX_INPUT_BITS 1024
static int impulsecount[MAX_INPUT_BITS];
static int waspressed[MAX_INPUT_BITS];
#define MAX_JOYSTICKS 3
#define MAX_PLAYERS 4
int joystick[MAX_JOYSTICKS*MAX_PLAYERS][4];


if (Machine->input_ports == 0)
{
	old_update_input_ports();
}
else
{
	/* clear all the values before proceeding */
	for (port = 0;port < MAX_INPUT_PORTS;port++)
	{
		input_port_value[port] = 0;
		input_vblank[port] = 0;
		input_analog[port] = 0;
	}

	for (i = 0;i < 4*MAX_JOYSTICKS*MAX_PLAYERS;i++)
		joystick[i/4][i%4] = 0;

	in = Machine->input_ports;

	if (in->type == IPT_END) return; 	/* nothing to do */

	/* make sure the InputPort definition is correct */
	if (in->type != IPT_PORT)
	{
		if (errorlog) fprintf(errorlog,"Error in InputPort definition: expecting PORT_START\n");
		return;
	}
	else in++;

	/* scan all the input ports */
	port = 0;
	ib = 0;
	while (in->type != IPT_END && port < MAX_INPUT_PORTS)
	{
		struct NewInputPort *start;


		/* first of all, scan the whole input port definition and build the */
		/* default value. I must do it before checking for input because otherwise */
		/* multiple keys associated with the same input bit wouldn't work (the bit */
		/* would be reset to its default value by the second entry, regardless if */
		/* the key associated with the first entry was pressed) */
		start = in;
		while (in->type != IPT_END && in->type != IPT_PORT)
		{
			if ((in->type & ~IPF_MASK) != IPT_DIPSWITCH_SETTING)	/* skip dipswitch definitions */
			{
				input_port_value[port] =
						(input_port_value[port] & ~in->mask) | (in->default_value & in->mask);
			}

			in++;
		}

		/* now get back to the beginning of the input port and check the input bits. */
		in = start;
		while (in->type != IPT_END && in->type != IPT_PORT)
		{
			if ((in->type & ~IPF_MASK) != IPT_DIPSWITCH_SETTING &&	/* skip dipswitch definitions */
					(in->type & IPF_UNUSED) == 0 &&	/* skip unused bits */
					!(nocheat && (in->type & IPF_CHEAT))) /* skip cheats if cheats disabled */
			{
				if ((in->type & ~IPF_MASK) == IPT_VBLANK)
				{
					input_vblank[port] ^= in->mask;
					input_port_value[port] ^= in->mask;
				}
				/* If it's an analog control, handle it appropriately */
				else if (((in->type & ~IPF_MASK) > IPT_ANALOG_START)
					  && ((in->type & ~IPF_MASK) < IPT_ANALOG_END  )) /* LBO 120897 */
					{
						input_analog[port]=in;
						update_analog_port(port);
					}
				else
				{
					int key,joy;


					key = default_key(in);
					joy = default_joy(in);

					if ((key != 0 && key != IP_KEY_NONE && osd_key_pressed(key)) ||
							(joy != 0 && joy != IP_JOY_NONE && osd_joy_pressed(joy)))
					{
						if (in->type & IPF_IMPULSE)
						{
if (errorlog && in->arg == 0)
	fprintf(errorlog,"error in input port definition: IPF_IMPULSE with length = 0\n");
							if (waspressed[ib] == 0)
								impulsecount[ib] = in->arg;
								/* the input bit will be toggled later */
						}
						else if (in->type & IPF_TOGGLE)
						{
							if (waspressed[ib] == 0)
							{
								in->default_value ^= in->mask;
								input_port_value[port] ^= in->mask;
							}
						}
						else if ((in->type & ~IPF_MASK) >= IPT_JOYSTICK_UP &&
								(in->type & ~IPF_MASK) <= IPT_JOYSTICKLEFT_RIGHT)
						{
							int joynum,joydir,mask,player;


							player = 0;
							if ((in->type & IPF_PLAYERMASK) == IPF_PLAYER2) player = 1;
							else if ((in->type & IPF_PLAYERMASK) == IPF_PLAYER3) player = 2;
							else if ((in->type & IPF_PLAYERMASK) == IPF_PLAYER4) player = 3;

							joynum = player * MAX_JOYSTICKS +
									((in->type & ~IPF_MASK) - IPT_JOYSTICK_UP) / 4;
							joydir = ((in->type & ~IPF_MASK) - IPT_JOYSTICK_UP) % 4;

							mask = in->mask;

							/* avoid movement in two opposite directions */
							if (joystick[joynum][joydir ^ 1] != 0)
								mask = 0;

							if (in->type & IPF_4WAY)
							{
								int dir;


								/* avoid diagonal movements */
								for (dir = 0;dir < 4;dir++)
								{
									if (joystick[joynum][dir] != 0)
										mask = 0;
								}
							}

							joystick[joynum][joydir] = 1;

							input_port_value[port] ^= mask;
						}
						else
							input_port_value[port] ^= in->mask;

						waspressed[ib] = 1;
					}
					else
						waspressed[ib] = 0;

					if ((in->type & IPF_IMPULSE) && impulsecount[ib] > 0)
					{
						impulsecount[ib]--;
						waspressed[ib] = 1;
						input_port_value[port] ^= in->mask;
					}
				}
			}

			in++;
			ib++;
		}

		port++;
		if (in->type == IPT_PORT) in++;
	}
	newgame = 0;
}

{
	extern void *record;
	extern void *playback;

	if (playback)
		osd_fread(playback,input_port_value,MAX_INPUT_PORTS);
	else if (record)
		osd_fwrite(record,input_port_value,MAX_INPUT_PORTS);
}

}



int readinputport(int port)
{
	if (input_vblank[port])
	{
		/* I'm not yet sure about how long the vertical blanking should last, */
		/* I think it should be about 1/12th of the frame. */
		if (cpu_getfcount() < cpu_getfperiod() * 11 / 12)
		{
			input_port_value[port] ^= input_vblank[port];
			input_vblank[port] = 0;
		}
	}

	return input_port_value[port];
}

int input_port_0_r(int offset) { return readinputport(0); }
int input_port_1_r(int offset) { return readinputport(1); }
int input_port_2_r(int offset) { return readinputport(2); }
int input_port_3_r(int offset) { return readinputport(3); }
int input_port_4_r(int offset) { return readinputport(4); }
int input_port_5_r(int offset) { return readinputport(5); }
int input_port_6_r(int offset) { return readinputport(6); }
int input_port_7_r(int offset) { return readinputport(7); }
int input_port_8_r(int offset) { return readinputport(8); }
int input_port_9_r(int offset) { return readinputport(9); }
int input_port_10_r(int offset) { return readinputport(10); }
int input_port_11_r(int offset) { return readinputport(11); }
int input_port_12_r(int offset) { return readinputport(12); }
int input_port_13_r(int offset) { return readinputport(13); }
int input_port_14_r(int offset) { return readinputport(14); }
int input_port_15_r(int offset) { return readinputport(15); }
