/***************************************************************************

Jack the Giant Killer memory map (preliminary)

b400 - sound command? 0x1d = self-test?

Sound CPU appears to run in interrupt mode 1

***************************************************************************/

#include "driver.h"
#include "vidhrdw/generic.h"
#include "sndhrdw/generic.h"
#include "sndhrdw/8910intf.h"

/*#define TRYSOUND*/

void espial_vh_convert_color_prom(unsigned char *palette, unsigned char *colortable,const unsigned char *color_prom);
void jack_vh_screenrefresh(struct osd_bitmap *bitmap)
{
	int offs;


	/* for every character in the Video RAM, check if it has been modified */
	/* since last time and update it accordingly. */
	for (offs = videoram_size - 1;offs >= 0;offs--)
	{
		if (dirtybuffer[offs])
		{
			int sx,sy;


			dirtybuffer[offs] = 0;

			sx = offs % 32;
			sy = offs / 32;

			drawgfx(tmpbitmap,Machine->gfx[0],
					videoram[offs] + ((colorram[offs] & 0x30) << 4),
/*					colorram[offs] & 0x0f,*/
					0,
					0,0,
					8*sx,8*sy,
					&Machine->drv->visible_area,TRANSPARENCY_NONE,0);
		}
	}


	/* copy the temporary bitmap to the screen */
	copybitmap(bitmap,tmpbitmap,0,0,0,0,&Machine->drv->visible_area,TRANSPARENCY_NONE,0);

	/* draw sprites */
	for (offs = 0;offs < spriteram_size;offs += 4)
	{
		int sx,sy;
		int num, color;

		color = spriteram[offs + 2];
		num   = spriteram[offs + 3];
		sx =    spriteram[offs];
		sy =    spriteram[offs + 1];
/*		flipx = spriteram[offs] & 0x40;*/
/*		flipy = spriteram[offs] & 0x80;*/

		drawgfx(bitmap,Machine->gfx[1],
				num,
				color,
				0,0,
				sx,sy,
				&Machine->drv->visible_area,TRANSPARENCY_PEN,0);
	}

}

static int b506_r (int offset)
{
	return rand();
}

#ifdef TRYSOUND
/* Sound stuff */
static struct AY8910interface jack_interface =
{
	2,	/* 2 chips */
	1832727040,	/* 1.832727040 MHZ?????? */
	{ 255, 255 },
	{ 0 },
	{ 0 },
	{ 0 },
	{ 0 }
};


int jack_sh_start(void)
{
	pending_commands = 0;

	return AY8910_sh_start(&jack_interface);
}

void jack_sh_command_w(int offset,int data)
{
	sound_command_w(0,data);
	cpu_cause_interrupt(1,0xff);
}
#endif

static struct MemoryReadAddress readmem[] =
{
	{ 0x0000, 0x3fff, MRA_ROM },
	{ 0xc000, 0xffff, MRA_ROM },
	{ 0x4000, 0x5fff, MRA_RAM },
	{ 0x6000, 0x62ff, MRA_RAM },
	{ 0xb500, 0xb500, input_port_0_r },
	{ 0xb501, 0xb501, input_port_1_r },
	{ 0xb502, 0xb502, input_port_2_r },
	{ 0xb503, 0xb503, input_port_3_r },
	{ 0xb504, 0xb504, input_port_4_r },
	{ 0xb505, 0xb505, input_port_5_r },
/*	{ 0xb506, 0xb506, b506_r },*/
	{ 0xb000, 0xb07f, MRA_RAM },
	{ 0xb800, 0xbfff, MRA_RAM },
	{ -1 }	/* end of table */
};

static struct MemoryWriteAddress writemem[] =
{
	{ 0x0000, 0x3fff, MWA_ROM },
	{ 0x4000, 0x5fff, MWA_RAM },
	{ 0x6000, 0x62ff, MWA_RAM },
	{ 0xb000, 0xb07f, MWA_RAM, &spriteram, &spriteram_size },
#ifdef TRYSOUND
	{ 0xb400, 0xb400, jack_sh_command_w },
#endif
	{ 0xb800, 0xbbff, videoram_w, &videoram, &videoram_size },
	{ 0xbc00, 0xbfff, colorram_w, &colorram },
	{ 0xc000, 0xffff, MWA_ROM },
	{ -1 }	/* end of table */
};

#ifdef TRYSOUND
static struct MemoryReadAddress sound_readmem[] =
{
	{ 0x0000, 0x0fff, MRA_ROM },
	{ 0x4000, 0x43ff, MRA_RAM },
	{ -1 }	/* end of table */
};

static struct MemoryWriteAddress sound_writemem[] =
{
	{ 0x0000, 0x0fff, MWA_ROM },
	{ 0x4000, 0x43ff, MWA_RAM },
	{ -1 }	/* end of table */
};



static struct IOReadPort sound_readport[] =
{
	{ 0x40, 0x40, sound_command_latch_r },
/*	{ 0x20, 0x20, AY8910_read_port_1_r },*/
	{ -1 }	/* end of table */
};

static struct IOWritePort sound_writeport[] =
{
/*	{ 0x40, 0x40, AY8910_control_port_0_w },*/
/*	{ 0x80, 0x80, AY8910_write_port_0_w },*/
	{ 0x80, 0x80, AY8910_control_port_0_w },
	{ 0x40, 0x40, AY8910_write_port_0_w },
	{ -1 }	/* end of table */
};
#endif

INPUT_PORTS_START( input_ports )
	PORT_START	/* IN0 - DSW1 */
	PORT_BIT( 0xff, IP_ACTIVE_HIGH, IPT_UNKNOWN )

	PORT_START	/* DSW2 */
	PORT_BIT( 0xdf, IP_ACTIVE_HIGH, IPT_UNKNOWN )
	PORT_BITX ( 0x20, 0x00, IPT_DIPSWITCH_NAME | IPF_TOGGLE, "Service Mode", OSD_KEY_F2, IP_JOY_NONE, 0 )
	PORT_DIPSETTING ( 0x00, "Off" )
	PORT_DIPSETTING ( 0x20, "On" )

	PORT_START	/* IN2 */
	PORT_BIT( 0x01, IP_ACTIVE_HIGH, IPT_START1 )
	PORT_BIT( 0x02, IP_ACTIVE_HIGH, IPT_START2 )
	PORT_BIT( 0x1c, IP_ACTIVE_HIGH, IPT_UNKNOWN )
	PORT_BIT( 0x20, IP_ACTIVE_HIGH, IPT_COIN1 )
	PORT_BIT( 0x40, IP_ACTIVE_HIGH, IPT_COIN2 )

	PORT_START	/* IN3 */
	PORT_BIT( 0x01, IP_ACTIVE_HIGH, IPT_JOYSTICK_UP | IPF_4WAY )
	PORT_BIT( 0x02, IP_ACTIVE_HIGH, IPT_JOYSTICK_DOWN | IPF_4WAY )
	PORT_BIT( 0x04, IP_ACTIVE_HIGH, IPT_JOYSTICK_RIGHT | IPF_4WAY )
	PORT_BIT( 0x08, IP_ACTIVE_HIGH, IPT_JOYSTICK_LEFT | IPF_4WAY )
	PORT_BIT( 0x10, IP_ACTIVE_HIGH, IPT_JOYSTICK_UP | IPF_4WAY | IPF_PLAYER2 )
	PORT_BIT( 0x20, IP_ACTIVE_HIGH, IPT_JOYSTICK_DOWN | IPF_4WAY | IPF_PLAYER2 )
	PORT_BIT( 0x40, IP_ACTIVE_HIGH, IPT_JOYSTICK_RIGHT | IPF_4WAY | IPF_PLAYER2 )
	PORT_BIT( 0x80, IP_ACTIVE_HIGH, IPT_JOYSTICK_LEFT | IPF_4WAY | IPF_PLAYER2 )

	PORT_START	/* IN4 */
	PORT_BIT( 0x01, IP_ACTIVE_HIGH, IPT_BUTTON1 )
	PORT_BIT( 0x02, IP_ACTIVE_HIGH, IPT_JOYSTICK_UP | IPF_4WAY )
	PORT_BIT( 0x04, IP_ACTIVE_HIGH, IPT_JOYSTICK_DOWN | IPF_4WAY )
	PORT_BIT( 0x08, IP_ACTIVE_HIGH, IPT_JOYSTICK_RIGHT | IPF_4WAY )
	PORT_BIT( 0x10, IP_ACTIVE_HIGH, IPT_JOYSTICK_LEFT | IPF_4WAY )
	PORT_BIT( 0xe0, IP_ACTIVE_HIGH, IPT_UNUSED )

	PORT_START	/* IN5 */
	PORT_BIT( 0x01, IP_ACTIVE_HIGH, IPT_BUTTON1 | IPF_COCKTAIL )
	PORT_BIT( 0x02, IP_ACTIVE_HIGH, IPT_JOYSTICK_UP | IPF_4WAY | IPF_COCKTAIL )
	PORT_BIT( 0x04, IP_ACTIVE_HIGH, IPT_JOYSTICK_DOWN | IPF_4WAY | IPF_COCKTAIL )
	PORT_BIT( 0x08, IP_ACTIVE_HIGH, IPT_JOYSTICK_RIGHT | IPF_4WAY | IPF_COCKTAIL )
	PORT_BIT( 0x10, IP_ACTIVE_HIGH, IPT_JOYSTICK_LEFT | IPF_4WAY | IPF_COCKTAIL )
	PORT_BIT( 0xe0, IP_ACTIVE_HIGH, IPT_UNUSED )

INPUT_PORTS_END



static struct GfxLayout charlayout =
{
	8,8,	/* 8*8 characters */
	1024,	/* 1024 characters */
	2,	/* 2 bits per pixel */
	{ 0, 1024*8*8 },	/* the two bitplanes for 4 pixels are packed into one byte */
	{ 7*8, 6*8, 5*8, 4*8, 3*8, 2*8, 1*8, 0*8 },
	{ 0, 1, 2, 3, 4, 5, 6, 7 },
	8*8	/* every char takes 16 bytes */
};

static struct GfxLayout spritelayout =
{
	16,16,	/* 16*16 sprites */
	256,	/* 256 sprites */
	2,	/* 2 bits per pixel */
	{ 0, 256*16*16 },	/* the bitplanes are separated */
	{ 23*8, 22*8, 21*8, 20*8, 19*8, 18*8, 17*8, 16*8,
			7*8, 6*8, 5*8, 4*8, 3*8, 2*8, 1*8, 0*8 },
	{ 0, 1, 2, 3, 4, 5, 6, 7,	/* pretty straightforward layout */
			8*8+0, 8*8+1, 8*8+2, 8*8+3, 8*8+4, 8*8+5, 8*8+6, 8*8+7 },
	32*8	/* every sprite takes 32 consecutive bytes */
};


static struct GfxDecodeInfo gfxdecodeinfo[] =
{
	{ 1, 0x0000, &charlayout,    0, 64 },
	{ 1, 0x0000, &spritelayout,  0, 64 },
	{ -1 } /* end of array */
};



/* these are NOT the original color PROMs - they come from Espial */
static unsigned char color_prom[] =
{
	/* 1f - palette low 4 bits */
	0x00,0x00,0x06,0x00,0x03,0x00,0x06,0x00,0x00,0x00,0x07,0x00,0x00,0x08,0x08,0x05,
	0x00,0x0D,0x08,0x0A,0x00,0x00,0x00,0x00,0x00,0x0E,0x06,0x0F,0x00,0x00,0x00,0x00,
	0x00,0x0F,0x08,0x07,0x00,0x06,0x0F,0x0C,0x00,0x06,0x00,0x09,0x00,0x06,0x06,0x07,
	0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x07,0x00,0x00,0x00,0x0F,
	0x00,0x06,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x0F,0x05,0x0B,0x00,0x00,0x00,0x00,0x00,0x0F,0x07,0x06,0x00,0x0E,0x03,0x06,
	0x00,0x00,0x00,0x00,0x00,0x05,0x08,0x08,0x0D,0x02,0x06,0x00,0x0D,0x05,0x06,0x00,
	0x0D,0x07,0x06,0x00,0x00,0x07,0x06,0x0F,0x04,0x0F,0x07,0x06,0x0D,0x0F,0x07,0x06,
	0x04,0x00,0x00,0x06,0x04,0x09,0x00,0x06,0x04,0x06,0x03,0x02,0x00,0x07,0x06,0x00,
	0x00,0x00,0x06,0x04,0x04,0x00,0x06,0x00,0x00,0x04,0x02,0x05,0x0D,0x08,0x08,0x08,
	0x04,0x0D,0x03,0x0B,0x04,0x0B,0x03,0x0D,0x04,0x0D,0x03,0x00,0x04,0x0B,0x03,0x00,
	0x02,0x00,0x03,0x08,0x05,0x00,0x03,0x08,0x07,0x00,0x03,0x08,0x0D,0x05,0x06,0x04,
	0x00,0x08,0x03,0x08,0x0D,0x0D,0x00,0x02,0x00,0x0D,0x0C,0x02,0x00,0x00,0x00,0x00,
	0x0D,0x00,0x00,0x00,0x0D,0x00,0x06,0x00,0x00,0x0C,0x0E,0x02,0x00,0x02,0x03,0x08,
	0x00,0x0C,0x0E,0x02,0x00,0x0C,0x0D,0x08,0x0D,0x0B,0x02,0x03,0x0D,0x02,0x0B,0x0B,
	0x00,0x05,0x07,0x04,0x00,0x03,0x0C,0x08,0x0D,0x0A,0x06,0x00,0x0D,0x0A,0x06,0x00,
	/* 1h - palette high 4 bits */
	0x00,0x08,0x0F,0x0F,0x08,0x00,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x0E,0x0F,
	0x00,0x0F,0x0A,0x05,0x00,0x00,0x00,0x00,0x00,0x07,0x0F,0x0E,0x00,0x00,0x00,0x00,
	0x00,0x0F,0x07,0x07,0x00,0x0F,0x0E,0x0F,0x00,0x0F,0x0D,0x0E,0x00,0x0F,0x07,0x06,
	0x00,0x00,0x00,0x0E,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x01,
	0x00,0x0F,0x03,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x0F,0x0E,0x08,0x00,0x00,0x00,0x00,0x00,0x03,0x01,0x0F,0x00,0x03,0x0A,0x0F,
	0x00,0x00,0x00,0x00,0x00,0x0F,0x0E,0x0C,0x0E,0x01,0x0F,0x0F,0x0E,0x01,0x0F,0x0F,
	0x0E,0x04,0x0F,0x0F,0x00,0x01,0x0F,0x03,0x0A,0x02,0x01,0x0F,0x01,0x02,0x01,0x0F,
	0x0A,0x00,0x0F,0x0F,0x0A,0x09,0x00,0x0F,0x0A,0x0F,0x04,0x04,0x00,0x04,0x0F,0x0F,
	0x00,0x08,0x0F,0x0A,0x0A,0x08,0x0F,0x0F,0x00,0x0A,0x0A,0x0E,0x01,0x06,0x0B,0x01,
	0x0A,0x0E,0x0A,0x0E,0x0A,0x0E,0x0A,0x0E,0x0A,0x0E,0x0A,0x00,0x0A,0x0E,0x0A,0x00,
	0x01,0x0A,0x0F,0x05,0x01,0x0A,0x0F,0x05,0x01,0x0A,0x0F,0x05,0x01,0x0E,0x0F,0x0C,
	0x00,0x0E,0x0F,0x09,0x01,0x05,0x04,0x0E,0x04,0x05,0x01,0x0E,0x00,0x00,0x00,0x00,
	0x01,0x00,0x00,0x00,0x01,0x04,0x0F,0x00,0x00,0x0A,0x0F,0x0A,0x00,0x0E,0x0F,0x09,
	0x00,0x0A,0x0F,0x0A,0x00,0x0A,0x0F,0x05,0x01,0x08,0x04,0x05,0x01,0x04,0x08,0x05,
	0x00,0x0A,0x0F,0x04,0x00,0x0A,0x0F,0x09,0x01,0x00,0x02,0x00,0x01,0x00,0x02,0x00
};



static struct MachineDriver machine_driver =
{
	/* basic machine hardware */
	{
		{
			CPU_Z80,
			3072000,	/* 3.072 Mhz */
			0,
			readmem,writemem,0,0,
			interrupt,1
#ifdef TRYSOUND
		},
		{
			CPU_Z80 | CPU_AUDIO_CPU,
			2100000,	/* 2 Mhz?????? */
			2,	/* memory region #2 */
			sound_readmem,sound_writemem,sound_readport,sound_writeport,
			ignore_interrupt,1
#endif
		}
	},
	60,
	10,	/* 10 CPU slices per frame - enough for the sound CPU to read all commands */
	0,

	/* video hardware */
	32*8, 32*8, { 0*8, 32*8-1, 0*8, 32*8-1 },
	gfxdecodeinfo,
	256,256,
	espial_vh_convert_color_prom,

	VIDEO_TYPE_RASTER,
	0,
	generic_vh_start,
	generic_vh_stop,
	jack_vh_screenrefresh,

	/* sound hardware */
#ifdef TRYSOUND
	0,
	jack_sh_start,
	AY8910_sh_stop,
	AY8910_sh_update
#else
	0,0,0,0
#endif
};



/***************************************************************************

  Game driver(s)

***************************************************************************/

ROM_START( jack_rom )
	ROM_REGION(0x10000)	/* 64k for code */
	ROM_LOAD( "jgk.j8", 0x0000, 0x1000, 0x27e0c818 )
	ROM_LOAD( "jgk.j6", 0x1000, 0x1000, 0x97ab32d9 )
	ROM_LOAD( "jgk.j7", 0x2000, 0x1000, 0x4622cc4a )
	ROM_LOAD( "jgk.j5", 0x3000, 0x1000, 0xbfda4dce )
	ROM_LOAD( "jgk.j4", 0xc000, 0x1000, 0x9c7a8886 )
	ROM_LOAD( "jgk.j2", 0xd000, 0x1000, 0xe1862056 )
	ROM_LOAD( "jgk.j3", 0xe000, 0x1000, 0xd4cad17e )
	ROM_LOAD( "jgk.j1", 0xf000, 0x1000, 0x832bfd35 )

	ROM_REGION(0x4000)	/* temporary space for graphics (disposed after conversion) */
	ROM_LOAD( "jgk.j12",  0x0000, 0x1000, 0x6d506420 )
	ROM_LOAD( "jgk.j13",  0x1000, 0x1000, 0x31b999a7 )
	ROM_LOAD( "jgk.j11",  0x2000, 0x1000, 0x08957111 )
	ROM_LOAD( "jgk.j10",  0x3000, 0x1000, 0xecc2d6ac )

	ROM_REGION(0x10000)	/* 64k for the audio CPU */
	ROM_LOAD( "jgk.j9", 0x0000, 0x1000, 0x7b878165 )
ROM_END



struct GameDriver jack_driver =
{
	"Jack the Giant Killer",
	"jack",
	"Brad Oliver",
	&machine_driver,

	jack_rom,
	0, 0,
	0,
	0,	/* sound_prom */

	0/*TBR*/,input_ports,0/*TBR*/,0/*TBR*/,0/*TBR*/,

	color_prom, 0, 0,
	ORIENTATION_DEFAULT,

	0, 0
};
