/***************************************************************************



***************************************************************************/

#include "driver.h"
#include "vidhrdw/generic.h"
#include "sndhrdw/generic.h"
#include "sndhrdw/8910intf.h"

void arkanoid_vh_convert_color_prom(unsigned char *palette, unsigned char *colortable,const unsigned char *color_prom);

int arkanoid_vh_start (void) {return 0;}
void arkanoid_vh_stop (void) {}
void arkanoid_vh_screenrefresh (struct osd_bitmap *bitmap);

/* Machine stuff */
static int command0;
static int command1;

int arkanoid_d018_r (int offset)
{
	static int val;

	val ^= 0x55;
	if (command1 == 0x88)
		return readinputport (3);
	if (command1 == 0x8c)
		return readinputport (4);

	if (errorlog) fprintf (errorlog,"d018_r: %02x\n",val);
	return val;
}

int arkanoid_d001_r (int offset)
{
	/* This may also control the scoring */
	int val;

	if (command0 == 0x0f)
		return readinputport (2);
	else
		val = command0;

	if (errorlog) fprintf (errorlog,"d001_r: %02x\n",val);
	return val;
}

void arkanoid_d000_w (int offset, int data)
{
	if (data != command0)
		if (errorlog) fprintf (errorlog, "command0: %02x\n",data);
	command0 = data;
}

void arkanoid_d008_w (int offset, int data)
{
	if (data != command1)
		if (errorlog) fprintf (errorlog, "command1: %02x\n",data);
	command1 = data;
}
/* end machine stuff */

static struct MemoryReadAddress readmem[] =
{
	{ 0x0000, 0x7fff, MRA_ROM },
	{ 0xc000, 0xcfff, MRA_RAM },
	{ 0xd001, 0xd001, arkanoid_d001_r },
	{ 0xd00c, 0xd00c, input_port_0_r },
	{ 0xd010, 0xd010, input_port_1_r },
	{ 0xd018, 0xd018, arkanoid_d018_r },
	{ 0xe000, 0xe7ff, videoram_r, &videoram, &videoram_size },
	{ 0xe800, 0xefff, MRA_RAM },
	{ 0xf000, 0xffff, MRA_ROM },
	{ -1 }	/* end of table */
};

static struct MemoryWriteAddress writemem[] =
{
	{ 0x0000, 0xbfff, MWA_ROM },
	{ 0xc000, 0xcfff, MWA_RAM },
	{ 0xd000, 0xd000, arkanoid_d000_w },
	{ 0xd008, 0xd008, arkanoid_d008_w },
	{ 0xd010, 0xd010, MWA_NOP},
	{ 0xd018, 0xd018, MWA_NOP},
	{ 0xe000, 0xe7ff, videoram_w, &videoram, &videoram_size },
	{ 0xe800, 0xefff, MWA_RAM },
	{ 0xf000, 0xffff, MWA_ROM },
	{ -1 }	/* end of table */
};



INPUT_PORTS_START( input_ports )
	PORT_START	/* IN0 */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_START1 )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_START2 )
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_COIN3 )
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_TILT )
	PORT_BIT( 0x10, IP_ACTIVE_HIGH, IPT_COIN1 )
	PORT_BIT( 0x20, IP_ACTIVE_HIGH, IPT_COIN2 )
	PORT_BIT( 0x40, IP_ACTIVE_HIGH, IPT_VBLANK )
	PORT_BIT( 0x80, IP_ACTIVE_HIGH, IPT_VBLANK )

	PORT_START	/* IN1 */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_BUTTON1 )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_UNKNOWN )
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_BUTTON1 | IPF_COCKTAIL )
	PORT_BIT( 0xf8, IP_ACTIVE_LOW, IPT_UNKNOWN )

	PORT_START	/* DSW1 */
	PORT_DIPNAME( 0x01, 0x00, "Allow Continue", IP_KEY_NONE )
	PORT_DIPSETTING(    0x01, "No" )
	PORT_DIPSETTING(    0x00, "Yes" )
	PORT_DIPNAME( 0x02, 0x02, "Cabinet", IP_KEY_NONE )
	PORT_DIPSETTING(    0x02, "Upright" )
	PORT_DIPSETTING(    0x00, "Cocktail" )
	PORT_BITX ( 0x04, 0x04, IPT_DIPSWITCH_NAME | IPF_TOGGLE, "Service Mode", OSD_KEY_F2, IP_JOY_NONE, 0 )
	PORT_DIPSETTING ( 0x04, "Off" )
	PORT_DIPSETTING ( 0x00, "On" )
	PORT_DIPNAME( 0x08, 0x08, "Difficulty", IP_KEY_NONE )
	PORT_DIPSETTING(    0x08, "Easy" )
	PORT_DIPSETTING(    0x00, "Hard" )
	PORT_DIPNAME( 0x10, 0x10, "Bonus Life", IP_KEY_NONE )
	PORT_DIPSETTING(    0x10, "20000 60000" )
	PORT_DIPSETTING(    0x00, "20000" )
	PORT_DIPNAME( 0x20, 0x20, "Lives", IP_KEY_NONE )
	PORT_DIPSETTING(    0x20, "3" )
	PORT_DIPSETTING(    0x00, "5" )
	PORT_DIPNAME( 0xc0, 0xc0, "Coinage", IP_KEY_NONE )
	PORT_DIPSETTING(    0x80, "2 Coins/1 Credit" )
	PORT_DIPSETTING(    0xc0, "1 Coin/1 Credit" )
	PORT_DIPSETTING(    0x40, "1 Coin/2 Credit" )
	PORT_DIPSETTING(    0x00, "1 Coin/3 Credits" )

	PORT_START	/* IN3 -- p1 spinner */
	PORT_ANALOG( 0xff, 0x00, IPT_DIAL, 100, 0, 0, 0 )

	PORT_START	/* IN4 -- p2 spinner */
	PORT_ANALOG( 0xff, 0x00, IPT_DIAL, 100, 0, 0, 0 )

INPUT_PORTS_END

static struct GfxLayout charlayout =
{
	8,8,	/* 8*8 characters */
	4096,	/* 4096 characters */
	3,	/* 3 bits per pixel */
	{ 2*4096*8*8, 4096*8*8, 0 },	/* the two bitplanes are separated */
	{ 7*8, 6*8, 5*8, 4*8, 3*8, 2*8, 1*8, 0*8 },
	{ 0, 1, 2, 3, 4, 5, 6, 7 },
	8*8	/* every char takes 8 consecutive bytes */
};



static struct GfxDecodeInfo gfxdecodeinfo[] =
{
	{ 1, 0x00000, &charlayout,  0, 64 },
	{ -1 } /* end of array */
};


/* this is NOT the original color PROM */
static unsigned char arkanoid_color_prom[] =
{
	/* 07.bpr - palette red component */
	0x00,0x0F,0x0F,0x0F,0x00,0x00,0x00,0x0F,0x00,0x0F,0x0B,0x0B,0x00,0x00,0x00,0x0B,
	0x00,0x0F,0x07,0x07,0x00,0x00,0x00,0x07,0x00,0x00,0x04,0x04,0x00,0x00,0x00,0x04,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x0A,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x0F,0x0B,0x08,0x06,0x00,
	0x00,0x00,0x0F,0x0F,0x0B,0x08,0x06,0x00,0x00,0x00,0x0F,0x0F,0x0B,0x08,0x06,0x00,
	0x00,0x00,0x0F,0x0F,0x0B,0x08,0x06,0x00,0x00,0x0F,0x0F,0x0B,0x00,0x00,0x00,0x00,
	0x00,0x0F,0x00,0x00,0x0F,0x0B,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x00,0x0F,0x0B,
	0x00,0x00,0x0F,0x0F,0x0C,0x09,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x0A,
	0x00,0x00,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x0F,0x0F,0x0A,0x00,0x00,
	0x00,0x00,0x0F,0x0F,0x0F,0x0D,0x00,0x00,0x00,0x00,0x0F,0x0F,0x00,0x00,0x0F,0x0C,
	0x00,0x00,0x0F,0x0D,0x0B,0x08,0x05,0x0F,0x02,0x04,0x06,0x08,0x0A,0x0C,0x0E,0x0F,
	0x00,0x00,0x0E,0x0F,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x0F,0x0F,0x0C,0x09,0x08,
	0x00,0x00,0x0F,0x0F,0x0C,0x0A,0x0F,0x00,0x00,0x00,0x0F,0x0F,0x0F,0x0D,0x0B,0x09,
	0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x0F,0x05,0x0D,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x0F,0x08,0x00,0x00,0x05,
	0x00,0x0F,0x0F,0x0F,0x00,0x00,0x00,0x0F,0x00,0x0F,0x00,0x0F,0x0F,0x08,0x0A,0x00,
	0x00,0x00,0x0F,0x0D,0x0B,0x09,0x07,0x0A,0x00,0x00,0x0F,0x0D,0x0B,0x09,0x07,0x0A,
	0x00,0x00,0x0F,0x0D,0x0B,0x09,0x07,0x0A,0x00,0x00,0x0F,0x0D,0x0B,0x09,0x07,0x0A,
	0x00,0x00,0x0F,0x0D,0x0B,0x09,0x07,0x0A,0x00,0x00,0x0F,0x0D,0x0B,0x09,0x07,0x09,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x0F,0x0B,0x08,0x06,0x00,
	0x00,0x00,0x0F,0x0F,0x0B,0x08,0x06,0x00,0x00,0x00,0x0F,0x0F,0x0B,0x08,0x06,0x00,
	0x00,0x00,0x0F,0x0F,0x0B,0x08,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x0A,0x07,0x00,0x00,0x00,
	0x00,0x00,0x0F,0x0D,0x0B,0x09,0x07,0x0A,0x00,0x00,0x0F,0x0F,0x0C,0x0A,0x08,0x07,
	0x00,0x00,0x0F,0x0B,0x09,0x08,0x0F,0x00,0x00,0x0F,0x05,0x05,0x05,0x02,0x0C,0x09,
	0x00,0x0F,0x06,0x06,0x06,0x04,0x0D,0x0A,0x00,0x0F,0x07,0x07,0x07,0x06,0x0E,0x0B,
	0x00,0x0F,0x08,0x08,0x08,0x08,0x0F,0x0C,0x00,0x0F,0x00,0x00,0x00,0x00,0x0B,0x08,
	0x00,0x00,0x0F,0x0D,0x0B,0x09,0x07,0x08,0x00,0x00,0x0F,0x0D,0x0B,0x09,0x07,0x07,
	0x00,0x00,0x0F,0x0D,0x0B,0x09,0x07,0x06,0x00,0x00,0x0F,0x0D,0x0B,0x09,0x07,0x05,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x00,0x0B,0x08,
	0x00,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x0D,0x0B,0x09,0x07,0x00,
	/* 08.bpr - palette green component */
	0x00,0x0F,0x00,0x0F,0x0F,0x0F,0x00,0x0F,0x00,0x00,0x00,0x0B,0x0B,0x0B,0x00,0x0B,
	0x00,0x0F,0x00,0x07,0x07,0x07,0x00,0x07,0x00,0x0F,0x00,0x04,0x04,0x04,0x00,0x04,
	0x00,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x07,0x05,0x03,0x03,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x05,0x02,0x08,0x06,0x00,
	0x00,0x00,0x0F,0x05,0x02,0x08,0x06,0x00,0x00,0x00,0x0F,0x05,0x02,0x08,0x06,0x08,
	0x00,0x00,0x0F,0x05,0x02,0x08,0x06,0x0F,0x00,0x0F,0x00,0x00,0x0F,0x0B,0x0F,0x0B,
	0x00,0x0F,0x0F,0x0B,0x00,0x00,0x0F,0x0B,0x00,0x0F,0x0F,0x0B,0x0F,0x0B,0x00,0x00,
	0x00,0x00,0x0F,0x00,0x00,0x00,0x0A,0x00,0x00,0x00,0x0F,0x0F,0x0A,0x08,0x00,0x00,
	0x00,0x00,0x0F,0x0A,0x08,0x00,0x00,0x00,0x00,0x00,0x0F,0x0F,0x00,0x00,0x00,0x00,
	0x00,0x00,0x0F,0x0F,0x0A,0x08,0x0F,0x0A,0x00,0x00,0x0F,0x0F,0x0F,0x0A,0x00,0x00,
	0x00,0x00,0x0F,0x0B,0x07,0x00,0x00,0x05,0x02,0x04,0x06,0x08,0x0A,0x0C,0x0E,0x00,
	0x00,0x00,0x0E,0x08,0x0F,0x0F,0x00,0x07,0x00,0x00,0x0F,0x00,0x0F,0x0C,0x09,0x08,
	0x00,0x00,0x0F,0x09,0x0F,0x0F,0x09,0x08,0x00,0x00,0x0F,0x09,0x0F,0x0C,0x0A,0x08,
	0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x00,0x0A,0x08,0x06,0x06,0x00,0x00,
	0x0F,0x05,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x05,0x08,0x00,0x08,0x05,
	0x00,0x0F,0x00,0x0F,0x0F,0x0F,0x00,0x0F,0x00,0x00,0x00,0x0F,0x05,0x08,0x00,0x0B,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x05,0x02,0x08,0x06,0x00,
	0x00,0x00,0x0F,0x05,0x02,0x08,0x06,0x00,0x00,0x00,0x0F,0x05,0x02,0x08,0x06,0x08,
	0x00,0x00,0x0F,0x05,0x02,0x08,0x06,0x0F,0x00,0x0F,0x08,0x00,0x00,0x00,0x00,0x00,
	0x00,0x0F,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x0A,0x07,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x07,0x00,0x00,0x00,0x00,
	0x00,0x00,0x0F,0x0B,0x09,0x08,0x00,0x00,0x00,0x04,0x07,0x05,0x00,0x00,0x0B,0x08,
	0x00,0x03,0x07,0x05,0x00,0x00,0x0B,0x08,0x00,0x02,0x07,0x05,0x00,0x00,0x0B,0x08,
	0x00,0x01,0x07,0x05,0x00,0x00,0x0B,0x08,0x00,0x0F,0x07,0x05,0x00,0x00,0x0B,0x08,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x0A,0x09,0x06,0x00,0x00,0x00,0x00,0x05,0x07,0x05,0x00,0x00,0x0B,0x08,
	0x00,0x0F,0x0F,0x0A,0x08,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,
	/* 09.bpr - palette blue component */
	0x00,0x0F,0x00,0x00,0x0F,0x00,0x0F,0x0F,0x00,0x00,0x00,0x00,0x0B,0x00,0x0B,0x0B,
	0x00,0x00,0x00,0x00,0x07,0x00,0x07,0x07,0x00,0x0F,0x00,0x00,0x04,0x00,0x04,0x04,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x07,0x06,0x05,0x04,0x03,0x00,
	0x00,0x00,0x00,0x00,0x00,0x09,0x04,0x00,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x00,0x00,0x08,0x06,0x00,
	0x00,0x00,0x0F,0x00,0x00,0x08,0x06,0x09,0x00,0x00,0x0F,0x00,0x00,0x08,0x06,0x0F,
	0x00,0x00,0x0F,0x00,0x00,0x08,0x06,0x0F,0x00,0x0F,0x00,0x00,0x0F,0x0F,0x00,0x00,
	0x00,0x0F,0x00,0x00,0x00,0x00,0x0F,0x0F,0x00,0x0F,0x0F,0x0F,0x00,0x00,0x00,0x00,
	0x00,0x00,0x0F,0x00,0x00,0x00,0x0A,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x0F,0x0F,0x0F,0x0C,0x0A,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x0A,
	0x00,0x00,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x00,0x0F,0x0F,0x0F,0x0C,
	0x00,0x00,0x0F,0x0F,0x0F,0x0B,0x07,0x00,0x02,0x04,0x06,0x08,0x0A,0x0C,0x0E,0x00,
	0x00,0x00,0x0E,0x00,0x0F,0x00,0x00,0x0F,0x00,0x00,0x0F,0x0F,0x00,0x0C,0x09,0x08,
	0x00,0x00,0x0F,0x00,0x0F,0x0A,0x09,0x0F,0x00,0x00,0x0F,0x0F,0x0C,0x00,0x00,0x00,
	0x0F,0x0B,0x0A,0x09,0x08,0x07,0x06,0x00,0x0F,0x00,0x00,0x00,0x00,0x0C,0x07,0x00,
	0x0F,0x05,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x00,0x08,0x07,0x00,0x05,
	0x02,0x0F,0x00,0x00,0x0F,0x00,0x0F,0x0F,0x02,0x00,0x00,0x0F,0x00,0x08,0x00,0x0B,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0A,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0C,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0D,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x00,0x00,0x08,0x06,0x00,
	0x00,0x00,0x0F,0x00,0x00,0x08,0x06,0x0C,0x00,0x00,0x0F,0x00,0x00,0x08,0x06,0x0F,
	0x00,0x00,0x0F,0x00,0x00,0x08,0x06,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x0A,0x07,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x0F,0x0B,0x09,0x08,0x00,0x00,0x02,0x00,0x0B,0x0A,0x08,0x00,0x0B,0x08,
	0x02,0x00,0x0B,0x0A,0x08,0x00,0x0B,0x08,0x02,0x00,0x0B,0x0A,0x08,0x00,0x0B,0x08,
	0x02,0x00,0x0B,0x0A,0x08,0x00,0x0B,0x08,0x02,0x00,0x0B,0x0A,0x08,0x00,0x0B,0x08,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0B,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x09,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x05,
	0x02,0x00,0x0F,0x09,0x06,0x00,0x00,0x00,0x02,0x00,0x0B,0x0A,0x08,0x00,0x0B,0x08,
	0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F
};



static int arkanoid_interrupt(void)
{
	static int count;


	count++;
	if (count & 1) return ignore_interrupt();
	else return interrupt();
}

static struct MachineDriver machine_driver =
{
	/* basic machine hardware */
	{
		{
			CPU_Z80,
			6000000,	/* 6 Mhz ?? */
			0,
			readmem,writemem,0,0,
			arkanoid_interrupt,1
		},
	},
	60,
	1,
	0,

	/* video hardware */
	32*8, 32*8, { 2*8, 30*8, 0*8, 32*8 },
	gfxdecodeinfo,
	256,64*8,
	arkanoid_vh_convert_color_prom,

	VIDEO_TYPE_RASTER,
	0,
	generic_vh_start,
	generic_vh_stop,
	arkanoid_vh_screenrefresh,

	/* sound hardware */
	0,
	0,
	0,
	0
};



/***************************************************************************

  Game driver(s)

***************************************************************************/

ROM_START( arkanoid_rom )
	ROM_REGION(0x10000)	/* 64k for code */
	ROM_LOAD( "a75_01-1.rom", 0x0000, 0x8000, 0x3f362d52 )
	ROM_LOAD( "a75_11.rom",   0x8000, 0x8000, 0x0f946676 )

	ROM_REGION(0x18000)	/* temporary space for graphics (disposed after conversion) */
	ROM_LOAD( "a75_03.rom",  0x00000, 0x8000, 0x08db46ed )
	ROM_LOAD( "a75_04.rom",  0x08000, 0x8000, 0x56e6b2de )
	ROM_LOAD( "a75_05.rom",  0x10000, 0x8000, 0x861d955f )
ROM_END

ROM_START( arknoidu_rom )
	ROM_REGION(0x10000)	/* 64k for code */
	ROM_LOAD( "a75-19.bin", 0x0000, 0x8000, 0xdf73005f )
	ROM_LOAD( "a75-18.bin",   0x8000, 0x8000, 0xb416b738 )

	ROM_REGION(0x18000)	/* temporary space for graphics (disposed after conversion) */
	ROM_LOAD( "a75-03.bin",  0x00000, 0x8000, 0x08db46ed )
	ROM_LOAD( "a75-04.bin",  0x08000, 0x8000, 0x56e6b2de )
	ROM_LOAD( "a75-05.bin",  0x10000, 0x8000, 0x861d955f )
ROM_END


/* Looks like high score values start at $6600 and high score initials at $6700 */

struct GameDriver arkanoid_driver =
{
	"Arkanoid",
	"arkanoid",
	"Brad Oliver",
	&machine_driver,

	arkanoid_rom,
	0, 0,
	0,
	0,	/* sound_prom */

	0/*TBR*/,input_ports,0/*TBR*/,0/*TBR*/,0/*TBR*/,

	arkanoid_color_prom, 0, 0,
	ORIENTATION_DEFAULT,

	0, 0
};

struct GameDriver arknoidu_driver =
{
	"Arkanoid (U.S. Romstar)",
	"arknoidu",
	"Brad Oliver",
	&machine_driver,

	arknoidu_rom,
	0, 0,
	0,
	0,	/* sound_prom */

	0/*TBR*/,input_ports,0/*TBR*/,0/*TBR*/,0/*TBR*/,

	arkanoid_color_prom, 0, 0,
	ORIENTATION_DEFAULT,

	0, 0
};
