#include <stdio.h>
#include <string.h>
#include <errno.h>

int 
main (int argc, char **argv)
{
  int n,i,len;
  int status;
  FILE *fpin, *fpout;
  char input_filename[BUFSIZ], output_filename[BUFSIZ];
  char buffer[BUFSIZ];

  if (argc < 2)
    {
      printf("Usage: fix [sourcefilenames]\n");
      return 1;
    }

  /* multiple argument */
  for (n = 1; n < argc; n++)
    {
      strcpy (output_filename, argv[n]);	/* filename to write */
      strcpy (input_filename, argv[n]);

      if ((fpin = fopen (input_filename, "r")) == NULL)
	{
          printf ("Error opening input file %s\n",input_filename);
          printf ("Continuing with next file\n");
	  continue;
	}

      strcat (input_filename, ".orig");	/* filename to backup */

      if (rename (output_filename, input_filename)==-1)
        {
          printf ("Error renaming %s to %s\n",output_filename,input_filename);
          printf ("Continuing with next file\n");
          continue;
        } 

      if ((fpout = fopen (output_filename, "w")) == NULL)
	{
          printf ("Error opening output file %s\n",output_filename);
          printf ("Continuing with next file\n");
	  continue;
	}
	
      status=0;
	
      while (fgets (buffer, BUFSIZ, fpin) != NULL)
	{
	  len = strlen(buffer);
	  /* strip newline */
	  if (buffer[len-1]=='\n') len--;
	  /* if dos format and len > 0, strip cariage return */ 
	  if (len)
	     if (buffer[len-1]==0x0D) len--;
          
  	  for (i=0;i<len;i++)
	  {
	    switch (status)
	    {
	    
	      case 0: /* nothing found sofar */
	        if (buffer[i]=='/') status=1;
	        break;
	      case 1: /* found a / */
	        switch (buffer[i])
	        {
	          case '*':
	            status=2;
	            break;
	          case '/': /* found cpp-style comment bah */
	            buffer[i]='*';
	            buffer[len]='*';
	            buffer[len+1]='/';
	            len+=2;
	            status=4;
	            break;
	          default :
	            status=0;
	            break;
	        }
	        break;
	      case 2: /* currently in old-style commented  text */
	        if (buffer[i]=='*') status=3;
	        break;
	      case 3: /* in old-style comment, found * */
	        switch (buffer[i])
	        {
	          case '/':
	            status=0;
	            break;
	          case '*':
	            break;
	          default:
	            status=2;
	        }
	        break; 
	      case 4: /* in cpp-style comment */
	        if (buffer[i]=='/')status=5;
	        if (buffer[i]=='*')status=6;
	        break;
	      case 5: /* in cpp-style comment, found / */
	        if (buffer[i]=='*')
	        {
	          buffer[i-1]=' ';
	          buffer[i]  =' ';
	        }
	        status=4;
	        break;  
	      case 6: /* in cpp-style comment, found * */
	        if (buffer[i]=='/' && i<(len-1))
	        {
	          buffer[i-1]=' ';
	          buffer[i]  =' ';
	          status=4;
	        }
	        else if (buffer[i]=='/' && i==(len-1))
	          status=0;
                else
                  status=4; 
	        break;
	    }  
	  }
	  /* add newline */
	  buffer[len]='\n';
	  buffer[len+1]=0;
	  fputs (buffer, fpout); 
	}

      fclose (fpout);
      fclose (fpin);
    }

  return 0;
}
