/* World objects for Hyperplay
   Copyright (C) 1996, 1997, 1999 Hypercore Software Design, Ltd.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307, USA.  */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#undef const

#include <hyperplay/world.h>

using namespace std;
using namespace hyperplay;

//
// world implementation.
//

// Pack "long" data.
template <class OutputIterator, class T>
inline OutputIterator
hplay_pack_long (OutputIterator i, T x)
{
  *i++ = (x >> (3 * 8)) & 0xff;
  *i++ = (x >> (2 * 8)) & 0xff;
  *i++ = (x >> 8) & 0xff;
  *i++ = x & 0xff;
  return i;
}

long
world::var(unsigned long d, unsigned long name) const
{
  const_iterator found_domain = find(d);
  if (found_domain != end())
    {
      domain::const_iterator found = found_domain->second.find(name);
      if (found != found_domain->second.end())
	return found->second.n_value;
    }
  return 0;
}

void
world::set_var(unsigned long d, unsigned long name, long value)
{
  (*this)[d][name] = value;
}

// Save a world into CHUNK.
void
world::save (const data_chunk_type &chunk) const
{
  vector <char> data;
  data.push_back (1);		// format version
  data.push_back (0);		// reserved
  for (const_iterator i = begin (),
	 n = end ();
       i != n;
       ++ i)
    {
      data.push_back (1);
      hplay_pack_long (back_inserter (data), (*i).first);
      for (domain::const_iterator
	     j = (*i).second.begin (),
	     m = (*i).second.end ();
	   j != m;
	   ++j)
	{
	  data.push_back (1);
	  hplay_pack_long (back_inserter (data), (*j).first);
	  hplay_pack_long (back_inserter (data), (*j).second.n_value);
	}
      data.push_back (0);	// end of variable sequence
    }
  data.push_back (0);		// end of domain sequence
  chunk.store (data.begin (), data.end ());
}

// Load a world out of CHUNK.  The previous world will be lost.
void
world::load (const data_chunk_type &chunk)
{
  vector <char> data;
  chunk.load (data);
  vector <char>::const_iterator i = data.begin ();
  vector <char>::const_iterator n = data.end ();
  world new_omap;
  if (n - i >= 3 && *i++ == 1)
    {
      *i++;			// reserved (shall be zero)
      while (*i++ == 1)
	{
	  unsigned long oname;
	  hyperplay::data_file::unpack32 (i, oname);
	  new_omap[oname];	// create object
	  while (*i++ == 1)
	    {
	      unsigned long pname;
	      hyperplay::data_file::unpack32 (i, pname);
	      unsigned long value;
	      hyperplay::data_file::unpack32 (i, value);
	      new_omap[oname][pname].n_value = value;
	    }
	  // end marker is already read here
	}
      // end marker is already read here
    }
  swap (new_omap);
}

// Destruct a world.
world::~world ()
{
}

// Construct an empty world.
world::world ()
{
}

