/* Timer objects for Hyperplay
   Copyright (C) 1996, 1997, 1999 Hypercore Software Design, Ltd.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307, USA.  */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#undef const

#include <hyperplay/timer.h>

using namespace hyperplay;
using namespace std;

void
timer::tick(unsigned long now)
{
  timestamp = now;

  processing = true;
  while (!scheduled_entries.empty()
	 && scheduled_entries.top().time - epoch < timestamp - epoch)
    {
      epoch = scheduled_entries.top().time;
      interp::block b = scheduled_entries.top().block;
      scheduled_entries.pop();
      b.eval();
    }
  processing = false;

  while (!pending_entries.empty())
    {
      scheduled_entries.push(pending_entries.front());
      pending_entries.pop_front();
    }
}

void
timer::sync()
{
  // FIXME
}

void
timer::schedule(unsigned long time, const interp::block &block)
{
  entry e = {epoch + time, block};
#if 0
  /* XXX - This has an effect that newly added entries do not evaled
     immediately.  However, there is a problem that a new entry can
     have timestamp before the current epoch.  */
  if (processing)
    pending_entries.push_back(e);
  else
#endif
    scheduled_entries.push(e);
}

void
timer::reset()
{
  while (!scheduled_entries.empty())
    scheduled_entries.pop();

  epoch = timestamp;
}

timer::timer()
  : scheduled_entries(entry_less(&epoch)),
    processing(false)
{
}

