/* Script class for Hyperplay
   Copyright (C) 1996, 1997, 1999 Hypercore Software Design, Ltd.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307, USA.  */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#undef const

#include <hyperplay/scene.h>

#include <algorithm>

using namespace std;
using namespace hyperplay;

// Make INTERP execute the code chunk of KEY.
void
scene::call (const chunk::key_type key,
	     const interpreter &interp,
	     interp::context &c) const
{
  vector <chunk>::const_iterator i =
    find (chunks.begin (), chunks.end (), key);
  if (i != chunks.end ())
    {
      chunk::data code;
      (*i).load (code);
      static const char sig[4] = { 'C', 'O', 'D', 'E' };
      if (code.size () >= 4
	  && equal (sig, sig + 4, code.begin ()))
	c.execute (code.begin () + 4, code.end ());
    }
}

scene::scene (const chunk *first,
	      const chunk *last,
	      const data_file *s)
  : chunks (first, last),
    stream (s)
{
  assert (first != 0);
  assert (last != 0);
  assert (s != 0);
}

