/* Raw image objects for Hyperplay
   Copyright (C) 1996, 1997, 1999 Hypercore Software Design, Ltd.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307, USA.  */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#undef const

#include <hyperplay/visual.h>

using namespace hyperplay::visual;
using namespace std;

unsigned char *
raw_image::address(int x, int y) const
{
  return buf + y * row_size() + x * pixel_size(with_alpha());
}

raw_image::~raw_image()
{
  delete [] buf;
}

raw_image::raw_image(int w, int h, bool a)
  : width(w), height(h),
    with_alpha_value(a),
    row_size_value(w * pixel_size(a)),
    buf(NULL)
{
  buf = new unsigned char [height * row_size()];
}

using namespace hyperplay;

void
visual::unref(raw_image *img)
{
  delete img;
}

