/* Image objects for Hyperplay
   Copyright (C) 1996, 1997, 1999 Hypercore Software Design, Ltd.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307, USA.  */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#undef const

#include <hyperplay/visual.h>
#include <hyperplay/player.h>

using namespace hyperplay::visual;
using namespace std;

void
image::draw(class frame *frame, int x, int y, int v)
{
  unsigned char *s = master->address(subs[v].x, subs[v].y);
  if (master->with_alpha())
    frame->draw_rgba(x, y, s, master->row_size(), width(), height());
  else
    frame->draw_rgb(x, y, s, master->row_size(), width(), height());
}

image::~image()
{
  unref(master);
}

