/* Visual objects for Hyperplay
   Copyright (C) 1996, 2000 Hypercore Software Design, Ltd.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307, USA.  */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#undef const

#include <hyperplay/view.h>

using namespace hyperplay;
using namespace std;

bool
gadget::shape::inside(int x, int y) const
{
  // A poligon must have three vertexes or more.
  if (vertexes.size () < 3)
    return false;

  bool in = false;
  point prev = vertexes.back();
  for (vector<point>::const_iterator i = vertexes.begin();
       i != vertexes.end();
       ++i)
    {
      point cur = *i;

      int y0 = y - prev.y;
      int y1 = y - cur.y;
      if (y0 < 0 ? y1 >= 0 : y1 < 0)
	{
	  int x0y1 = (x - prev.x) * y1;
	  int x1y0 = (x - cur.x) * y0;
	  if (y1 < y0 ? x1y0 < x0y1 : x0y1 < x1y0)
	    in = !in;
	}

      prev = cur;
    }

  return in;
}

bool
gadget::inside(int x, int y) const
{
  return (x >= 0 && x < width() && y >= 0 && y < height()
	  && (shape_a == NULL || shape_a->inside(x, y)));
}

void
gadget::set_shape(shape *s)
{
  if (shape_a != NULL)
    delete shape_a;
  shape_a = s;
}

gadget::~gadget()
{
  delete shape_a;
}

gadget::gadget(int w, int h)
  : width_a(w), height_a(h),
    shape_a(NULL)
{
}

