/* Document objects for Hyperplay
   Copyright (C) 1996, 1997, 1999 Hypercore Software Design, Ltd.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307, USA.  */

#include "hyperplay/document.h"

#include <functional>
#include <algorithm>
#include <stdexcept>

using namespace std;
using namespace hyperplay;

// Return the script name without the directory prefix and the
// suffix.
string
document::script_name () const
{
  static const chunk::key_type key ("SNAM");
  data_file::const_iterator i =
    find (file.begin (), file.end (), key);
  if (i == file.end ())
    throw runtime_error ("invalid file");
  chunk::data ch;
  (*i).load (ch);
  return string (ch.begin (), ch.size ());
}

// Past the end of world chunks.
data_file::iterator
document::world_end ()
{
  return file.end ();
}

// Get the (N+1)-th chunk for world.
data_file::iterator
document::world_chunk (unsigned int n)
{
  static const chunk::key_type WRLD ("WRLD");
  data_file::iterator first = file.begin ();
  data_file::iterator last = file.end ();
  first = find (first, last, WRLD);
  while (first != last && n-- != 0)
    {
      ++first;
      first = find (first, last, WRLD);
    }
  return first;
}

// Close a document file associated with this object.
void
document::close ()
{
  file.close ();
}

// Open a document file and associate it with this object.
void
document::open (const string &docname)
{
  file.open (docname);
}

// Destruct a document object.
document::~document ()
{
}

// Construct a document object.
document::document ()
{
}

document::document (const string &docname)
  : file (docname)
{
}
