/* Color object for Hyperplay
   Copyright (C) 1997, 1999 Hypercore Software Design, Ltd.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307, USA.  */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#undef const

#include <hyperplay/color.h>

using namespace std;
using namespace hyperplay;

// Fade COLOR with VALUE [0, 255].
color
fade (const color &c, int value)
{
  color out;
  // FIXME: There is a complex but better way.
  out.red   = (value * c.red)   / color::max_value();
  out.green = (value * c.green) / color::max_value();
  out.blue  = (value * c.blue)  / color::max_value();
  return out;
}
