/* Data file object for Hyperplay
   Copyright (C) 1996, 1997, 1999 Hypercore Software Design, Ltd.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307, USA.  */

#include "hyperplay/file.h"

#include <algorithm>
#include <stdexcept>

using namespace std;
using namespace hyperplay;

chunk::key_type::key_type (const char *key_string)
{
  assert (key_string != 0);
  strncpy (data, key_string, sizeof data);
}

bool
hyperplay::operator== (const chunk::key_type &a,
		       const chunk::key_type &b)
{
  return equal (a.data + 0, a.data + 4, b.data + 0);
}

// Store data.
void
chunk::store (const char *first, const char *last) const
{
  if (last - first > last_pos - first_pos)
    throw runtime_error ("store: Data too large");
  vector<char> block(size_t(last_pos - first_pos), '\0');
  copy (first, last, block.begin ());
  assert (s != NULL);
  if (!s->seekp (first_pos))
    throw runtime_error ("store: Seek failed for write");
  if (!s->write (block.begin (), block.size ()))
    throw runtime_error ("store: Write failed");
  if (!s->flush ())
    throw runtime_error ("store: Buffer flush failed");
}

// `chunk::load' loads the chunk data into the address space.
void
chunk::load (data &d) const
{
  assert (s != 0);
  if (!s->seekg (first_pos))
    throw runtime_error ("file seek failed");
  d = data(size_t(last_pos - first_pos), 0);
  if (!s->read (d.begin (), d.size ()))
    throw runtime_error ("file read failed");
}

chunk::chunk()
  : key("\0\0\0\0"),
    s(NULL),
    first_pos(0),
    last_pos(0)
{
}

chunk::chunk(const key_type &k, iostream *stream, streampos f, streampos l)
  : key (k), s (stream), first_pos (f), last_pos (l)
{
}

