/* -*-C++-*- */
/* World objects for Hyperplay
   Copyright (C) 1996, 1997, 1999 Hypercore Software Design, Ltd.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307, USA.  */

#ifndef _HYPERPLAY_WORLD_H
#define _HYPERPLAY_WORLD_H 1

#include <hyperplay/file.h>
#include <map>
#include <vector>
#include <string>

#if __WATCOMC__ > 1000
# pragma pack (push, 4)
#else
# pragma pack (4)
#endif

namespace hyperplay
{
  using namespace std;

#ifdef HPLAY_API
  class HPLAY_API world;
#endif

  typedef unsigned long id_type;

  class variable
  {
  public:
    long n_value;
    string s;
    variable (long num = 0, const string &str = string ())
      : n_value (num), s (str) {}
    variable (const string &str): s (str) {}
  };

  /* A domain is a collection of variables.  In a domain, variables
     are identified by numbers of type id_type.  */
  typedef map<id_type, variable> domain;

  // Class `world'

  // A "world" is a database of domains and their relations.

  // An identifier number is assigned to each domain by the world.

  class world
    : public map<id_type, domain>
  {
  public:				// Data management.
    typedef chunk data_chunk_type;
    void save (const data_chunk_type &) const;
    void load (const data_chunk_type &);

  public:				// Construction and destruction.
    world ();
    // template <class InputIterator> world...
    world (vector <char>::const_iterator,
	   vector <char>::const_iterator);
    ~world ();

  public:
    /* Returns the value of a variable with name NAME in domain
       DOMAIN.  */
    long var(unsigned long domain, unsigned long name) const;

    /* Sets a variable with name NAME in domain DOMAIN to VALUE.  */
    void set_var(unsigned long domain, unsigned long name, long value);
  };

} // hyperplay

#if __WATCOMC__ > 1000
# pragma pack (pop)
#else
# pragma pack ()
#endif

#endif /* not _HYPERPLAY_WORLD_H */
