/* -*-C++-*- */
/* Visual objects for Hyperplay
   Copyright (C) 1996, 2000 Hypercore Software Design, Ltd.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307, USA.  */

#ifndef _HYPERPLAY_VISUAL_H
#define _HYPERPLAY_VISUAL_H 1

#include <hyperplay/view.h>
#include <vector>

namespace hyperplay
{
  using namespace std;

  class frame;

  namespace visual
  {
    struct point
    {
      int x, y;
    };

    class raw_image
    {
      friend void unref(raw_image *);
    public:
      static size_t pixel_size(bool with_alpha)
	{return with_alpha ? 4 : 3;}
    private:
      int width;
      int height;
      bool with_alpha_value;
      size_t row_size_value;
      unsigned char *buf;
    public:
      raw_image(int, int, bool);
    protected:
      ~raw_image();
    public:
      bool with_alpha() const
	{return with_alpha_value;}
      size_t row_size() const
	{return row_size_value;}
      unsigned char *address(int x, int y) const;
    };

    /* Visual object with an image representation.  Implementation
       details are hidden from the interface.  */
    class image
      : public gadget
    {
    private:
      raw_image *master;
      vector<point> subs;

    public:
      template <class InputIterator> image(int, int, raw_image *,
					   InputIterator, InputIterator);
      ~image();

    public:
      void draw(frame *, int, int, int);
    };

    template <class InputIterator>
    image::image(int w, int h,
		 raw_image *img,
		 InputIterator first,
		 InputIterator last)
      : gadget(w, h),
        master(img),
        subs(first, last)
    {
    }

    /* Visual object with a text representation.  */
    class text
      : public gadget
    {
    public:
      text(int width, int height)
	: gadget(width, height) {} // FIXME

    public:
      void draw(frame *, int, int, int);
    };
  } // visual
} // hyperplay

#endif /* not _HYPERPLAY_VISUAL_H */

