/* -*-C++-*- */
/* Timer and related objects for Hyperplay
   Copyright (C) 1996, 1997, 1999 Hypercore Software Design, Ltd.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307, USA.  */

#ifndef _HYPERPLAY_TIMER_H
#define _HYPERPLAY_TIMER_H 1

#include <hyperplay/interp.h>
#include <queue>

namespace hyperplay
{
  using namespace std;

  class timer
  {
  protected:
    struct entry
    {
      unsigned long time;
      interp::block block;
    };
    class entry_less
    {
    private:
      unsigned long *epoch;
    public:
      entry_less(unsigned long *e)
	: epoch(e) {}
    public:
      bool operator()(const entry &a, const entry &b) const
	{return a.time - *epoch < b.time - *epoch;}
    };

  private:
    unsigned long epoch;
    priority_queue<entry, vector<entry>, entry_less> scheduled_entries;
    unsigned long timestamp;
    bool processing;
    deque<entry> pending_entries;

  public:
    timer();

  public:
    void reset();
    void schedule(unsigned long, const interp::block &);
    void sync();
    void tick(unsigned long);
  };
} // hyperplay

#endif /* not _HYPERPLAY_TIMER_H */

