/* -*-C++-*- */
/* Script class for Hyperplay
   Copyright (C) 1996, 2000 Hypercore Software Design, Ltd.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307, USA.  */

#ifndef _HYPERPLAY_SCRIPT_H
#define _HYPERPLAY_SCRIPT_H 1

#include <hyperplay/scene.h>
#include <hyperplay/visual.h>
#include <hyperplay/interp.h>
#include <map>
#include <vector>
#include <string>

namespace hyperplay
{
  using interp::interpreter;
  using namespace std;

#ifdef HPLAY_API
  class HPLAY_API script;
#endif /* HPLAY_API */

  /* Abstract base of a script.  */
  class script
  {
    // Custom cursors.
  public:
    struct cursor
    {
      unsigned long index;
      visual::point hot;
      char and_bits[32 * 4];
      char xor_bits[32 * 4];
    };

  private:
    /* Attributes for the frame's width and height.  */
    int frame_width_a, frame_height_a;

    /* Attribute for the title.  */
    string title_a;

  public:
    virtual ~script();

  protected:
    script();

  public:
    /* Sets search path for script files to PATH.  PATH is a list of
       directories that is separated by colons.  A null element
       specifies the default directory.  */
    void set_path(const char *path);

  public:
    int frame_width() const
    {return frame_width_a;}

    int frame_height() const
    {return frame_height_a;}

    unsigned long initial_scene() const
    {return 0;}

    string title() const
    {return title_a;}

  protected:
    /* Sets the frame size.  */
    void set_frame_size(int width, int height)
    {frame_width_a = width; frame_height_a = height;}

    void set_title(string title)
    {title_a = title;}

  public:
    /* Configures an interpreter.  */
    virtual void configure(interpreter *) const = 0;

    /* Opens a scene.  */
    virtual scene find_scene(unsigned long) const = 0;
  };

#ifndef __GNUC__		/* temporary */

  inline bool
    operator!= (const script::cursor_iterator &a,
		const script::cursor_iterator &b)
  {
    return !(a == b);
  }

#endif /* not __GNUC__ */

} // hyperplay

#endif /* not _HYPERPLAY_SCRIPT_H */

