/* -*-C++-*- */
/* Scene objects for Hyperplay
   Copyright (C) 1996, 2000 Hypercore Software Design, Ltd.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307, USA.  */

#ifndef _HYPERPLAY_SCENE_H
#define _HYPERPLAY_SCENE_H 1

#include <hyperplay/interp.h>
#include <vector>

namespace hyperplay
{
  using interp::interpreter;
  using namespace std;

#ifdef HPLAY_API
  class HPLAY_API scene;
#endif /* HPLAY_API */

  class data_file;

  /* FIXME: This class is placed temporarily.  */
  /* A chunk has a type code and content data.  */
  class chunk
  {
    // NOTE: this is not at all space-efficient, and can be improved
    // by defining our iterators.
    friend class data_file;

    // key
  public:
    class key_type
    {
      friend bool operator==(const key_type &a, const key_type &b);
    protected:
      char data[4];
    public:
      key_type();
      key_type(const char *);
    };
  protected:
    key_type key;
  public:
    operator const key_type &() const {return key;}

  public:
    typedef vector <char> data;
  protected:
    iostream *s;
    streampos first_pos;
    streampos last_pos;
  public:
    // template <Iterator> void store(Iterator, Iterator);
    void store(const char *, const char *) const;
    void load(data &) const;

  public:
    chunk();
  protected:
    chunk(const key_type &k, iostream *stream, streampos f, streampos l);
  };

  class scene
  {
  protected:
    vector <chunk> chunks;

    // code
  public:
    void call (const chunk::key_type,
	       const interpreter &,
	       interp::context &) const;

  protected:
    const data_file *stream;
  public:
    scene (): stream (0) {}
    scene (const chunk *, const chunk *, const data_file *);
  };				// scene

} // hyperplay

#endif /* not _HYPERPLAY_SCENE_H */

