/* -*-C++-*- */
/* Image file objects for Hyperplay.
   Copyright (C) 1996, 1997, 1999 Hypercore Software Design, Ltd.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307, USA.  */

#ifndef _HYPERPLAY_IMAGEFILE_H
#define _HYPERPLAY_IMAGEFILE_H 1

#include <hyperplay/visual.h>
#include <png.h>
#include <cstdio>

namespace hyperplay
{
  using namespace std;

  namespace file
  {
    // Class of PNG readers.
    class png_reader
    {
    public:
      static const char *file_suffix()
	{return ".png";}
    private:
      FILE *fp;
      png_structp png_ptr;
      png_infop info_ptr;
    public:
      png_reader();
      ~png_reader();
    public:
      void open(const char *);
      visual::raw_image *read() const;
#if 0
    public:
      hplay_png_reader &read_image(char *const *);

      // Color table
    public:
      typedef png_color color_value_type;
      typedef png_colorp color_iterator;
      size_t color_size () const {return png.info_ptr->num_palette;}
      color_iterator color_begin () const
	{
	  return png.info_ptr->palette;
	}
      color_iterator color_end () const
	{
	  return color_begin () + png.info_ptr->num_palette;
	}

      // Transparency
    public:
      bool transparent (color_iterator) const;

    protected:
      ifstream stream;
      static void read_data (png_structp, png_bytep, png_size_t);
      struct libpng
      {
	png_structp png_ptr;
	png_infop info_ptr;
	libpng ();
	~libpng ();
	static png_structp create_struct ();
	static void error (png_structp, png_const_charp msg);
      };
      const libpng png;
    public:
      hplay_png_reader (const char *);
      ~hplay_png_reader ();
#endif
    };
  } // file
} // hyperplay

#endif /* not _HYPERPLAY_IMAGEFILE_H */

